/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.webserviceclient;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.webserviceclient.tc.TCEncoder;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class WebServicesDialogTCStepThree
extends StepPane
implements ActionListener {
    private JRadioButton tierListRB;
    private JRadioButton typeListRB;
    private JList tierList;
    private DefaultListModel tierModel;
    private JList typeList;
    private DefaultListModel typeModel;
    private JButton uploadButton;
    private TranscriptionImpl trans;

    public WebServicesDialogTCStepThree(MultiStepPane multiPane) {
        super(multiPane);
        Object transObj = multiPane.getStepProperty("transcription");
        if (transObj instanceof TranscriptionImpl) {
            this.trans = (TranscriptionImpl)transObj;
        }
        this.initComponents();
    }

    @Override
    public void initComponents() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 0, 2, 0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets;
        if (this.trans == null) {
            JLabel errorLabel = new JLabel("There is no transcription, cannot upload anything.");
            gbc.anchor = 17;
            this.add((Component)errorLabel, gbc);
        } else {
            this.typeListRB = new JRadioButton("Select the phrase level type:");
            this.typeListRB.setSelected(true);
            this.typeListRB.addActionListener(this);
            this.tierListRB = new JRadioButton("Select the phrase level tier:");
            this.tierListRB.addActionListener(this);
            this.tierListRB.setEnabled(false);
            ButtonGroup ttGroup = new ButtonGroup();
            ttGroup.add(this.typeListRB);
            ttGroup.add(this.tierListRB);
            this.typeModel = new DefaultListModel();
            this.typeList = new JList(this.typeModel);
            this.typeList.getSelectionModel().setSelectionMode(0);
            this.tierModel = new DefaultListModel();
            this.tierList = new JList(this.tierModel);
            this.tierList.getSelectionModel().setSelectionMode(0);
            this.tierList.setEnabled(false);
            this.loadTypeList();
            this.loadTierList();
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.add((Component)this.typeListRB, gbc);
            gbc.gridy = 1;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            this.add((Component)new JScrollPane(this.typeList), gbc);
            gbc.gridy = 2;
            gbc.fill = 2;
            gbc.weighty = 0.0;
            this.add((Component)this.tierListRB, gbc);
            gbc.gridy = 3;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            this.add((Component)new JScrollPane(this.tierList), gbc);
            this.uploadButton = new JButton("Upload text");
            this.uploadButton.addActionListener(this);
            gbc.gridy = 4;
            gbc.fill = 0;
            gbc.weighty = 0.0;
            gbc.weightx = 0.0;
            this.add((Component)this.uploadButton, gbc);
        }
    }

    private void loadTypeList() {
        if (this.trans != null && this.typeList != null) {
            Vector types = this.trans.getLinguisticTypes();
            for (int i = 0; i < types.size(); ++i) {
                LinguisticType lt = (LinguisticType)types.get(i);
                this.typeModel.addElement(lt.getLinguisticTypeName());
                if (!lt.getLinguisticTypeName().equals("phrase")) continue;
                this.typeList.setSelectedIndex(i);
            }
        }
    }

    private void loadTierList() {
        if (this.trans != null && this.tierList != null) {
            Vector tiers = this.trans.getTiers();
            for (int i = 0; i < tiers.size(); ++i) {
                TierImpl t = (TierImpl)tiers.get(i);
                this.tierModel.addElement(t.getName());
                if (!t.getName().equals("phrase")) continue;
                this.tierList.setSelectedIndex(i);
            }
        }
    }

    @Override
    public String getStepTitle() {
        return "TypeCraft upload text";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.uploadButton) {
            if (this.typeListRB.isSelected()) {
                String typeName = (String)this.typeList.getSelectedValue();
                if (typeName == null) return;
                TCEncoder tcenc = new TCEncoder();
                String result = tcenc.encodeTCTypeBased(this.trans, typeName);
                return;
            }
            String tierName = (String)this.tierList.getSelectedValue();
            if (tierName == null) return;
            return;
        } else {
            if (e.getSource() == this.typeListRB) {
                this.typeList.setEnabled(true);
                this.tierList.setEnabled(false);
                return;
            }
            if (e.getSource() != this.tierListRB) return;
            this.typeList.setEnabled(false);
            this.tierList.setEnabled(true);
        }
    }

    private String encodeText(List<String> tiers) {
        return null;
    }
}

