/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.webserviceclient;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.webserviceclient.WebServicesDialogTCInOut;
import mpi.eudico.client.annotator.webserviceclient.WebServicesDialogTCStepOne;
import mpi.eudico.client.annotator.webserviceclient.WebServicesDialogTCStepThree;
import mpi.eudico.client.annotator.webserviceclient.WebServicesDialogTCStepTwo;
import mpi.eudico.client.annotator.webserviceclient.weblicht.WebLichtStep1;
import mpi.eudico.client.annotator.webserviceclient.weblicht.WebLichtStep2;
import mpi.eudico.client.annotator.webserviceclient.weblicht.WebLichtTierBasedStep2;
import mpi.eudico.client.annotator.webserviceclient.weblicht.WebLichtTierBasedStep3;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class WebServicesDialog
extends ClosableDialog
implements ActionListener,
TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private JLabel titleLabel;
    private JScrollPane treeScrollPane;
    private JPanel prefCatPanel;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JTree catTree;
    private HashMap<String, String> catKeyMap;
    private HashMap<String, JComponent> activatedPanels;
    private CardLayout cardLayout;
    private JComponent currentEditPanel = null;
    private TranscriptionImpl trans;

    public WebServicesDialog() throws HeadlessException {
        this.initComponents();
    }

    public WebServicesDialog(Frame owner, boolean modal) throws HeadlessException {
        this(owner, "", modal);
    }

    public WebServicesDialog(Frame owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.initComponents();
    }

    private void postInit() {
        this.pack();
        int w = 720;
        int h = 450;
        this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height < h ? h : this.getSize().height);
        this.setLocationRelativeTo(this.getParent());
    }

    public void setTranscription(TranscriptionImpl trans) {
        this.trans = trans;
    }

    private void initComponents() {
        this.catKeyMap = new HashMap();
        this.activatedPanels = new HashMap();
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setHorizontalAlignment(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = new Insets(6, 6, 10, 6);
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        this.getContentPane().add((Component)this.titleLabel, gbc);
        this.catTree = new JTree(new DefaultMutableTreeNode(""));
        this.catTree.getSelectionModel().setSelectionMode(1);
        ((DefaultTreeCellRenderer)this.catTree.getCellRenderer()).setLeafIcon(null);
        ((DefaultTreeCellRenderer)this.catTree.getCellRenderer()).setOpenIcon(null);
        ((DefaultTreeCellRenderer)this.catTree.getCellRenderer()).setClosedIcon(null);
        this.treeScrollPane = new JScrollPane(this.catTree);
        Dimension dim = new Dimension(180, 300);
        this.treeScrollPane.setPreferredSize(dim);
        this.treeScrollPane.setMinimumSize(dim);
        this.treeScrollPane.setBackground(Color.WHITE);
        gbc = new GridBagConstraints();
        gbc.fill = 3;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.weighty = 1.0;
        gbc.gridy = 1;
        this.getContentPane().add((Component)this.treeScrollPane, gbc);
        this.cardLayout = new CardLayout();
        this.prefCatPanel = new JPanel(this.cardLayout);
        this.prefCatPanel.add((Component)new JLabel(ElanLocale.getString("WebServicesDialog.SelectService")), "Intro_xxx");
        this.cardLayout.show(this.prefCatPanel, "Intro_xxx");
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = insets;
        gbc.gridy = 1;
        gbc.gridx = 1;
        this.getContentPane().add((Component)this.prefCatPanel, gbc);
        this.buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.cancelButton);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 15;
        gbc.insets = insets;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.gridwidth = 2;
        this.getContentPane().add((Component)this.buttonPanel, gbc);
        this.updateLocale();
        this.postInit();
        this.catTree.addTreeSelectionListener(this);
    }

    private void updateLocale() {
        this.setTitle(ElanLocale.getString("WebServicesDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("WebServicesDialog.Title"));
        this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
        String val = ElanLocale.getString("WebServicesDialog.WebService.TypeCraft");
        this.catKeyMap.put(val, "WebServicesDialog.WebService.TypeCraft");
        ((DefaultMutableTreeNode)this.catTree.getModel().getRoot()).add(new DefaultMutableTreeNode(val));
        val = ElanLocale.getString("WebServicesDialog.WebService.WebLicht");
        this.catKeyMap.put(val, "WebServicesDialog.WebService.WebLicht");
        ((DefaultMutableTreeNode)this.catTree.getModel().getRoot()).add(new DefaultMutableTreeNode(val));
        this.catTree.setEditable(false);
        this.catTree.expandRow(0);
    }

    private JComponent getPanelsForKey(String key) {
        if (key == null) {
            return null;
        }
        if (key.equals("WebServicesDialog.WebService.TypeCraft")) {
            MultiStepPane pane = new MultiStepPane(ElanLocale.getResourceBundle());
            WebServicesDialogTCStepOne stepOne = new WebServicesDialogTCStepOne(pane);
            pane.addStep(stepOne);
            WebServicesDialogTCInOut choseStep = new WebServicesDialogTCInOut(pane);
            pane.addStep(choseStep);
            WebServicesDialogTCStepTwo stepTwo = new WebServicesDialogTCStepTwo(pane);
            stepTwo.setName("download");
            pane.addStep(stepTwo);
            WebServicesDialogTCStepThree stepThree = new WebServicesDialogTCStepThree(pane);
            stepThree.setName("upload");
            pane.addStep(stepThree);
            pane.putStepProperty("transcription", this.trans);
            pane.setButtonVisible(8, false);
            return pane;
        }
        if (key.equals("WebServicesDialog.WebService.WebLicht")) {
            MultiStepPane pane = new MultiStepPane(ElanLocale.getResourceBundle());
            WebLichtStep1 step1 = new WebLichtStep1(pane);
            pane.addStep(step1);
            step1.setName("TextOrTierStep1");
            pane.setButtonVisible(4, false);
            WebLichtStep2 step2 = new WebLichtStep2(pane);
            step2.setName("TextStep2");
            pane.addStep(step2);
            WebLichtTierBasedStep2 stTier2 = new WebLichtTierBasedStep2(pane);
            stTier2.setName("TierStep2");
            pane.addStep(stTier2);
            WebLichtTierBasedStep3 stTier3 = new WebLichtTierBasedStep3(pane);
            stTier3.setName("TierStep3");
            pane.addStep(stTier3);
            pane.putStepProperty("transcription", this.trans);
            return pane;
        }
        return null;
    }

    private void closeDialog() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.cancelButton) {
            this.setVisible(false);
            this.closeDialog();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Object selNode = e.getPath().getLastPathComponent();
        if (selNode instanceof DefaultMutableTreeNode) {
            String key = (String)((DefaultMutableTreeNode)selNode).getUserObject();
            String val = this.catKeyMap.get(key);
            if (this.currentEditPanel != null && this.activatedPanels.get(val) == this.currentEditPanel) {
                return;
            }
            if (this.activatedPanels.get(val) != null) {
                this.cardLayout.show(this.prefCatPanel, val);
                this.currentEditPanel = this.activatedPanels.get(val);
            } else {
                JComponent keyPanel = this.getPanelsForKey(val);
                if (keyPanel != null) {
                    this.prefCatPanel.add((Component)keyPanel, val);
                    this.cardLayout.show(this.prefCatPanel, val);
                    this.currentEditPanel = keyPanel;
                    this.activatedPanels.put(val, keyPanel);
                }
            }
        }
    }
}

