/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.FormattedMessageDlg;
import mpi.eudico.client.annotator.recognizer.data.Boundary;
import mpi.eudico.client.annotator.recognizer.data.BoundarySegmentation;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.client.annotator.viewer.GesturesListener;
import mpi.eudico.client.annotator.viewer.PraatConnection;
import mpi.eudico.client.annotator.viewer.TimeRuler;
import mpi.eudico.client.annotator.viewer.TimeScaleBasedViewer;
import mpi.eudico.client.annotator.viewer.WavePart;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.StopEvent;
import mpi.eudico.client.mediacontrol.TimeEvent;
import mpi.eudico.client.util.WAVCuePoint;
import mpi.eudico.client.util.WAVSampler;
import mpi.eudico.util.TimeFormatter;

public class SignalViewer
extends TimeScaleBasedViewer
implements ComponentListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
ActionListener,
GesturesListener {
    public static final int MONO = 0;
    public static final int STEREO_SEPARATE = 1;
    public static final int STEREO_MERGED = 2;
    public static final int STEREO_BLENDED = 3;
    static final int PIXELS_FOR_SECOND = 100;
    private int channelMode;
    public final int[] VERT_ZOOM = new int[]{100, 150, 200, 300, 500, 1000, 2000, 3000};
    private final int GAP = 4;
    private int rulerHeight;
    private BufferedImage bi;
    private Graphics2D big2d;
    private AlphaComposite alpha04;
    private AlphaComposite alpha07;
    private WavePart currentPart;
    private final int SCREEN_BUFFER = 1;
    private WAVSampler samp;
    public final int DEFAULT_MS_PER_PIXEL = 10;
    private float msPerPixel;
    private float samplesPerPixel;
    private TimeRuler ruler;
    private int maxAmplitude;
    private int imageWidth;
    private int imageHeight;
    private long crossHairTime;
    private int crossHairPos;
    private long intervalBeginTime;
    private long intervalEndTime;
    private long dragStartTime;
    private long selectionBeginTime;
    private long selectionEndTime;
    private int selectionBeginPos;
    private int selectionEndPos;
    private Point dragStartPoint;
    private Point dragEndPoint;
    public final int SCROLL_OFFSET = 16;
    private DragScroller scroller;
    private JPopupMenu popup;
    private JMenuItem praatSelMI;
    private JMenuItem clipSelPraatMI;
    private JMenuItem infoItem;
    private ButtonGroup zoomBG;
    private JRadioButtonMenuItem customZoomMI;
    private JMenuItem zoomSelectionMI;
    private ButtonGroup vertZoomGroup;
    private JRadioButtonMenuItem separateMI;
    private JRadioButtonMenuItem mergedMI;
    private JRadioButtonMenuItem blendMI;
    private JCheckBoxMenuItem timeRulerVisMI;
    private JCheckBoxMenuItem timeScaleConMI;
    private JMenuItem copyOrigTimeItem;
    private boolean timeScaleConnected;
    private boolean panMode;
    private boolean timeRulerVisible;
    private boolean clearSelOnSingleClick = true;
    private int vertZoom = 100;
    private final Object paintlock = new Object();
    private long mediaOffset;
    private String mediaFilePath;
    boolean stopScrolling = true;
    boolean allowConnecting = true;
    private Color selectionColor = Constants.SELECTIONCOLOR;
    JMenu segmentationMenu;
    BoundarySegmentation segmentationChannel1;
    boolean showSegmentationChannel1;
    JCheckBoxMenuItem segmentationChannel1Item;
    BoundarySegmentation segmentationChannel2;
    boolean showSegmentationChannel2;
    JCheckBoxMenuItem segmentationChannel2Item;
    private String errorKey = null;
    private boolean recalculateInterval = true;
    private int horScrollSpeed = 10;

    public SignalViewer() {
        this.initViewer();
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.setDoubleBuffered(false);
        this.setOpaque(true);
    }

    public SignalViewer(URL mediaURL, boolean allowConnecting) {
        this(mediaURL);
        this.allowConnecting = allowConnecting;
        this.removeMouseMotionListener(this);
    }

    public SignalViewer(URL mediaUrl) {
        this(mediaUrl.toExternalForm());
    }

    public SignalViewer(String mediaPath) {
        this();
        this.setMedia(mediaPath);
        this.paintBuffer();
        System.out.println("MediaUrl SignalViewer: " + mediaPath);
        this.createPopupMenu();
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        return false;
    }

    private void initViewer() {
        this.ruler = new TimeRuler(Constants.DEFAULTFONT, TimeFormatter.toString(0L));
        this.rulerHeight = this.ruler.getHeight();
        this.timeRulerVisible = true;
        this.channelMode = 2;
        this.msPerPixel = 10.0f;
        this.samplesPerPixel = this.msPerPixel * 44100.0f / 1000.0f;
        this.maxAmplitude = Short.MAX_VALUE;
        this.imageWidth = 0;
        this.imageHeight = 0;
        this.crossHairTime = 0L;
        this.crossHairPos = 0;
        this.intervalBeginTime = 0L;
        this.intervalEndTime = 0L;
        this.dragStartTime = 0L;
        this.selectionBeginTime = 0L;
        this.selectionEndTime = 0L;
        this.selectionBeginPos = 0;
        this.selectionEndPos = 0;
        this.alpha04 = AlphaComposite.getInstance(3, 0.4f);
        this.alpha07 = AlphaComposite.getInstance(3, 0.7f);
        this.currentPart = new WavePart(1);
        this.timeScaleConnected = true;
        this.mediaOffset = 0L;
    }

    public void setMedia(String mediaPath) {
        if (!mediaPath.endsWith("wav")) {
            int i = mediaPath.lastIndexOf(46);
            mediaPath = i > 0 ? mediaPath.substring(0, i) + ".wav" : mediaPath + ".wav";
        }
        if (mediaPath.startsWith("file:")) {
            mediaPath = mediaPath.substring(5);
        }
        this.mediaFilePath = mediaPath;
        this.initLoad(mediaPath);
        this.paintBuffer();
    }

    public String getMediaPath() {
        return this.mediaFilePath;
    }

    private void openInPraat(long begin, long end) {
        PraatConnection.openInPraat(this.mediaFilePath, begin, end);
    }

    private void openSelectionInPraat() {
        if (this.getSelectionBeginTime() == this.getSelectionEndTime()) {
            this.openInPraat(0L, 0L);
        } else {
            this.openInPraat(this.getSelectionBeginTime() + this.mediaOffset, this.getSelectionEndTime() + this.mediaOffset);
        }
    }

    private void clipSelectionWithPraat() {
        if (this.getSelectionBeginTime() == this.getSelectionEndTime()) {
            return;
        }
        PraatConnection.clipWithPraat(this.mediaFilePath, this.getSelectionBeginTime() + this.mediaOffset, this.getSelectionEndTime() + this.mediaOffset);
    }

    private void showMediaInfo() {
        String[][] info = new String[3][2];
        info[0][0] = ElanLocale.getString("LinkedFilesDialog.Label.MediaURL");
        info[0][1] = this.mediaFilePath;
        info[1][0] = ElanLocale.getString("LinkedFilesDialog.Label.MediaOffset");
        info[1][1] = String.valueOf(this.mediaOffset);
        info[2][0] = ElanLocale.getString("Player.duration");
        info[2][1] = TimeFormatter.toString((long)this.samp.getDuration());
        new FormattedMessageDlg(info);
    }

    public long getSignalDuration() {
        return (long)this.samp.getDuration();
    }

    public void setSelectionColor(Color selectionColor) {
        this.selectionColor = selectionColor;
    }

    private void initLoad(String sourcePath) {
        try {
            this.samp = new WAVSampler(sourcePath);
        }
        catch (IOException ioe) {
            System.out.println("Failed to create a WAVSampler");
            this.errorKey = ElanLocale.getString("SignalViewer.Message.NoReader") + ": " + ioe.getMessage();
        }
        if (this.samp != null) {
            this.samplesPerPixel = this.msPerPixel * (float)this.samp.getSampleFrequency() / 1000.0f;
            this.maxAmplitude = Math.max(this.samp.getPossibleMaxSample(), Math.abs(this.samp.getPossibleMinSample()));
            if (this.samp.getWavHeader().getNumberOfChannels() == 1) {
                this.channelMode = 0;
            } else if (this.samp.getWavHeader().getNumberOfChannels() == 2) {
                this.channelMode = 1;
            }
            short compr = this.samp.getWavHeader().getCompressionCode();
            this.samp.getWavHeader();
            if (compr != 0) {
                this.samp.getWavHeader();
                if (compr != 1) {
                    this.samp.getWavHeader();
                    if (compr != 6) {
                        this.errorKey = ElanLocale.getString("SignalViewer.Message.Compression");
                    }
                }
            }
        }
        int w = Toolkit.getDefaultToolkit().getScreenSize().width;
        this.loadData(0L, (long)this.msPerPixel, w);
    }

    private boolean loadData(long fromTime, long toTime, int width) {
        if (this.samp == null) {
            return false;
        }
        if ((float)(fromTime += this.mediaOffset) > this.samp.getDuration() || fromTime > (toTime += this.mediaOffset) || toTime < 0L) {
            return false;
        }
        long to = toTime > (long)this.samp.getDuration() ? (long)this.samp.getDuration() : toTime;
        long from = fromTime < this.mediaOffset ? this.mediaOffset : fromTime;
        long startSample = (long)((float)from / this.msPerPixel);
        long stopSample = (long)((float)to / this.msPerPixel);
        int extent = (int)(stopSample - startSample) + 1;
        int size = extent > width ? extent : width;
        double firstSeeksample = (float)(from * (long)this.samp.getSampleFrequency()) / 1000.0f;
        int samplesRead = 0;
        int startSampleInt = (int)startSample;
        int samplesPerPixelInt = (int)this.samplesPerPixel;
        boolean roundProb = this.samplesPerPixel * 10.0f % 10.0f != 0.0f;
        switch (this.channelMode) {
            case 0: 
            case 2: {
                this.currentPart.reset();
                this.currentPart.setInterval(from, to, startSampleInt, size, extent);
                if (roundProb) {
                    int startPixel = (int)((float)from / this.msPerPixel);
                    long startSamp = (long)((float)startPixel * this.samplesPerPixel);
                    this.samp.seekSample(startSamp);
                    samplesRead = this.samp.readInterval((int)((float)extent * this.samplesPerPixel), 1);
                    for (int i = 0; i < size; ++i) {
                        int min = 0;
                        int max = 0;
                        int index = 0;
                        if (i > 0) {
                            long sm = (long)((float)(startPixel + i) * this.samplesPerPixel);
                            index = (int)(sm - startSamp);
                        }
                        int j = 0;
                        while ((float)j <= this.samplesPerPixel && j + index < this.samp.getFirstChannelArray().length) {
                            int sample = this.samp.getFirstChannelArray()[j + index];
                            if (sample < min) {
                                min = sample;
                            } else if (sample > max) {
                                max = sample;
                            }
                            ++j;
                        }
                        this.currentPart.addLineToFirstChannel(startSampleInt + i, -max, -min);
                    }
                } else {
                    this.samp.seekSample((long)firstSeeksample);
                    samplesRead = this.samp.readInterval((int)((float)extent * this.samplesPerPixel), 1);
                    int i = 0;
                    for (int p = startSampleInt; i < samplesRead - samplesPerPixelInt && p < startSampleInt + size; i += samplesPerPixelInt, ++p) {
                        int min = 0;
                        int max = 0;
                        for (int j = 0; j < samplesPerPixelInt; ++j) {
                            int sample = this.samp.getFirstChannelArray()[i + j];
                            if (sample < min) {
                                min = sample;
                                continue;
                            }
                            if (sample <= max) continue;
                            max = sample;
                        }
                        this.currentPart.addLineToFirstChannel(p, -max, -min);
                    }
                }
                break;
            }
            case 1: 
            case 3: {
                this.currentPart.reset();
                this.currentPart.setInterval(from, to, startSampleInt, size, extent);
                if (roundProb) {
                    int startPixel = (int)((float)from / this.msPerPixel);
                    long startSamp = (long)((float)startPixel * this.samplesPerPixel);
                    this.samp.seekSample(startSamp);
                    samplesRead = this.samp.readInterval((int)((float)extent * this.samplesPerPixel), 2);
                    for (int i = 0; i < size; ++i) {
                        int min = 0;
                        int max = 0;
                        int min2 = 0;
                        int max2 = 0;
                        int index = 0;
                        if (i > 0) {
                            long sm = (long)((float)(startPixel + i) * this.samplesPerPixel);
                            index = (int)(sm - startSamp);
                        }
                        int j = 0;
                        while ((float)j <= this.samplesPerPixel && j + index < this.samp.getFirstChannelArray().length) {
                            int sample = this.samp.getFirstChannelArray()[j + index];
                            if (sample < min) {
                                min = sample;
                            } else if (sample > max) {
                                max = sample;
                            }
                            int sample2 = this.samp.getSecondChannelArray()[j + index];
                            if (sample2 < min2) {
                                min2 = sample2;
                            } else if (sample2 > max2) {
                                max2 = sample2;
                            }
                            ++j;
                        }
                        this.currentPart.addLineToFirstChannel(startSampleInt + i, -max, -min);
                        this.currentPart.addLineToRightChannel(startSampleInt + i, -max2, -min2);
                    }
                } else {
                    this.samp.seekSample((long)firstSeeksample);
                    samplesRead = this.samp.readInterval((int)((float)extent * this.samplesPerPixel), 2);
                    int i = 0;
                    for (int p = startSampleInt; i < samplesRead - samplesPerPixelInt && p < startSampleInt + size; i += samplesPerPixelInt, ++p) {
                        int min = 0;
                        int max = 0;
                        int min2 = 0;
                        int max2 = 0;
                        for (int j = 0; j < samplesPerPixelInt; ++j) {
                            int sample = this.samp.getFirstChannelArray()[i + j];
                            if (sample < min) {
                                min = sample;
                            } else if (sample > max) {
                                max = sample;
                            }
                            int sample2 = this.samp.getSecondChannelArray()[i + j];
                            if (sample2 < min2) {
                                min2 = sample2;
                                continue;
                            }
                            if (sample2 <= max2) continue;
                            max2 = sample2;
                        }
                        this.currentPart.addLineToFirstChannel(p, -max, -min);
                        this.currentPart.addLineToRightChannel(p, -max2, -min2);
                    }
                }
                break;
            }
        }
        return true;
    }

    private boolean shiftAndLoadData(long fromTime, long toTime) {
        long loadTime;
        int extent;
        if (this.samp == null) {
            return false;
        }
        if ((float)fromTime > this.samp.getDuration() || fromTime > toTime || toTime < 0L) {
            return false;
        }
        if ((float)toTime > this.samp.getDuration()) {
            toTime = (long)this.samp.getDuration();
        }
        long oldStop = this.currentPart.getStopTime();
        long oldStart = this.currentPart.getStartTime();
        long startSample = (long)((float)fromTime / this.msPerPixel);
        long stopSample = (long)((float)toTime / this.msPerPixel);
        int size = extent = (int)(stopSample - startSample) + 1;
        boolean roundProb = this.samplesPerPixel * 10.0f % 10.0f != 0.0f;
        int oldStartPixel = (int)((float)oldStart / this.msPerPixel);
        int newStartPixel = (int)startSample;
        int distance = oldStartPixel - newStartPixel;
        if (distance == 0) {
            return true;
        }
        if (this.currentPart.rightOverlap(fromTime, toTime)) {
            this.currentPart.shiftInterval(distance);
            this.currentPart.setInterval(fromTime, toTime, (int)((float)fromTime / this.msPerPixel), size, extent);
            startSample = (long)((float)oldStop / this.msPerPixel);
            size = extent = (int)(stopSample - startSample) + 1;
            loadTime = oldStop;
        } else if (this.currentPart.leftOverlap(fromTime, toTime)) {
            this.currentPart.shiftInterval(distance);
            this.currentPart.setInterval(fromTime, toTime, (int)((float)fromTime / this.msPerPixel), size, extent);
            stopSample = (long)((float)oldStart / this.msPerPixel);
            size = extent = (int)(stopSample - startSample) + 1;
            loadTime = fromTime;
        } else {
            return false;
        }
        int samplesRead = 0;
        int startSampleInt = (int)startSample;
        int samplesPerPixelInt = (int)this.samplesPerPixel;
        double firstSeeksample = loadTime * (long)this.samp.getSampleFrequency() / 1000L;
        switch (this.channelMode) {
            case 0: 
            case 2: {
                if (roundProb) {
                    int startPixel = (int)((float)loadTime / this.msPerPixel);
                    long startSamp = (long)((float)startPixel * this.samplesPerPixel);
                    this.samp.seekSample(startSamp);
                    samplesRead = this.samp.readInterval((int)((float)extent * this.samplesPerPixel), 1);
                    for (int i = 0; i < size; ++i) {
                        int min = 0;
                        int max = 0;
                        int index = 0;
                        if (i > 0) {
                            long sm = (long)((float)(startPixel + i) * this.samplesPerPixel);
                            index = (int)(sm - startSamp);
                        }
                        int j = 0;
                        while ((float)j <= this.samplesPerPixel && j + index < this.samp.getFirstChannelArray().length) {
                            int sample = this.samp.getFirstChannelArray()[j + index];
                            if (sample < min) {
                                min = sample;
                            } else if (sample > max) {
                                max = sample;
                            }
                            ++j;
                        }
                        this.currentPart.addLineToFirstChannel(startSampleInt + i, -max, -min);
                    }
                } else {
                    this.samp.seekSample((long)firstSeeksample);
                    samplesRead = this.samp.readInterval((int)((float)extent * this.samplesPerPixel), 1);
                    int i = 0;
                    for (int p = startSampleInt; i < samplesRead - samplesPerPixelInt && p < startSampleInt + size; i += samplesPerPixelInt, ++p) {
                        int min = 0;
                        int max = 0;
                        for (int j = 0; j < samplesPerPixelInt; ++j) {
                            int sample = this.samp.getFirstChannelArray()[i + j];
                            if (sample < min) {
                                min = sample;
                                continue;
                            }
                            if (sample <= max) continue;
                            max = sample;
                        }
                        this.currentPart.addLineToFirstChannel(p, -max, -min);
                    }
                }
                break;
            }
            case 1: 
            case 3: {
                if (roundProb) {
                    int startPixel = (int)((float)loadTime / this.msPerPixel);
                    long startSamp = (long)((float)startPixel * this.samplesPerPixel);
                    this.samp.seekSample(startSamp);
                    samplesRead = this.samp.readInterval((int)((float)extent * this.samplesPerPixel), 2);
                    for (int i = 0; i < size; ++i) {
                        int min = 0;
                        int max = 0;
                        int min2 = 0;
                        int max2 = 0;
                        int index = 0;
                        if (i > 0) {
                            long sm = (long)((float)(startPixel + i) * this.samplesPerPixel);
                            index = (int)(sm - startSamp);
                        }
                        int j = 0;
                        while ((float)j <= this.samplesPerPixel && j + index < this.samp.getFirstChannelArray().length) {
                            int sample = this.samp.getFirstChannelArray()[j + index];
                            if (sample < min) {
                                min = sample;
                            } else if (sample > max) {
                                max = sample;
                            }
                            int sample2 = this.samp.getSecondChannelArray()[j + index];
                            if (sample2 < min2) {
                                min2 = sample2;
                            } else if (sample2 > max2) {
                                max2 = sample2;
                            }
                            ++j;
                        }
                        this.currentPart.addLineToFirstChannel(startSampleInt + i, -max, -min);
                        this.currentPart.addLineToRightChannel(startSampleInt + i, -max2, -min2);
                    }
                } else {
                    this.samp.seekSample((long)firstSeeksample);
                    samplesRead = this.samp.readInterval((int)((float)extent * this.samplesPerPixel), 2);
                    int i = 0;
                    for (int p = startSampleInt; i < samplesRead - samplesPerPixelInt && p < startSampleInt + size; i += samplesPerPixelInt, ++p) {
                        int min = 0;
                        int max = 0;
                        int min2 = 0;
                        int max2 = 0;
                        for (int j = 0; j < samplesPerPixelInt; ++j) {
                            int sample = this.samp.getFirstChannelArray()[i + j];
                            if (sample < min) {
                                min = sample;
                            } else if (sample > max) {
                                max = sample;
                            }
                            int sample2 = this.samp.getSecondChannelArray()[i + j];
                            if (sample2 < min2) {
                                min2 = sample2;
                                continue;
                            }
                            if (sample2 <= max2) continue;
                            max2 = sample2;
                        }
                        this.currentPart.addLineToFirstChannel(p, -max, -min);
                        this.currentPart.addLineToRightChannel(p, -max2, -min2);
                    }
                }
                break;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintBuffer() {
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        if (this.getWidth() != this.imageWidth || this.getHeight() != this.imageHeight) {
            this.imageWidth = this.getWidth();
            this.imageHeight = this.getHeight();
            if (this.intervalEndTime == 0L) {
                this.intervalEndTime = this.intervalBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
                if (this.timeScaleConnected) {
                    this.setGlobalTimeScaleIntervalEndTime(this.intervalEndTime);
                }
            }
        }
        Object object = this.paintlock;
        synchronized (object) {
            if (this.bi == null || this.bi.getWidth() < this.imageWidth || this.bi.getHeight() < this.imageHeight) {
                this.bi = new BufferedImage(this.imageWidth, this.imageHeight, 1);
                this.big2d = this.bi.createGraphics();
            }
            if (SystemReporting.antiAliasedText) {
                this.big2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            long mediaBT = this.intervalBeginTime + this.mediaOffset;
            long mediaET = this.intervalEndTime + this.mediaOffset;
            if ((float)mediaET > this.samp.getDuration()) {
                mediaET = (long)this.samp.getDuration();
            }
            if (!this.currentPart.contains(mediaBT, mediaET)) {
                boolean loaded = false;
                long begin = System.currentTimeMillis();
                if (this.currentPart.amountOfOverlap(mediaBT, mediaET) > 0.8f && this.currentPart.sameIntervalLength(mediaBT, mediaET)) {
                    loaded = this.shiftAndLoadData(mediaBT, mediaET);
                }
                if (!loaded) {
                    loaded = this.loadData(this.intervalBeginTime, this.intervalBeginTime + (long)((int)((float)(1 * this.imageWidth) * this.msPerPixel)), this.imageWidth);
                }
            }
            int intervalX1 = (int)((float)this.intervalBeginTime / this.msPerPixel);
            int waveIntervalX1 = (int)((float)(this.intervalBeginTime + this.mediaOffset) / this.msPerPixel);
            int waveIntervalX2 = (int)((float)mediaET / this.msPerPixel);
            AffineTransform at = new AffineTransform();
            this.big2d.setComposite(AlphaComposite.Src);
            this.big2d.setColor(Constants.DEFAULTBACKGROUNDCOLOR);
            this.big2d.fillRect(0, 0, this.imageWidth, this.imageHeight);
            if (this.intervalEndTime > this.getMediaDuration()) {
                int xx = this.xAt(this.getMediaDuration());
                if (!SystemReporting.isMacOS()) {
                    this.big2d.setColor(UIManager.getColor("Panel.background"));
                } else {
                    this.big2d.setColor(Color.LIGHT_GRAY);
                }
                this.big2d.fillRect(xx, 0, this.imageWidth - xx, this.bi.getHeight());
            }
            if (this.timeRulerVisible) {
                this.big2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
                this.big2d.translate((double)(-intervalX1), 0.0);
                this.ruler.paint(this.big2d, this.intervalBeginTime, this.imageWidth, this.msPerPixel, 1);
                this.big2d.translate((double)(intervalX1 - waveIntervalX1), 0.0);
            } else {
                this.big2d.translate((double)(-waveIntervalX1), 0.0);
            }
            switch (this.channelMode) {
                case 0: 
                case 2: {
                    int channelHeight = this.imageHeight - this.rulerHeight;
                    int channelMid = this.rulerHeight + Math.round((float)channelHeight / 2.0f);
                    this.big2d.translate(0.0, (double)channelMid);
                    this.big2d.setColor(Color.DARK_GRAY);
                    this.big2d.drawLine(waveIntervalX1, 0, waveIntervalX2, 0);
                    this.big2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
                    at.setToScale(1.0, (float)channelHeight / (float)this.maxAmplitude / 2.0f * ((float)this.vertZoom / 100.0f));
                    this.currentPart.paintLeftChannelLimit(this.big2d, at, channelHeight / 2);
                    this.big2d.translate(0.0, (double)(-channelMid));
                    int leftTop = this.rulerHeight;
                    int rightTop = this.rulerHeight;
                    this.drawSegmentation(this.big2d, leftTop, leftTop + channelHeight, rightTop, rightTop + channelHeight);
                    break;
                }
                case 1: {
                    int channelHeight = (this.imageHeight - this.rulerHeight - 4) / 2;
                    int leftChannelMid = this.rulerHeight + (int)Math.ceil((float)channelHeight / 2.0f);
                    int rightChannelMid = this.imageHeight - (int)Math.ceil((float)channelHeight / 2.0f);
                    this.big2d.setColor(Constants.SIGNALCHANNELCOLOR);
                    this.big2d.fillRect(waveIntervalX1, this.rulerHeight, this.imageWidth + 2, channelHeight);
                    this.big2d.fillRect(waveIntervalX1, this.imageHeight - channelHeight, this.imageWidth + 2, channelHeight);
                    this.big2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
                    this.big2d.translate(0.0, (double)leftChannelMid);
                    this.big2d.setColor(Color.DARK_GRAY);
                    this.big2d.drawLine(waveIntervalX1, 0, waveIntervalX2, 0);
                    this.big2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
                    at.setToScale(1.0, (float)channelHeight / (float)this.maxAmplitude / 2.0f * ((float)this.vertZoom / 100.0f));
                    this.currentPart.paintLeftChannelLimit(this.big2d, at, channelHeight / 2);
                    this.big2d.translate(0.0, (double)(rightChannelMid - leftChannelMid));
                    this.big2d.setColor(Color.DARK_GRAY);
                    this.big2d.drawLine(waveIntervalX1, 0, waveIntervalX2, 0);
                    this.big2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
                    this.currentPart.paintRightChannelLimit(this.big2d, at, channelHeight / 2);
                    this.big2d.translate(0.0, (double)(-rightChannelMid));
                    int leftTop = this.rulerHeight;
                    int rightTop = leftTop + channelHeight + 4;
                    this.drawSegmentation(this.big2d, leftTop, leftTop + channelHeight, rightTop, rightTop + channelHeight);
                    break;
                }
                case 3: {
                    int channelHeight = this.imageHeight - this.rulerHeight;
                    int chMid = this.rulerHeight + Math.round((float)channelHeight / 2.0f);
                    this.big2d.translate(0.0, (double)chMid);
                    this.big2d.drawLine(waveIntervalX1, 0, waveIntervalX2, 0);
                    at.setToScale(1.0, (float)channelHeight / (float)this.maxAmplitude / 2.0f * ((float)this.vertZoom / 100.0f));
                    this.big2d.setColor(Constants.SIGNALSTEREOBLENDEDCOLOR1);
                    this.currentPart.paintLeftChannelLimit(this.big2d, at, channelHeight / 2);
                    this.big2d.setColor(Constants.SIGNALSTEREOBLENDEDCOLOR2);
                    this.big2d.setComposite(this.alpha04);
                    this.currentPart.paintRightChannelLimit(this.big2d, at, channelHeight / 2);
                    this.big2d.setComposite(AlphaComposite.Src);
                    this.big2d.translate(0.0, (double)(-chMid));
                    int leftTop = this.rulerHeight;
                    int rightTop = this.rulerHeight;
                    this.drawSegmentation(this.big2d, leftTop, leftTop + channelHeight, rightTop, rightTop + channelHeight);
                    break;
                }
            }
            this.drawCuePoints(this.big2d);
            this.big2d.setTransform(new AffineTransform());
        }
        if (this.timeRulerVisible) {
            this.big2d.setColor(Constants.SELECTIONCOLOR);
            this.big2d.drawLine(0, this.rulerHeight, this.imageWidth, this.rulerHeight);
        }
        this.repaint();
    }

    private void drawSegmentation(Graphics2D big2d, int imageTopLeft, int imageBottomLeft, int imageTopRight, int imageBottomRight) {
        Rectangle2D rect;
        int x;
        String label;
        Boundary boundary;
        long to;
        long from;
        int i;
        FontRenderContext frc;
        AffineTransform aft = big2d.getTransform();
        if (this.segmentationChannel1 != null && this.showSegmentationChannel1) {
            frc = big2d.getFontRenderContext();
            for (i = 0; i < this.imageWidth; ++i) {
                from = this.intervalBeginTime + (long)((int)((float)i * this.msPerPixel));
                to = (long)((float)from + this.msPerPixel);
                boundary = this.segmentationChannel1.boundaryBetween(from, to);
                label = null;
                if (boundary != null) {
                    label = boundary.label;
                }
                x = (int)((double)i - aft.getTranslateX());
                if (label == null) continue;
                big2d.setColor(Constants.SEGMENTATIONCOLOR);
                big2d.drawLine(x, imageTopLeft, x, imageBottomLeft);
                if (label.equals("")) continue;
                rect = big2d.getFont().getStringBounds(label, frc);
                big2d.setColor(Color.white);
                big2d.fill3DRect(x + 3, imageBottomLeft - (int)rect.getHeight() - 2, (int)rect.getWidth() + 6, (int)rect.getHeight() + 2, true);
                big2d.setColor(Color.black);
                big2d.drawString(label, x + 5, imageBottomLeft - 3);
            }
        }
        if (this.segmentationChannel2 != null && this.showSegmentationChannel2) {
            frc = big2d.getFontRenderContext();
            for (i = 0; i < this.imageWidth; ++i) {
                from = this.intervalBeginTime + (long)((int)((float)i * this.msPerPixel));
                to = (long)((float)from + this.msPerPixel);
                boundary = this.segmentationChannel2.boundaryBetween(from, to);
                label = null;
                if (boundary != null) {
                    label = boundary.label;
                }
                x = (int)((double)i - aft.getTranslateX());
                if (label == null) continue;
                big2d.setColor(Constants.SEGMENTATIONCOLOR);
                big2d.drawLine(x, imageTopRight, x, imageBottomRight);
                if (label.equals("")) continue;
                rect = big2d.getFont().getStringBounds(label, frc);
                big2d.setColor(Color.white);
                big2d.fill3DRect(x + 3, imageBottomRight - (int)rect.getHeight() - 2, (int)rect.getWidth() + 6, (int)rect.getHeight() + 2, true);
                big2d.setColor(Color.black);
                big2d.drawString(label, x + 5, imageBottomRight - 3);
            }
        }
    }

    public void setSegmentation(BoundarySegmentation segmentation) {
        this.segmentationChannel1 = segmentation;
        if (segmentation != null) {
            this.segmentationChannel2 = null;
            this.segmentationChannel1Item.setSelected(true);
            this.showSegmentationChannel1 = true;
        } else {
            this.segmentationChannel1Item.setSelected(false);
            this.showSegmentationChannel1 = false;
        }
        this.enableSegmentationMenu();
        this.paintBuffer();
    }

    public void setSegmentationChannel1(BoundarySegmentation segmentation) {
        this.segmentationChannel1 = segmentation;
        if (this.segmentationChannel1 != null) {
            this.segmentationChannel1Item.setSelected(true);
            this.showSegmentationChannel1 = true;
        } else {
            this.segmentationChannel1Item.setSelected(false);
            this.showSegmentationChannel1 = false;
        }
        this.enableSegmentationMenu();
        this.paintBuffer();
    }

    public void setSegmentationChannel2(BoundarySegmentation segmentation) {
        this.segmentationChannel2 = segmentation;
        if (this.segmentationChannel2 != null && this.segmentationChannel2Item != null) {
            this.segmentationChannel2Item.setSelected(true);
            this.showSegmentationChannel2 = true;
        } else if (this.segmentationChannel2Item != null) {
            this.segmentationChannel2Item.setSelected(false);
            this.showSegmentationChannel2 = false;
        }
        this.enableSegmentationMenu();
        this.paintBuffer();
    }

    public void enableSegmentationMenu() {
        if (this.segmentationChannel1 != null) {
            this.segmentationMenu.setEnabled(true);
            this.segmentationChannel1Item.setEnabled(true);
        } else {
            this.segmentationChannel1Item.setEnabled(false);
        }
        if (this.segmentationChannel2 != null) {
            this.segmentationMenu.setEnabled(true);
            this.segmentationChannel2Item.setEnabled(true);
        } else if (this.getChannelMode() != 0) {
            this.segmentationChannel2Item.setEnabled(false);
        }
        if (this.segmentationChannel1 == null && this.segmentationChannel2 == null) {
            this.segmentationMenu.setEnabled(false);
        }
    }

    private void drawCuePoints(Graphics2D big2g) {
        if (this.samp == null) {
            return;
        }
        WAVCuePoint[] cuePoints = this.samp.getWavHeader().getCuePoints();
        if (cuePoints.length > 0) {
            this.big2d.setStroke(new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{4.0f}, 0.0f));
            this.big2d.setColor(Color.darkGray);
            for (int i = 0; i < cuePoints.length; ++i) {
                int time = (int)this.samp.getTimeAtSample(cuePoints[i].getSampleOffset());
                int x = (int)((float)time / this.msPerPixel);
                if (this.intervalBeginTime > (long)time || (long)time >= this.intervalEndTime) continue;
                this.big2d.drawLine(x, this.rulerHeight, x, this.imageHeight);
                String label = cuePoints[i].getLabel();
                String note = cuePoints[i].getNote();
                if (label != null && note != null) {
                    label = label + " : ";
                }
                this.big2d.drawString((label != null ? label : new Integer(i).toString()) + (note != null ? note : ""), x + 1, this.imageHeight - 1);
            }
            this.big2d.setStroke(new BasicStroke());
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (SystemReporting.antiAliasedText) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        int h = this.getHeight();
        if (this.bi != null) {
            g2d.drawImage((Image)this.bi, 0, 0, this);
        }
        if (this.selectionBeginPos != this.selectionEndPos) {
            g2d.setColor(this.selectionColor);
            g2d.setComposite(this.alpha04);
            g2d.fillRect(this.selectionBeginPos, 0, this.selectionEndPos - this.selectionBeginPos, this.rulerHeight);
            g2d.setComposite(this.alpha07);
            g2d.fillRect(this.selectionBeginPos, this.rulerHeight, this.selectionEndPos - this.selectionBeginPos, h - this.rulerHeight);
            g2d.setComposite(AlphaComposite.Src);
        }
        g2d.setColor(Constants.CROSSHAIRCOLOR);
        g2d.drawLine(this.crossHairPos, 0, this.crossHairPos, h);
        if (this.errorKey != null) {
            g2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
            g2d.drawString(this.errorKey, 10, 20 + this.rulerHeight);
        }
    }

    @Override
    public void updateTimeScale() {
        if (this.timeScaleConnected) {
            if (this.getGlobalTimeScaleMsPerPixel() != this.msPerPixel) {
                this.setLocalTimeScaleMsPerPixel(this.getGlobalTimeScaleMsPerPixel());
            } else if (this.getGlobalTimeScaleIntervalBeginTime() != this.intervalBeginTime) {
                this.setLocalTimeScaleIntervalBeginTime(this.getGlobalTimeScaleIntervalBeginTime());
            }
        }
    }

    public void setTimeScaleConnected(boolean connected) {
        this.timeScaleConnected = connected;
        if (this.timeScaleConnected) {
            if (this.msPerPixel != this.getGlobalTimeScaleMsPerPixel()) {
                this.setLocalTimeScaleMsPerPixel(this.getGlobalTimeScaleMsPerPixel());
            }
            if (this.intervalBeginTime != this.getGlobalTimeScaleIntervalBeginTime()) {
                this.setLocalTimeScaleIntervalBeginTime(this.getGlobalTimeScaleIntervalBeginTime());
            }
        }
    }

    public boolean getTimeScaleConnected() {
        return this.timeScaleConnected;
    }

    public void setMsPerPixel(float mspp) {
        if (this.timeScaleConnected) {
            this.setGlobalTimeScaleMsPerPixel(mspp);
            this.setGlobalTimeScaleIntervalBeginTime(this.intervalBeginTime);
            this.setGlobalTimeScaleIntervalEndTime(this.intervalEndTime);
        } else {
            this.setLocalTimeScaleMsPerPixel(mspp);
        }
    }

    private void setLocalTimeScaleMsPerPixel(float step) {
        int zoom;
        boolean playing;
        if (this.msPerPixel == step) {
            return;
        }
        this.msPerPixel = step >= 0.025f ? step : 0.025f;
        if (this.currentPart != null) {
            this.currentPart.setDrawExtremesContour(this.msPerPixel <= 0.5f);
        }
        if (playing = this.playerIsPlaying()) {
            this.stopPlayer();
        }
        long mediaTime = this.getMediaTime();
        int oldScreenPos = this.crossHairPos;
        int newMediaX = (int)((float)mediaTime / this.msPerPixel);
        int numScreens = (int)((float)mediaTime / ((float)this.imageWidth * this.msPerPixel));
        int newScreenPos = newMediaX - numScreens * this.imageWidth;
        int diff = oldScreenPos - newScreenPos;
        this.intervalBeginTime = (long)((float)(numScreens * this.imageWidth - diff) * this.msPerPixel);
        if (this.intervalBeginTime < 0L) {
            this.intervalBeginTime = 0L;
        }
        this.intervalEndTime = this.intervalBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
        this.crossHairPos = this.xAt(mediaTime);
        this.selectionBeginPos = this.xAt(this.getSelectionBeginTime());
        this.selectionEndPos = this.xAt(this.getSelectionEndTime());
        if (this.samp != null) {
            this.samplesPerPixel = this.msPerPixel * (float)this.samp.getSampleFrequency() / 1000.0f;
        }
        this.currentPart.setStartTime(0L);
        this.currentPart.setStopTime(0L);
        this.paintBuffer();
        if (playing) {
            this.startPlayer();
        }
        if ((zoom = (int)(100.0f * (10.0f / this.msPerPixel))) <= 0) {
            zoom = 100;
        }
        this.updateZoomPopup(zoom);
        this.setPreference("SignalViewer.ZoomLevel", new Float(zoom), this.getViewerManager().getTranscription());
    }

    public float getMsPerPixel() {
        return this.msPerPixel;
    }

    public int getChannelMode() {
        return this.channelMode;
    }

    public void setChannelMode(int mode, boolean storePref) {
        if (mode == this.channelMode) {
            return;
        }
        if (mode <= 0 || mode > 3) {
            this.channelMode = 0;
        } else {
            if (this.samp != null && this.samp.getWavHeader().getNumberOfChannels() != 2) {
                this.channelMode = 0;
                return;
            }
            this.channelMode = mode;
        }
        if (storePref) {
            this.setPreference("SignalViewer.StereoMode", new Integer(this.channelMode), this.getViewerManager().getTranscription());
        }
        this.paintBuffer();
    }

    public boolean isTimeRulerVisible() {
        return this.timeRulerVisible;
    }

    public void setTimeRulerVisible(boolean timeRulerVisible) {
        this.timeRulerVisible = timeRulerVisible;
        if (this.timeRulerVisMI != null && this.timeRulerVisMI.isSelected() != timeRulerVisible) {
            this.timeRulerVisMI.setSelected(timeRulerVisible);
        }
        this.rulerHeight = timeRulerVisible ? this.ruler.getHeight() : 0;
        this.paintBuffer();
    }

    public int xAt(long t) {
        return (int)((float)t / this.msPerPixel - (float)this.intervalBeginTime / this.msPerPixel);
    }

    public long timeAt(int x) {
        return this.intervalBeginTime + (long)((float)x * this.msPerPixel);
    }

    public long getIntervalBeginTime() {
        return this.intervalBeginTime;
    }

    public long getIntervalEndTime() {
        return this.intervalEndTime;
    }

    public void setIntervalBeginTime(long begin) {
        if (this.timeScaleConnected) {
            this.setGlobalTimeScaleIntervalBeginTime(begin);
            this.setGlobalTimeScaleIntervalEndTime(this.intervalEndTime);
        } else {
            this.setLocalTimeScaleIntervalBeginTime(begin);
        }
    }

    public void setRecalculateInterval(boolean recalculate) {
        this.recalculateInterval = recalculate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void recalculateInterval(long mediaTime) {
        if (!this.recalculateInterval) {
            return;
        }
        long newBeginTime = this.intervalBeginTime;
        long newEndTime = this.intervalEndTime;
        if (this.playerIsPlaying()) {
            if (mediaTime > this.intervalEndTime) {
                newBeginTime = this.intervalEndTime;
                newEndTime = newBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
                while ((newEndTime = (long)((float)newEndTime + ((float)this.imageWidth + this.msPerPixel))) < mediaTime) {
                    newBeginTime = (long)((float)newBeginTime + (float)this.imageWidth * this.msPerPixel);
                }
            } else {
                if (mediaTime >= this.intervalBeginTime) return;
                newEndTime = this.intervalBeginTime;
                newBeginTime = newEndTime - (long)((int)((float)this.imageWidth * this.msPerPixel));
                while ((newEndTime = (long)((float)newEndTime - (float)this.imageWidth * this.msPerPixel)) > mediaTime) {
                    newBeginTime = (long)((float)newBeginTime - (float)this.imageWidth * this.msPerPixel);
                }
                if (newBeginTime < 0L) {
                    newBeginTime = 0L;
                    newEndTime = (long)((float)this.imageWidth * this.msPerPixel);
                }
            }
        } else {
            if (mediaTime < this.intervalBeginTime) {
                newBeginTime = mediaTime - (long)((int)(16.0f * this.msPerPixel));
                if (newBeginTime < 0L) {
                    newBeginTime = 0L;
                }
                newEndTime = newBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
            } else if (mediaTime > this.intervalEndTime && (newBeginTime = (newEndTime = mediaTime + (long)((int)(16.0f * this.msPerPixel))) - (long)((int)((float)this.imageWidth * this.msPerPixel))) < 0L) {
                newBeginTime = 0L;
                newEndTime = newBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
            }
            if (newBeginTime == this.getSelectionBeginTime() && (float)newBeginTime > 16.0f * this.msPerPixel) {
                newBeginTime = (long)((float)newBeginTime - 16.0f * this.msPerPixel);
                newEndTime = newBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
            }
            if (newEndTime == this.getSelectionEndTime() && (newBeginTime = (newEndTime = (long)((float)newEndTime + 16.0f * this.msPerPixel)) - (long)((int)((float)this.imageWidth * this.msPerPixel))) < 0L) {
                newBeginTime = 0L;
                newEndTime = newBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
            }
        }
        if (this.timeScaleConnected) {
            this.setGlobalTimeScaleIntervalBeginTime(newBeginTime);
            this.setGlobalTimeScaleIntervalEndTime(newEndTime);
            return;
        } else {
            this.setLocalTimeScaleIntervalBeginTime(newBeginTime);
        }
    }

    private void setLocalTimeScaleIntervalBeginTime(long begin) {
        if (begin == this.intervalBeginTime) {
            return;
        }
        this.intervalBeginTime = begin;
        this.intervalEndTime = this.intervalBeginTime + (long)((int)((float)this.imageWidth * this.msPerPixel));
        this.crossHairPos = this.xAt(this.crossHairTime);
        this.selectionBeginPos = this.xAt(this.getSelectionBeginTime());
        this.selectionEndPos = this.xAt(this.getSelectionEndTime());
        this.paintBuffer();
    }

    private void createPopupMenu() {
        JRadioButtonMenuItem zoomRB;
        this.popup = new JPopupMenu("Signal Viewer");
        JMenu zoomMI = new JMenu(ElanLocale.getString("TimeScaleBasedViewer.Zoom"));
        this.zoomBG = new ButtonGroup();
        this.zoomSelectionMI = new JMenuItem(ElanLocale.getString("TimeScaleBasedViewer.Zoom.Selection"));
        this.zoomSelectionMI.addActionListener(this);
        this.zoomSelectionMI.setActionCommand("zoomSel");
        zoomMI.add(this.zoomSelectionMI);
        this.customZoomMI = new JRadioButtonMenuItem(ElanLocale.getString("TimeScaleBasedViewer.Zoom.Custom"));
        this.customZoomMI.setEnabled(false);
        this.zoomBG.add(this.customZoomMI);
        zoomMI.add(this.customZoomMI);
        zoomMI.addSeparator();
        for (int i = 0; i < this.ZOOMLEVELS.length; ++i) {
            zoomRB = new JRadioButtonMenuItem(this.ZOOMLEVELS[i] + "%");
            zoomRB.setActionCommand(String.valueOf(this.ZOOMLEVELS[i]));
            zoomRB.addActionListener(this);
            this.zoomBG.add(zoomRB);
            zoomMI.add(zoomRB);
            if (this.ZOOMLEVELS[i] != 100) continue;
            zoomRB.setSelected(true);
        }
        this.popup.add(zoomMI);
        JMenu vertZoomMenu = new JMenu(ElanLocale.getString("SignalViewer.VertZoom"));
        this.vertZoomGroup = new ButtonGroup();
        for (int i = 0; i < this.VERT_ZOOM.length; ++i) {
            zoomRB = new JRadioButtonMenuItem(this.VERT_ZOOM[i] + "%");
            zoomRB.setActionCommand("vz-" + this.VERT_ZOOM[i]);
            zoomRB.addActionListener(this);
            this.vertZoomGroup.add(zoomRB);
            vertZoomMenu.add(zoomRB);
            if (this.vertZoom != this.VERT_ZOOM[i]) continue;
            zoomRB.setSelected(true);
        }
        this.popup.add(vertZoomMenu);
        if (this.samp != null && this.samp.getWavHeader().getNumberOfChannels() == 2) {
            ButtonGroup chanGroup = new ButtonGroup();
            JMenu channelMI = new JMenu(ElanLocale.getString("SignalViewer.Stereo"));
            this.separateMI = new JRadioButtonMenuItem(ElanLocale.getString("SignalViewer.Stereo.Separate"));
            this.separateMI.setActionCommand("sep");
            this.separateMI.addActionListener(this);
            chanGroup.add(this.separateMI);
            channelMI.add(this.separateMI);
            if (this.channelMode == 1) {
                this.separateMI.setSelected(true);
            }
            this.mergedMI = new JRadioButtonMenuItem(ElanLocale.getString("SignalViewer.Stereo.Merged"));
            this.mergedMI.setActionCommand("merge");
            this.mergedMI.addActionListener(this);
            chanGroup.add(this.mergedMI);
            channelMI.add(this.mergedMI);
            if (this.channelMode == 2) {
                this.mergedMI.setSelected(true);
            }
            this.blendMI = new JRadioButtonMenuItem(ElanLocale.getString("SignalViewer.Stereo.Blended"));
            this.blendMI.setActionCommand("blend");
            this.blendMI.addActionListener(this);
            chanGroup.add(this.blendMI);
            channelMI.add(this.blendMI);
            if (this.channelMode == 3) {
                this.blendMI.setSelected(true);
            }
            this.popup.add(channelMI);
        }
        this.timeRulerVisMI = new JCheckBoxMenuItem(ElanLocale.getString("TimeScaleBasedViewer.TimeRuler.Visible"));
        this.timeRulerVisMI.setSelected(this.timeRulerVisible);
        this.timeRulerVisMI.addActionListener(this);
        this.popup.add(this.timeRulerVisMI);
        if (this.allowConnecting) {
            this.timeScaleConMI = new JCheckBoxMenuItem(ElanLocale.getString("TimeScaleBasedViewer.Connected"), this.timeScaleConnected);
            this.timeScaleConMI.setActionCommand("connect");
            this.timeScaleConMI.addActionListener(this);
            this.popup.add(this.timeScaleConMI);
        }
        this.popup.addSeparator();
        JMenuItem praatMI = new JMenuItem(ElanLocale.getString("SignalViewer.Praat.File"));
        praatMI.setActionCommand("praat");
        praatMI.addActionListener(this);
        this.popup.add(praatMI);
        this.praatSelMI = new JMenuItem(ElanLocale.getString("SignalViewer.Praat.Selection"));
        this.praatSelMI.setActionCommand("praatSel");
        this.praatSelMI.addActionListener(this);
        this.popup.add(this.praatSelMI);
        this.clipSelPraatMI = new JMenuItem(ElanLocale.getString("SignalViewer.Praat.Clip"));
        this.clipSelPraatMI.setActionCommand("clipSel");
        this.clipSelPraatMI.addActionListener(this);
        this.popup.add(this.clipSelPraatMI);
        if (this.getSelectionBeginTime() == this.getSelectionEndTime()) {
            this.praatSelMI.setEnabled(false);
            this.clipSelPraatMI.setEnabled(false);
        } else {
            this.praatSelMI.setEnabled(true);
            this.clipSelPraatMI.setEnabled(true);
        }
        if (this.samp != null) {
            this.popup.addSeparator();
            this.segmentationMenu = new JMenu(ElanLocale.getString("SignalViewer.Segmentation"));
            if (this.samp.getWavHeader().getNumberOfChannels() == 2) {
                this.segmentationChannel1Item = new JCheckBoxMenuItem(ElanLocale.getString("SignalViewer.Segmentation.LeftVisible"), this.showSegmentationChannel1);
                this.segmentationChannel1Item.addActionListener(this);
                this.segmentationMenu.add(this.segmentationChannel1Item);
                this.segmentationChannel2Item = new JCheckBoxMenuItem(ElanLocale.getString("SignalViewer.Segmentation.RightVisible"), this.showSegmentationChannel2);
                this.segmentationChannel2Item.addActionListener(this);
                this.segmentationMenu.add(this.segmentationChannel2Item);
                this.popup.add(this.segmentationMenu);
                this.segmentationMenu.setEnabled(false);
                this.segmentationChannel1Item.setEnabled(false);
                this.segmentationChannel2Item.setEnabled(false);
            } else {
                this.segmentationChannel1Item = new JCheckBoxMenuItem(ElanLocale.getString("SignalViewer.Segmentation.Visible"), this.showSegmentationChannel1);
                this.segmentationChannel1Item.addActionListener(this);
                this.segmentationMenu.add(this.segmentationChannel1Item);
                this.popup.add(this.segmentationMenu);
                this.segmentationMenu.setEnabled(false);
                this.segmentationChannel1Item.setEnabled(false);
            }
        }
        if (this.allowConnecting) {
            this.popup.addSeparator();
            this.infoItem = new JMenuItem(ElanLocale.getString("Player.Info"));
            this.infoItem.setActionCommand("info");
            this.infoItem.addActionListener(this);
            this.popup.add(this.infoItem);
        }
        this.copyOrigTimeItem = new JMenuItem(ElanLocale.getString("Player.CopyTimeIgnoringOffset"));
        this.copyOrigTimeItem.addActionListener(this);
        this.popup.add(this.copyOrigTimeItem);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        int zoom = (int)(100.0f * (10.0f / this.msPerPixel));
        if (zoom <= 0) {
            zoom = 100;
        }
        this.updateZoomPopup(zoom);
    }

    private void updateZoomPopup(int zoom) {
        int zoomMenuIndex = -1;
        for (int i = 0; i < this.ZOOMLEVELS.length; ++i) {
            if (zoom - this.ZOOMLEVELS[i] < -1 || zoom - this.ZOOMLEVELS[i] > 1) continue;
            zoomMenuIndex = i;
            break;
        }
        if (this.popup != null) {
            Enumeration<AbstractButton> en = this.zoomBG.getElements();
            int counter = 0;
            while (en.hasMoreElements()) {
                JRadioButtonMenuItem rbmi = (JRadioButtonMenuItem)en.nextElement();
                if (counter == zoomMenuIndex + 1) {
                    rbmi.setSelected(true);
                    break;
                }
                rbmi.setSelected(false);
                ++counter;
            }
            if (zoomMenuIndex == -1) {
                this.customZoomMI.setSelected(true);
                this.customZoomMI.setText(ElanLocale.getString("TimeScaleBasedViewer.Zoom.Custom") + " - " + zoom + "%");
            } else {
                this.customZoomMI.setText(ElanLocale.getString("TimeScaleBasedViewer.Zoom.Custom"));
            }
        }
    }

    private void zoomIn() {
        float zoom = 100.0f / (this.msPerPixel / 10.0f);
        float nz = zoom + 10.0f;
        float nm = 100.0f / nz * 10.0f;
        this.setMsPerPixel(nm);
    }

    private void zoomOut() {
        float zoom = 100.0f / (this.msPerPixel / 10.0f);
        float nz = zoom - 10.0f;
        if (nz < 10.0f) {
            nz = 10.0f;
        }
        float nm = 100.0f / nz * 10.0f;
        this.setMsPerPixel(nm);
    }

    private void zoomToSelection() {
        int sw;
        long selInterval = this.getSelectionEndTime() - this.getSelectionBeginTime();
        float nextMsPP = (float)selInterval / (float)(sw = this.imageWidth != 0 ? this.imageWidth - 32 : this.getWidth() - 32);
        if (nextMsPP > 200.0f) {
            nextMsPP = 200.0f;
        }
        if (nextMsPP < 0.025f) {
            nextMsPP = 0.025f;
        }
        this.setMsPerPixel(nextMsPP);
        if (!this.playerIsPlaying()) {
            long ibt = this.getSelectionBeginTime() - (long)(16.0f * this.msPerPixel);
            if (ibt < 0L) {
                ibt = 0L;
            }
            this.setIntervalBeginTime(ibt);
        }
        this.setPreference("SignalViewer.ZoomLevel", new Float(100.0f * (10.0f / this.msPerPixel)), this.getViewerManager().getTranscription());
    }

    private void updateVertZoomPopup(int vertZoom) {
        if (this.popup != null) {
            Enumeration<AbstractButton> en = this.vertZoomGroup.getElements();
            while (en.hasMoreElements()) {
                JRadioButtonMenuItem rbmi = (JRadioButtonMenuItem)en.nextElement();
                if (rbmi.getText().indexOf("" + vertZoom) > -1) {
                    rbmi.setSelected(true);
                    break;
                }
                rbmi.setSelected(false);
            }
        }
    }

    public void setOffset(long offset) {
        if (offset != this.mediaOffset) {
            this.mediaOffset = offset;
            this.currentPart.setStartTime(0L);
            this.currentPart.setStopTime(0L);
            this.paintBuffer();
        }
    }

    @Override
    public void controllerUpdate(ControllerEvent event) {
        if (event instanceof TimeEvent || event instanceof StopEvent) {
            this.crossHairTime = this.getMediaTime();
            if (this.crossHairTime == this.intervalEndTime && !this.playerIsPlaying()) {
                this.recalculateInterval(this.crossHairTime);
            } else if (this.crossHairTime < this.intervalBeginTime || this.crossHairTime > this.intervalEndTime) {
                this.recalculateInterval(this.crossHairTime);
            } else {
                int oldCrossHairPos = this.crossHairPos;
                this.crossHairPos = this.xAt(this.crossHairTime);
                if (this.crossHairPos >= oldCrossHairPos) {
                    this.repaint(oldCrossHairPos - 1, 0, this.crossHairPos - oldCrossHairPos + 2, this.getHeight());
                } else {
                    this.repaint(this.crossHairPos - 1, 0, oldCrossHairPos - this.crossHairPos + 2, this.getHeight());
                }
            }
        }
    }

    @Override
    public void updateSelection() {
        this.selectionBeginPos = this.xAt(this.getSelectionBeginTime());
        this.selectionEndPos = this.xAt(this.getSelectionEndTime());
        if (this.praatSelMI != null) {
            if (this.selectionBeginPos == this.selectionEndPos) {
                this.praatSelMI.setEnabled(false);
            } else {
                this.praatSelMI.setEnabled(true);
            }
        }
        if (this.clipSelPraatMI != null) {
            if (this.selectionBeginPos == this.selectionEndPos) {
                this.clipSelPraatMI.setEnabled(false);
            } else {
                this.clipSelPraatMI.setEnabled(true);
            }
        }
        this.repaint();
    }

    public void updateInterval(long begin, long end) {
        long selInterval = end - begin;
        int sw = this.imageWidth != 0 ? this.imageWidth - 32 : this.getWidth() - 32;
        float nextMsPP = (float)selInterval / (float)sw;
        if (nextMsPP > 200.0f) {
            nextMsPP = 200.0f;
        }
        if (nextMsPP < 0.025f) {
            nextMsPP = 0.025f;
        }
        this.setMsPerPixel(nextMsPP);
        if (!this.playerIsPlaying()) {
            long ibt = begin - (long)(16.0f * this.msPerPixel);
            if (ibt < 0L) {
                ibt = 0L;
            }
            this.setIntervalBeginTime(ibt);
        }
        this.repaint();
    }

    @Override
    public void updateActiveAnnotation() {
    }

    @Override
    public void updateLocale() {
        if (this.popup != null) {
            this.createPopupMenu();
        }
    }

    public int getLeftMargin() {
        return 0;
    }

    public int getRightMargin() {
        return 0;
    }

    private void printMem(String message) {
        System.out.println(message);
        Runtime r = Runtime.getRuntime();
        System.out.println("Total memory: " + r.totalMemory() / 1024L + " Kb");
        System.out.println("Free memory: " + r.freeMemory() / 1024L + " Kb");
    }

    private void copyToClipboard(String text) {
        if (text == null) {
            return;
        }
        if (System.getSecurityManager() != null) {
            try {
                System.getSecurityManager().checkSystemClipboardAccess();
                StringSelection ssVal = new StringSelection(text);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ssVal, null);
            }
            catch (SecurityException se) {
            }
            catch (IllegalStateException ise) {}
        } else {
            try {
                StringSelection ssVal = new StringSelection(text);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ssVal, null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.intervalEndTime = this.intervalBeginTime + (long)((int)((float)this.getWidth() * this.msPerPixel));
        if (this.timeScaleConnected) {
            this.setGlobalTimeScaleIntervalEndTime(this.intervalEndTime);
        }
        this.paintBuffer();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        Point pp = e.getPoint();
        if (e.getClickCount() == 2) {
            long clickTime = this.timeAt(pp.x);
            switch (this.channelMode) {
                case 0: {
                    if (this.segmentationChannel1 == null || !this.showSegmentationChannel1) break;
                    long beforeTime = this.segmentationChannel1.boundaryTimeBefore(clickTime);
                    long afterTime = this.segmentationChannel1.boundaryTimeAfter(clickTime);
                    this.setSelection(beforeTime, afterTime);
                    this.setMediaTime(beforeTime);
                    break;
                }
                case 1: {
                    if (pp.y < ((SignalViewer)e.getSource()).getHeight() / 2) {
                        if (this.segmentationChannel1 == null || !this.showSegmentationChannel1) break;
                        long beforeTime = this.segmentationChannel1.boundaryTimeBefore(clickTime);
                        long afterTime = this.segmentationChannel1.boundaryTimeAfter(clickTime);
                        this.setSelection(beforeTime, afterTime);
                        this.setMediaTime(beforeTime);
                        break;
                    }
                    if (this.segmentationChannel2 == null || !this.showSegmentationChannel2) break;
                    long beforeTime = this.segmentationChannel2.boundaryTimeBefore(clickTime);
                    long afterTime = this.segmentationChannel2.boundaryTimeAfter(clickTime);
                    this.setSelection(beforeTime, afterTime);
                    this.setMediaTime(beforeTime);
                    break;
                }
                case 2: 
                case 3: {
                    if (this.segmentationChannel1 != null && this.showSegmentationChannel1 && !this.showSegmentationChannel2) {
                        long beforeTime = this.segmentationChannel1.boundaryTimeBefore(clickTime);
                        long afterTime = this.segmentationChannel1.boundaryTimeAfter(clickTime);
                        this.setSelection(beforeTime, afterTime);
                        this.setMediaTime(beforeTime);
                        break;
                    }
                    if (this.segmentationChannel2 == null || !this.showSegmentationChannel2 || this.showSegmentationChannel1) break;
                    long beforeTime = this.segmentationChannel2.boundaryTimeBefore(clickTime);
                    long afterTime = this.segmentationChannel2.boundaryTimeAfter(clickTime);
                    this.setSelection(beforeTime, afterTime);
                    this.setMediaTime(beforeTime);
                }
            }
        } else if (e.getClickCount() == 1 && e.isShiftDown()) {
            if (this.getSelectionBeginTime() != this.getSelectionEndTime()) {
                long clickTime = this.timeAt(pp.x);
                if (clickTime > this.getSelectionEndTime()) {
                    this.setSelection(this.getSelectionBeginTime(), clickTime);
                } else if (clickTime < this.getSelectionBeginTime()) {
                    this.setSelection(clickTime, this.getSelectionEndTime());
                } else if (clickTime - this.getSelectionBeginTime() < this.getSelectionEndTime() - clickTime) {
                    this.setSelection(clickTime, this.getSelectionEndTime());
                } else {
                    this.setSelection(this.getSelectionBeginTime(), clickTime);
                }
            } else {
                long medTime;
                long clickTime = this.timeAt(pp.x);
                if (clickTime > (medTime = this.getMediaTime())) {
                    this.setSelection(medTime, clickTime);
                } else if (clickTime < medTime) {
                    this.setSelection(clickTime, medTime);
                }
            }
        } else if (SwingUtilities.isLeftMouseButton(e)) {
            this.setMediaTime(this.timeAt(pp.x));
        }
        if (this.clearSelOnSingleClick && e.getClickCount() == 1 && !e.isShiftDown() && !this.popup.isShowing() && !this.getViewerManager().getMediaPlayerController().getSelectionMode()) {
            this.setSelection(0L, 0L);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            Point pp = e.getPoint();
            if (this.popup == null) {
                this.createPopupMenu();
            }
            if (this.popup.getWidth() == 0 || this.popup.getHeight() == 0) {
                this.popup.show(this, pp.x, pp.y);
            } else {
                this.popup.show(this, pp.x, pp.y);
                SwingUtilities.convertPointToScreen(pp, this);
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                Window w = SwingUtilities.windowForComponent(this);
                if (pp.x + this.popup.getWidth() > d.width) {
                    pp.x -= this.popup.getWidth();
                }
                if (pp.y + this.popup.getHeight() > d.height) {
                    pp.y -= this.popup.getHeight();
                }
                if (pp.y + this.popup.getHeight() > w.getLocationOnScreen().y + w.getHeight()) {
                    pp.y -= this.popup.getHeight();
                }
                this.popup.setLocation(pp);
            }
            return;
        }
        if (this.playerIsPlaying()) {
            this.stopPlayer();
        }
        this.dragStartPoint = e.getPoint();
        this.dragStartTime = this.timeAt(this.dragStartPoint.x);
        if (e.isAltDown() && this.dragStartPoint.y < this.rulerHeight) {
            this.panMode = true;
            this.setCursor(Cursor.getPredefinedCursor(13));
        } else {
            this.panMode = false;
            this.stopScroll();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.stopScroll();
        if (this.timeScaleConnected) {
            this.setGlobalTimeScaleIntervalBeginTime(this.intervalBeginTime);
            this.setGlobalTimeScaleIntervalEndTime(this.intervalEndTime);
        }
        if (this.panMode) {
            this.panMode = false;
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.stopScroll();
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        this.dragEndPoint = e.getPoint();
        if (this.panMode) {
            int scrolldiff = this.dragEndPoint.x - this.dragStartPoint.x;
            long newTime = this.intervalBeginTime - (long)((int)((float)scrolldiff * this.msPerPixel));
            this.setIntervalBeginTime(newTime < -this.mediaOffset ? -this.mediaOffset : newTime);
            this.dragStartPoint = this.dragEndPoint;
            return;
        }
        if (this.dragEndPoint.x <= 0 || this.dragEndPoint.x >= this.getWidth()) {
            this.stopScroll();
            return;
        }
        if (this.dragEndPoint.x < 16 && this.dragEndPoint.x > 0) {
            if (this.scroller == null) {
                if (this.dragStartPoint.x < 16 && this.dragStartPoint.x > 0) {
                    this.setSelection(this.dragStartTime, this.dragStartTime);
                }
                this.stopScrolling = false;
                this.scroller = new DragScroller(-4, this.dragScrollSleepTime);
                this.scroller.start();
            }
            return;
        }
        if (this.dragEndPoint.x > this.getWidth() - 16 && this.dragEndPoint.x < this.getWidth()) {
            if (this.scroller == null) {
                if (this.dragStartPoint.x > this.getWidth() - 16 && this.dragStartPoint.x < this.getWidth()) {
                    this.setSelection(this.dragStartTime, this.dragStartTime);
                }
                this.stopScrolling = false;
                this.scroller = new DragScroller(4, this.dragScrollSleepTime);
                this.scroller.start();
            }
            return;
        }
        this.stopScroll();
        if (this.timeAt(this.dragEndPoint.x) > this.dragStartTime) {
            this.selectionEndTime = this.timeAt(this.dragEndPoint.x);
            if (this.samp != null && (float)this.selectionEndTime > this.samp.getDuration()) {
                this.selectionEndTime = (long)this.samp.getDuration();
            }
            this.selectionBeginTime = this.dragStartTime;
            if (this.selectionBeginTime < 0L) {
                this.selectionBeginTime = 0L;
            }
            if (this.selectionEndTime < 0L) {
                this.selectionEndTime = 0L;
            }
            this.setMediaTime(this.selectionEndTime);
        } else {
            this.selectionBeginTime = this.timeAt(this.dragEndPoint.x);
            if (this.samp != null && (float)this.selectionBeginTime > this.samp.getDuration()) {
                this.selectionBeginTime = (long)this.samp.getDuration();
            }
            this.selectionEndTime = this.dragStartTime;
            if (this.samp != null && (float)this.selectionEndTime > this.samp.getDuration()) {
                this.selectionEndTime = (long)this.samp.getDuration();
            }
            if (this.selectionBeginTime < 0L) {
                this.selectionBeginTime = 0L;
            }
            if (this.selectionEndTime < 0L) {
                this.selectionEndTime = 0L;
            }
            this.setMediaTime(this.selectionBeginTime);
        }
        this.setSelection(this.selectionBeginTime, this.selectionEndTime);
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getPoint().y <= this.rulerHeight) {
            this.setToolTipText(TimeFormatter.toString(this.timeAt(e.getPoint().x)));
        } else if (e.getPoint().x >= this.selectionBeginPos && e.getPoint().x <= this.selectionEndPos) {
            this.setToolTipText("Selection: " + TimeFormatter.toString(this.getSelectionBeginTime()) + " - " + TimeFormatter.toString(this.getSelectionEndTime()));
        } else {
            this.setToolTipText(null);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.isControlDown()) {
            if (e.getUnitsToScroll() > 0) {
                this.zoomOut();
            } else {
                this.zoomIn();
            }
            return;
        }
        if (e.isShiftDown()) {
            int timeDiff;
            long newTime;
            if (e.getWheelRotation() != 0 && (newTime = this.intervalBeginTime + (long)(timeDiff = (int)((float)(this.horScrollSpeed * e.getWheelRotation()) * this.msPerPixel))) != this.intervalBeginTime && (this.intervalBeginTime >= 0L || newTime >= this.intervalBeginTime)) {
                this.setIntervalBeginTime(newTime);
            }
            return;
        }
    }

    @Override
    public void magnify(double zoom) {
        if (zoom > 0.0) {
            this.zoomIn();
        } else if (zoom < 0.0) {
            this.zoomOut();
        }
    }

    @Override
    public void swipe(int x, int y) {
        long newTime;
        if (x != 0 && (newTime = this.intervalBeginTime + (long)((float)x * this.msPerPixel)) != this.intervalBeginTime && (newTime >= 0L || newTime >= this.intervalBeginTime)) {
            this.setIntervalBeginTime(newTime);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.timeRulerVisMI) {
            this.timeRulerVisible = this.timeRulerVisMI.isSelected();
            this.rulerHeight = this.timeRulerVisible ? this.ruler.getHeight() : 0;
            this.paintBuffer();
            this.setPreference("SignalViewer.TimeRulerVisible", new Boolean(this.timeRulerVisible), this.getViewerManager().getTranscription());
        } else if (e.getActionCommand().equals("connect")) {
            boolean connected = ((JCheckBoxMenuItem)e.getSource()).getState();
            this.setTimeScaleConnected(connected);
            this.setPreference("SignalViewer.TimeScaleConnected", new Boolean(connected), this.getViewerManager().getTranscription());
        } else if (e.getActionCommand().equals("sep")) {
            this.setChannelMode(1, true);
        } else if (e.getActionCommand().equals("merge")) {
            this.setChannelMode(2, true);
        } else if (e.getActionCommand().equals("blend")) {
            this.setChannelMode(3, true);
        } else if (e.getActionCommand().equals("praat")) {
            this.openInPraat(0L, 0L);
        } else if (e.getActionCommand().equals("praatSel")) {
            this.openSelectionInPraat();
        } else if (e.getActionCommand().equals("clipSel")) {
            this.clipSelectionWithPraat();
        } else if (e.getActionCommand().equals("info")) {
            this.showMediaInfo();
        } else if (e.getActionCommand().startsWith("vz-")) {
            int nvz = 100;
            String vzVal = e.getActionCommand().substring(3);
            try {
                nvz = Integer.parseInt(vzVal);
            }
            catch (NumberFormatException nfe) {
                System.out.println("Error parsing the vertical zoom level");
            }
            this.vertZoom = nvz;
            this.paintBuffer();
            this.setPreference("SignalViewer.VerticalZoomLevel", new Integer(this.vertZoom), this.getViewerManager().getTranscription());
        } else if (e.getSource() == this.zoomSelectionMI) {
            this.zoomToSelection();
        } else if (e.getSource() == this.segmentationChannel1Item) {
            this.showSegmentationChannel1 = this.segmentationChannel1Item.getState();
            this.paintBuffer();
        } else if (e.getSource() == this.segmentationChannel2Item) {
            this.showSegmentationChannel2 = this.segmentationChannel2Item.getState();
            this.paintBuffer();
        } else if (e.getSource() == this.copyOrigTimeItem) {
            long t = this.getMediaTime() + this.mediaOffset;
            Object val = Preferences.get("CurrentTime.Copy.TimeFormat", null);
            String timeFormat = null;
            String currentTime = null;
            currentTime = val instanceof String ? ((timeFormat = val.toString()).equals("hh:mm:ss.ms") ? TimeFormatter.toString(t) : (timeFormat.equals("ss.ms") ? TimeFormatter.toSSMSString(t) : (timeFormat.equals("NTSC") ? TimeFormatter.toTimecodeNTSC(t) : (timeFormat.equals("PAL") ? TimeFormatter.toTimecodePAL(t) : Long.toString(t))))) : Long.toString(t);
            this.copyToClipboard(currentTime);
        } else {
            String zoomString = e.getActionCommand();
            int zoom = 100;
            try {
                zoom = Integer.parseInt(zoomString);
            }
            catch (NumberFormatException nfe) {
                System.err.println("Error parsing the zoom level");
            }
            float newMsPerPixel = 100.0f / (float)zoom * 10.0f;
            this.setMsPerPixel(newMsPerPixel);
        }
    }

    @Override
    public void preferencesChanged() {
        Object val;
        Object obj;
        Boolean rulerVis;
        Object vzLevel;
        Integer stereoMode;
        Boolean tsConnect;
        Object zoomLevel = this.getPreference("SignalViewer.ZoomLevel", this.getViewerManager().getTranscription());
        if (zoomLevel instanceof Float) {
            float zl = ((Float)zoomLevel).floatValue();
            if ((double)zl > 5000.0) {
                zl = 5000.0f;
            }
            float newMsPerPixel = 100.0f / zl * 10.0f;
            this.setMsPerPixel(newMsPerPixel);
        }
        if ((tsConnect = (Boolean)this.getPreference("SignalViewer.TimeScaleConnected", this.getViewerManager().getTranscription())) != null) {
            if (this.timeScaleConMI != null) {
                this.timeScaleConMI.setSelected(tsConnect);
            }
            this.setTimeScaleConnected(tsConnect);
        }
        if ((stereoMode = (Integer)this.getPreference("SignalViewer.StereoMode", this.getViewerManager().getTranscription())) != null) {
            this.setChannelMode(stereoMode, false);
            if (this.popup != null && this.separateMI != null) {
                switch (this.channelMode) {
                    case 2: {
                        this.mergedMI.setSelected(true);
                        break;
                    }
                    case 3: {
                        this.blendMI.setSelected(true);
                        break;
                    }
                    default: {
                        this.separateMI.setSelected(true);
                    }
                }
            }
        }
        if ((vzLevel = this.getPreference("SignalViewer.VerticalZoomLevel", this.getViewerManager().getTranscription())) instanceof Integer) {
            this.vertZoom = (Integer)vzLevel;
            this.updateVertZoomPopup(this.vertZoom);
        }
        if ((rulerVis = (Boolean)this.getPreference("SignalViewer.TimeRulerVisible", this.getViewerManager().getTranscription())) != null) {
            this.timeRulerVisible = rulerVis;
            if (this.timeRulerVisMI != null) {
                this.timeRulerVisMI.setSelected(this.timeRulerVisible);
            }
            this.rulerHeight = this.timeRulerVisible ? this.ruler.getHeight() : 0;
        }
        if ((obj = this.getPreference("ClearSelectionOnSingleClick", null)) instanceof Boolean) {
            this.clearSelOnSingleClick = (Boolean)obj;
        }
        if ((val = this.getPreference("Preferences.TimeLine.HorScrollSpeed", null)) instanceof Integer) {
            this.horScrollSpeed = (Integer)val;
        }
        this.paintBuffer();
    }

    public void finalize() {
        if (this.samp != null) {
            this.samp.close();
        }
    }

    synchronized void scroll(int numPixels) {
        long begin = this.intervalBeginTime + (long)((int)((float)numPixels * this.msPerPixel));
        if (numPixels > 0) {
            this.setIntervalBeginTime(begin);
            this.selectionEndTime = this.getSelectionEndTime() + (long)((int)((float)numPixels * this.msPerPixel));
            if (this.samp != null && (float)this.selectionEndTime > this.samp.getDuration()) {
                this.selectionEndTime = (long)this.samp.getDuration();
            }
            this.setMediaTime(this.selectionEndTime);
            this.setSelection(this.getSelectionBeginTime(), this.selectionEndTime);
        } else {
            if (begin < 0L) {
                begin = 0L;
            }
            this.setIntervalBeginTime(begin);
            this.selectionBeginTime = this.getSelectionBeginTime() + (long)((int)((float)numPixels * this.msPerPixel));
            if (this.selectionBeginTime < 0L) {
                this.selectionBeginTime = 0L;
            }
            this.setMediaTime(this.selectionBeginTime);
            this.setSelection(this.selectionBeginTime, this.getSelectionEndTime());
        }
    }

    void stopScroll() {
        this.stopScrolling = true;
        this.scroller = null;
    }

    class DragScroller
    extends Thread {
        int numPixels;
        long sleepTime;

        DragScroller(int numPixels, long sleepTime) {
            this.numPixels = numPixels;
            this.sleepTime = sleepTime;
        }

        @Override
        public void run() {
            while (!SignalViewer.this.stopScrolling) {
                SignalViewer.this.scroll(this.numPixels);
                try {
                    DragScroller.sleep(this.sleepTime);
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
        }
    }
}

