/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.lexicon.LexiconClientFactoryLoader;
import mpi.eudico.client.annotator.lexicon.LexiconLoginDialog;
import mpi.eudico.client.annotator.lexicon.ValueChooseDialog;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;
import mpi.eudico.server.corpora.lexicon.EntryElement;
import mpi.eudico.server.corpora.lexicon.Lexicon;
import mpi.eudico.server.corpora.lexicon.LexiconEntry;
import mpi.eudico.server.corpora.lexicon.LexiconQueryBundle2;
import mpi.eudico.server.corpora.lexicon.LexiconServiceClient;
import mpi.eudico.server.corpora.lexicon.LexiconServiceClientException;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;

public class LexiconEntryViewer
extends AbstractViewer
implements ACMEditListener,
ActionListener,
ElanLocaleListener,
TreeSelectionListener {
    private JPanel mainPanel;
    private JTextField activeAnnotationValue;
    private JLabel activeAnnotationLabel;
    private JTree lexiconResponseTree;
    private JButton getLexiconEntryButton;
    private String activeAnnotationText;
    private Tier tierOfActiveAnnotation;
    private LexiconServiceClient currentClient;
    private JLabel tierOfActiveAnnotationLabel;
    private JTextField tierOfActiveAnnotationValue;
    private JLabel constraintsLabel;
    private JComboBox constraintsComboBox;
    private DefaultMutableTreeNode resultsNode;
    private DefaultTreeModel resultsTreeModel;
    private LexiconQueryBundle2 currentLexiconQueryBundle;
    private JScrollPane lexiconResponseTextScroller;
    private JLabel message;
    private Lexicon searchResultLexicon;
    private JButton changeAnnotationButton;
    private Annotation activeAnnotation;
    private ArrayList<String> selectedEntryValues;
    private boolean clientLoadStateChecked = false;

    public LexiconEntryViewer() {
        this.initComponents();
    }

    private void initComponents() {
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 22;
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.activeAnnotationLabel = new JLabel();
        searchPanel.add((Component)this.activeAnnotationLabel, gbc);
        gbc.fill = 2;
        gbc.anchor = 21;
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.activeAnnotationValue = new JTextField();
        searchPanel.add((Component)this.activeAnnotationValue, gbc);
        gbc.fill = 0;
        gbc.anchor = 22;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.tierOfActiveAnnotationLabel = new JLabel();
        searchPanel.add((Component)this.tierOfActiveAnnotationLabel, gbc);
        gbc.fill = 2;
        gbc.anchor = 21;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.tierOfActiveAnnotationValue = new JTextField();
        this.tierOfActiveAnnotationValue.setEditable(false);
        searchPanel.add((Component)this.tierOfActiveAnnotationValue, gbc);
        gbc.fill = 0;
        gbc.anchor = 22;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.constraintsLabel = new JLabel();
        searchPanel.add((Component)this.constraintsLabel, gbc);
        gbc.fill = 2;
        gbc.anchor = 21;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = 2;
        this.constraintsComboBox = new JComboBox();
        searchPanel.add((Component)this.constraintsComboBox, gbc);
        gbc.fill = 0;
        gbc.anchor = 21;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = 3;
        this.getLexiconEntryButton = new JButton();
        this.getLexiconEntryButton.setEnabled(false);
        this.getLexiconEntryButton.addActionListener(this);
        searchPanel.add((Component)this.getLexiconEntryButton, gbc);
        gbc.fill = 0;
        gbc.anchor = 21;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = 4;
        this.changeAnnotationButton = new JButton();
        this.changeAnnotationButton.setEnabled(false);
        this.changeAnnotationButton.addActionListener(this);
        searchPanel.add((Component)this.changeAnnotationButton, gbc);
        JPanel resultsPanel = new JPanel();
        resultsPanel.setLayout(new GridBagLayout());
        gbc.fill = 1;
        gbc.anchor = 21;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.message = new JLabel();
        this.message.setBackground(Color.WHITE);
        this.resultsNode = new DefaultMutableTreeNode("Results");
        this.resultsTreeModel = new DefaultTreeModel(this.resultsNode);
        this.lexiconResponseTree = new JTree(this.resultsTreeModel);
        ((DefaultTreeCellRenderer)this.lexiconResponseTree.getCellRenderer()).setOpenIcon(null);
        ((DefaultTreeCellRenderer)this.lexiconResponseTree.getCellRenderer()).setClosedIcon(null);
        ((DefaultTreeCellRenderer)this.lexiconResponseTree.getCellRenderer()).setLeafIcon(null);
        ((DefaultTreeCellRenderer)this.lexiconResponseTree.getCellRenderer()).setTextNonSelectionColor(Color.BLACK);
        ((DefaultTreeCellRenderer)this.lexiconResponseTree.getCellRenderer()).setTextSelectionColor(Color.BLACK);
        this.lexiconResponseTree.getSelectionModel().setSelectionMode(1);
        this.lexiconResponseTree.addTreeSelectionListener(this);
        this.lexiconResponseTree.setRootVisible(true);
        this.lexiconResponseTextScroller = new JScrollPane(this.lexiconResponseTree);
        resultsPanel.add((Component)this.lexiconResponseTextScroller, gbc);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.mainPanel.add((Component)searchPanel, gbc);
        gbc.fill = 1;
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.mainPanel.add((Component)resultsPanel, gbc);
        this.setLayout(new GridBagLayout());
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.mainPanel, gbc);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getLexiconEntryButton) {
            this.doSearch();
        } else if (e.getSource() == this.changeAnnotationButton) {
            this.changeAnnotation();
        }
    }

    private void doSearch() {
        String searchString = this.activeAnnotationValue.getText();
        if (this.currentClient != null && !searchString.equals("")) {
            this.lexiconResponseTree.removeTreeSelectionListener(this);
            boolean trySearch = true;
            while (trySearch) {
                try {
                    String resultsStr = ElanLocale.getString("LexiconEntryViewer.Results");
                    String lexiconStr = ElanLocale.getString("LexiconEntryViewer.Lexicon");
                    String fieldStr = ElanLocale.getString("LexiconEntryViewer.Field");
                    String constraintsStr = ElanLocale.getString("LexiconEntryViewer.Constraints");
                    String searchStringStr = ElanLocale.getString("LexiconEntryViewer.SearchString");
                    String performingStr = ElanLocale.getString("LexiconEntryViewer.PerformingMessage");
                    String rootText = "(" + lexiconStr + ": <i>" + this.currentLexiconQueryBundle.getLink().getLexId().getName() + "</i>; " + fieldStr + ": <i>" + this.currentLexiconQueryBundle.getFldId().getName() + "</i>; " + constraintsStr + ": <i>" + this.constraintsComboBox.getSelectedItem() + "</i>; " + searchStringStr + ": <i>" + searchString + "</i>)</html>";
                    this.message.setText("<html><b>" + performingStr + "</b> " + rootText);
                    this.lexiconResponseTextScroller.setViewportView(this.message);
                    this.searchResultLexicon = this.currentClient.search(this.currentLexiconQueryBundle.getLink().getLexId(), this.currentLexiconQueryBundle.getFldId(), (String)this.constraintsComboBox.getSelectedItem(), searchString);
                    this.searchResultLexicon.setName("<html><b>" + resultsStr + "</b> " + rootText);
                    this.lexiconResponseTree.setModel(this.searchResultLexicon);
                    this.lexiconResponseTextScroller.setViewportView(this.lexiconResponseTree);
                    trySearch = false;
                }
                catch (LexiconServiceClientException ex) {
                    if (ex.getMessage().equals("No username or password") || ex.getMessage().equals("Incorrect username or password")) {
                        Container parent = this.getRootPane().getParent();
                        if (parent instanceof Frame) {
                            LexiconLoginDialog loginDialog = new LexiconLoginDialog((Frame)parent, this.currentLexiconQueryBundle.getLink());
                            loginDialog.setVisible(true);
                            if (loginDialog.isCanceled()) {
                                trySearch = false;
                            }
                        }
                    }
                    String title = ElanLocale.getString("LexiconLink.Action.Error");
                    String message = title + "\n" + ElanLocale.getString("LexiconServiceClientException.Cause") + " " + ex.getMessageLocale();
                    JOptionPane.showMessageDialog(this, message, title, 0);
                    trySearch = false;
                }
                this.message.setText("");
            }
            this.lexiconResponseTree.addTreeSelectionListener(this);
        }
    }

    private void changeAnnotation() {
        TranscriptionImpl trans;
        ControlledVocabulary cv;
        CVEntry cvEntry;
        String newAnnotationValue = "";
        if (this.selectedEntryValues.size() == 1) {
            newAnnotationValue = this.selectedEntryValues.get(0);
        } else if (this.selectedEntryValues.size() > 1) {
            Container parent = this.getRootPane().getParent();
            ValueChooseDialog chooser = new ValueChooseDialog((Frame)parent, this.selectedEntryValues);
            chooser.setVisible(true);
            if (!chooser.isCanceled()) {
                newAnnotationValue = chooser.getSelectedValue();
            } else {
                return;
            }
        }
        LinguisticType type = ((TierImpl)this.tierOfActiveAnnotation).getLinguisticType();
        Object extRef = null;
        if (type.isUsingControlledVocabulary() && (cvEntry = (cv = (trans = (TranscriptionImpl)this.tierOfActiveAnnotation.getParent()).getControlledVocabulary(((TierImpl)this.tierOfActiveAnnotation).getLinguisticType().getControlledVocabylaryName())).getEntryWithValue(newAnnotationValue)) != null) {
            extRef = cvEntry.getExternalRef();
        }
        Command c = ELANCommandFactory.createCommand(this.tierOfActiveAnnotation.getParent(), "Menu.Annotation.ModifyAnnotation");
        Object[] args = new Object[]{this.activeAnnotation.getValue(), newAnnotationValue, extRef};
        c.execute(this.activeAnnotation, args);
    }

    @Override
    public void controllerUpdate(ControllerEvent event) {
    }

    @Override
    public void preferencesChanged() {
    }

    @Override
    public void updateActiveAnnotation() {
        this.doUpdate();
    }

    @Override
    public void updateLocale() {
        this.activeAnnotationLabel.setText(ElanLocale.getString("LexiconEntryViewer.AnnotationLabel"));
        this.tierOfActiveAnnotationLabel.setText(ElanLocale.getString("LexiconEntryViewer.Tier"));
        this.constraintsLabel.setText(ElanLocale.getString("LexiconEntryViewer.Constraints"));
        this.getLexiconEntryButton.setText(ElanLocale.getString("LexiconEntryViewer.GetEntriesButton"));
        this.changeAnnotationButton.setText(ElanLocale.getString("LexiconEntryViewer.ChangeAnnotation"));
    }

    @Override
    public void updateSelection() {
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
        this.doUpdate();
    }

    private void doUpdate() {
        this.activeAnnotationValue.setText("");
        this.tierOfActiveAnnotationValue.setText("");
        this.constraintsComboBox.removeAllItems();
        this.getLexiconEntryButton.setEnabled(false);
        this.activeAnnotation = this.getActiveAnnotation();
        if (this.activeAnnotation != null) {
            this.activeAnnotationText = this.activeAnnotation.getValue();
            this.activeAnnotationValue.setText(this.activeAnnotationText);
            this.tierOfActiveAnnotation = this.activeAnnotation.getTier();
            this.tierOfActiveAnnotationValue.setText(this.tierOfActiveAnnotation.getName());
            LinguisticType linguisticTypeOfTier = ((TierImpl)this.tierOfActiveAnnotation).getLinguisticType();
            this.currentLexiconQueryBundle = linguisticTypeOfTier.getLexiconQueryBundle();
            if (this.currentLexiconQueryBundle != null) {
                if (!this.clientLoadStateChecked) {
                    if (!((TranscriptionImpl)this.tierOfActiveAnnotation.getParent()).isLexcionServicesLoaded()) {
                        new LexiconClientFactoryLoader().loadLexiconClientFactories((TranscriptionImpl)this.tierOfActiveAnnotation.getParent());
                        ((TranscriptionImpl)this.tierOfActiveAnnotation.getParent()).setLexcionServicesLoaded(true);
                    }
                    this.clientLoadStateChecked = true;
                }
                this.currentClient = this.currentLexiconQueryBundle.getLink().getSrvcClient();
                if (this.currentClient != null) {
                    this.getLexiconEntryButton.setEnabled(true);
                    ArrayList<String> constraints = this.currentClient.getSearchConstraints();
                    for (int i = 0; i < constraints.size(); ++i) {
                        this.constraintsComboBox.addItem(constraints.get(i));
                    }
                }
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        this.changeAnnotationButton.setEnabled(false);
        TreePath path = this.lexiconResponseTree.getSelectionPath();
        if (path != null) {
            String value;
            Object node = path.getLastPathComponent();
            if (node instanceof LexiconEntry) {
                this.selectedEntryValues = ((LexiconEntry)node).getFocusFieldValues();
                this.changeAnnotationButton.setEnabled(true);
            } else if (node instanceof EntryElement && (value = ((EntryElement)node).getValue()).toLowerCase().startsWith("http")) {
                try {
                    URL url = new URL(value);
                    this.openURL(value);
                }
                catch (MalformedURLException mue) {
                    // empty catch block
                }
            }
        }
    }

    private void openURL(String url) {
        if (url == null) {
            return;
        }
        if (SystemReporting.isMacOS()) {
            String[] command = new String[]{"open", url};
            String error = this.execCommand(command);
            if (error != null) {
                this.errorMessage(error);
            }
        } else if (SystemReporting.isWindows()) {
            String[] command = new String[]{"rundll32", "url.dll", "FileProtocolHandler", url};
            String error = this.execCommand(command);
            if (error != null) {
                this.errorMessage(error);
            }
        } else {
            String[][] commands = new String[][]{{"xdg-open", url}, {"gnome-open", url}, {"kde-open", url}, {"firefox", url}};
            String error = "";
            for (int i = 0; i < commands.length; ++i) {
                String nextError = this.execCommand(commands[i]);
                if (nextError == null) {
                    return;
                }
                error = error + ", " + nextError;
            }
            this.errorMessage(error);
        }
    }

    private void errorMessage(String message) {
        JOptionPane.showMessageDialog(this, ElanLocale.getString("Message.Web.NoConnection") + ": " + message, ElanLocale.getString("Message.Warning"), 2);
    }

    private String execCommand(String[] command) {
        try {
            Process proc = Runtime.getRuntime().exec(command);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }
        catch (SecurityException se) {
            ClientLogger.LOG.warning("No connection: " + se.getMessage());
            return se.getMessage();
        }
        catch (IOException ioe) {
            ClientLogger.LOG.warning("No connection: " + ioe.getMessage());
            return ioe.getMessage();
        }
    }
}

