/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class LogBufferHandler
extends Handler {
    private List<String> buffer;
    private SimpleFormatter formatter;
    private int size = 1000;
    private boolean closed = false;

    public LogBufferHandler() {
        this.buffer = new ArrayList<String>(200);
        this.formatter = new SimpleFormatter();
    }

    public LogBufferHandler(int maxSize) {
        this.size = maxSize;
        this.buffer = new ArrayList<String>(Math.min(200, this.size));
        this.formatter = new SimpleFormatter();
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (!this.closed) {
            this.buffer.add(this.formatter.format(record));
            if (this.buffer.size() > this.size) {
                this.buffer.remove(0);
            }
        }
    }

    @Override
    public void close() throws SecurityException {
        if (!this.closed) {
            this.flush();
            this.buffer.clear();
        }
    }

    @Override
    public void flush() {
    }

    public synchronized StringBuilder getLogBuffer() {
        if (!this.closed) {
            StringBuilder builder = new StringBuilder();
            for (String s : this.buffer) {
                builder.append(s);
            }
            return builder;
        }
        return null;
    }
}

