/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import mpi.eudico.client.annotator.util.Tag2D;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class DragTag2D
extends Tag2D {
    private int y;
    private int origX;
    private int origY = 0;
    private int dx;
    private int dy;
    private boolean moveAcrossTiersAllowed = false;
    public boolean isOverTargetTier = false;

    public DragTag2D(Annotation annotation) {
        super(annotation);
        if (annotation != null && annotation.getTier() != null && ((TierImpl)annotation.getTier()).getParentTier() == null) {
            this.moveAcrossTiersAllowed = true;
        }
    }

    public void copyFrom(Tag2D tag2d) {
        if (tag2d != null) {
            this.setX(tag2d.getX());
            this.origX = tag2d.getX();
            this.setWidth(tag2d.getWidth());
            this.setTier2D(tag2d.getTier2D());
        }
    }

    public boolean isMoveAcrossTiersAllowed() {
        return this.moveAcrossTiersAllowed;
    }

    public int getY() {
        return this.y;
    }

    public int getOrigY() {
        return this.origY;
    }

    public void resetY() {
        this.y = this.origY;
    }

    public int getOrigX() {
        return this.origX;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void resetX() {
        this.setX(this.origX);
    }

    public void move(int x, int y) {
        this.dx += x;
        this.dy += y;
    }

    public int getDx() {
        return this.dx;
    }

    public int getDy() {
        return this.dy;
    }
}

