/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.update;

import java.util.Calendar;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.update.ElanUpdateDialog;

public class ExternalUpdaterThread
extends Thread {
    private static boolean running;
    private static final int INTERVAL_IN_DAYS = 7;

    public ExternalUpdaterThread() {
        this.setPriority(1);
    }

    @Override
    public synchronized void start() {
        running = true;
        System.out.println("External updater thread started ");
        super.start();
    }

    public void close() {
        running = false;
        if (this.isAlive()) {
            try {
                this.interrupt();
            }
            catch (SecurityException se) {
                System.out.println("Could not stop the external updater thread: " + se.getMessage());
            }
        }
    }

    @Override
    public void run() {
        this.checkForUpdates();
    }

    private void checkForUpdates() {
        long difference;
        long diffInDays;
        if (!running) {
            return;
        }
        long lastUpdate = -1L;
        Object val = Preferences.get("ElanUpdater.LastUpdate", null);
        if (val != null && val instanceof Long) {
            lastUpdate = (Long)val;
        }
        if ((diffInDays = (difference = Calendar.getInstance().getTimeInMillis() - lastUpdate) / 86400000L) < 7L) {
            return;
        }
        ElanUpdateDialog updater = new ElanUpdateDialog(null, true);
        updater.checkForUpdates();
    }

    public void finalize() {
        this.close();
    }
}

