/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.transcriptionMode;

import java.util.List;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;

public class TranscriptionTableModel
extends DefaultTableModel {
    public static final String COLUMN0 = ElanLocale.getString("TranscriptionTable.Column.No");
    public static final String COLUMN_PREFIX = ElanLocale.getString("TranscriptionTable.ColumnPrefix");
    private String[] columnIdentifiers = new String[]{COLUMN0};
    private List<String> nonEditableTiers;
    private boolean autoCreateAnn = true;

    public TranscriptionTableModel() {
        for (int i = 0; i < this.columnIdentifiers.length; ++i) {
            this.addColumn(this.columnIdentifiers[i]);
        }
        this.setColumnIdentifiers(this.columnIdentifiers);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        Object obj = this.getValueAt(row, column);
        String tierName = this.getTierName(row, column);
        if (tierName != null && this.nonEditableTiers != null && this.nonEditableTiers.contains(tierName)) {
            return false;
        }
        if (obj instanceof String) {
            return this.autoCreateAnn;
        }
        return obj instanceof Annotation;
    }

    public void updateModel(List<String> columnNames) {
        if (this.getColumnCount() - 1 == columnNames.size()) {
            Object[] columnsNames = new String[columnNames.size() + 1];
            columnsNames[0] = COLUMN0;
            for (int i = 0; i < columnNames.size(); ++i) {
                columnsNames[i + 1] = COLUMN_PREFIX + (i + 1) + " : " + columnNames.get(i);
            }
            this.setColumnIdentifiers(columnsNames);
            this.columnIdentifiers = columnsNames;
        } else {
            Object[] columnsNames = new String[columnNames.size() + 1];
            columnsNames[0] = COLUMN0;
            for (int i = 0; i < columnNames.size(); ++i) {
                columnsNames[i + 1] = COLUMN_PREFIX + (i + 1) + " : " + columnNames.get(i);
                this.addColumn(columnsNames[i + 1]);
            }
            this.setColumnIdentifiers(columnsNames);
            this.columnIdentifiers = columnsNames;
        }
    }

    public String[] getColumnIdentifiers() {
        return this.columnIdentifiers;
    }

    public void setNonEditableTiers(List<String> nonEditableTiers) {
        this.nonEditableTiers = nonEditableTiers;
    }

    public void setAutoCreateAnnotations(boolean create) {
        this.autoCreateAnn = create;
    }

    public boolean isAnnotationsCreatedAutomatically() {
        return this.autoCreateAnn;
    }

    private String getTierName(int row, int column) {
        String tierName = null;
        Object val = this.getValueAt(row, column);
        if (val instanceof Annotation) {
            AbstractAnnotation ann = (AbstractAnnotation)val;
            tierName = ann.getTier().getName();
        } else if (val instanceof String) {
            String value = (String)this.getValueAt(row, column);
            String[] s = value.split(";");
            tierName = s[1];
        }
        return tierName;
    }
}

