/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.transcriptionMode;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionTableModel;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class SelectChildTiersDlg
extends ClosableDialog
implements ActionListener {
    private static final String defaultValue = ElanLocale.getString("TranscriptionManager.SelectTierDlg.DefaultValue");
    private static final String NO_TIER = ElanLocale.getString("TranscriptionManager.SelectTierDlg.No_Tier");
    private static final String EMPTY_TIER = ElanLocale.getString("TranscriptionManager.SelectTierDlg.Empty_Tier");
    private final String TIER_NAME_COLUMN = ElanLocale.getString("TranscriptionManager.SelectTierDlg.Tier_Name_Column");
    private final String HIDE_COLUMN = ElanLocale.getString("TranscriptionManager.SelectTierDlg.Show_Hide_Tiers");
    private final String COLUMN_PREFIX = TranscriptionTableModel.COLUMN_PREFIX;
    private JTable selectionTable;
    DefaultTableModel model;
    private Transcription transcription;
    private JButton okButton;
    private JButton cancelButton;
    private HashMap<TierImpl, List<TierImpl>> tierMap;
    private HashMap<String, HashMap<String, List<String>>> typeTierMap;
    private List<String> columnTypeList;
    private List<String> hiddenTiers;
    private boolean valueChanged = false;

    public SelectChildTiersDlg(ElanLayoutManager layoutManager, HashMap<TierImpl, List<TierImpl>> tierMap, List<String> hiddenTiers, List<String> columnTypeList) {
        super(layoutManager.getElanFrame(), ElanLocale.getString("TranscriptionManager.SelectTierDlg.Title"), true);
        this.transcription = layoutManager.getViewerManager().getTranscription();
        this.hiddenTiers = new ArrayList<String>();
        this.columnTypeList = new ArrayList<String>();
        this.tierMap = new HashMap();
        this.columnTypeList.addAll(columnTypeList);
        if (tierMap == null) {
            this.loadMap();
        } else {
            this.tierMap.putAll(tierMap);
        }
        if (hiddenTiers != null) {
            this.hiddenTiers.addAll(hiddenTiers);
        }
        this.typeTierMap = new HashMap();
        this.initComponents();
        this.fillTable();
        this.postInit();
    }

    private void postInit() {
        this.pack();
        this.setResizable(true);
        this.setLocationRelativeTo(this.getParent());
    }

    public void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                if (this.getColumnName(column).equals(SelectChildTiersDlg.this.TIER_NAME_COLUMN)) {
                    return false;
                }
                if (column != 0) {
                    Object value = this.getValueAt(row, 0);
                    if (value instanceof Boolean && !((Boolean)value).booleanValue()) {
                        return false;
                    }
                    value = this.getValueAt(row, column);
                    if (value != null && value instanceof String && value.equals(NO_TIER)) {
                        return false;
                    }
                }
                return true;
            }
        };
        DefaultTableCellRenderer render = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (table.getColumnName(column).equals(SelectChildTiersDlg.this.TIER_NAME_COLUMN)) {
                    this.setText((String)value);
                    this.setFont(new Font(table.getFont().getFontName(), 2, table.getFont().getSize()));
                    this.setBackground(Color.LIGHT_GRAY);
                    this.setForeground(Color.BLACK);
                    this.setOpaque(true);
                    return this;
                }
                boolean rowSelected = (Boolean)table.getValueAt(row, 0);
                boolean deSelectRow = false;
                if (table.isEditing() && table.getEditingRow() == row && table.getEditingColumn() == 0) {
                    if (rowSelected) {
                        deSelectRow = true;
                    }
                } else if (!rowSelected) {
                    deSelectRow = true;
                }
                this.setText((String)value);
                if (deSelectRow) {
                    this.setBackground(Color.LIGHT_GRAY);
                    this.setForeground(Color.GRAY);
                    this.setOpaque(true);
                } else {
                    this.setBackground(Color.WHITE);
                    this.setOpaque(false);
                    if (value != null && (value.equals(defaultValue) || value.equals(NO_TIER))) {
                        this.setForeground(Color.GRAY);
                    } else {
                        this.setForeground(Color.BLACK);
                    }
                }
                if (value != null && (value.equals(NO_TIER) || value.equals(EMPTY_TIER))) {
                    this.setFont(new Font(table.getFont().getFontName(), 2, table.getFont().getSize()));
                }
                return this;
            }
        };
        this.model.setColumnCount(this.columnTypeList.size() + 1);
        Object[] columnIdentifiers = new String[this.columnTypeList.size() + 2];
        columnIdentifiers[0] = this.HIDE_COLUMN;
        columnIdentifiers[1] = this.TIER_NAME_COLUMN;
        for (int i = 0; i < this.columnTypeList.size(); ++i) {
            columnIdentifiers[i + 2] = this.COLUMN_PREFIX + " " + (i + 1) + " : " + this.columnTypeList.get(i);
        }
        this.model.setColumnIdentifiers(columnIdentifiers);
        this.selectionTable = new JTable(this.model);
        this.selectionTable.setFont(Constants.DEFAULTFONT);
        this.selectionTable.setCellSelectionEnabled(true);
        this.selectionTable.setShowGrid(true);
        this.selectionTable.setGridColor(Color.BLACK);
        this.selectionTable.setDefaultEditor(Object.class, new TableCellEditor());
        this.selectionTable.setRowHeight(25);
        this.selectionTable.setDefaultRenderer(Object.class, render);
        this.selectionTable.getColumnModel().getColumn(0).setCellRenderer(new CheckBoxTableCellRenderer());
        this.selectionTable.getColumnModel().getColumn(0).setCellEditor(new TableCellEditor(new JCheckBox()));
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.okButton = new JButton();
        this.okButton.setText(ElanLocale.getString("Button.Apply"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        Insets insets = new Insets(2, 6, 2, 6);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JScrollPane tierScrollPane = new JScrollPane(this.selectionTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)tierScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)buttonPanel, gridBagConstraints);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                SelectChildTiersDlg.this.doClose();
            }
        });
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    private List<String> getLinkedTiersOfType(TierImpl refTier, String type) {
        Vector childTiers = refTier.getChildTiers();
        ArrayList<String> linkedTiers = new ArrayList<String>();
        for (int i = 0; i < childTiers.size(); ++i) {
            TierImpl childTier = (TierImpl)childTiers.get(i);
            if (childTier.getLinguisticType().getConstraints().getStereoType() != 4) continue;
            if (childTier.getLinguisticType().getLinguisticTypeName().equals(type)) {
                linkedTiers.add(childTier.getName());
            }
            Vector dependentTiers = childTier.getDependentTiers();
            for (int y = 0; y < dependentTiers.size(); ++y) {
                TierImpl dependantTier = (TierImpl)dependentTiers.get(y);
                if (!dependantTier.getLinguisticType().getLinguisticTypeName().equals(type)) continue;
                linkedTiers.add(dependantTier.getName());
            }
        }
        return linkedTiers;
    }

    private List<TierImpl> getLinkedTiers(TierImpl refTier, String type) {
        Vector childTiers = refTier.getChildTiers();
        ArrayList<TierImpl> linkedTiers = new ArrayList<TierImpl>();
        for (int i = 0; i < childTiers.size(); ++i) {
            TierImpl childTier = (TierImpl)childTiers.get(i);
            if (childTier.getLinguisticType().getConstraints().getStereoType() != 4) continue;
            if (childTier.getLinguisticType().getLinguisticTypeName().equals(type)) {
                linkedTiers.add(childTier);
            }
            Vector dependentTiers = childTier.getDependentTiers();
            for (int y = 0; y < dependentTiers.size(); ++y) {
                TierImpl dependantTier = (TierImpl)dependentTiers.get(y);
                if (!dependantTier.getLinguisticType().getLinguisticTypeName().equals(type)) continue;
                linkedTiers.add(dependantTier);
            }
        }
        return linkedTiers;
    }

    private void fillTable() {
        boolean column1ParentType = false;
        ArrayList<TierImpl> parentTierList = new ArrayList<TierImpl>();
        Vector tierList = this.transcription.getTiersWithLinguisticType(this.columnTypeList.get(0));
        for (int i = 0; i < tierList.size(); ++i) {
            TierImpl parentTier;
            TierImpl tier = (TierImpl)tierList.get(i);
            if (tier.getLinguisticType().getConstraints() == null || tier.getLinguisticType().getConstraints().getStereoType() != 4) {
                column1ParentType = true;
                if (parentTierList.contains(tier)) continue;
                parentTierList.add(tier);
                continue;
            }
            for (parentTier = (TierImpl)tier.getParentTier(); parentTier != null && parentTier.getLinguisticType().getConstraints() != null && parentTier.getLinguisticType().getConstraints().getStereoType() == 4; parentTier = (TierImpl)parentTier.getParentTier()) {
            }
            if (parentTierList.contains(parentTier)) continue;
            parentTierList.add(parentTier);
        }
        for (int x = 0; x < parentTierList.size(); ++x) {
            TierImpl refTier = (TierImpl)parentTierList.get(x);
            String refTierName = refTier.getName();
            HashMap<String, List<Object>> typeMap = new HashMap<String, List<Object>>();
            this.typeTierMap.put(refTierName, typeMap);
            if (this.hiddenTiers != null) {
                if (this.hiddenTiers.contains(refTierName)) {
                    this.model.addRow(new Object[]{Boolean.FALSE, refTierName});
                } else {
                    this.model.addRow(new Object[]{Boolean.TRUE, refTierName});
                }
            } else {
                this.model.addRow(new Object[]{Boolean.TRUE, refTierName});
            }
            List<TierImpl> currentTierList = this.tierMap.get(refTier);
            if (currentTierList != null && currentTierList.size() != this.columnTypeList.size()) {
                currentTierList = null;
            }
            block7: for (int i = 0; i < this.columnTypeList.size(); ++i) {
                List<Object> tierNames = new ArrayList<String>();
                if (i == 0 && column1ParentType) {
                    tierNames.add(refTierName);
                } else {
                    tierNames = this.getLinkedTiersOfType(refTier, this.columnTypeList.get(i));
                }
                typeMap.put(this.columnTypeList.get(i), tierNames);
                switch (tierNames.size()) {
                    case 0: {
                        this.model.setValueAt(NO_TIER, this.model.getRowCount() - 1, i + 2);
                        continue block7;
                    }
                    case 1: {
                        String tierName;
                        TierImpl tier;
                        if (currentTierList != null) {
                            tier = currentTierList.get(i);
                            if (tier != null) {
                                tierName = tier.getName();
                                if (tierNames.contains(tierName)) {
                                    this.model.setValueAt(tierName, this.model.getRowCount() - 1, i + 2);
                                    continue block7;
                                }
                                this.model.setValueAt(EMPTY_TIER, this.model.getRowCount() - 1, i + 2);
                                continue block7;
                            }
                            this.model.setValueAt(EMPTY_TIER, this.model.getRowCount() - 1, i + 2);
                            continue block7;
                        }
                        boolean valueSet = false;
                        for (int c = 2; c < i + 2; ++c) {
                            String tierName2 = (String)this.model.getValueAt(this.model.getRowCount() - 1, c);
                            if (!((String)tierNames.get(0)).equals(tierName2)) continue;
                            this.model.setValueAt(EMPTY_TIER, this.model.getRowCount() - 1, i + 2);
                            valueSet = true;
                            break;
                        }
                        if (valueSet) continue block7;
                        this.model.setValueAt(tierNames.get(0), this.model.getRowCount() - 1, i + 2);
                        continue block7;
                    }
                    default: {
                        String tierName;
                        TierImpl tier;
                        if (currentTierList != null) {
                            tier = currentTierList.get(i);
                            if (tier != null) {
                                tierName = tier.getName();
                                if (tierNames.contains(tierName)) {
                                    this.model.setValueAt(tierName, this.model.getRowCount() - 1, i + 2);
                                    continue block7;
                                }
                                this.model.setValueAt(defaultValue, this.model.getRowCount() - 1, i + 2);
                                continue block7;
                            }
                            this.model.setValueAt(defaultValue, this.model.getRowCount() - 1, i + 2);
                            continue block7;
                        }
                        this.model.setValueAt(defaultValue, this.model.getRowCount() - 1, i + 2);
                    }
                }
            }
        }
    }

    private void loadMap() {
        block36: {
            Vector tiers = this.transcription.getTiersWithLinguisticType(this.columnTypeList.get(0));
            ArrayList<TierImpl> parentTierListType = new ArrayList<TierImpl>();
            ArrayList annotationsList = new ArrayList();
            ArrayList<String> types = new ArrayList<String>();
            for (int i = 0; i < this.columnTypeList.size(); ++i) {
                if (types.contains(this.columnTypeList.get(i))) continue;
                types.add(this.columnTypeList.get(i));
            }
            if (tiers == null || tiers.size() <= 0) break block36;
            TierImpl tierC1 = (TierImpl)tiers.get(0);
            if (tierC1.getLinguisticType().getConstraints() != null && tierC1.getLinguisticType().getConstraints().getStereoType() == 4) {
                for (int x = 0; x < tiers.size(); ++x) {
                    int i;
                    TierImpl parentTier;
                    TierImpl tier = (TierImpl)tiers.get(x);
                    for (parentTier = (TierImpl)tier.getParentTier(); parentTier != null && parentTier.getLinguisticType().getConstraints() != null && parentTier.getLinguisticType().getConstraints().getStereoType() == 4; parentTier = (TierImpl)parentTier.getParentTier()) {
                    }
                    if (parentTierListType.contains(parentTier)) continue;
                    parentTierListType.add(parentTier);
                    List<TierImpl> linkedTiers = this.tierMap.get(parentTier);
                    ArrayList<TierImpl> matchedTiersType = new ArrayList<TierImpl>();
                    if (linkedTiers != null) {
                        if (linkedTiers.size() < this.columnTypeList.size()) {
                            for (i = linkedTiers.size(); i < this.columnTypeList.size(); ++i) {
                                linkedTiers.add(null);
                            }
                        } else if (linkedTiers.size() > this.columnTypeList.size()) {
                            for (i = linkedTiers.size(); i > this.columnTypeList.size(); --i) {
                                linkedTiers.remove(i - 1);
                            }
                        }
                    } else {
                        linkedTiers = new ArrayList<TierImpl>();
                        for (i = 0; i < this.columnTypeList.size(); ++i) {
                            linkedTiers.add(null);
                        }
                    }
                    for (int c = 0; c < types.size(); ++c) {
                        matchedTiersType.clear();
                        matchedTiersType.addAll(this.getLinkedTiers(parentTier, (String)types.get(c)));
                        if (types.size() != this.columnTypeList.size()) {
                            for (int i2 = c; i2 < this.columnTypeList.size(); ++i2) {
                                if (!this.columnTypeList.get(i2).equals(types.get(c))) continue;
                                if (linkedTiers.get(i2) == null || !matchedTiersType.contains(linkedTiers.get(i2))) {
                                    if (matchedTiersType.size() >= 1) {
                                        linkedTiers.set(i2, (TierImpl)matchedTiersType.get(0));
                                        matchedTiersType.remove(matchedTiersType.get(0));
                                        continue;
                                    }
                                    linkedTiers.set(i2, null);
                                    continue;
                                }
                                if (!matchedTiersType.contains(linkedTiers.get(i2))) continue;
                                matchedTiersType.remove(linkedTiers.get(i2));
                            }
                            continue;
                        }
                        int index = this.columnTypeList.indexOf(this.columnTypeList.get(c));
                        if (linkedTiers.get(index) == null || !matchedTiersType.contains(linkedTiers.get(index))) {
                            if (matchedTiersType.size() >= 1) {
                                linkedTiers.set(index, (TierImpl)matchedTiersType.get(0));
                                matchedTiersType.remove(matchedTiersType.get(0));
                                continue;
                            }
                            linkedTiers.set(index, null);
                            continue;
                        }
                        if (!matchedTiersType.contains(linkedTiers.get(index))) continue;
                        matchedTiersType.remove(linkedTiers.get(index));
                    }
                    this.tierMap.put(parentTier, linkedTiers);
                }
            } else {
                ArrayList parentTiers = new ArrayList();
                for (int x = 0; x < tiers.size(); ++x) {
                    int i;
                    TierImpl tier = (TierImpl)tiers.get(x);
                    parentTierListType.add(tier);
                    List<TierImpl> linkedTiers = this.tierMap.get(tier);
                    ArrayList<TierImpl> matchedTiersType = new ArrayList<TierImpl>();
                    if (linkedTiers != null) {
                        if (linkedTiers.size() < this.columnTypeList.size()) {
                            for (i = linkedTiers.size(); i < this.columnTypeList.size(); ++i) {
                                linkedTiers.add(null);
                            }
                        } else if (linkedTiers.size() > this.columnTypeList.size()) {
                            for (i = linkedTiers.size(); i > this.columnTypeList.size(); --i) {
                                linkedTiers.remove(i - 1);
                            }
                        }
                    } else {
                        linkedTiers = new ArrayList<TierImpl>();
                        for (i = 0; i < this.columnTypeList.size(); ++i) {
                            linkedTiers.add(null);
                        }
                    }
                    linkedTiers.set(0, tier);
                    for (int c = 1; c < types.size(); ++c) {
                        matchedTiersType.clear();
                        matchedTiersType.addAll(this.getLinkedTiers(tier, (String)types.get(c)));
                        if (types.size() != this.columnTypeList.size()) {
                            for (int i3 = c; i3 < this.columnTypeList.size(); ++i3) {
                                if (!this.columnTypeList.get(i3).equals(types.get(c))) continue;
                                if (linkedTiers.get(i3) == null || !matchedTiersType.contains(linkedTiers.get(i3))) {
                                    if (matchedTiersType.size() >= 1) {
                                        linkedTiers.set(i3, (TierImpl)matchedTiersType.get(0));
                                        matchedTiersType.remove(matchedTiersType.get(0));
                                        continue;
                                    }
                                    linkedTiers.set(i3, null);
                                    continue;
                                }
                                if (!matchedTiersType.contains(linkedTiers.get(i3))) continue;
                                matchedTiersType.remove(linkedTiers.get(i3));
                            }
                            continue;
                        }
                        int index = this.columnTypeList.indexOf(this.columnTypeList.get(c));
                        if (linkedTiers.get(index) == null || !matchedTiersType.contains(linkedTiers.get(index))) {
                            if (matchedTiersType.size() >= 1) {
                                linkedTiers.set(index, (TierImpl)matchedTiersType.get(0));
                                matchedTiersType.remove(matchedTiersType.get(0));
                                continue;
                            }
                            linkedTiers.set(index, null);
                            continue;
                        }
                        if (!matchedTiersType.contains(linkedTiers.get(index))) continue;
                        matchedTiersType.remove(linkedTiers.get(index));
                    }
                    this.tierMap.put(tier, linkedTiers);
                }
            }
        }
    }

    public boolean isValueChanged() {
        return this.valueChanged;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.selectionTable.isEditing()) {
                this.selectionTable.editingStopped(new ChangeEvent(this));
            }
            String message = ElanLocale.getString("TranscriptionManager.SelectTierDlg.ErrMessageSameTiers");
            HashMap newTierMap = new HashMap();
            ArrayList<String> newHiddenTiersList = new ArrayList<String>();
            for (int i = 0; i < this.selectionTable.getRowCount(); ++i) {
                TierImpl refTier = (TierImpl)this.transcription.getTierWithId((String)this.selectionTable.getValueAt(i, this.selectionTable.getColumnModel().getColumnIndex(this.TIER_NAME_COLUMN)));
                ArrayList<TierImpl> tierList = new ArrayList<TierImpl>();
                ArrayList<String> tierNamesList = new ArrayList<String>();
                for (int j = 0; j < this.selectionTable.getColumnCount(); ++j) {
                    if (j == 0) {
                        Boolean value = (Boolean)this.selectionTable.getValueAt(i, j);
                        String refTierName = this.selectionTable.getValueAt(i, j + 1).toString();
                        if (value.booleanValue()) continue;
                        if (newHiddenTiersList.contains(refTierName)) break;
                        newHiddenTiersList.add(refTierName);
                        break;
                    }
                    if (j == 1) continue;
                    String tierName = (String)this.selectionTable.getValueAt(i, j);
                    if (tierName == null || tierName.equals(defaultValue) || tierName.equals(NO_TIER) || tierName.equals(EMPTY_TIER)) {
                        tierList.add(null);
                        continue;
                    }
                    TierImpl tier = (TierImpl)this.transcription.getTierWithId(tierName);
                    if (tier != null && tierNamesList.contains(tierName)) {
                        Component cell = this.selectionTable.getDefaultRenderer(Object.class).getTableCellRendererComponent(this.selectionTable, tierName, false, false, i, j);
                        cell.setForeground(Color.red);
                        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
                        return;
                    }
                    tierNamesList.add(tierName);
                    tierList.add(tier);
                }
                newTierMap.put(refTier, tierList);
            }
            boolean bl = this.valueChanged = !this.hiddenTiers.equals(newHiddenTiersList);
            if (!this.valueChanged) {
                boolean bl2 = this.valueChanged = !this.tierMap.equals(newTierMap);
            }
            if (this.valueChanged) {
                this.tierMap = newTierMap;
                this.hiddenTiers = newHiddenTiersList;
            }
            this.doClose();
        } else if (e.getSource() == this.cancelButton) {
            this.tierMap = null;
            this.hiddenTiers = null;
            this.valueChanged = false;
            this.doClose();
        }
    }

    public HashMap<TierImpl, List<TierImpl>> getTierMap() {
        return this.tierMap;
    }

    public List<String> getHiddenTiers() {
        return this.hiddenTiers;
    }

    public List<String> getColumnTypes() {
        return this.columnTypeList;
    }

    private class TableCellEditor
    extends DefaultCellEditor
    implements ActionListener {
        private int startEditInOneClick;
        private JComboBox comboBox;
        private String previousValue;

        public TableCellEditor() {
            super(new JComboBox());
            this.startEditInOneClick = 1;
            this.setClickCountToStart(this.startEditInOneClick);
        }

        public TableCellEditor(JCheckBox checkBox) {
            super(checkBox);
            this.startEditInOneClick = 1;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            String typeName;
            if (value instanceof Boolean) {
                table.repaint();
                return super.getTableCellEditorComponent(table, value, isSelected, row, column);
            }
            this.previousValue = value != null ? value.toString() : null;
            String refTier = (String)table.getValueAt(row, table.getColumnModel().getColumnIndex(SelectChildTiersDlg.this.TIER_NAME_COLUMN));
            HashMap map = (HashMap)SelectChildTiersDlg.this.typeTierMap.get(refTier);
            List linkedTiers = (List)map.get(typeName = (String)SelectChildTiersDlg.this.columnTypeList.get(column - 2));
            if (linkedTiers == null) {
                return null;
            }
            this.comboBox = new JComboBox();
            for (int i = 0; i < linkedTiers.size(); ++i) {
                this.comboBox.addItem(linkedTiers.get(i));
            }
            this.comboBox.setSelectedIndex(-1);
            this.comboBox.addActionListener(this);
            return this.comboBox;
        }

        @Override
        public Object getCellEditorValue() {
            Object value = super.getCellEditorValue();
            if (value instanceof Boolean) {
                return value;
            }
            value = this.comboBox.getSelectedItem();
            if (value == null) {
                return EMPTY_TIER;
            }
            return value;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.comboBox && this.comboBox.getSelectedItem() != null) {
                int row = SelectChildTiersDlg.this.selectionTable.getSelectedRow();
                String selectedTierName = this.comboBox.getSelectedItem().toString();
                if (this.previousValue != null && this.previousValue.equals(selectedTierName)) {
                    SelectChildTiersDlg.this.selectionTable.editingStopped(new ChangeEvent(this));
                    return;
                }
                for (int i = 2; i < SelectChildTiersDlg.this.selectionTable.getColumnCount(); ++i) {
                    String tierName = (String)SelectChildTiersDlg.this.selectionTable.getValueAt(row, i);
                    if (!selectedTierName.equals(tierName)) continue;
                    if (this.comboBox.getItemCount() == 1) {
                        SelectChildTiersDlg.this.selectionTable.setValueAt(EMPTY_TIER, row, i);
                        continue;
                    }
                    if (this.comboBox.getItemCount() <= 1) continue;
                    ArrayList<String> usedTiersList = new ArrayList<String>();
                    block1: for (int x = 0; x < this.comboBox.getItemCount(); ++x) {
                        String comboBoxValue = this.comboBox.getItemAt(x).toString();
                        for (int c = 2; c < SelectChildTiersDlg.this.selectionTable.getColumnCount(); ++c) {
                            tierName = (String)SelectChildTiersDlg.this.selectionTable.getValueAt(row, c);
                            if (!comboBoxValue.equals(tierName)) continue;
                            if (usedTiersList.contains(comboBoxValue)) continue block1;
                            usedTiersList.add(comboBoxValue);
                            continue block1;
                        }
                    }
                    if (usedTiersList.size() < this.comboBox.getItemCount()) {
                        SelectChildTiersDlg.this.selectionTable.setValueAt(defaultValue, row, i);
                        continue;
                    }
                    SelectChildTiersDlg.this.selectionTable.setValueAt(EMPTY_TIER, row, i);
                }
                SelectChildTiersDlg.this.selectionTable.editingStopped(new ChangeEvent(this));
            }
        }
    }
}

