/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries.glove;

import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import mpi.eudico.client.annotator.timeseries.ContinuousRateTSTrack;
import mpi.eudico.client.annotator.timeseries.config.SamplePosition;
import mpi.eudico.client.annotator.timeseries.config.TSSourceConfiguration;
import mpi.eudico.client.annotator.timeseries.config.TSTrackConfiguration;
import mpi.eudico.client.annotator.timeseries.glove.DataGloveConfigPanel;
import mpi.eudico.client.annotator.timeseries.glove.DataGloveFileReader;
import mpi.eudico.client.annotator.timeseries.spi.TSConfigPanel;
import mpi.eudico.client.annotator.timeseries.spi.TSServiceProvider;
import mpi.eudico.client.annotator.util.ClientLogger;

public class DataGloveServiceProvider
implements TSServiceProvider,
ClientLogger {
    private static final String suffix = "log";
    private HashMap sourceToReaderMap = new HashMap();

    @Override
    public boolean canHandle(String filePath) {
        LOG.info("Polling: " + filePath);
        if (filePath == null || filePath.length() < 5) {
            return false;
        }
        if (!filePath.toLowerCase().endsWith(suffix)) {
            return false;
        }
        DataGloveFileReader reader = new DataGloveFileReader(filePath);
        if (reader.isValidFile()) {
            try {
                reader.detectSampleFrequency();
            }
            catch (IOException ioe) {
                LOG.severe("Could not detect sample frequency.");
            }
            this.sourceToReaderMap.put(filePath, reader);
        } else {
            LOG.info("Not a valid data glove file: " + filePath);
        }
        return reader.isValidFile();
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public TSConfigPanel getConfigPanel(TSSourceConfiguration config) {
        DataGloveConfigPanel panel = new DataGloveConfigPanel();
        panel.setSourceConfiguration(config);
        if (this.sourceToReaderMap.get(config.getSource()) != null) {
            panel.setReader((DataGloveFileReader)this.sourceToReaderMap.get(config.getSource()));
        } else {
            DataGloveFileReader dr = new DataGloveFileReader(config.getSource());
            try {
                dr.detectSampleFrequency();
            }
            catch (IOException ioe) {
                LOG.severe("Could not detect sample frequency.");
            }
            this.sourceToReaderMap.put(config.getSource(), dr);
            panel.setReader(dr);
        }
        return panel;
    }

    @Override
    public void autoCreateTracks(TSSourceConfiguration config) {
    }

    @Override
    public void createTracksFromConfiguration(TSSourceConfiguration config) {
        if (config == null) {
            return;
        }
        DataGloveFileReader reader = null;
        if (this.sourceToReaderMap.containsKey(config.getSource())) {
            reader = (DataGloveFileReader)this.sourceToReaderMap.get(config.getSource());
        } else {
            reader = new DataGloveFileReader(config.getSource());
            try {
                reader.detectSampleFrequency();
            }
            catch (IOException ioe) {
                LOG.severe("Could not detect sample frequency.");
            }
            this.sourceToReaderMap.put(config.getSource(), reader);
        }
        Iterator trIt = config.objectKeySet().iterator();
        int offset = config.getTimeOrigin();
        while (trIt.hasNext()) {
            Object key = trIt.next();
            Object val = config.getObject(key);
            if (!(val instanceof TSTrackConfiguration)) continue;
            TSTrackConfiguration trconf = (TSTrackConfiguration)val;
            ContinuousRateTSTrack track = new ContinuousRateTSTrack();
            track.setName(trconf.getTrackName());
            track.setTimeOffset(offset);
            SamplePosition spos = trconf.getSamplePos();
            int derLevel = 0;
            try {
                derLevel = Integer.parseInt(trconf.getProperty("derivative"));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            try {
                track.setData(reader.readTrack(spos.getRows()[0], spos.getColumns()[0], derLevel));
                track.setSampleRate(reader.getSampleFrequency());
                track.setDerivativeLevel(derLevel);
            }
            catch (IOException ioe) {
                LOG.severe("Could not read track: " + trconf.getTrackName() + " from: " + config.getSource());
            }
            track.setDescription(trconf.getProperty("description"));
            track.setUnitString(trconf.getProperty("units"));
            track.setType(1);
            float min = 0.0f;
            float max = 100.0f;
            try {
                min = Float.parseFloat(trconf.getProperty("min"));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            try {
                max = Float.parseFloat(trconf.getProperty("max"));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            track.setRange(new float[]{min, max});
            Color c = this.parseColor(trconf.getProperty("color"));
            track.setColor(c);
            trconf.putObject(track.getName(), track);
            trconf.removeProperty("derivative");
            trconf.removeProperty("description");
            trconf.removeProperty("units");
            trconf.removeProperty("min");
            trconf.removeProperty("max");
            trconf.removeProperty("color");
        }
    }

    private Color parseColor(String rgb) {
        if (rgb == null) {
            return Color.GREEN;
        }
        int index = rgb.indexOf(44);
        int index2 = rgb.lastIndexOf(44);
        if (index > -1 && index2 > -1) {
            int r = this.parseInt(rgb.substring(0, index));
            int g = this.parseInt(rgb.substring(index + 1, index2));
            int b = this.parseInt(rgb.substring(index2 + 1));
            return new Color(r, g, b);
        }
        return Color.GREEN;
    }

    private int parseInt(String sint) {
        try {
            return Integer.parseInt(sint);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }
}

