/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries.glove;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.timeseries.AbstractTSTrack;
import mpi.eudico.client.annotator.timeseries.ContinuousRateTSTrack;
import mpi.eudico.client.annotator.timeseries.TimeSeriesChangeEvent;
import mpi.eudico.client.annotator.timeseries.TimeSeriesChangeListener;
import mpi.eudico.client.annotator.timeseries.TrackTableModel;
import mpi.eudico.client.annotator.timeseries.config.SamplePosition;
import mpi.eudico.client.annotator.timeseries.config.TSSourceConfiguration;
import mpi.eudico.client.annotator.timeseries.config.TSTrackConfiguration;
import mpi.eudico.client.annotator.timeseries.glove.DataGloveConstants;
import mpi.eudico.client.annotator.timeseries.glove.DataGloveFileReader;
import mpi.eudico.client.annotator.timeseries.spi.TSConfigPanel;
import mpi.eudico.client.annotator.util.ClientLogger;

public class DataGloveConfigPanel
extends TSConfigPanel
implements ActionListener,
ItemListener,
ChangeListener,
ListSelectionListener,
ClientLogger {
    public static final int ADD = 0;
    public static final int CHANGE = 1;
    public static final int DELETE = 2;
    private TSSourceConfiguration config;
    private ArrayList listeners;
    private DataGloveFileReader reader;
    private TSTrackConfiguration currentTrack;
    private ArrayList tracks = new ArrayList();
    private int mode = 0;
    private JLabel titleLabel;
    private JLabel sourceLabel;
    private JPanel tablePanel;
    private JTable trackTable;
    private JTabbedPane tabPane;
    private TrackTableModel model;
    private JPanel editPanel;
    private JLabel selectTrackLabel;
    private JComboBox currentTracksCB;
    private JLabel trackNameLabel;
    private JTextField trackNameTF;
    private JLabel trackDescLabel;
    private JTextField trackDescTF;
    private JLabel sampleLabel;
    private JPanel singleCellPanel;
    private JRadioButton singleCellRB;
    private JLabel rowLabel;
    private JSpinner rowSpinner;
    private SpinnerNumberModel rowSpinModel;
    private JLabel columnLabel;
    private JSpinner colSpinner;
    private SpinnerNumberModel colSpinModel;
    private JPanel multiCellPanel;
    private JRadioButton multiCellRB;
    private JButton multiCellButton;
    private JLabel rangeLabel;
    private JPanel rangePanel;
    private JRadioButton calcRangeRB;
    private JRadioButton manRangeRB;
    private JLabel minLabel;
    private JFormattedTextField minTF;
    private JLabel maxLabel;
    private JFormattedTextField maxTF;
    private JLabel deriveLabel;
    private JRadioButton deriv0RB;
    private JRadioButton deriv1RB;
    private JRadioButton deriv2RB;
    private JRadioButton deriv3RB;
    private JLabel unitLabel;
    private JTextField unitTF;
    private JLabel colorLabel;
    private JButton colorButton;
    private JButton changeButton;
    private JPanel buttonPanel;

    public DataGloveConfigPanel() {
        this.initComponents();
        this.updateLocale();
        this.updateForMode();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setHorizontalAlignment(0);
        this.sourceLabel = new JLabel();
        this.sourceLabel.setFont(this.titleLabel.getFont().deriveFont(10.0f));
        this.sourceLabel.setHorizontalAlignment(0);
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new GridBagLayout());
        this.model = new TrackTableModel();
        this.trackTable = new JTable(this.model);
        this.trackTable.setSelectionMode(0);
        this.trackTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane tableScrollPane = new JScrollPane(this.trackTable);
        Dimension size = new Dimension(500, 100);
        tableScrollPane.setMinimumSize(size);
        tableScrollPane.setPreferredSize(size);
        this.tabPane = new JTabbedPane();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.weightx = 1.0;
        this.add((Component)this.titleLabel, gbc);
        gbc.gridy = 1;
        gbc.insets = insets;
        this.add((Component)this.sourceLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.tablePanel.add((Component)tableScrollPane, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.tablePanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 3;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(10, 6, 6, 6);
        gbc.weightx = 1.0;
        this.add((Component)this.tabPane, gbc);
        this.editPanel = new JPanel(new GridBagLayout());
        this.selectTrackLabel = new JLabel();
        this.currentTracksCB = new JComboBox();
        this.currentTracksCB.addItemListener(this);
        this.trackNameLabel = new JLabel();
        this.trackNameTF = new JTextField();
        this.trackDescLabel = new JLabel();
        this.trackDescTF = new JTextField();
        this.sampleLabel = new JLabel();
        this.singleCellPanel = new JPanel(new GridBagLayout());
        this.singleCellRB = new JRadioButton();
        this.singleCellRB.setSelected(true);
        this.rowLabel = new JLabel();
        this.rowSpinModel = new SpinnerNumberModel();
        this.rowSpinModel.setMinimum(new Integer(0));
        this.rowSpinModel.setMaximum(new Integer(34));
        this.rowSpinner = new JSpinner(this.rowSpinModel);
        this.rowSpinner.addChangeListener(this);
        this.columnLabel = new JLabel();
        this.colSpinModel = new SpinnerNumberModel();
        this.colSpinModel.setMinimum(new Integer(0));
        this.colSpinModel.setMaximum(new Integer(DataGloveConstants.COLS_PER_ROW[0] - 1));
        this.colSpinner = new JSpinner(this.colSpinModel);
        this.multiCellPanel = new JPanel(new GridBagLayout());
        this.multiCellRB = new JRadioButton();
        this.multiCellRB.setEnabled(false);
        this.multiCellButton = new JButton();
        this.multiCellButton.setEnabled(false);
        this.rangeLabel = new JLabel();
        this.rangePanel = new JPanel(new GridBagLayout());
        this.calcRangeRB = new JRadioButton();
        this.calcRangeRB.addChangeListener(this);
        this.manRangeRB = new JRadioButton();
        this.manRangeRB.setSelected(true);
        this.manRangeRB.addChangeListener(this);
        this.minLabel = new JLabel();
        NumberFormat format = NumberFormat.getNumberInstance(Locale.ENGLISH);
        format.setParseIntegerOnly(false);
        this.minTF = new JFormattedTextField(format);
        this.maxLabel = new JLabel();
        this.maxTF = new JFormattedTextField(format);
        this.deriveLabel = new JLabel();
        this.deriv0RB = new JRadioButton("0");
        this.deriv0RB.setSelected(true);
        this.deriv1RB = new JRadioButton("1");
        this.deriv2RB = new JRadioButton("2");
        this.deriv3RB = new JRadioButton("3");
        this.unitLabel = new JLabel();
        this.unitTF = new JTextField();
        this.colorLabel = new JLabel();
        this.colorButton = new JButton();
        this.colorButton.setBackground(Color.GREEN);
        this.colorButton.addActionListener(this);
        this.singleCellPanel.setBorder(new TitledBorder(""));
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.singleCellRB);
        group1.add(this.multiCellRB);
        GridBagConstraints subgbc = new GridBagConstraints();
        subgbc.gridwidth = 2;
        subgbc.anchor = 18;
        subgbc.insets = insets;
        subgbc.fill = 2;
        subgbc.weightx = 1.0;
        this.singleCellPanel.add((Component)this.singleCellRB, subgbc);
        subgbc.gridy = 1;
        subgbc.gridwidth = 1;
        subgbc.fill = 0;
        this.singleCellPanel.add((Component)this.rowLabel, subgbc);
        subgbc.gridy = 2;
        this.singleCellPanel.add((Component)this.columnLabel, subgbc);
        subgbc.gridy = 1;
        subgbc.gridx = 1;
        subgbc.fill = 2;
        this.singleCellPanel.add((Component)this.rowSpinner, subgbc);
        subgbc.gridy = 2;
        this.singleCellPanel.add((Component)this.colSpinner, subgbc);
        this.multiCellPanel.setBorder(new TitledBorder(""));
        subgbc = new GridBagConstraints();
        subgbc.anchor = 18;
        subgbc.insets = insets;
        subgbc.fill = 2;
        subgbc.weightx = 1.0;
        this.multiCellPanel.add((Component)this.multiCellRB, subgbc);
        subgbc.gridy = 2;
        this.multiCellPanel.add((Component)this.multiCellButton, subgbc);
        this.rangePanel.setBorder(new TitledBorder(""));
        ButtonGroup group3 = new ButtonGroup();
        group3.add(this.manRangeRB);
        group3.add(this.calcRangeRB);
        subgbc.gridy = 0;
        subgbc.gridwidth = 2;
        this.rangePanel.add((Component)this.calcRangeRB, subgbc);
        subgbc.gridy = 1;
        this.rangePanel.add((Component)this.manRangeRB, subgbc);
        subgbc.gridy = 2;
        subgbc.gridwidth = 1;
        subgbc.fill = 0;
        subgbc.weightx = 0.0;
        this.rangePanel.add((Component)this.minLabel, subgbc);
        subgbc.gridy = 3;
        this.rangePanel.add((Component)this.maxLabel, subgbc);
        subgbc.gridy = 2;
        subgbc.gridx = 1;
        subgbc.fill = 2;
        subgbc.weightx = 0.5;
        subgbc.gridwidth = 1;
        this.rangePanel.add((Component)this.minTF, subgbc);
        subgbc.gridy = 3;
        this.rangePanel.add((Component)this.maxTF, subgbc);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.deriv0RB);
        group2.add(this.deriv1RB);
        group2.add(this.deriv2RB);
        group2.add(this.deriv3RB);
        GridBagConstraints lgbc = new GridBagConstraints();
        lgbc.anchor = 18;
        lgbc.insets = insets;
        this.editPanel.add((Component)this.selectTrackLabel, lgbc);
        GridBagConstraints rgbc = new GridBagConstraints();
        rgbc.gridx = 1;
        rgbc.gridwidth = 4;
        rgbc.fill = 2;
        rgbc.anchor = 18;
        rgbc.insets = insets;
        rgbc.weightx = 1.0;
        this.editPanel.add((Component)this.currentTracksCB, rgbc);
        lgbc.gridy = 1;
        this.editPanel.add((Component)this.trackNameLabel, lgbc);
        rgbc.gridy = 1;
        this.editPanel.add((Component)this.trackNameTF, rgbc);
        lgbc.gridy = 2;
        this.editPanel.add((Component)this.trackDescLabel, lgbc);
        rgbc.gridy = 2;
        this.editPanel.add((Component)this.trackDescTF, rgbc);
        lgbc.gridy = 3;
        this.editPanel.add((Component)this.sampleLabel, lgbc);
        rgbc.gridy = 3;
        rgbc.gridwidth = 2;
        this.editPanel.add((Component)this.singleCellPanel, rgbc);
        rgbc.gridx = 3;
        this.editPanel.add((Component)this.multiCellPanel, rgbc);
        lgbc.gridy = 4;
        this.editPanel.add((Component)this.rangeLabel, lgbc);
        rgbc.gridx = 1;
        rgbc.gridwidth = 4;
        rgbc.gridy = 4;
        this.editPanel.add((Component)this.rangePanel, rgbc);
        lgbc.gridy = 5;
        this.editPanel.add((Component)this.deriveLabel, lgbc);
        rgbc.gridy = 5;
        rgbc.gridwidth = 1;
        this.editPanel.add((Component)this.deriv0RB, rgbc);
        rgbc.gridx = 2;
        this.editPanel.add((Component)this.deriv1RB, rgbc);
        rgbc.gridx = 3;
        this.editPanel.add((Component)this.deriv2RB, rgbc);
        rgbc.gridx = 4;
        this.editPanel.add((Component)this.deriv3RB, rgbc);
        lgbc.gridy = 6;
        this.editPanel.add((Component)this.unitLabel, lgbc);
        rgbc.gridy = 6;
        rgbc.gridx = 1;
        rgbc.gridwidth = 1;
        this.editPanel.add((Component)this.unitTF, rgbc);
        lgbc.gridy = 7;
        this.editPanel.add((Component)this.colorLabel, lgbc);
        rgbc.gridy = 7;
        this.editPanel.add((Component)this.colorButton, rgbc);
        this.buttonPanel = new JPanel(new GridBagLayout());
        this.buttonPanel.setBorder(new TitledBorder(""));
        this.changeButton = new JButton();
        this.changeButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.insets = insets;
        this.buttonPanel.add((Component)this.changeButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.gridwidth = 5;
        gbc.anchor = 10;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.editPanel.add((Component)this.buttonPanel, gbc);
        this.tabPane.addTab(ElanLocale.getString("Button.Add"), null);
        this.tabPane.addTab(ElanLocale.getString("Button.Change"), null);
        this.tabPane.addTab(ElanLocale.getString("Button.Delete"), null);
        this.tabPane.setComponentAt(0, this.editPanel);
        this.tabPane.setSelectedIndex(0);
        this.tabPane.addChangeListener(this);
    }

    private void updateLocale() {
        this.tablePanel.setBorder(new TitledBorder(ElanLocale.getString("TimeSeriesViewer.Config.CurrentTracks")));
        this.titleLabel.setText(ElanLocale.getString("TimeSeriesViewer.Config.Tracks.Title"));
        this.selectTrackLabel.setText(ElanLocale.getString("TimeSeriesViewer.Config.SelectTrack"));
        this.trackNameLabel.setText(ElanLocale.getString("TimeSeriesViewer.Config.TrackName"));
        this.trackDescLabel.setText(ElanLocale.getString("TimeSeriesViewer.Config.TrackDesc"));
        this.sampleLabel.setText(ElanLocale.getString("TimeSeriesViewer.Config.SampleCell"));
        this.singleCellRB.setText(ElanLocale.getString("TimeSeriesViewer.Config.SingleCell"));
        this.rowLabel.setText(ElanLocale.getString("TimeSeriesViewer.Config.SampleRow"));
        this.columnLabel.setText(ElanLocale.getString("TimeSeriesViewer.Config.SampleColumn"));
        this.multiCellRB.setText(ElanLocale.getString("TimeSeriesViewer.Config.MultiCell"));
        this.multiCellButton.setText(ElanLocale.getString("TimeSeriesViewer.Config.MultiCellConfig"));
        this.rangeLabel.setText(ElanLocale.getString("TimeSeriesViewer.Config.Range"));
        this.calcRangeRB.setText(ElanLocale.getString("TimeSeriesViewer.Config.RangeCalc"));
        this.manRangeRB.setText(ElanLocale.getString("TimeSeriesViewer.Config.RangeManual"));
        this.minLabel.setText(ElanLocale.getString("TimeSeriesViewer.Config.RangeMinimum"));
        this.maxLabel.setText(ElanLocale.getString("TimeSeriesViewer.Config.RangeMaximum"));
        this.deriveLabel.setText(ElanLocale.getString("TimeSeriesViewer.Config.Derivative"));
        this.unitLabel.setText(ElanLocale.getString("TimeSeriesViewer.Config.Units"));
        this.colorLabel.setText(ElanLocale.getString("TimeSeriesViewer.Config.TrackColor"));
        this.colorButton.setText("...");
        this.changeButton.setText(ElanLocale.getString("Button.Add"));
    }

    private void updateForMode() {
        switch (this.mode) {
            case 0: {
                this.currentTracksCB.setEnabled(false);
                this.trackNameTF.setEnabled(true);
                this.trackNameTF.setEditable(true);
                this.trackDescTF.setEnabled(true);
                this.trackDescTF.setEditable(true);
                this.rowSpinner.setEnabled(true);
                this.colSpinner.setEnabled(true);
                if (this.manRangeRB.isSelected()) {
                    this.minTF.setEnabled(true);
                    this.minTF.setEditable(true);
                    this.maxTF.setEnabled(true);
                    this.maxTF.setEditable(true);
                }
                this.deriv0RB.setEnabled(true);
                this.deriv1RB.setEnabled(true);
                this.deriv2RB.setEnabled(true);
                this.deriv3RB.setEnabled(true);
                this.unitTF.setEnabled(true);
                this.unitTF.setEditable(true);
                this.colorButton.setEnabled(true);
                this.changeButton.setText(ElanLocale.getString("Button.Add"));
                break;
            }
            case 1: {
                this.currentTracksCB.setEnabled(true);
                this.trackNameTF.setEnabled(true);
                this.trackNameTF.setEditable(true);
                this.trackDescTF.setEnabled(true);
                this.trackDescTF.setEditable(true);
                this.rowSpinner.setEnabled(false);
                this.colSpinner.setEnabled(false);
                if (this.manRangeRB.isSelected()) {
                    this.minTF.setEnabled(true);
                    this.minTF.setEditable(true);
                    this.maxTF.setEnabled(true);
                    this.maxTF.setEditable(true);
                }
                this.deriv0RB.setEnabled(false);
                this.deriv1RB.setEnabled(false);
                this.deriv2RB.setEnabled(false);
                this.deriv3RB.setEnabled(false);
                this.unitTF.setEnabled(true);
                this.unitTF.setEditable(true);
                this.colorButton.setEnabled(true);
                this.changeButton.setText(ElanLocale.getString("Button.Change"));
                break;
            }
            case 2: {
                this.currentTracksCB.setEnabled(true);
                this.trackNameTF.setEnabled(false);
                this.trackNameTF.setEditable(false);
                this.trackDescTF.setEnabled(false);
                this.trackDescTF.setEditable(false);
                this.rowSpinner.setEnabled(false);
                this.colSpinner.setEnabled(false);
                this.minTF.setEnabled(false);
                this.minTF.setEditable(false);
                this.maxTF.setEnabled(false);
                this.maxTF.setEditable(false);
                this.deriv0RB.setEnabled(false);
                this.deriv1RB.setEnabled(false);
                this.deriv2RB.setEnabled(false);
                this.deriv3RB.setEnabled(false);
                this.unitTF.setEnabled(false);
                this.unitTF.setEditable(false);
                this.colorButton.setEnabled(false);
                this.changeButton.setText(ElanLocale.getString("Button.Delete"));
            }
        }
    }

    private void updateForTrack(String trackName) {
        if (trackName == null) {
            this.trackNameTF.setText("");
            this.trackDescTF.setText("");
            this.unitTF.setText("");
            this.rowSpinner.setValue(new Integer(0));
            this.colSpinModel.setMaximum(new Integer(DataGloveConstants.COLS_PER_ROW[0] - 1));
            this.colSpinner.setValue(new Integer(0));
            this.minTF.setValue(new Float(0.0f));
            this.maxTF.setValue(new Float(100.0f));
            this.deriv0RB.setSelected(true);
            this.colorButton.setBackground(Color.GREEN);
            this.trackTable.getSelectionModel().clearSelection();
            return;
        }
        for (int i = 0; i < this.tracks.size(); ++i) {
            TSTrackConfiguration tst = (TSTrackConfiguration)this.tracks.get(i);
            if (!tst.getTrackName().equals(trackName)) continue;
            this.currentTrack = tst;
            break;
        }
        if (this.currentTrack != null) {
            AbstractTSTrack track = (AbstractTSTrack)this.currentTrack.getObject(this.currentTrack.getTrackName());
            if (this.currentTracksCB.getSelectedItem() != this.currentTrack.getTrackName()) {
                this.currentTracksCB.setSelectedItem(this.currentTrack.getTrackName());
            }
            this.trackNameTF.setText(this.currentTrack.getTrackName());
            if (track != null) {
                String tmp = track.getDescription();
                if (tmp != null) {
                    this.trackDescTF.setText(tmp);
                } else {
                    this.trackDescTF.setText("");
                }
                tmp = track.getUnitString();
                if (tmp != null) {
                    this.unitTF.setText(tmp);
                } else {
                    this.unitTF.setText("");
                }
                if ("true".equals(this.currentTrack.getProperty("detect-range"))) {
                    this.calcRangeRB.setSelected(true);
                    this.minTF.setEnabled(false);
                    this.minTF.setEditable(false);
                    this.maxTF.setEnabled(false);
                    this.maxTF.setEditable(false);
                } else {
                    this.manRangeRB.setSelected(true);
                    this.minTF.setEnabled(true);
                    this.minTF.setEditable(true);
                    this.maxTF.setEnabled(true);
                    this.maxTF.setEditable(true);
                }
                float[] range = track.getRange();
                if (range != null) {
                    this.minTF.setValue(new Float(range[0]));
                    this.maxTF.setValue(new Float(range[1]));
                } else {
                    this.minTF.setValue(new Float(0.0f));
                    this.maxTF.setValue(new Float(100.0f));
                }
                int deriv = track.getDerivativeLevel();
                switch (deriv) {
                    case 1: {
                        this.deriv1RB.setSelected(true);
                        break;
                    }
                    case 2: {
                        this.deriv2RB.setSelected(true);
                        break;
                    }
                    case 3: {
                        this.deriv3RB.setSelected(true);
                        break;
                    }
                    default: {
                        this.deriv0RB.setSelected(true);
                    }
                }
                Color c = track.getColor();
                if (c != null) {
                    this.colorButton.setBackground(c);
                } else {
                    this.colorButton.setBackground(Color.GREEN);
                }
            } else {
                this.trackDescTF.setText("");
                this.unitTF.setText("");
                this.deriv0RB.setSelected(true);
                this.colorButton.setBackground(Color.GREEN);
            }
            SamplePosition spos = this.currentTrack.getSamplePos();
            if (spos != null) {
                int[] rows = spos.getRows();
                int[] cols = spos.getColumns();
                if (rows.length == 1) {
                    this.singleCellRB.setSelected(true);
                    this.rowSpinner.setValue(new Integer(rows[0]));
                    this.colSpinModel.setMaximum(new Integer(DataGloveConstants.COLS_PER_ROW[rows[0]] - 1));
                    this.colSpinner.setValue(new Integer(cols[0]));
                } else {
                    this.multiCellRB.setSelected(true);
                }
            }
            if (this.model != null) {
                int col = this.model.findColumn("TimeSeriesViewer.Config.TrackName");
                this.trackTable.getSelectionModel().removeListSelectionListener(this);
                for (int i = 0; i < this.model.getRowCount(); ++i) {
                    if (!this.currentTrack.getTrackName().equals(this.model.getValueAt(i, col))) continue;
                    this.trackTable.getSelectionModel().setLeadSelectionIndex(i);
                    break;
                }
                this.trackTable.getSelectionModel().addListSelectionListener(this);
            }
        }
    }

    private void reextractTracks() {
        this.currentTracksCB.removeItemListener(this);
        this.currentTracksCB.removeAllItems();
        this.model.removeAllRows();
        for (int i = 0; i < this.tracks.size(); ++i) {
            TSTrackConfiguration tr = (TSTrackConfiguration)this.tracks.get(i);
            this.currentTracksCB.addItem(tr.getTrackName());
            this.model.addRow(tr);
        }
        this.currentTracksCB.addItemListener(this);
    }

    private void notifyListeners(TimeSeriesChangeEvent ev) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((TimeSeriesChangeListener)this.listeners.get(i)).timeSeriesChanged(ev);
            }
        }
    }

    public void setReader(DataGloveFileReader reader) {
        this.reader = reader;
    }

    @Override
    public void addTimeSeriesChangeListener(TimeSeriesChangeListener li) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(li);
    }

    @Override
    public void setSourceConfiguration(TSSourceConfiguration tssc) {
        if (tssc == null) {
            return;
        }
        this.tracks.clear();
        this.config = tssc;
        this.sourceLabel.setText(this.config.getSource());
        Iterator trit = this.config.objectKeySet().iterator();
        while (trit.hasNext()) {
            Object val = this.config.getObject(trit.next());
            if (!(val instanceof TSTrackConfiguration)) continue;
            this.tracks.add(val);
        }
        this.currentTracksCB.removeItemListener(this);
        this.currentTracksCB.removeAllItems();
        this.trackTable.getSelectionModel().removeListSelectionListener(this);
        this.model.removeAllRows();
        for (int i = 0; i < this.tracks.size(); ++i) {
            TSTrackConfiguration tr = (TSTrackConfiguration)this.tracks.get(i);
            this.currentTracksCB.addItem(tr.getTrackName());
            this.model.addRow(tr);
        }
        this.currentTracksCB.addItemListener(this);
        this.trackTable.getSelectionModel().addListSelectionListener(this);
        if (this.currentTracksCB.getItemCount() > 0) {
            this.updateForTrack((String)this.currentTracksCB.getSelectedItem());
        }
    }

    private void selectColor() {
        Color newColor = JColorChooser.showDialog(this, ElanLocale.getString("TimeSeriesViewer.Config.TrackColor"), this.colorButton.getBackground());
        this.colorButton.setBackground(newColor);
    }

    private AbstractTSTrack createTrack(int row, int col, int derLevel) {
        if (this.reader == null) {
            return null;
        }
        ContinuousRateTSTrack track = new ContinuousRateTSTrack();
        try {
            track.setData(this.reader.readTrack(row, col, derLevel));
            track.setSampleRate(this.reader.getSampleFrequency());
            track.setType(1);
        }
        catch (IOException ioe) {
            LOG.warning("Could not read data for track: " + ioe.getMessage());
        }
        return track;
    }

    private float[] calculateRange(AbstractTSTrack track) {
        float[] range = new float[]{0.0f, 100.0f};
        if (track != null && track.getData() instanceof float[]) {
            float[] data = (float[])track.getData();
            float min = Float.MAX_VALUE;
            float max = Float.MIN_VALUE;
            for (int i = 0; i < data.length; ++i) {
                if (data[i] < min) {
                    min = data[i];
                }
                if (!(data[i] > max)) continue;
                max = data[i];
            }
            range[0] = min;
            range[1] = max;
        }
        return range;
    }

    private void doAdd() {
        String name = this.trackNameTF.getText();
        int row = 0;
        int col = 0;
        int derLevel = 0;
        float min = 0.0f;
        float max = 100.0f;
        if (name != null) {
            name = name.trim();
        }
        if (name.length() == 0) {
            this.showWarningMessage(ElanLocale.getString("TimeSeriesViewer.Config.Message.NoName"));
            return;
        }
        for (int i = 0; i < this.tracks.size(); ++i) {
            TSTrackConfiguration tst = (TSTrackConfiguration)this.tracks.get(i);
            if (!name.equals(tst.getTrackName())) continue;
            this.showWarningMessage(ElanLocale.getString("TimeSeriesViewer.Config.Message.NameExists"));
            return;
        }
        TSTrackConfiguration nextTrack = new TSTrackConfiguration(name);
        if (this.singleCellRB.isSelected()) {
            row = (Integer)this.rowSpinner.getValue();
            col = (Integer)this.colSpinner.getValue();
            SamplePosition spos = new SamplePosition(new int[]{row}, new int[]{col});
            nextTrack.setSamplePos(spos);
        }
        if (this.calcRangeRB.isSelected()) {
            nextTrack.setProperty("detect-range", "true");
        } else {
            Object minObj = this.minTF.getValue();
            Object maxObj = this.maxTF.getValue();
            if (minObj instanceof Double) {
                min = ((Double)minObj).floatValue();
            } else if (minObj instanceof Long) {
                min = ((Long)minObj).floatValue();
            } else if (minObj instanceof Float) {
                min = ((Float)minObj).floatValue();
            }
            if (maxObj instanceof Double) {
                max = ((Double)maxObj).floatValue();
            } else if (maxObj instanceof Long) {
                max = ((Long)maxObj).floatValue();
            } else if (maxObj instanceof Float) {
                max = ((Float)maxObj).floatValue();
            }
            nextTrack.setProperty("detect-range", "false");
        }
        if (this.deriv1RB.isSelected()) {
            derLevel = 1;
        } else if (this.deriv2RB.isSelected()) {
            derLevel = 2;
        } else if (this.deriv3RB.isSelected()) {
            derLevel = 3;
        }
        AbstractTSTrack track = this.createTrack(row, col, derLevel);
        if (track != null) {
            track.setColor(this.colorButton.getBackground());
            track.setDerivativeLevel(derLevel);
            track.setName(name);
            if (this.calcRangeRB.isSelected()) {
                track.setRange(this.calculateRange(track));
            } else {
                track.setRange(new float[]{min, max});
            }
            nextTrack.putObject(name, track);
        }
        if (this.trackDescTF.getText() != null) {
            track.setDescription(this.trackDescTF.getText().trim());
        }
        if (this.unitTF.getText() != null) {
            track.setUnitString(this.unitTF.getText().trim());
        }
        this.config.putObject(name, nextTrack);
        this.tracks.add(nextTrack);
        this.currentTracksCB.addItem(name);
        this.model.addRow(nextTrack);
        this.notifyListeners(new TimeSeriesChangeEvent(nextTrack, 0, 101));
        this.updateForTrack(name);
    }

    private void doChange() {
        if (this.currentTrack != null) {
            boolean changed = false;
            AbstractTSTrack track = (AbstractTSTrack)this.currentTrack.getObject(this.currentTrack.getTrackName());
            String name = this.trackNameTF.getText();
            if (name != null) {
                name = name.trim();
            }
            if (name.length() == 0) {
                this.showWarningMessage(ElanLocale.getString("TimeSeriesViewer.Config.Message.NoName"));
                return;
            }
            if (!name.equals(this.currentTrack.getTrackName())) {
                this.currentTrack.setTrackName(name);
                if (track != null) {
                    track.setName(name);
                }
                changed = true;
            }
            if (this.trackDescTF.getText() != null) {
                String desc = this.trackDescTF.getText().trim();
                if (track != null && !desc.equals(track.getDescription())) {
                    track.setDescription(desc);
                    changed = true;
                }
            }
            if ("true".equals(this.currentTrack.getProperty("detect-range")) && !this.calcRangeRB.isSelected()) {
                this.currentTrack.setProperty("detect-range", "false");
                changed = true;
            }
            if (track != null && track.getRange() != null) {
                float min = 0.0f;
                float max = 100.0f;
                Object minObj = this.minTF.getValue();
                Object maxObj = this.maxTF.getValue();
                if (minObj instanceof Double) {
                    min = ((Double)minObj).floatValue();
                } else if (minObj instanceof Long) {
                    min = ((Long)minObj).floatValue();
                } else if (minObj instanceof Float) {
                    min = ((Float)minObj).floatValue();
                }
                if (maxObj instanceof Double) {
                    max = ((Double)maxObj).floatValue();
                } else if (maxObj instanceof Long) {
                    max = ((Long)maxObj).floatValue();
                } else if (maxObj instanceof Float) {
                    max = ((Float)maxObj).floatValue();
                }
                if (track.getRange()[0] != min || track.getRange()[1] != max) {
                    track.setRange(new float[]{min, max});
                    changed = true;
                }
            }
            if (track != null) {
                String units;
                if (this.unitTF.getText() != null && !(units = this.unitTF.getText().trim()).equals(track.getUnitString())) {
                    track.setUnitString(units);
                    changed = true;
                }
                if (track.getColor() != this.colorButton.getBackground()) {
                    track.setColor(this.colorButton.getBackground());
                    changed = true;
                }
            }
            if (changed) {
                this.notifyListeners(new TimeSeriesChangeEvent(this.currentTrack, 1, 101));
                this.reextractTracks();
                this.updateForTrack(this.currentTrack.getTrackName());
            }
        }
    }

    private void doDelete() {
        if (this.currentTrack != null) {
            this.tracks.remove(this.currentTrack);
            this.config.removeObject(this.currentTrack.getTrackName());
            this.reextractTracks();
            this.notifyListeners(new TimeSeriesChangeEvent(this.currentTrack, 2, 101));
            if (this.currentTracksCB.getItemCount() > 0) {
                this.updateForTrack((String)this.currentTracksCB.getItemAt(0));
            } else {
                this.updateForTrack(null);
            }
        }
    }

    private void showWarningMessage(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.changeButton) {
            switch (this.mode) {
                case 0: {
                    this.doAdd();
                    break;
                }
                case 1: {
                    this.doChange();
                    break;
                }
                case 2: {
                    this.doDelete();
                }
            }
        } else if (event.getSource() == this.colorButton) {
            this.selectColor();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.tabPane) {
            this.mode = this.tabPane.getSelectedIndex();
            this.updateForMode();
        } else if (e.getSource() == this.calcRangeRB) {
            this.minTF.setEnabled(false);
            this.minTF.setEditable(false);
            this.maxTF.setEnabled(false);
            this.maxTF.setEditable(false);
        } else if (e.getSource() == this.manRangeRB) {
            this.minTF.setEnabled(true);
            this.minTF.setEditable(true);
            this.maxTF.setEnabled(true);
            this.maxTF.setEditable(true);
        } else if (e.getSource() == this.rowSpinner) {
            if (this.rowSpinner.getValue() instanceof Integer) {
                int row = (Integer)this.rowSpinner.getValue();
                this.colSpinModel.setMaximum(new Integer(DataGloveConstants.COLS_PER_ROW[row] - 1));
                this.colSpinner.setValue(new Integer(0));
            }
        } else if (e.getSource() == this.singleCellRB) {
            this.rowSpinner.setEnabled(true);
            this.colSpinner.setEnabled(true);
            this.multiCellButton.setEnabled(false);
        } else if (e.getSource() == this.multiCellRB) {
            this.rowSpinner.setEnabled(false);
            this.colSpinner.setEnabled(false);
            this.multiCellButton.setEnabled(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            String trackName = (String)this.currentTracksCB.getSelectedItem();
            this.updateForTrack(trackName);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int row = this.trackTable.getSelectedRow();
        if (row > -1) {
            int column = this.model.findColumn("TimeSeriesViewer.Config.TrackName");
            this.updateForTrack((String)this.model.getValueAt(row, column));
        }
    }
}

