/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.timeseries.AbstractTSTrack;
import mpi.eudico.client.annotator.timeseries.TSRuler;
import mpi.eudico.client.annotator.timeseries.TSTrackPanelImpl;

public class TSRulerImpl
implements TSRuler {
    private int height;
    private int width;
    private float zoom;
    private float[] range;
    private String units;
    private Color foreground;
    private Font font;
    private int[] tickYPos = new int[3];
    private final int majorTickWidth = 5;
    private final int minorTickWidth = 3;
    private TSTrackPanelImpl trackPanel;

    public TSRulerImpl() {
        this(new float[]{0.0f, 100.0f});
    }

    public TSRulerImpl(float[] range) {
        this.setRange(range);
    }

    public TSRulerImpl(float[] range, int width, int height) {
        this.width = width;
        this.height = height;
        this.setRange(range);
    }

    @Override
    public float[] getRange() {
        return this.range;
    }

    @Override
    public void setRange(float[] range) {
        if (range != null) {
            this.range = range;
        }
    }

    @Override
    public String getUnitString() {
        return this.units;
    }

    @Override
    public void setUnitString(String unitString) {
        this.units = unitString;
    }

    public void paint(Graphics2D g2d) {
        float ym;
        if (this.range == null) {
            return;
        }
        if (this.foreground != null) {
            g2d.setColor(this.foreground);
        }
        if (this.font != null) {
            g2d.setFont(this.font);
        }
        float unitLabelRX = 0.0f;
        int numLabels = (int)((float)this.height / (g2d.getFont().getSize2D() + 2.0f));
        g2d.drawLine(this.width - 5, 0, this.width, 0);
        int lw = this.width - 5 - 2;
        String label = this.getLabelString(this.range[1], g2d.getFontMetrics(), lw);
        if (numLabels > 0) {
            g2d.drawString(label, (float)(lw - g2d.getFontMetrics(g2d.getFont()).stringWidth(label)), g2d.getFont().getSize2D());
        }
        g2d.drawLine(this.width - 5, this.height, this.width, this.height);
        if (numLabels > 1) {
            label = this.getLabelString(this.range[0], g2d.getFontMetrics(), lw);
            unitLabelRX = lw - g2d.getFontMetrics(g2d.getFont()).stringWidth(label);
            g2d.drawString(label, unitLabelRX, (float)this.height);
        }
        if (this.range[0] < 0.0f && this.range[1] > 0.0f) {
            ym = (float)this.height * this.range[1] / (this.range[1] - this.range[0]);
            this.tickYPos[0] = (int)ym;
            g2d.drawLine(this.width - 5, this.tickYPos[0], this.width, this.tickYPos[0]);
            if (numLabels > 2 && (double)ym > 1.5 * (double)g2d.getFont().getSize2D() + 2.0 && (double)ym < (double)this.height - 1.5 * (double)g2d.getFont().getSize2D() - 2.0) {
                label = "0";
                g2d.drawString(label, (float)(lw - g2d.getFontMetrics(g2d.getFont()).stringWidth(label)), ym + g2d.getFont().getSize2D() / 2.0f);
            }
            this.tickYPos[1] = (int)ym / 2;
            g2d.drawLine(this.width - 3, this.tickYPos[1], this.width, this.tickYPos[1]);
            this.tickYPos[2] = (int)(ym + ((float)this.height - ym) / 2.0f);
            g2d.drawLine(this.width - 3, this.tickYPos[2], this.width, this.tickYPos[2]);
        } else {
            ym = (float)this.height / 2.0f;
            this.tickYPos[0] = (int)ym;
            this.tickYPos[1] = this.height / 4;
            this.tickYPos[2] = (int)((float)(3 * this.height) / 4.0f);
            g2d.drawLine(this.width - 3, this.tickYPos[1], this.width, this.tickYPos[1]);
            g2d.drawLine(this.width - 5, this.tickYPos[0], this.width, this.tickYPos[0]);
            if (numLabels > 2 && (double)ym > 1.5 * (double)g2d.getFont().getSize2D() + 2.0 && (double)ym < (double)this.height - 1.5 * (double)g2d.getFont().getSize2D() - 2.0) {
                label = this.getLabelString((this.range[0] + this.range[1]) / 2.0f, g2d.getFontMetrics(), lw);
                g2d.drawString(label, (float)(lw - g2d.getFontMetrics(g2d.getFont()).stringWidth(label)), ym + g2d.getFont().getSize2D() / 2.0f);
            }
            g2d.drawLine(this.width - 3, this.tickYPos[2], this.width, this.tickYPos[2]);
        }
        if (this.units != null && this.units.length() > 0 && numLabels > 1) {
            String us = "(" + this.units + ")";
            int unitLX = g2d.getFontMetrics(g2d.getFont()).stringWidth(us);
            g2d.setColor(Constants.ACTIVEANNOTATIONCOLOR);
            g2d.drawString(us, unitLabelRX - 2.0f - (float)unitLX, (float)this.height);
        }
        if (this.trackPanel != null && this.trackPanel.getTracks().size() > 0) {
            int ly = (int)(2.0f * g2d.getFont().getSize2D());
            for (int i = 0; i < this.trackPanel.getTracks().size() && ly < this.height; ++i) {
                AbstractTSTrack track = (AbstractTSTrack)this.trackPanel.getTracks().get(i);
                g2d.setColor(track.getColor());
                g2d.drawString(track.getName(), 2, ly);
                ly = (int)((float)ly + (g2d.getFont().getSize2D() + 2.0f));
            }
        }
    }

    public int[] getTickYPositions() {
        return this.tickYPos;
    }

    public float getVerticalZoom() {
        return this.zoom;
    }

    public void setVerticalZoom(float vertZoom) {
        this.zoom = vertZoom;
    }

    public void setTrackPanel(TSTrackPanelImpl trackPanel) {
        this.trackPanel = trackPanel;
    }

    public TSTrackPanelImpl getTrackPanel() {
        return this.trackPanel;
    }

    public void removeTrackPanel(TSTrackPanelImpl trackPanel) {
        if (this.trackPanel == trackPanel) {
            trackPanel = null;
        }
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setForegroundColor(Color foreground) {
        this.foreground = foreground;
    }

    @Override
    public Color getForegroundColor() {
        return this.foreground;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFontSize(float size) {
        if (this.font != null) {
            this.font = this.font.deriveFont(size);
        }
    }

    @Override
    public float getFontSize() {
        if (this.font != null) {
            return this.font.getSize2D();
        }
        return 0.0f;
    }

    private String getLabelString(float value, FontMetrics metrics, int maxWidth) {
        String lab = String.valueOf(value);
        if (metrics == null) {
            return lab;
        }
        int w = metrics.stringWidth(lab);
        if (w <= maxWidth) {
            return lab;
        }
        while (w > maxWidth && lab.length() > 0) {
            lab = lab.substring(0, lab.length() - 1);
            w = metrics.stringWidth(lab);
        }
        return lab;
    }
}

