/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.tier.DisplayableContentTableModel;

public class OverlapsStep2
extends StepPane {
    private JLabel createAnnotationLabel;
    private JButton valuesMatchConstraintsBtn;
    private JTable tierValueTable;
    private JRadioButton overlapRB;
    private JRadioButton valuesTheSameRB;
    private JRadioButton valuesDifferentRB;
    private JRadioButton valuesMatchConstraintsRB;
    private Insets globalInset;
    private Insets singleTabInset;
    private Frame parentFrame;

    public OverlapsStep2(MultiStepPane mp, Frame owner) {
        super(mp);
        this.parentFrame = owner;
        this.globalInset = new Insets(5, 10, 5, 10);
        this.singleTabInset = new Insets(0, 30, 0, 10);
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        this.createAnnotationLabel = new JLabel(ElanLocale.getString("OverlapsDialog.Label.CreateAnnotation"));
        RadioButtonListener radioButtonListener = new RadioButtonListener();
        this.overlapRB = new JRadioButton(ElanLocale.getString("OverlapsDialog.Radio.Overlap"), true);
        this.overlapRB.addActionListener(radioButtonListener);
        this.valuesTheSameRB = new JRadioButton(ElanLocale.getString("OverlapsDialog.Radio.ValuesTheSame"));
        this.valuesTheSameRB.addActionListener(radioButtonListener);
        this.valuesDifferentRB = new JRadioButton(ElanLocale.getString("OverlapsDialog.Radio.ValuesDifferent"));
        this.valuesDifferentRB.addActionListener(radioButtonListener);
        this.valuesMatchConstraintsRB = new JRadioButton(ElanLocale.getString("OverlapsDialog.Radio.ValuesMatchConstraints"));
        this.valuesMatchConstraintsRB.addActionListener(radioButtonListener);
        this.valuesMatchConstraintsBtn = new JButton(ElanLocale.getString("OverlapsDialog.Button.Constraints"));
        this.valuesMatchConstraintsBtn.addActionListener(new ButtonListener());
        this.valuesMatchConstraintsBtn.setEnabled(false);
        ButtonGroup criteriaButtonGroup = new ButtonGroup();
        criteriaButtonGroup.add(this.overlapRB);
        criteriaButtonGroup.add(this.valuesTheSameRB);
        criteriaButtonGroup.add(this.valuesDifferentRB);
        criteriaButtonGroup.add(this.valuesMatchConstraintsRB);
        JPanel criteriaPanel = new JPanel(new GridBagLayout());
        criteriaPanel.setBorder(new TitledBorder(ElanLocale.getString("OverlapsDialog.Panel.Title.Criteria")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = this.globalInset;
        criteriaPanel.add((Component)this.createAnnotationLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = this.singleTabInset;
        criteriaPanel.add((Component)this.overlapRB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = this.singleTabInset;
        criteriaPanel.add((Component)this.valuesTheSameRB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        criteriaPanel.add((Component)this.valuesDifferentRB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        criteriaPanel.add((Component)this.valuesMatchConstraintsRB, gbc);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.anchor = 13;
        gbc.fill = 0;
        criteriaPanel.add((Component)this.valuesMatchConstraintsBtn, gbc);
        this.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.insets = this.globalInset;
        gbc.fill = 2;
        this.add((Component)criteriaPanel, gbc);
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("OverlapsDialog.Title.Step2Title");
    }

    @Override
    public void enterStepForward() {
        this.updateButtonStates();
    }

    @Override
    public void enterStepBackward() {
        this.updateButtonStates();
    }

    @Override
    public boolean leaveStepForward() {
        int overlapsCriteria = 0;
        if (this.overlapRB.isSelected()) {
            overlapsCriteria = 0;
        } else if (this.valuesTheSameRB.isSelected()) {
            overlapsCriteria = 1;
        } else if (this.valuesDifferentRB.isSelected()) {
            overlapsCriteria = 2;
        } else if (this.valuesMatchConstraintsRB.isSelected()) {
            overlapsCriteria = 3;
        }
        ArrayList<String[]> tierValuePairs = new ArrayList<String[]>();
        if (this.tierValueTable != null) {
            DisplayableContentTableModel m = (DisplayableContentTableModel)this.tierValueTable.getModel();
            for (int i = 0; i < m.getRowCount(); ++i) {
                tierValuePairs.add(new String[]{(String)m.getValueAt(i, 1), (String)m.getValueAt(i, 3)});
            }
        }
        this.multiPane.putStepProperty("overlapsCriteria", overlapsCriteria);
        this.multiPane.putStepProperty("tierValueConstraints", tierValuePairs);
        this.updateButtonStates();
        return true;
    }

    public void updateButtonStates() {
        this.multiPane.setButtonEnabled(1, true);
        this.multiPane.setButtonEnabled(2, true);
    }

    private class ConstraintDialog
    extends ClosableDialog
    implements ActionListener,
    ItemListener {
        private JPanel constraintPanel;
        private JPanel buttonPanel;
        private JButton removeButton;
        private JButton removeAllButton;
        private JButton addButton;
        private JButton okButton;
        private JLabel containsLabel;
        private JPanel specifyConstraintPanel;
        private JPanel constraintOverviewPanel;
        private JTable tierValueTable;
        private JComboBox tierNameCB;
        private JTextField annotationValueTF;
        private JScrollPane scrollPane;
        private DisplayableContentTableModel tableModel;

        public ConstraintDialog() {
            super(OverlapsStep2.this.parentFrame, true);
            this.setTitle(ElanLocale.getString("OverlapsDialog.Dialog.ConstraintDialog.Title"));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            this.initConstraintPanel();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.anchor = 18;
            gbc.insets = new Insets(4, 5, 4, 4);
            this.add((Component)this.constraintPanel, gbc);
        }

        private void initConstraintPanel() {
            Insets insets;
            this.tierNameCB = new JComboBox();
            this.tableModel = new DisplayableContentTableModel(4);
            this.tierValueTable = new JTable(this.tableModel);
            this.tierValueTable.getColumnModel().getColumn(0).setMaxWidth(35);
            this.tierValueTable.getColumnModel().getColumn(2).setMaxWidth(60);
            Vector tierList = (Vector)OverlapsStep2.this.multiPane.getStepProperty("SelectedTiers");
            for (int i = 0; i < tierList.size(); ++i) {
                this.tierNameCB.addItem(tierList.get(i).toString());
            }
            for (int r = this.tableModel.getRowCount() - 1; r >= 0; --r) {
                if (tierList.contains(this.tableModel.getValueAt(r, 1))) continue;
                this.tableModel.removeRow(r);
            }
            this.tierNameCB.addItemListener(this);
            this.constraintPanel = new JPanel(new GridBagLayout());
            this.specifyConstraintPanel = new JPanel(new GridBagLayout());
            this.specifyConstraintPanel.setBorder(new TitledBorder(ElanLocale.getString("OverlapsDialog.Panel.Title.SpecifyConstraint")));
            this.constraintOverviewPanel = new JPanel(new GridBagLayout());
            this.constraintOverviewPanel.setBorder(new TitledBorder(ElanLocale.getString("OverlapsDialog.Panel.Title.ConstraintsOverview")));
            this.annotationValueTF = new JTextField();
            this.containsLabel = new JLabel(ElanLocale.getString("OverlapsDialog.Combo.Contains"));
            this.addButton = new JButton(ElanLocale.getString("Button.Add"));
            this.addButton.addActionListener(this);
            this.tierValueTable.getColumnModel().getColumn(0).setHeaderValue("");
            this.tierValueTable.getColumnModel().getColumn(0).setWidth(10);
            this.tierValueTable.getColumnModel().getColumn(1).setHeaderValue(ElanLocale.getString("OverlapsDialog.Column.Header.Tier"));
            this.tierValueTable.getColumnModel().getColumn(2).setHeaderValue("");
            this.tierValueTable.getColumnModel().getColumn(2).setWidth(30);
            this.tierValueTable.getColumnModel().getColumn(3).setHeaderValue(ElanLocale.getString("OverlapsDialog.Column.Header.Value"));
            this.tableModel.connectTable(this.tierValueTable);
            this.scrollPane = new JScrollPane(this.tierValueTable);
            this.removeButton = new JButton(ElanLocale.getString("OverlapsDialog.Button.Remove"));
            this.removeButton.addActionListener(this);
            this.removeAllButton = new JButton(ElanLocale.getString("OverlapsDialog.Button.RemoveAll"));
            this.removeAllButton.addActionListener(this);
            this.okButton = new JButton(ElanLocale.getString("Button.OK"));
            this.okButton.addActionListener(this);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 0.5;
            gbc.insets = new Insets(5, 10, 5, 0);
            gbc.anchor = 10;
            gbc.fill = 2;
            this.specifyConstraintPanel.add((Component)this.tierNameCB, gbc);
            gbc.gridy = 0;
            gbc.gridx = 1;
            gbc.fill = 1;
            gbc.weightx = 0.0;
            this.specifyConstraintPanel.add((Component)this.containsLabel, gbc);
            gbc.gridx = 2;
            gbc.weightx = 0.5;
            gbc.fill = 1;
            this.specifyConstraintPanel.add((Component)this.annotationValueTF, gbc);
            gbc.gridx = 3;
            gbc.weightx = 0.0;
            gbc.insets = OverlapsStep2.this.globalInset;
            gbc.anchor = 17;
            gbc.fill = 0;
            this.specifyConstraintPanel.add((Component)this.addButton, gbc);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.fill = 1;
            gbc.anchor = 10;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = OverlapsStep2.this.globalInset;
            this.constraintOverviewPanel.add((Component)this.scrollPane, gbc);
            this.buttonPanel = new JPanel(new FlowLayout());
            this.buttonPanel.add(this.removeButton);
            this.buttonPanel.add(this.removeAllButton);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.gridwidth = 1;
            gbc.insets = insets = new Insets(0, ((OverlapsStep2)OverlapsStep2.this).globalInset.left, ((OverlapsStep2)OverlapsStep2.this).globalInset.bottom, ((OverlapsStep2)OverlapsStep2.this).globalInset.right);
            gbc.anchor = 17;
            gbc.fill = 0;
            this.constraintOverviewPanel.add((Component)this.buttonPanel, gbc);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 10;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.constraintPanel.add((Component)this.specifyConstraintPanel, gbc);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            this.constraintPanel.add((Component)this.constraintOverviewPanel, gbc);
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = OverlapsStep2.this.globalInset;
            this.constraintPanel.add((Component)this.okButton, gbc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton btn = (JButton)e.getSource();
            if (btn == this.addButton) {
                this.addButton.setEnabled(false);
                int selectedIndex = this.tierNameCB.getSelectedIndex();
                String[] value = new String[]{"", this.tierNameCB.getItemAt(selectedIndex).toString(), ElanLocale.getString("OverlapsDialog.Combo.Contains"), this.annotationValueTF.getText()};
                int rowIndex = this.findIndexToAdd(value[1], value[3]);
                if (this.tableModel.contains(value[1], 1)) {
                    return;
                }
                if (rowIndex > 0) {
                    value[0] = ElanLocale.getString("OverlapsDialog.Message.And");
                    this.tableModel.addRowAt(value, rowIndex);
                } else {
                    this.tableModel.addRowAt(value, rowIndex);
                    if (this.tableModel.getRowCount() >= 2) {
                        this.tableModel.setValueAt(ElanLocale.getString("OverlapsDialog.Message.And"), 1, 0);
                    }
                }
                this.tableModel.updateTables();
            } else if (btn == this.removeButton) {
                int i;
                int[] selectedRows = this.tierValueTable.getSelectedRows();
                for (i = selectedRows.length - 1; i >= 0; --i) {
                    this.tableModel.removeRow(selectedRows[i]);
                }
                for (i = 0; i < this.tableModel.getRowCount(); ++i) {
                    if (i == 0) {
                        this.tableModel.setValueAt("", 0, 0);
                        continue;
                    }
                    this.tableModel.setValueAt(ElanLocale.getString("OverlapsDialog.Message.And"), i, 0);
                }
                this.tierValueTable.getSelectionModel().clearSelection();
                String tierName = (String)this.tierNameCB.getSelectedItem();
                this.addButton.setEnabled(!this.tableModel.contains(tierName, 1));
                this.updateAddButtonState();
            } else if (btn == this.removeAllButton) {
                for (int i = this.tableModel.getRowCount() - 1; i >= 0; --i) {
                    this.tableModel.removeRow(i);
                }
                this.tierValueTable.getSelectionModel().clearSelection();
                this.updateAddButtonState();
            } else if (btn == this.okButton) {
                this.setVisible(false);
                this.dispose();
            }
        }

        private int findIndexToAdd(String tiername, String value) {
            Collator collator = Collator.getInstance();
            for (int r = 0; r < this.tableModel.getRowCount(); ++r) {
                int res = collator.compare((Object)tiername, this.tableModel.getValueAt(r, 1));
                if (res == -1) {
                    return r;
                }
                if (res != 0 || collator.compare((Object)value, this.tableModel.getValueAt(r, 3)) >= 0) continue;
                return r;
            }
            return this.tableModel.getRowCount();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.updateAddButtonState();
        }

        private void updateAddButtonState() {
            String tierName = (String)this.tierNameCB.getSelectedItem();
            this.addButton.setEnabled(!this.tableModel.contains(tierName, 1));
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton btn = (JButton)e.getSource();
            if (btn == OverlapsStep2.this.valuesMatchConstraintsBtn) {
                ConstraintDialog dialog = new ConstraintDialog();
                dialog.setSize(400, 500);
                dialog.setVisible(true);
            }
        }
    }

    private class RadioButtonListener
    implements ActionListener {
        private RadioButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean b = OverlapsStep2.this.valuesMatchConstraintsRB.isSelected();
            OverlapsStep2.this.valuesMatchConstraintsBtn.setEnabled(b);
        }
    }
}

