/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.util.List;
import java.util.Vector;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.AnnotationsFromOverlapsUndoableCommand;
import mpi.eudico.client.annotator.commands.AnnotationsFromSubtractionUndoableCommand;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.ProgressStepPane;
import mpi.eudico.client.annotator.tier.AnnotationFromOverlaps;
import mpi.eudico.client.annotator.tier.AnnotationFromSubtraction;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class OverlapsOrSubtractionStep5
extends ProgressStepPane {
    private TranscriptionImpl transcription;
    private boolean subtractionDialog;

    public OverlapsOrSubtractionStep5(MultiStepPane multiPane, TranscriptionImpl transcription) {
        this(multiPane, transcription, false);
    }

    public OverlapsOrSubtractionStep5(MultiStepPane multiPane, TranscriptionImpl transcription, boolean subtractionDialog) {
        super(multiPane);
        this.subtractionDialog = subtractionDialog;
        this.transcription = transcription;
        this.initComponents();
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("OverlapsDialog.Calculating");
    }

    @Override
    public void enterStepForward() {
        this.doFinish();
    }

    @Override
    public boolean doFinish() {
        this.completed = false;
        this.multiPane.setButtonEnabled(8, false);
        Vector selectedValues = (Vector)this.multiPane.getStepProperty("SelectedTiers");
        String[] sourceTiers = new String[selectedValues.size()];
        for (int i = 0; i < selectedValues.size(); ++i) {
            sourceTiers[i] = (String)selectedValues.get(i);
        }
        String destTierName = (String)this.multiPane.getStepProperty("DestinationTierName");
        String destLingType = (String)this.multiPane.getStepProperty("linguisticType");
        String parentTierName = (String)this.multiPane.getStepProperty("ParentTierName");
        int annotationValueType = (Integer)this.multiPane.getStepProperty("AnnotationValueType");
        String timeFormat = (String)this.multiPane.getStepProperty("TimeFormat");
        boolean usePalFormat = (Boolean)this.multiPane.getStepProperty("UsePalFormat");
        String annWithValue = (String)this.multiPane.getStepProperty("AnnotationValue");
        String annFromTier = (String)this.multiPane.getStepProperty("AnnFromTier");
        int transcriptionMode = (Integer)this.multiPane.getStepProperty("TranscriptionMode");
        List openedFileList = (List)this.multiPane.getStepProperty("OpenedFiles");
        Object[] filenames = openedFileList != null ? openedFileList.toArray() : null;
        Object[] args = null;
        AnnotationFromOverlaps com = null;
        if (this.subtractionDialog) {
            String referenceTierName = (String)this.multiPane.getStepProperty("ReferenceTierName");
            args = new Object[]{sourceTiers, destTierName, destLingType, annotationValueType, timeFormat, annWithValue, transcriptionMode, filenames, usePalFormat, parentTierName, referenceTierName};
            com = this.transcription != null ? (AnnotationsFromSubtractionUndoableCommand)ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.AnnotationsFromSubtraction") : new AnnotationFromSubtraction("Menu.Tier.AnnotationsFromOverlaps");
        } else {
            int overlapsCriteria = (Integer)this.multiPane.getStepProperty("overlapsCriteria");
            List tierValuePairs = (List)this.multiPane.getStepProperty("tierValueConstraints");
            List tierOrder = (List)this.multiPane.getStepProperty("TierOrder");
            args = new Object[]{sourceTiers, destTierName, destLingType, annotationValueType, timeFormat, annWithValue, annFromTier, tierOrder, overlapsCriteria, tierValuePairs, transcriptionMode, filenames, usePalFormat, parentTierName};
            com = this.transcription != null ? (AnnotationsFromOverlapsUndoableCommand)ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.AnnotationsFromOverlaps") : new AnnotationFromOverlaps("Menu.Tier.AnnotationsFromOverlaps");
        }
        com.addProgressListener(this);
        ((AnnotationFromOverlaps)com).execute(this.transcription, args);
        return false;
    }
}

