/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.tier.TierExportTableModel;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class CreateAnnsOnDependentTiersStep1
extends StepPane
implements MouseListener,
ListSelectionListener {
    private TranscriptionImpl transcription;
    private JTable tierTable;
    private TierExportTableModel model;

    public CreateAnnsOnDependentTiersStep1(MultiStepPane multiPane, TranscriptionImpl trans) {
        super(multiPane);
        this.transcription = trans;
        this.initComponents();
        this.extractTiers();
    }

    @Override
    public void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.model = new TierExportTableModel();
        this.model.setColumnCount(2);
        this.tierTable = new JTable(this.model);
        DefaultCellEditor cellEd = new DefaultCellEditor(new JCheckBox());
        this.tierTable.getColumnModel().getColumn(0).setCellEditor(cellEd);
        this.tierTable.getColumnModel().getColumn(0).setCellRenderer(new CheckBoxTableCellRenderer());
        this.tierTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.tierTable.setShowVerticalLines(false);
        this.tierTable.setTableHeader(null);
        this.tierTable.addMouseListener(this);
        this.tierTable.getSelectionModel().addListSelectionListener(this);
        Insets insets = new Insets(2, 6, 2, 6);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Dimension tableDim = new Dimension(450, 100);
        JScrollPane tierScrollPane = new JScrollPane(this.tierTable);
        tierScrollPane.setPreferredSize(tableDim);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)tierScrollPane, gridBagConstraints);
    }

    private void extractTiers() {
        if (this.transcription != null) {
            Vector v = this.transcription.getTiers();
            boolean selectFirstTier = false;
            for (int i = 0; i < v.size(); ++i) {
                TierImpl t = (TierImpl)v.get(i);
                if (t.getChildTiers().size() <= 0) continue;
                if (!selectFirstTier) {
                    this.model.addRow(new Object[]{Boolean.TRUE, t.getName()});
                    selectFirstTier = true;
                    continue;
                }
                this.model.addRow(new Object[]{Boolean.FALSE, t.getName()});
            }
        }
    }

    private List getSelectedTiers() {
        ArrayList<Object> tiers = new ArrayList<Object>();
        Object selObj = null;
        Object nameObj = null;
        for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
            selObj = this.tierTable.getValueAt(i, 0);
            if (selObj != Boolean.TRUE) continue;
            nameObj = this.tierTable.getValueAt(i, 1);
            TierImpl t = (TierImpl)this.transcription.getTierWithId(nameObj.toString());
            if (nameObj == null || t == null) continue;
            if (t.hasParentTier()) {
                if (tiers.contains(t.getParentTier().getName())) continue;
                tiers.add(nameObj);
                continue;
            }
            tiers.add(nameObj);
        }
        return tiers;
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("CreateAnnsOnDependentTiersDlg.Title");
    }

    @Override
    public void enterStepForward() {
        List selectedTiers = this.getSelectedTiers();
        if (selectedTiers.size() > 0) {
            this.multiPane.setButtonEnabled(1, true);
        }
    }

    @Override
    public void enterStepBackward() {
        this.multiPane.setButtonEnabled(1, true);
        this.multiPane.setButtonEnabled(4, true);
    }

    @Override
    public boolean leaveStepForward() {
        this.multiPane.putStepProperty("SelectedParentTiers", this.getSelectedTiers());
        return true;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        List selectedTiers = this.getSelectedTiers();
        if (selectedTiers.size() > 0) {
            this.multiPane.setButtonEnabled(1, true);
        } else {
            this.multiPane.setButtonEnabled(1, false);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (this.model != null && lse.getValueIsAdjusting()) {
            int b = lse.getFirstIndex();
            int e = lse.getLastIndex();
            int col = 0;
            for (int i = b; i <= e; ++i) {
                if (!this.tierTable.isRowSelected(i)) continue;
                this.model.setValueAt(Boolean.TRUE, i, col);
            }
        }
    }
}

