/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.util.TierTree;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class CopyTierStep2
extends StepPane
implements TreeSelectionListener {
    private TranscriptionImpl transcription;
    private JTree tierTree;
    private String tierName;
    private TierImpl selTier;
    private JLabel tierLabel;
    private boolean copyMode = false;

    public CopyTierStep2(MultiStepPane multiPane, TranscriptionImpl transcription) {
        super(multiPane);
        this.transcription = transcription;
        if (multiPane.getStepProperty("CopyMode") != null) {
            this.copyMode = true;
        }
        this.initComponents();
    }

    @Override
    public void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.tierLabel = new JLabel();
        if (this.transcription != null) {
            TierTree tree = new TierTree(this.transcription);
            DefaultMutableTreeNode transNode = tree.getTree();
            transNode.setUserObject(ElanLocale.getString("MultiStep.Reparent.Transcription"));
            this.tierTree = new JTree(transNode);
        } else {
            this.tierTree = new JTree();
        }
        DefaultTreeSelectionModel model = new DefaultTreeSelectionModel();
        model.setSelectionMode(1);
        model.addTreeSelectionListener(this);
        this.tierTree.setSelectionModel(model);
        this.tierTree.putClientProperty("JTree.lineStyle", "Angled");
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.tierTree.getCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setBackgroundNonSelectionColor(Constants.DEFAULTBACKGROUNDCOLOR);
        this.tierTree.setRootVisible(true);
        this.tierTree.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        this.tierTree.setFont(this.tierTree.getFont().deriveFont(14.0f));
        JScrollPane scrollPane = new JScrollPane(this.tierTree);
        for (int i = 0; i < this.tierTree.getRowCount(); ++i) {
            this.tierTree.expandRow(i);
        }
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        this.add((Component)this.tierLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        this.add((Component)new JLabel("<html>" + ElanLocale.getString("MultiStep.Reparent.SelectParent") + " " + ElanLocale.getString("MultiStep.Reparent.SelectTrans") + "</html>"), gbc);
        gbc.gridy = 2;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add((Component)scrollPane, gbc);
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("MultiStep.Reparent.SelectParent");
    }

    @Override
    public void enterStepForward() {
        this.tierName = (String)this.multiPane.getStepProperty("SelTier");
        if (this.tierName != null) {
            this.tierLabel.setText(ElanLocale.getString("MultiStep.Reparent.SelectedTier") + " " + this.tierName);
            this.selTier = (TierImpl)this.transcription.getTierWithId(this.tierName);
            if (this.copyMode) {
                if (this.selTier.hasParentTier()) {
                    String parentName = this.selTier.getParentTier().getName();
                    Enumeration<TreeNode> en = ((DefaultMutableTreeNode)this.tierTree.getModel().getRoot()).breadthFirstEnumeration();
                    DefaultMutableTreeNode node = null;
                    while (en.hasMoreElements()) {
                        node = (DefaultMutableTreeNode)en.nextElement();
                        if (!parentName.equals((String)node.getUserObject())) continue;
                        this.tierTree.getSelectionModel().setSelectionPath(new TreePath(((DefaultTreeModel)this.tierTree.getModel()).getPathToRoot(node)));
                        break;
                    }
                } else {
                    this.tierTree.getSelectionModel().setSelectionPath(new TreePath(this.tierTree.getModel().getRoot()));
                }
            }
        } else {
            this.tierName = "";
            this.selTier = null;
        }
        this.valueChanged(null);
    }

    @Override
    public void enterStepBackward() {
        this.multiPane.setButtonEnabled(1, true);
    }

    @Override
    public boolean leaveStepForward() {
        if (this.tierTree.getSelectionModel().getSelectionCount() > 0) {
            Object o = this.tierTree.getLastSelectedPathComponent();
            if (o instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)o;
                if (node.isRoot()) {
                    this.multiPane.putStepProperty("SelNewParent", null);
                } else {
                    String parentName = (String)node.getUserObject();
                    this.multiPane.putStepProperty("SelNewParent", parentName);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean leaveStepBackward() {
        return true;
    }

    @Override
    public boolean doFinish() {
        return true;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.tierTree.getSelectionCount() > 0) {
            Object o = this.tierTree.getLastSelectedPathComponent();
            if (o instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)o;
                String parentName = (String)node.getUserObject();
                if (!this.copyMode) {
                    String oldParent;
                    if (parentName.equals(this.tierName)) {
                        this.tierTree.setSelectionPath(null);
                        return;
                    }
                    if (this.selTier != null && this.selTier.getParentTier() == null && node.isRoot()) {
                        this.tierTree.setSelectionPath(null);
                        return;
                    }
                    if (this.selTier != null && this.selTier.getParentTier() != null && (oldParent = this.selTier.getParentTier().getName()).equals(parentName)) {
                        this.tierTree.setSelectionPath(null);
                        return;
                    }
                }
            }
            this.multiPane.setButtonEnabled(1, true);
        } else {
            this.multiPane.setButtonEnabled(1, false);
        }
    }
}

