/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.type.LinguisticTypeTableModel;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class CalcOverlapsStep2
extends StepPane
implements ListSelectionListener,
ActionListener,
CaretListener {
    private TranscriptionImpl transcription;
    private LinguisticTypeTableModel model;
    private JTable table;
    private JTextField nameField;
    JCheckBox contentCB;
    JRadioButton concatValuesRB;
    JRadioButton durationRB;
    JRadioButton msRB;
    JRadioButton secRB;
    JRadioButton hourRB;
    JLabel nameLabel;
    JLabel typeLabel;
    JCheckBox matchedValuesCB;
    JCheckBox specificValueCB;
    JTextField matchedValueTF;

    public CalcOverlapsStep2(MultiStepPane multiPane, TranscriptionImpl transcription) {
        super(multiPane);
        this.transcription = transcription;
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        this.model = new LinguisticTypeTableModel(null, new String[]{"Type", "Stereotype"});
        for (int i = 0; i < this.transcription.getLinguisticTypes().size(); ++i) {
            LinguisticType lt = (LinguisticType)this.transcription.getLinguisticTypes().get(i);
            if (lt.getConstraints() != null) continue;
            this.model.addRow(lt);
        }
        this.table = new JTable(this.model);
        this.table.getSelectionModel().setSelectionMode(0);
        if (this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        this.table.getSelectionModel().addListSelectionListener(this);
        Dimension prdim = new Dimension(120, 80);
        JScrollPane p1 = new JScrollPane(this.table);
        p1.setPreferredSize(prdim);
        this.nameField = new JTextField();
        this.nameField.addActionListener(this);
        this.nameField.addCaretListener(this);
        this.nameLabel = new JLabel(ElanLocale.getString("OverlapsDialog.Label.DestName"));
        this.typeLabel = new JLabel(ElanLocale.getString("OverlapsDialog.Label.Type"));
        this.concatValuesRB = new JRadioButton(ElanLocale.getString("OverlapsDialog.Label.Content2"));
        this.concatValuesRB.setSelected(true);
        this.concatValuesRB.addActionListener(this);
        this.durationRB = new JRadioButton(ElanLocale.getString("OverlapsDialog.Label.Content"));
        this.durationRB.addActionListener(this);
        ButtonGroup contentBG = new ButtonGroup();
        contentBG.add(this.durationRB);
        contentBG.add(this.concatValuesRB);
        this.msRB = new JRadioButton(ElanLocale.getString("TimeCodeFormat.MilliSec"));
        this.msRB.setSelected(true);
        this.secRB = new JRadioButton(ElanLocale.getString("TimeCodeFormat.Seconds"));
        this.hourRB = new JRadioButton(ElanLocale.getString("TimeCodeFormat.TimeCode"));
        this.msRB.setEnabled(false);
        this.secRB.setEnabled(false);
        this.hourRB.setEnabled(false);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.msRB);
        bg.add(this.secRB);
        bg.add(this.hourRB);
        this.matchedValuesCB = new JCheckBox(ElanLocale.getString("OverlapsDialog.Label.MatchingValues"));
        this.matchedValuesCB.addActionListener(this);
        this.specificValueCB = new JCheckBox(ElanLocale.getString("OverlapsDialog.Label.SpecificValue"));
        this.specificValueCB.setEnabled(false);
        this.specificValueCB.addActionListener(this);
        this.matchedValueTF = new JTextField();
        this.matchedValueTF.setEnabled(false);
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        this.add((Component)this.nameLabel, gbc);
        gbc.gridy = 1;
        this.add((Component)this.nameField, gbc);
        gbc.gridy = 2;
        this.add((Component)this.typeLabel, gbc);
        gbc.gridy = 3;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add((Component)p1, gbc);
        gbc.gridy = 4;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        this.add((Component)this.durationRB, gbc);
        JPanel filler = new JPanel();
        filler.setPreferredSize(new Dimension(24, 16));
        gbc.gridy = 5;
        gbc.insets = new Insets(0, 6, 0, 6);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 3;
        this.add((Component)filler, gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridheight = 1;
        this.add((Component)this.msRB, gbc);
        gbc.gridy = 6;
        this.add((Component)this.secRB, gbc);
        gbc.gridy = 7;
        this.add((Component)this.hourRB, gbc);
        gbc.insets = new Insets(10, 6, 4, 6);
        gbc.gridx = 0;
        gbc.gridy = 9;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.concatValuesRB, gbc);
        gbc.insets = new Insets(10, 6, 4, 6);
        gbc.gridx = 0;
        gbc.gridy = 10;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.matchedValuesCB, gbc);
        filler = new JPanel();
        filler.setPreferredSize(new Dimension(24, 16));
        JPanel valPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        valPanel.add((Component)filler, gbc);
        gbc.gridx = 1;
        valPanel.add((Component)this.specificValueCB, gbc);
        gbc.gridx = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        valPanel.add((Component)this.matchedValueTF, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.gridy = 11;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)valPanel, gbc);
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("OverlapsDialog.DefineDest");
    }

    @Override
    public void enterStepBackward() {
        this.multiPane.setButtonEnabled(1, false);
        this.multiPane.setButtonEnabled(3, true);
    }

    @Override
    public void enterStepForward() {
        this.valueChanged(null);
    }

    @Override
    public boolean leaveStepForward() {
        if (this.table.getSelectedRowCount() > -1) {
            if (!this.validTierName()) {
                return false;
            }
            this.multiPane.putStepProperty("DestTier", this.nameField.getText());
            int row = this.table.getSelectedRow();
            Object sel = this.table.getValueAt(row, 0);
            this.multiPane.putStepProperty("Type", (String)sel);
            this.multiPane.putStepProperty("Content", new Boolean(this.durationRB.isSelected()));
            if (this.durationRB.isSelected()) {
                this.multiPane.putStepProperty("ContentType", "Duration");
                if (this.msRB.isSelected()) {
                    this.multiPane.putStepProperty("Format", new Integer(102));
                } else if (this.secRB.isSelected()) {
                    this.multiPane.putStepProperty("Format", new Integer(101));
                } else if (this.hourRB.isSelected()) {
                    this.multiPane.putStepProperty("Format", new Integer(100));
                }
            }
            this.multiPane.putStepProperty("MatchingValuesOnly", new Boolean(this.matchedValuesCB.isSelected()));
            this.multiPane.putStepProperty("SpecificValueOnly", new Boolean(this.specificValueCB.isSelected()));
            if (this.specificValueCB.isSelected()) {
                this.multiPane.putStepProperty("SpecificValue", this.matchedValueTF.getText());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean doFinish() {
        this.multiPane.nextStep();
        return false;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.checkConditions();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.durationRB || e.getSource() == this.concatValuesRB) {
            this.msRB.setEnabled(this.durationRB.isSelected());
            this.secRB.setEnabled(this.durationRB.isSelected());
            this.hourRB.setEnabled(this.durationRB.isSelected());
        } else if (e.getSource() == this.matchedValuesCB) {
            this.specificValueCB.setEnabled(this.matchedValuesCB.isSelected());
            if (!this.matchedValuesCB.isSelected()) {
                this.matchedValueTF.setEnabled(false);
            }
        } else if (e.getSource() == this.specificValueCB) {
            if (this.specificValueCB.isSelected()) {
                this.matchedValueTF.setEnabled(true);
                this.matchedValueTF.grabFocus();
            } else {
                this.matchedValueTF.setEnabled(false);
            }
        } else {
            this.checkConditions();
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.checkConditions();
    }

    private boolean validTierName() {
        String name = this.nameField.getText();
        if (name == null || name.length() == 0) {
            return false;
        }
        return this.transcription.getTierWithId(name) == null;
    }

    void checkConditions() {
        if (this.table.getSelectedRow() > -1) {
            if (this.validTierName()) {
                this.multiPane.setButtonEnabled(3, true);
            } else {
                this.multiPane.setButtonEnabled(3, false);
            }
        } else {
            this.multiPane.setButtonEnabled(3, false);
        }
    }
}

