/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.MFDomainDialog;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.tier.DisplayableContentTableModel;
import mpi.eudico.client.annotator.tier.SelectableContentTableModel;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public abstract class AbstractFileAndTierSelectionStepPane
extends StepPane {
    private TranscriptionImpl transcription;
    private JTable tierTable;
    private Set<String> tierSet;
    private JRadioButton currentlyOpenedFileRB;
    private JRadioButton selectedFilesFromDiskRB;
    private JRadioButton filesFromDomainRB;
    private JPanel fileSelectionPanel;
    private JPanel tierSelectionPanel;
    private JPanel buttonPanel;
    private ButtonGroup buttonGroup;
    private JButton selectFilesBtn;
    private JButton selectDomainBtn;
    private JButton selectAllButton;
    private JButton selectNoneButton;
    private JScrollPane tierTableScrollPane;
    private List<String> openedFileList;
    private List<String> rootTierTypeNamesList;
    private List<String> childTierTypeNamesList;
    private List<String> completeTypeNamesList;
    private Insets globalInset;

    public AbstractFileAndTierSelectionStepPane(MultiStepPane mp, TranscriptionImpl transcription) {
        super(mp);
        this.transcription = transcription;
        this.globalInset = new Insets(5, 10, 5, 10);
        if (transcription != null) {
            this.tierSet = new TreeSet<String>();
            Vector tiers = transcription.getTiers();
            for (TierImpl tier : tiers) {
                this.tierSet.add(tier.getName());
            }
        }
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        this.initFileSelectionPanel();
        this.initTierSelectionPanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = this.globalInset;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.anchor = 10;
        this.add((Component)this.fileSelectionPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 10;
        this.add((Component)this.tierSelectionPanel, gbc);
    }

    @Override
    public abstract String getStepTitle();

    @Override
    public void enterStepForward() {
        this.updateButtonStates();
    }

    @Override
    public void enterStepBackward() {
        this.updateButtonStates();
    }

    @Override
    public boolean leaveStepForward() {
        SelectableContentTableModel model = (SelectableContentTableModel)this.tierTable.getModel();
        this.multiPane.putStepProperty("SelectedTiers", model.getSelectedValues());
        this.multiPane.putStepProperty("OpenedFiles", this.openedFileList);
        this.multiPane.putStepProperty("RootTierTypes", this.rootTierTypeNamesList);
        this.multiPane.putStepProperty("ChildTierTypes", this.childTierTypeNamesList);
        this.multiPane.putStepProperty("CompleteTierTypes", this.completeTypeNamesList);
        this.multiPane.putStepProperty("AllTiers", this.tierSet);
        int transcriptionMode = this.currentlyOpenedFileRB.isSelected() ? 0 : 1;
        this.multiPane.putStepProperty("TranscriptionMode", transcriptionMode);
        return true;
    }

    private void initFileSelectionPanel() {
        this.fileSelectionPanel = new JPanel(new GridBagLayout());
        this.fileSelectionPanel.setBorder(new TitledBorder(ElanLocale.getString("FileAndTierSelectionStepPane.Panel.Title.FileSelection")));
        RadioButtonHandler radioButtonListener = new RadioButtonHandler();
        this.currentlyOpenedFileRB = new JRadioButton(ElanLocale.getString("FileAndTierSelectionStepPane.Radio.CurrentlyOpenedFile"));
        this.currentlyOpenedFileRB.addActionListener(radioButtonListener);
        this.selectedFilesFromDiskRB = new JRadioButton(ElanLocale.getString("FileAndTierSelectionStepPane.Radio.FilesFromFileBrowser"));
        this.selectedFilesFromDiskRB.addActionListener(radioButtonListener);
        this.filesFromDomainRB = new JRadioButton(ElanLocale.getString("FileAndTierSelectionStepPane.Radio.FilesFromDomain"));
        this.filesFromDomainRB.addActionListener(radioButtonListener);
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.currentlyOpenedFileRB);
        this.buttonGroup.add(this.selectedFilesFromDiskRB);
        this.buttonGroup.add(this.filesFromDomainRB);
        ButtonHandler buttonHandler = new ButtonHandler();
        this.selectFilesBtn = new JButton(ElanLocale.getString("Button.Browse"));
        this.selectFilesBtn.addActionListener(buttonHandler);
        this.selectDomainBtn = new JButton(ElanLocale.getString("FileAndTierSelectionStepPane.Button.Domain"));
        this.selectDomainBtn.addActionListener(buttonHandler);
        this.selectDomainBtn.setEnabled(false);
        if (this.transcription == null) {
            this.currentlyOpenedFileRB.setEnabled(false);
            this.selectedFilesFromDiskRB.setEnabled(true);
            this.selectedFilesFromDiskRB.setSelected(true);
            this.selectFilesBtn.setEnabled(true);
        } else {
            this.selectedFilesFromDiskRB.setEnabled(false);
            this.filesFromDomainRB.setEnabled(false);
            this.selectFilesBtn.setEnabled(false);
            this.selectDomainBtn.setEnabled(false);
            this.currentlyOpenedFileRB.setSelected(true);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 30, 0, 10);
        this.fileSelectionPanel.add((Component)this.currentlyOpenedFileRB, gbc);
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        this.fileSelectionPanel.add((Component)this.selectedFilesFromDiskRB, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        this.fileSelectionPanel.add((Component)this.selectFilesBtn, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        this.fileSelectionPanel.add((Component)this.filesFromDomainRB, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        this.fileSelectionPanel.add((Component)this.selectDomainBtn, gbc);
    }

    private void initTierSelectionPanel() {
        Insets insets;
        this.buttonPanel = new JPanel(new FlowLayout(0));
        this.tierSelectionPanel = new JPanel(new GridBagLayout());
        this.globalInset = new Insets(5, 10, 5, 10);
        this.tierSelectionPanel.setBorder(new TitledBorder(ElanLocale.getString("FileAndTierSelectionStepPane.Panel.Title.TierSelection")));
        this.selectAllButton = new JButton(ElanLocale.getString("Button.SelectAll"));
        this.selectNoneButton = new JButton(ElanLocale.getString("Button.SelectNone"));
        ButtonHandler buttonHandler = new ButtonHandler();
        this.selectAllButton.addActionListener(buttonHandler);
        this.selectNoneButton.addActionListener(buttonHandler);
        this.tierTable = new JTable();
        this.tierTable.setSelectionMode(0);
        this.tierTable.setShowVerticalLines(true);
        if (this.transcription != null) {
            Object[] tierArray = this.tierSet.toArray();
            String[] stereotypeArray = new String[tierArray.length];
            String[] linguisticArray = new String[tierArray.length];
            for (int i = 0; i < tierArray.length; ++i) {
                TierImpl tier = (TierImpl)this.transcription.getTierWithId((String)tierArray[i]);
                linguisticArray[i] = tier.getLinguisticType().getLinguisticTypeName();
                stereotypeArray[i] = "";
                if (!tier.getLinguisticType().hasConstraints()) continue;
                stereotypeArray[i] = Constraint.stereoTypes[tier.getLinguisticType().getConstraints().getStereoType()];
            }
            SelectableContentTableModel model = new SelectableContentTableModel(this.tierTable, tierArray, linguisticArray, stereotypeArray);
            model.addActionListener(new ModelClickedHandler());
            this.tierTable.setModel(model);
            this.tierTable.getColumnModel().getColumn(0).setHeaderValue(null);
            this.tierTable.getColumnModel().getColumn(1).setHeaderValue(ElanLocale.getString("FileAndTierSelectionStepPane.Column.TierName"));
            this.tierTable.getColumnModel().getColumn(2).setHeaderValue(ElanLocale.getString("FileAndTierSelectionStepPane.Column.LinguisticType"));
            this.tierTable.getColumnModel().getColumn(3).setHeaderValue(ElanLocale.getString("FileAndTierSelectionStepPane.Column.Stereotype"));
            this.tierTable.getColumnModel().getColumn(0).setMaxWidth(30);
        } else {
            DisplayableContentTableModel model = new DisplayableContentTableModel(ElanLocale.getString("FileAndTierSelectionStepPane.Message1"));
            this.tierTable.setModel(model);
            this.tierTable.getColumnModel().getColumn(0).setHeaderValue(ElanLocale.getString("FileAndTierSelectionStepPane.Column.Header.Message"));
            this.selectFilesBtn.setEnabled(true);
            this.selectDomainBtn.setEnabled(false);
        }
        this.tierTableScrollPane = new JScrollPane(this.tierTable);
        this.tierTableScrollPane.setColumnHeaderView(null);
        this.buttonPanel.add(this.selectAllButton);
        this.buttonPanel.add(this.selectNoneButton);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = this.globalInset;
        this.tierSelectionPanel.add((Component)this.tierTableScrollPane, gbc);
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = insets = new Insets(0, this.globalInset.left, 0, this.globalInset.right);
        this.tierSelectionPanel.add((Component)this.buttonPanel, gbc);
    }

    private List<String> showMultiFileChooser() {
        ArrayList<String> fileNames = null;
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowMultiFileDialog(ElanLocale.getString("Frame.ElanFrame.OpenDialog.Title"), 0, FileExtension.EAF_EXT, "LastUsedEAFDir");
        Object[] objects = chooser.getSelectedFiles();
        if (objects != null && objects.length > 0) {
            fileNames = new ArrayList<String>();
            for (int i = 0; i < objects.length; ++i) {
                if (fileNames.contains(objects[i])) continue;
                fileNames.add("" + objects[i]);
            }
        }
        return fileNames;
    }

    public void updateButtonStates() {
        try {
            SelectableContentTableModel model = (SelectableContentTableModel)this.tierTable.getModel();
            this.multiPane.setButtonEnabled(1, model.getSelectedValues().size() > 1);
            this.multiPane.setButtonEnabled(2, false);
        }
        catch (ClassCastException e) {
            this.multiPane.setButtonEnabled(1, false);
        }
    }

    protected void addFileNames(File dir, List<String> files) {
        if (dir == null && files == null) {
            return;
        }
        File[] allSubs = dir.listFiles();
        for (int i = 0; i < allSubs.length; ++i) {
            if (allSubs[i].isDirectory() && allSubs[i].canRead()) {
                this.addFileNames(allSubs[i], files);
                continue;
            }
            if (!allSubs[i].canRead() || !allSubs[i].getName().toLowerCase().endsWith(FileExtension.EAF_EXT[0]) || files.contains(allSubs[i].getAbsolutePath())) continue;
            files.add(allSubs[i].getAbsolutePath());
        }
    }

    private class OpenFilesThread
    extends Thread {
        private List<String> filenames;
        private JTable tierTable;
        private DisplayableContentTableModel model;
        private ActionListener listener;

        public OpenFilesThread(List<String> filenames, JTable tierTable, ActionListener listener) {
            this.filenames = filenames;
            this.tierTable = tierTable;
            this.listener = listener;
            this.model = new DisplayableContentTableModel(new String[]{ElanLocale.getString("FileAndTierSelectionStepPane.Message2.Part1"), "0 " + ElanLocale.getString("FileAndTierSelectionStepPane.Message2.Part2") + " " + filenames.size() + " " + ElanLocale.getString("FileAndTierSelectionStepPane.Message2.Part3") + " (0%)"});
            this.model.connectTable(this.tierTable);
            this.tierTable.setModel(this.model);
        }

        @Override
        public void run() {
            AbstractFileAndTierSelectionStepPane.this.tierSet = new TreeSet();
            AbstractFileAndTierSelectionStepPane.this.openedFileList = new ArrayList();
            AbstractFileAndTierSelectionStepPane.this.rootTierTypeNamesList = new ArrayList();
            AbstractFileAndTierSelectionStepPane.this.childTierTypeNamesList = new ArrayList();
            AbstractFileAndTierSelectionStepPane.this.completeTypeNamesList = new ArrayList();
            AbstractFileAndTierSelectionStepPane.this.multiPane.setButtonEnabled(2, false);
            AbstractFileAndTierSelectionStepPane.this.multiPane.setButtonEnabled(1, false);
            FrameManager manager = FrameManager.getInstance();
            for (int i = 0; i < this.filenames.size(); ++i) {
                TranscriptionImpl transImpl = null;
                ElanFrame2 frame = manager.getFrameFor(this.filenames.get(i), false);
                String message = null;
                if (frame != null) {
                    message = "' " + this.filenames.get(i) + ElanLocale.getString("FileAndTierSelectionStepPane.Message3.Part1");
                    if (frame.getViewerManager().getTranscription().isChanged()) {
                        message = message + "\\n" + ElanLocale.getString("FileAndTierSelectionStepPane.Message3.Part2");
                    }
                    message = message + "\\n" + ElanLocale.getString("FileAndTierSelectionStepPane.Message3.Part3");
                    JOptionPane.showMessageDialog(AbstractFileAndTierSelectionStepPane.this, message, ElanLocale.getString("Message.Warning"), 2, null);
                }
                if (transImpl == null) {
                    transImpl = new TranscriptionImpl(this.filenames.get(i));
                }
                AbstractFileAndTierSelectionStepPane.this.openedFileList.add(this.filenames.get(i));
                Vector tiersInFile = transImpl.getTiers();
                for (TierImpl tier : tiersInFile) {
                    AbstractFileAndTierSelectionStepPane.this.tierSet.add(tier.getName());
                }
                this.model.updateMessage(1, i + 1 + " " + ElanLocale.getString("FileAndTierSelectionStepPane.Message2.Part2") + " " + this.filenames.size() + " " + ElanLocale.getString("FileAndTierSelectionStepPane.Message2.Part3") + " (" + Math.round((float)(i + 1) / (float)this.filenames.size() * 100.0f) + "%)");
                Vector typesInFile = transImpl.getLinguisticTypes();
                for (LinguisticType type : typesInFile) {
                    if (type.getConstraints() == null) {
                        if (!AbstractFileAndTierSelectionStepPane.this.rootTierTypeNamesList.contains(type.getLinguisticTypeName())) {
                            AbstractFileAndTierSelectionStepPane.this.rootTierTypeNamesList.add(type.getLinguisticTypeName());
                        }
                    } else if (type.getConstraints().getStereoType() == 1) {
                        if (type.isUsingControlledVocabulary()) continue;
                        if (!AbstractFileAndTierSelectionStepPane.this.childTierTypeNamesList.contains(type.getLinguisticTypeName())) {
                            AbstractFileAndTierSelectionStepPane.this.childTierTypeNamesList.add(type.getLinguisticTypeName());
                        }
                    }
                    if (AbstractFileAndTierSelectionStepPane.this.completeTypeNamesList.contains(type.getLinguisticTypeName())) continue;
                    AbstractFileAndTierSelectionStepPane.this.completeTypeNamesList.add(type.getLinguisticTypeName());
                }
            }
            if (AbstractFileAndTierSelectionStepPane.this.tierSet.isEmpty()) {
                AbstractFileAndTierSelectionStepPane.this.openedFileList.clear();
                DisplayableContentTableModel model = (DisplayableContentTableModel)this.tierTable.getModel();
                model.setValueAt(ElanLocale.getString("FileAndTierSelectionStepPane.Message3"), 0, 0);
            } else {
                SelectableContentTableModel model = new SelectableContentTableModel(AbstractFileAndTierSelectionStepPane.this.tierSet, this.tierTable);
                model.addActionListener(this.listener);
                this.tierTable.setModel(model);
                this.tierTable.getColumnModel().getColumn(0).setHeaderValue(null);
                this.tierTable.getColumnModel().getColumn(1).setHeaderValue(ElanLocale.getString("FileAndTierSelectionStepPane.Column.TierName"));
                this.tierTable.getColumnModel().getColumn(0).setMaxWidth(30);
                this.tierTable.repaint();
            }
        }
    }

    private class RadioButtonHandler
    implements ActionListener {
        private JRadioButton previouslySelectedRadioButton;

        private RadioButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JRadioButton rb = (JRadioButton)e.getSource();
            if (rb == AbstractFileAndTierSelectionStepPane.this.currentlyOpenedFileRB) {
                if (this.previouslySelectedRadioButton != rb) {
                    AbstractFileAndTierSelectionStepPane.this.openedFileList = null;
                    this.previouslySelectedRadioButton = rb;
                }
                AbstractFileAndTierSelectionStepPane.this.selectFilesBtn.setEnabled(false);
                AbstractFileAndTierSelectionStepPane.this.selectDomainBtn.setEnabled(false);
                Object[] tierArray = AbstractFileAndTierSelectionStepPane.this.tierSet.toArray();
                String[] stereotypeArray = new String[tierArray.length];
                String[] linguisticArray = new String[tierArray.length];
                for (int i = 0; i < tierArray.length; ++i) {
                    TierImpl tier = (TierImpl)AbstractFileAndTierSelectionStepPane.this.transcription.getTierWithId((String)tierArray[i]);
                    linguisticArray[i] = tier.getLinguisticType().getLinguisticTypeName();
                    stereotypeArray[i] = "";
                    if (!tier.getLinguisticType().hasConstraints()) continue;
                    stereotypeArray[i] = Constraint.stereoTypes[tier.getLinguisticType().getConstraints().getStereoType()];
                }
                SelectableContentTableModel model = new SelectableContentTableModel(AbstractFileAndTierSelectionStepPane.this.tierTable, tierArray, linguisticArray, stereotypeArray);
                model.addActionListener(new ModelClickedHandler());
                AbstractFileAndTierSelectionStepPane.this.tierTable.setModel(model);
                AbstractFileAndTierSelectionStepPane.this.tierTable.getColumnModel().getColumn(0).setHeaderValue(null);
                AbstractFileAndTierSelectionStepPane.this.tierTable.getColumnModel().getColumn(1).setHeaderValue(ElanLocale.getString("FileAndTierSelectionStepPane.Column.TierName"));
                AbstractFileAndTierSelectionStepPane.this.tierTable.getColumnModel().getColumn(2).setHeaderValue(ElanLocale.getString("FileAndTierSelectionStepPane.Column.LinguisticType"));
                AbstractFileAndTierSelectionStepPane.this.tierTable.getColumnModel().getColumn(3).setHeaderValue(ElanLocale.getString("FileAndTierSelectionStepPane.Column.Stereotype"));
                AbstractFileAndTierSelectionStepPane.this.tierTable.getColumnModel().getColumn(0).setMaxWidth(30);
            } else if (rb == AbstractFileAndTierSelectionStepPane.this.selectedFilesFromDiskRB) {
                if (this.previouslySelectedRadioButton != rb) {
                    AbstractFileAndTierSelectionStepPane.this.openedFileList = null;
                    this.previouslySelectedRadioButton = rb;
                }
                DisplayableContentTableModel model = new DisplayableContentTableModel(ElanLocale.getString("FileAndTierSelectionStepPane.Message1"));
                AbstractFileAndTierSelectionStepPane.this.tierTable.setModel(model);
                AbstractFileAndTierSelectionStepPane.this.tierTable.getColumnModel().getColumn(0).setHeaderValue(ElanLocale.getString("FileAndTierSelectionStepPane.Column.Header.Message"));
                AbstractFileAndTierSelectionStepPane.this.selectFilesBtn.setEnabled(true);
                AbstractFileAndTierSelectionStepPane.this.selectDomainBtn.setEnabled(false);
            } else if (rb == AbstractFileAndTierSelectionStepPane.this.filesFromDomainRB) {
                if (this.previouslySelectedRadioButton != rb) {
                    AbstractFileAndTierSelectionStepPane.this.openedFileList = null;
                    this.previouslySelectedRadioButton = rb;
                }
                DisplayableContentTableModel model = new DisplayableContentTableModel(ElanLocale.getString("FileAndTierSelectionStepPane.Message3"));
                AbstractFileAndTierSelectionStepPane.this.tierTable.setModel(model);
                AbstractFileAndTierSelectionStepPane.this.tierTable.getColumnModel().getColumn(0).setHeaderValue(ElanLocale.getString("FileAndTierSelectionStepPane.Column.Header.Message"));
                AbstractFileAndTierSelectionStepPane.this.selectFilesBtn.setEnabled(false);
                AbstractFileAndTierSelectionStepPane.this.selectDomainBtn.setEnabled(true);
            }
            AbstractFileAndTierSelectionStepPane.this.updateButtonStates();
        }
    }

    private class ModelClickedHandler
    implements ActionListener {
        private ModelClickedHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractFileAndTierSelectionStepPane.this.updateButtonStates();
        }
    }

    private class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractFileAndTierSelectionStepPane.this.updateButtonStates();
            if (e != null) {
                JButton button = (JButton)e.getSource();
                if (button == AbstractFileAndTierSelectionStepPane.this.selectFilesBtn) {
                    List filenames = AbstractFileAndTierSelectionStepPane.this.showMultiFileChooser();
                    if (filenames != null && !filenames.isEmpty()) {
                        OpenFilesThread t = new OpenFilesThread(filenames, AbstractFileAndTierSelectionStepPane.this.tierTable, new ModelClickedHandler());
                        t.start();
                    }
                } else if (button == AbstractFileAndTierSelectionStepPane.this.selectDomainBtn) {
                    MFDomainDialog domainDialog = new MFDomainDialog((Frame)ELANCommandFactory.getRootFrame(AbstractFileAndTierSelectionStepPane.this.transcription), true);
                    domainDialog.setVisible(true);
                    List<String> searchPaths = domainDialog.getSearchPaths();
                    List<String> searchDirs = domainDialog.getSearchDirs();
                    for (int i = 0; i < searchDirs.size(); ++i) {
                        String fileName = searchDirs.get(i);
                        File f = new File(fileName);
                        if (f.isFile() && f.canRead() && !searchPaths.contains(fileName)) {
                            searchPaths.add(fileName);
                            continue;
                        }
                        if (!f.isDirectory() || !f.canRead()) continue;
                        AbstractFileAndTierSelectionStepPane.this.addFileNames(f, searchPaths);
                    }
                    if (!searchPaths.isEmpty()) {
                        OpenFilesThread t = new OpenFilesThread(searchPaths, AbstractFileAndTierSelectionStepPane.this.tierTable, new ModelClickedHandler());
                        t.start();
                    }
                } else if (button == AbstractFileAndTierSelectionStepPane.this.selectAllButton) {
                    try {
                        SelectableContentTableModel model = (SelectableContentTableModel)AbstractFileAndTierSelectionStepPane.this.tierTable.getModel();
                        model.selectAll();
                        AbstractFileAndTierSelectionStepPane.this.updateButtonStates();
                    }
                    catch (ClassCastException exception) {}
                } else if (button == AbstractFileAndTierSelectionStepPane.this.selectNoneButton) {
                    try {
                        SelectableContentTableModel model = (SelectableContentTableModel)AbstractFileAndTierSelectionStepPane.this.tierTable.getModel();
                        model.selectNone();
                        AbstractFileAndTierSelectionStepPane.this.updateButtonStates();
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

