/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.svg;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.svg.AbstractSVGViewer;
import mpi.eudico.client.annotator.svg.GraphicNode2D;
import mpi.eudico.client.annotator.svg.GraphicTier2D;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.server.corpora.clom.Transcription;

public class GlassPaneSVGViewer
extends AbstractSVGViewer
implements ElanLocaleListener,
ComponentListener {
    private Component underlyingComponent;
    private BufferedImage graphicsBuffer;
    private Graphics2D big2d;
    private AffineTransform currentTransform;
    private final Color clearColor = new Color(255, 255, 255, 0);

    public GlassPaneSVGViewer(Transcription transcription) {
        super(transcription);
        this.setOpaque(false);
        this.setVisible(true);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.underlyingComponent == null || this.graphicsBuffer == null) {
            return;
        }
        g2d.drawImage((Image)this.graphicsBuffer, 0, 0, null);
    }

    private void paintBuffer() {
        if (this.underlyingComponent == null) {
            return;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.graphicsBuffer == null || this.graphicsBuffer.getWidth() != w || this.graphicsBuffer.getHeight() != h) {
            this.graphicsBuffer = new BufferedImage(w, h, 2);
            this.big2d = this.graphicsBuffer.createGraphics();
        }
        this.big2d.setBackground(this.clearColor);
        this.big2d.clearRect(0, 0, w, h);
        if (this.currentTransform != null) {
            this.big2d.setTransform(this.currentTransform);
        }
        long time = this.getMediaTime();
        for (int i = 0; i < this.allGraphicTiers.size(); ++i) {
            int index;
            GraphicTier2D tier2d = (GraphicTier2D)this.allGraphicTiers.get(i);
            if (!tier2d.isVisible() || (index = Collections.binarySearch(tier2d.getNodeList(), new Long(time))) < 0) continue;
            GraphicNode2D node2d = (GraphicNode2D)tier2d.getNodeList().get(index);
            this.big2d.setColor(Color.red);
            node2d.paintShape(this.big2d, true);
            if (node2d.getAnnotation() != this.getActiveAnnotation()) continue;
            this.big2d.setColor(Constants.ACTIVEANNOTATIONCOLOR);
            node2d.paintActiveMarker(this.big2d);
        }
        this.repaint();
    }

    @Override
    void requestRepaint() {
        this.paintBuffer();
    }

    @Override
    public void controllerUpdate(ControllerEvent event) {
        this.paintBuffer();
    }

    public void setUnderlyingComponent(Component component) {
        if (this.underlyingComponent != null) {
            this.underlyingComponent.removeComponentListener(this);
        }
        this.underlyingComponent = component;
        this.underlyingComponent.addComponentListener(this);
        this.componentResized(null);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        Point pp = this.underlyingComponent.getParent().getLocation();
        Point vp = this.underlyingComponent.getLocation();
        this.setSize(this.underlyingComponent.getSize());
        this.setLocation(pp.x + vp.x, pp.y + vp.y);
        try {
            Dimension pref = ELANCommandFactory.getViewerManager(this.transcription).getMasterMediaPlayer().getVisualComponent().getPreferredSize();
            double xscale = (double)this.underlyingComponent.getWidth() / pref.getWidth();
            this.currentTransform.setToIdentity();
            this.currentTransform.scale(xscale, xscale);
        }
        catch (Exception ex) {
            this.currentTransform = new AffineTransform();
        }
        this.paintBuffer();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.componentResized(e);
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.componentResized(e);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void paintAnnotations(Graphics2D big2d) {
        this.paintComponent(big2d);
    }

    @Override
    public void paintAnnotations() {
    }

    @Override
    public void setVisibleTiers(List tiers) {
    }
}

