/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.smfsearch;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import mpi.eudico.client.annotator.util.FileUtility;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ImdiSearchServiceParser {
    private List<String> sessionFiles;
    private XMLReader reader;
    private String corpusFilePath;
    private boolean isSearchService = false;

    public ImdiSearchServiceParser(String corpusFilePath) throws IOException, SAXException {
        if (corpusFilePath == null) {
            throw new IOException("Cannot parse file <null>");
        }
        this.corpusFilePath = corpusFilePath.replace('\\', '/');
        this.sessionFiles = new ArrayList<String>();
        this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
        this.reader.setContentHandler(new CorpusHandler());
        this.reader.parse(corpusFilePath);
    }

    public List<String> getSessionFiles() {
        return this.sessionFiles;
    }

    private String urlToPath(String url) {
        if (url == null) {
            return url;
        }
        try {
            int prevSl;
            URL u = new URL(url);
            String prot = u.getProtocol();
            if (prot != null) {
                if (prot.equals("file")) {
                    int prevSl2;
                    String path = u.getPath();
                    int index = path.indexOf("/../");
                    if (index > 0 && (prevSl2 = path.lastIndexOf(47, index - 1)) > -1) {
                        path = path.substring(0, prevSl2) + path.substring(index + 3);
                    }
                    return path;
                }
                return url;
            }
            String path = url;
            int index = path.indexOf("/../");
            if (index > 0 && (prevSl = path.lastIndexOf(47, index - 1)) > -1) {
                path = path.substring(0, prevSl) + path.substring(index + 3);
            }
            return path;
        }
        catch (MalformedURLException mue) {
            return url;
        }
    }

    class CorpusHandler
    implements ContentHandler {
        private final String DESC = "Description";
        private final String LINK = "CorpusLink";
        private final String CORPUS = "Corpus";
        private String curCorLink;
        private boolean inCorpLink = false;
        private String curContent;

        CorpusHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("Corpus".equals(qName)) {
                if (atts.getValue("SearchService") != null) {
                    ImdiSearchServiceParser.this.isSearchService = true;
                }
            } else if (!"Description".equals(qName) && "CorpusLink".equals(qName)) {
                this.inCorpLink = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inCorpLink) {
                this.curContent = new String(ch, start, length);
                this.curCorLink = ImdiSearchServiceParser.this.urlToPath(this.curContent);
                if (this.curCorLink.startsWith("../") || this.curCorLink.startsWith("./")) {
                    this.curCorLink = FileUtility.getAbsolutePath(ImdiSearchServiceParser.this.corpusFilePath, this.curCorLink);
                }
                if (this.curCorLink != null) {
                    ImdiSearchServiceParser.this.sessionFiles.add(this.curCorLink);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("CorpusLink".equals(qName)) {
                this.inCorpLink = false;
            }
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }
    }
}

