/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.result.viewer;

import mpi.eudico.client.annotator.search.result.model.ElanMatch;
import mpi.search.SearchLocale;
import mpi.search.content.result.model.ContentMatch;
import mpi.search.content.result.model.ContentResult;
import mpi.search.content.result.viewer.ContentResult2HTML;

public class ElanResult2HTML {
    private static final int maxVisibleChildren = 5;
    public static final String matchListStyle = "ul { list-style-type:none;}\n";
    private static final String css = "<style type=\"text/css\">ul { list-style-type:none;}\n<style>";

    public static void appendMatch(StringBuffer sb, ContentMatch rootMatch, boolean withChildren, boolean withCSS) {
        ContentResult2HTML.appendMatchValue(sb, rootMatch);
        if (rootMatch instanceof ElanMatch && withChildren) {
            ElanResult2HTML.addChildren(sb, (ElanMatch)rootMatch, withCSS);
        }
    }

    public static void appendResultAsTree(StringBuffer sb, ContentResult result) {
        for (int i = 0; i < result.getRealSize(); ++i) {
            ElanResult2HTML.appendMatch(sb, (ElanMatch)result.getMatch(i + 1), true, true);
            sb.append("<br>\n");
        }
    }

    public static String translate(ContentMatch rootMatch, boolean withChildren) {
        return ElanResult2HTML.translate(rootMatch, withChildren, false);
    }

    public static String translate(ContentMatch rootMatch, boolean withChildren, boolean withCSS) {
        StringBuffer sb = new StringBuffer("<HTML>\n");
        if (withCSS) {
            sb.append("<HEAD><style type=\"text/css\">ul { list-style-type:none;}\n<style></HEAD>\n");
        }
        sb.append("<BODY>\n");
        ElanResult2HTML.appendMatch(sb, rootMatch, withChildren, withCSS);
        sb.append("\n</BODY>\n</HTML>");
        return sb.toString();
    }

    private static void addChildren(StringBuffer sb, ElanMatch parentMatch, boolean withCSS) {
        if (parentMatch.getChildCount() > 0) {
            sb.append("<ul>");
            String lastConstraintId = null;
            for (int i = 0; i < parentMatch.getChildCount(); ++i) {
                if (i >= 5) {
                    sb.append("... (" + (parentMatch.getChildCount() - 5) + " " + SearchLocale.getString("Search.More") + ")");
                    break;
                }
                ElanMatch childMatch = (ElanMatch)parentMatch.getChildAt(i);
                if (lastConstraintId != null && !childMatch.getConstraintId().equals(lastConstraintId)) {
                    sb.append("</ul><ul>");
                    lastConstraintId = childMatch.getConstraintId();
                }
                sb.append("<li>");
                ContentResult2HTML.appendMatchValue(sb, childMatch);
                sb.append("  (" + childMatch.getTierName() + ")");
                ElanResult2HTML.addChildren(sb, childMatch, withCSS);
                sb.append("</li>");
            }
            sb.append("</ul>");
        }
    }
}

