/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.query.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.TierSortAndSelectDialog2;
import mpi.eudico.client.annotator.search.model.ElanType;
import mpi.eudico.client.annotator.search.query.viewer.ElanPatternPanel;
import mpi.eudico.client.annotator.search.query.viewer.ElanRelationPanel;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.search.SearchLocale;
import mpi.search.content.model.CorpusType;
import mpi.search.content.query.model.DependentConstraint;
import mpi.search.content.query.model.RestrictedAnchorConstraint;
import mpi.search.content.query.viewer.AbstractConstraintPanel;
import mpi.search.content.query.viewer.AttributeConstraintPanel;
import mpi.search.content.query.viewer.DependentConstraintPanel;

public class ElanDependentConstraintPanel
extends DependentConstraintPanel
implements MouseListener {
    public ElanDependentConstraintPanel(DependentConstraint constraint, DefaultTreeModel treeModel, CorpusType type, Action startAction) {
        super(constraint, treeModel, type, startAction);
    }

    @Override
    protected void makeLayout() {
        this.setFont(Constants.DEFAULTFONT);
        this.patternPanel = new ElanPatternPanel(this.type, this.tierComboBox, this.regExCheckBox, this.constraint, this.startAction, this.getFont());
        this.relationPanel = new ElanRelationPanel(this.type, this.constraint, this.getFont());
        JPanel checkBoxPanel = new JPanel(new GridLayout(2, 1));
        this.regExCheckBox.setFont(this.getFont().deriveFont(0, 9.0f));
        this.caseCheckBox.setFont(this.getFont().deriveFont(0, 9.0f));
        checkBoxPanel.add(this.regExCheckBox);
        checkBoxPanel.add(this.caseCheckBox);
        this.optionPanel.add((Component)checkBoxPanel, "West");
        JPanel inputPanel = new JPanel(new GridLayout(2, 1, 0, 1));
        inputPanel.add(this.patternPanel);
        inputPanel.add(this.relationPanel);
        if (this.type.hasAttributes()) {
            this.attributePanel = new AttributeConstraintPanel(this.type);
            this.optionPanel.add((Component)this.attributePanel, "Center");
            this.attributePanel.setTier(this.getTierName());
        }
        JPanel specificationPanel = new JPanel(new FlowLayout(0, 0, 1));
        specificationPanel.add(inputPanel);
        specificationPanel.add(this.optionPanel);
        this.framedPanel.add((Component)specificationPanel, "");
        this.framedPanel.setBorder(this.blueBorder);
        this.framedPanelLayout.show(this.framedPanel, "");
        this.setLayout(new BorderLayout());
        this.add((Component)this.titleComponent, "North");
        this.add((Component)this.framedPanel, "Center");
        this.tierComboBox.addItemListener(this);
        JPanel buttonPanel = new JPanel(new FlowLayout(0, 5, 1));
        AbstractAction addConstraintAction = new AbstractAction(SearchLocale.getString("Search.Query.Add")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ElanDependentConstraintPanel.this.addConstraint();
            }
        };
        KeyStroke ks = KeyStroke.getKeyStroke(65, 2);
        addConstraintAction.putValue("AcceleratorKey", ks);
        JButton addButton = new JButton(addConstraintAction);
        addButton.setFont(this.getFont().deriveFont(11.0f));
        buttonPanel.add(addButton);
        if (this.constraint.getParent() != null && !(this.constraint.getParent() instanceof RestrictedAnchorConstraint)) {
            AbstractAction deleteConstraintAction = new AbstractAction(SearchLocale.getString("Search.Query.Delete")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ElanDependentConstraintPanel.this.deleteConstraint();
                }
            };
            ks = KeyStroke.getKeyStroke(68, 2);
            deleteConstraintAction.putValue("AcceleratorKey", ks);
            JButton deleteButton = new JButton(deleteConstraintAction);
            deleteButton.setFont(this.getFont().deriveFont(11.0f));
            buttonPanel.add(deleteButton);
        }
        this.add((Component)buttonPanel, "South");
        try {
            Class popupMenu = this.type.getInputMethodClass();
            popupMenu.getConstructor(Component.class, AbstractConstraintPanel.class).newInstance(this.patternPanel.getDefaultInputComponent(), this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addMouseListener(this);
    }

    @Override
    public void grabFocus() {
        this.patternPanel.grabFocus();
    }

    @Override
    protected void updateTierComboBox() {
        if ("Search.Constraint.Temporal".equals(this.getMode())) {
            String[] tierNames = this.type.getTierNames();
            if (this.type instanceof ElanType) {
                String[] tnPlus = new String[tierNames.length + 1];
                System.arraycopy(tierNames, 0, tnPlus, 1, tierNames.length);
                tnPlus[0] = "Search.Constraint.CustomTiers";
                ElanDependentConstraintPanel.updateComboBox(this.tierComboBox, tnPlus);
            } else {
                ElanDependentConstraintPanel.updateComboBox(this.tierComboBox, tierNames);
            }
        } else {
            ElanDependentConstraintPanel.updateComboBox(this.tierComboBox, this.type.getRelatedTiers(this.getTierNamesOfParent()[0]));
            this.updateUnitComboBox();
        }
    }

    @Override
    protected void selectCustomTierSet() {
        String[] tierNames;
        if (!(this.type instanceof ElanType)) {
            return;
        }
        Transcription trans = ((ElanType)this.type).getTranscription();
        Window w = SwingUtilities.getWindowAncestor(this);
        ArrayList<String> allTiers = new ArrayList<String>();
        for (String s : tierNames = this.type.getTierNames()) {
            allTiers.add(s);
        }
        ArrayList<String> sTiers = new ArrayList<String>();
        if (this.selectedTiers != null && this.selectedTiers.size() > 0) {
            sTiers.addAll(this.selectedTiers);
        } else {
            String[] curTiers = this.getTierNames();
            if (curTiers.length == 1 && curTiers[0] == "Search.Constraint.AllTiers") {
                Object oldSelTiers = Preferences.get("Search.Dependent.SelectedTiers", trans);
                if (oldSelTiers instanceof List) {
                    List oldList = (List)oldSelTiers;
                    for (int i = 0; i < oldList.size(); ++i) {
                        sTiers.add((String)oldList.get(i));
                    }
                } else {
                    sTiers.addAll(allTiers);
                }
            } else {
                for (String s : curTiers) {
                    sTiers.add(s);
                }
            }
        }
        TierSortAndSelectDialog2 dialog = null;
        if (w instanceof Dialog) {
            dialog = new TierSortAndSelectDialog2((Dialog)w, ((ElanType)this.type).getTranscription(), allTiers, sTiers);
        } else if (w instanceof Frame) {
            dialog = new TierSortAndSelectDialog2((Frame)w, ((ElanType)this.type).getTranscription(), allTiers, sTiers);
        }
        if (dialog == null) {
            return;
        }
        Object modeObj = Preferences.get("Search.Dependent.TierSelectionMode", trans);
        Object itemObj = Preferences.get("Search.Dependent.HiddenItems", trans);
        if (modeObj instanceof String) {
            String mode = (String)modeObj;
            dialog.setSelectionMode(mode, (List)itemObj);
        }
        dialog.setTitle(ElanLocale.getString("TranscriptionManager.SelectTierDlg.Title"));
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        List<String> selTiers = dialog.getSelectedTiers();
        if (selTiers != null) {
            if (this.selectedTiers == null) {
                this.selectedTiers = new ArrayList<String>(selTiers);
            } else {
                this.selectedTiers.clear();
                this.selectedTiers.addAll(selTiers);
            }
            String mode = dialog.getSelectionMode();
            List<String> items = dialog.getUnselectedItems();
            Preferences.set("Search.Dependent.SelectedTiers", selTiers, trans);
            Preferences.set("Search.Dependent.TierSelectionMode", mode, trans);
            Preferences.set("Search.Dependent.HiddenItems", items, trans);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

