/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.model;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import mpi.eudico.client.annotator.search.model.EAFType;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.ControlledVocabulary;
import mpi.search.SearchLocale;

public class ElanType
extends EAFType {
    private Hashtable langHash = new Hashtable();
    private final Transcription transcription;

    public ElanType(Transcription transcription) {
        this.transcription = transcription;
        Vector tierVector = transcription.getTiers();
        this.tierNames = new String[tierVector.size()];
        for (int i = 0; i < tierVector.size(); ++i) {
            TierImpl tier = (TierImpl)tierVector.elementAt(i);
            this.tierNames[i] = tier.getName();
            Locale loc = tier.getDefaultLocale();
            if (loc == null) continue;
            this.langHash.put(this.tierNames[i], loc);
        }
    }

    @Override
    public List getClosedVoc(String tierName) {
        TierImpl tier = (TierImpl)this.transcription.getTierWithId(tierName);
        String cvName = tier.getLinguisticType().getControlledVocabylaryName();
        ControlledVocabulary cv = ((TranscriptionImpl)this.transcription).getControlledVocabulary(cvName);
        return cv != null ? Arrays.asList(cv.getEntries()) : null;
    }

    @Override
    public boolean isClosedVoc(String tierName) {
        TierImpl tier = (TierImpl)this.transcription.getTierWithId(tierName);
        if (tier == null) {
            return false;
        }
        String cvName = tier.getLinguisticType().getControlledVocabylaryName();
        return ((TranscriptionImpl)this.transcription).getControlledVocabulary(cvName) != null;
    }

    @Override
    public Locale getDefaultLocale(String tierName) {
        return (Locale)this.langHash.get(tierName);
    }

    @Override
    public String[] getPossibleUnitsFor(String tierName1, String tierName2) {
        Vector<String> commonAncestors = new Vector<String>();
        String[] possibleUnits = new String[]{};
        TierImpl tier1 = (TierImpl)this.transcription.getTierWithId(tierName1);
        TierImpl tier2 = (TierImpl)this.transcription.getTierWithId(tierName2);
        TierImpl loopTier = tier1;
        do {
            if (!loopTier.equals(tier2) && !tier2.hasAncestor(loopTier)) continue;
            commonAncestors.add(loopTier.getName() + " " + SearchLocale.getString("Search.Annotation_PL"));
        } while ((loopTier = (TierImpl)loopTier.getParentTier()) != null);
        possibleUnits = commonAncestors.toArray(new String[0]);
        this.standardUnit = possibleUnits.length > 0 ? (String)commonAncestors.get(0) : null;
        return possibleUnits;
    }

    @Override
    public String[] getRelatedTiers(String tierName) {
        String[] relatedTiers = new String[]{};
        try {
            TierImpl tier = (TierImpl)this.transcription.getTierWithId(tierName);
            TierImpl rootTier = tier.getRootTier();
            Vector dependentTiers = rootTier.getDependentTiers();
            relatedTiers = new String[dependentTiers.size() + 1];
            relatedTiers[0] = rootTier.getName();
            for (int i = 0; i < dependentTiers.size(); ++i) {
                relatedTiers[i + 1] = ((TierImpl)dependentTiers.get(i)).getName();
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return relatedTiers;
    }

    public Transcription getTranscription() {
        return this.transcription;
    }
}

