/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import mpi.eudico.client.annotator.recognizer.data.RSelection;
import mpi.eudico.client.annotator.recognizer.data.Segment;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlTierIO
implements ContentHandler {
    private final String TIERS = "TIERS";
    private final String TIER = "TIER";
    private final String SPAN = "span";
    private final String START = "start";
    private final String END = "end";
    private final String VAL = "v";
    private long bt = 0L;
    private long et = 0L;
    private String curContent = "";
    private List<String> vals;
    private HashMap<Integer, Segmentation> segmentations = null;
    private File xmlFile;
    private boolean newXSDVersion = false;

    public XmlTierIO(File xmlFile) {
        this.xmlFile = xmlFile;
    }

    public List<Segmentation> parse() throws Exception {
        if (this.xmlFile == null || !this.xmlFile.exists() || !this.xmlFile.canRead() || this.xmlFile.isDirectory()) {
            return null;
        }
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            reader.setContentHandler(this);
            reader.parse(this.xmlFile.getAbsolutePath());
            if (this.segmentations != null && this.segmentations.size() > 0) {
                return new ArrayList<Segmentation>(this.segmentations.values());
            }
            throw new Exception("No tiers found in the TIER file");
        }
        catch (IOException ioe) {
            throw new Exception("Parsing failed: " + ioe.getMessage());
        }
        catch (SAXException sax) {
            throw new Exception("Parsing failed: " + sax.getMessage());
        }
    }

    private long parseTime(String token) {
        if (token != null) {
            try {
                if (token.indexOf(46) > -1) {
                    float val = Float.parseFloat(token);
                    return (long)(1000.0f * val);
                }
                return Long.parseLong(token);
            }
            catch (NumberFormatException nfe) {
                return -1L;
            }
        }
        return -1L;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.curContent = this.curContent + new String(ch, start, length);
    }

    @Override
    public void startDocument() throws SAXException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
        if (name.equals("TIERS")) {
            this.newXSDVersion = true;
            this.segmentations = new HashMap();
        }
        if (name.equals("TIER")) {
            String cols = attributes.getValue("columns");
            if (cols == null || cols.length() <= 0) throw new SAXException("No tiernames found, cannot create tiers.");
            StringTokenizer tokenizer = new StringTokenizer(cols);
            int numTiers = tokenizer.countTokens();
            this.vals = new ArrayList<String>(numTiers);
            int i = 0;
            if (!this.newXSDVersion) {
                this.segmentations = new HashMap(numTiers);
            } else {
                i = this.segmentations.size();
            }
            while (tokenizer.hasMoreTokens()) {
                String tok = tokenizer.nextToken();
                if (tok.charAt(0) == '#') {
                    tok = tok.substring(1);
                }
                Segmentation segm = new Segmentation(tok, new ArrayList<RSelection>(), "");
                segm.getMediaDescriptors().clear();
                this.segmentations.put(i, segm);
                ++i;
            }
            return;
        } else {
            if (!name.equals("span")) return;
            this.bt = this.parseTime(attributes.getValue("start"));
            this.et = this.parseTime(attributes.getValue("end"));
            this.vals.clear();
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
        if (name.equals("v")) {
            this.vals.add(this.curContent.trim());
            this.curContent = "";
        } else if (name.equals("span") && this.bt > -1L && this.et > -1L) {
            for (int i = 0; i < this.vals.size(); ++i) {
                Segment segment = new Segment(this.bt, this.et, this.vals.get(i));
                int segIndex = i;
                if (this.newXSDVersion) {
                    segIndex = this.segmentations.size() - this.vals.size() + i;
                }
                if (segIndex >= this.segmentations.size()) continue;
                this.segmentations.get(segIndex).getSegments().add(segment);
            }
        }
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator arg0) {
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
    }
}

