/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mpi.eudico.client.annotator.recognizer.data.RSelection;
import mpi.eudico.client.annotator.recognizer.data.Segment;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;
import mpi.eudico.client.annotator.recognizer.data.SelectionComparator;
import mpi.eudico.client.util.MutableInt;
import mpi.eudico.util.TimeFormatter;

public class RecTierWriter {
    public void write(File outputFile, List<RSelection> segments) throws IOException {
        String outName;
        if (outputFile == null) {
            new IOException("Cannot write to file: file is null");
        }
        boolean xmlOut = !(outName = outputFile.getName().toLowerCase()).endsWith("csv") && !outName.endsWith("txt");
        String SC = ";";
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8")));
        if (xmlOut) {
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.print("<TIER xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
            writer.print("xsi:noNamespaceSchemaLocation=\"file:avatech-tier.xsd\" ");
            writer.println("columns=\"tier_1\">");
        } else {
            writer.println("\"#starttime\";\"#endtime\";\"tier_1\"");
        }
        if (segments != null && segments.size() > 0) {
            for (int i = 0; i < segments.size(); ++i) {
                RSelection iter = segments.get(i);
                if (xmlOut) {
                    writer.print("\t<span start=\"" + TimeFormatter.toSSMSString(iter.beginTime) + "\" ");
                    writer.print("end=\"" + TimeFormatter.toSSMSString(iter.endTime) + "\">");
                    if (iter instanceof Segment && ((Segment)iter).label != null) {
                        writer.print("<v>" + ((Segment)iter).label + "</v>");
                    } else {
                        writer.print("<v></v>");
                    }
                    writer.println("</span>");
                    continue;
                }
                writer.print(TimeFormatter.toSSMSString(iter.beginTime) + ";");
                writer.print(TimeFormatter.toSSMSString(iter.endTime) + ";");
                if (iter instanceof Segment && ((Segment)iter).label != null) {
                    writer.print("\"" + ((Segment)iter).label + "\"");
                    continue;
                }
                writer.println();
            }
        }
        if (xmlOut) {
            writer.println("</TIER>");
        }
        writer.close();
    }

    public void write(File outputFile, List<Object> segments, boolean includeSelections) throws IOException {
        int i;
        String outName;
        if (outputFile == null) {
            new IOException("Cannot write to file: file is null");
        }
        boolean xmlOut = !(outName = outputFile.getName().toLowerCase()).endsWith("csv") && !outName.endsWith("txt");
        String SC = ";";
        int numTiers = 0;
        int numColumns = 1;
        ArrayList<Segmentation> tiers = null;
        HashMap<RSelection, MutableInt> selMap = null;
        if (segments != null && segments.size() > 0) {
            tiers = new ArrayList<Segmentation>(6);
            for (Object obj : segments) {
                if (!(obj instanceof Segmentation)) continue;
                tiers.add((Segmentation)obj);
            }
            numTiers = tiers.size();
            if (numTiers > 1) {
                selMap = new HashMap<RSelection, MutableInt>();
                Segmentation seg = (Segmentation)tiers.get(0);
                for (RSelection sel : seg.getSegments()) {
                    selMap.put(sel, new MutableInt(1));
                }
                for (i = 1; i < tiers.size(); ++i) {
                    seg = (Segmentation)tiers.get(i);
                    for (RSelection sel : seg.getSegments()) {
                        Iterator keyIt = selMap.keySet().iterator();
                        boolean found = false;
                        while (keyIt.hasNext()) {
                            RSelection key = (RSelection)keyIt.next();
                            if (key.beginTime != sel.beginTime || key.endTime != sel.endTime) continue;
                            found = true;
                            ++((MutableInt)selMap.get((Object)key)).intValue;
                            break;
                        }
                        if (found) continue;
                        selMap.put(sel, new MutableInt(1));
                    }
                }
                int numKeys = selMap.size();
                int numOccur = 0;
                Iterator iter = selMap.values().iterator();
                while (iter.hasNext()) {
                    numOccur += ((MutableInt)iter.next()).intValue;
                }
                if (numKeys > 0 && (double)((float)numOccur / (float)numKeys) >= 1.5) {
                    numColumns = numTiers;
                }
            }
        }
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8")));
        if (xmlOut) {
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.print("<TIER xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
            writer.print("xsi:noNamespaceSchemaLocation=\"file:avatech-tier.xsd\" ");
            writer.print("columns=\"");
        } else {
            writer.print("\"#starttime\";\"#endtime\";");
        }
        if (numColumns > 1) {
            for (int i2 = 0; i2 < numColumns; ++i2) {
                if (xmlOut) {
                    writer.print(((Segmentation)tiers.get(i2)).getName().replaceAll(" ", "_"));
                } else {
                    writer.print("\"" + ((Segmentation)tiers.get(i2)).getName() + "\"");
                }
                if (i2 == numColumns - 1) continue;
                if (xmlOut) {
                    writer.print(" ");
                    continue;
                }
                writer.print(";");
            }
            if (xmlOut) {
                writer.println("\">");
            } else {
                writer.println();
            }
        } else if (xmlOut) {
            if (tiers.size() > 0) {
                writer.println("all_tiers\">");
            } else {
                writer.println("tier_1\">");
            }
        } else if (tiers.size() > 0) {
            writer.println("\"all_tiers\"");
        } else {
            writer.println("\"tier_1\"");
        }
        if (numColumns == 1) {
            ArrayList<RSelection> segs = new ArrayList<RSelection>();
            for (Segmentation s : tiers) {
                segs.addAll(s.getSegments());
            }
            if (includeSelections) {
                for (Object obj : segments) {
                    if (!(obj instanceof RSelection)) continue;
                    segs.add((RSelection)obj);
                }
            }
            Collections.sort(segs, new SelectionComparator());
            for (i = 0; i < segs.size(); ++i) {
                RSelection iter = (RSelection)segs.get(i);
                if (xmlOut) {
                    writer.print("\t<span start=\"" + TimeFormatter.toSSMSString(iter.beginTime) + "\" ");
                    writer.print("end=\"" + TimeFormatter.toSSMSString(iter.endTime) + "\">");
                    if (iter instanceof Segment && ((Segment)iter).label != null) {
                        writer.print("<v>" + ((Segment)iter).label + "</v>");
                    } else {
                        writer.print("<v></v>");
                    }
                    writer.println("</span>");
                    continue;
                }
                writer.print(TimeFormatter.toSSMSString(iter.beginTime) + ";");
                writer.print(TimeFormatter.toSSMSString(iter.endTime) + ";");
                if (iter instanceof Segment && ((Segment)iter).label != null) {
                    writer.println("\"" + ((Segment)iter).label + "\"");
                    continue;
                }
                writer.println();
            }
        } else if (numColumns > 1) {
            ArrayList<Object> segs = new ArrayList<Object>(selMap.size());
            segs.addAll(selMap.keySet());
            if (includeSelections) {
                for (Object obj : segments) {
                    if (!(obj instanceof RSelection)) continue;
                    segs.add((RSelection)obj);
                }
            }
            Collections.sort(segs, new SelectionComparator());
            int[] counters = new int[numTiers];
            Arrays.fill(counters, 0);
            for (int i3 = 0; i3 < segs.size(); ++i3) {
                RSelection iter = (RSelection)segs.get(i3);
                if (xmlOut) {
                    writer.print("\t<span start=\"" + TimeFormatter.toSSMSString(iter.beginTime) + "\" ");
                    writer.print("end=\"" + TimeFormatter.toSSMSString(iter.endTime) + "\">");
                } else {
                    writer.print(TimeFormatter.toSSMSString(iter.beginTime) + ";");
                    writer.print(TimeFormatter.toSSMSString(iter.endTime) + ";");
                }
                for (int j = 0; j < numTiers; ++j) {
                    Segmentation curTier = (Segmentation)tiers.get(j);
                    ArrayList<RSelection> curSelList = curTier.getSegments();
                    if (counters[j] < curSelList.size()) {
                        RSelection curSel = (RSelection)curSelList.get(counters[j]);
                        if (curSel.beginTime == iter.beginTime && curSel.endTime == iter.endTime) {
                            if (curSel instanceof Segment && ((Segment)curSel).label != null) {
                                if (xmlOut) {
                                    writer.print("<v>" + ((Segment)curSel).label + "</v>");
                                } else {
                                    writer.print("\"" + ((Segment)curSel).label + "\"");
                                }
                            } else if (xmlOut) {
                                writer.print("<v></v>");
                            }
                            int n = j;
                            counters[n] = counters[n] + 1;
                        } else if (xmlOut) {
                            writer.print("<v></v>");
                        }
                    } else if (xmlOut) {
                        writer.print("<v></v>");
                    }
                    if (xmlOut || j >= numTiers - 1) continue;
                    writer.print(";");
                }
                if (xmlOut) {
                    writer.println("</span>");
                    continue;
                }
                writer.println();
            }
        }
        if (xmlOut) {
            writer.println("</TIER>");
        }
        writer.close();
    }
}

