/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.impl;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.recognizer.api.ParamPreferences;
import mpi.eudico.client.annotator.recognizer.api.RecognizerConfigurationException;
import mpi.eudico.client.annotator.recognizer.data.RSelection;
import mpi.eudico.client.annotator.recognizer.gui.TierSelectionPanel;

public class DemoRecognizerPanel
extends JPanel
implements ChangeListener,
ParamPreferences {
    private JLabel stepDurationLabel;
    private JSlider stepSlider;
    private JComboBox mediaFilesComboBox;
    private JPanel settingsPanel;
    private TierSelectionPanel selectionPanel;
    private ArrayList<String> mediaFilesList;

    public DemoRecognizerPanel(TierSelectionPanel selectionPanel) {
        this.selectionPanel = selectionPanel;
        selectionPanel.enableFileSelection(false);
        this.initComponents();
    }

    private void initComponents() {
        this.mediaFilesComboBox = new JComboBox();
        JPanel filePanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(1, 1, 1, 1);
        filePanel.add((Component)new JLabel("Files List :"), gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        filePanel.add((Component)this.mediaFilesComboBox, gbc);
        JPanel selPanel = new JPanel(new GridBagLayout());
        selPanel.setBorder(new TitledBorder("Selection Panel"));
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.weightx = 1.0;
        selPanel.add((Component)this.selectionPanel, gbc);
        this.initializeSettingsPanel();
        this.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(4, 2, 4, 2);
        this.add((Component)filePanel, gbc);
        gbc.gridy = 1;
        this.add((Component)selPanel, gbc);
        gbc.gridy = 2;
        this.add((Component)this.settingsPanel, gbc);
        gbc.gridy = 3;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)new JPanel(), gbc);
    }

    private void initializeSettingsPanel() {
        int initialStepDuration = 5;
        this.settingsPanel = new JPanel();
        this.settingsPanel.setBorder(new TitledBorder("Settings"));
        this.settingsPanel.setLayout(new BoxLayout(this.settingsPanel, 1));
        this.settingsPanel.add(Box.createVerticalStrut(10));
        this.stepDurationLabel = new JLabel("Step Duration: " + initialStepDuration + " seconds");
        this.settingsPanel.add(this.stepDurationLabel);
        this.stepSlider = new JSlider(0, 1, 10, initialStepDuration);
        this.stepSlider.setMajorTickSpacing(1);
        this.stepSlider.setPaintTicks(true);
        this.stepSlider.setPaintLabels(true);
        this.stepSlider.addChangeListener(this);
        this.settingsPanel.add(this.stepSlider);
    }

    public void updateMediaFiles(List<String> mediaFiles) {
        if (this.mediaFilesComboBox == null) {
            this.mediaFilesComboBox = new JComboBox();
        }
        if (this.mediaFilesList == null) {
            this.mediaFilesList = new ArrayList();
        }
        this.mediaFilesComboBox.removeAllItems();
        this.mediaFilesList.clear();
        if (mediaFiles != null && mediaFiles.size() > 0) {
            ArrayList<String> fileNameList = new ArrayList<String>();
            for (String media : mediaFiles) {
                String fileName = this.fileNameFromPath(media);
                if (fileNameList.contains(fileName)) {
                    this.mediaFilesComboBox.addItem(media);
                } else {
                    this.mediaFilesComboBox.addItem(fileName);
                    fileNameList.add(fileName);
                }
                this.mediaFilesList.add(media);
            }
            this.mediaFilesComboBox.setSelectedIndex(0);
        }
    }

    private String fileNameFromPath(String path) {
        if (path == null) {
            return "Unknown";
        }
        int index = path.lastIndexOf(47);
        if (index > -1 && index < path.length() - 1) {
            return path.substring(index + 1);
        }
        return path;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.stepSlider) {
            this.stepDurationLabel.setText("Step Duration: " + this.stepSlider.getValue() + " seconds");
        }
    }

    public int getStepDuration() {
        return this.stepSlider.getValue();
    }

    public void setStepDuration(int stepDur) {
        if (stepDur >= this.stepSlider.getMinimum() && stepDur <= this.stepSlider.getMaximum()) {
            this.stepSlider.setValue(stepDur);
        }
    }

    @Override
    public Map<String, Object> getParamPreferences() {
        HashMap<String, Object> prefs = new HashMap<String, Object>(1);
        prefs.put("StepDuration", this.stepSlider.getValue());
        prefs.put("SelectionPanelPref", this.selectionPanel.getStorableParamPreferencesMap(this.selectionPanel.getParamValue()));
        return prefs;
    }

    @Override
    public void setParamPreferences(Map<String, Object> storedPrefs) {
        if (storedPrefs != null) {
            int step;
            Object val = storedPrefs.get("StepDuration");
            if (val instanceof Integer && (step = ((Integer)val).intValue()) >= this.stepSlider.getMinimum() && step <= this.stepSlider.getMaximum()) {
                this.stepSlider.setValue(step);
            }
            if ((val = storedPrefs.get("SelectionPanelPref")) instanceof HashMap) {
                this.selectionPanel.setParamValue((HashMap)val);
            }
        }
    }

    public String getSelectedMediaFile() {
        return this.mediaFilesList.get(this.mediaFilesComboBox.getSelectedIndex());
    }

    public void validateParameters() throws RecognizerConfigurationException {
    }

    public ArrayList<RSelection> getSelections() {
        Object value = this.selectionPanel.getSelectionedValue();
        if (value instanceof ArrayList) {
            return (ArrayList)value;
        }
        return null;
    }
}

