/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import javax.swing.JLabel;
import mpi.eudico.client.annotator.recognizer.data.FileParam;
import mpi.eudico.client.annotator.recognizer.gui.FileParamPanel;
import mpi.eudico.client.annotator.recognizer.gui.TierSelectionPanel;

public class TierParamPanel
extends FileParamPanel {
    private TierSelectionPanel selectionPanel;

    public TierParamPanel(FileParam param, TierSelectionPanel panel) {
        super(param);
        if (param != null) {
            this.selectionPanel = panel;
            this.initComponents();
            if (this.isInputType()) {
                this.selectionPanel.setFileDialogType(0);
            } else {
                this.selectionPanel.setFileDialogType(1);
            }
            this.selectionPanel.setFileExtensions(this.getFileTypeExtension());
        }
    }

    @Override
    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        this.descLabel = new JLabel(this.description);
        StringBuilder builder = new StringBuilder("<html><table><tr>");
        if (!this.isOptional()) {
            builder.append("<td style=\"color:red\">");
        } else {
            builder.append("<td style=\"color:green\">");
        }
        if (this.getContentType() == 3) {
            builder.append("<small>[csv tier]</small>: </td><td>");
        } else if (this.getContentType() == 2) {
            builder.append("<small>[xml tier]</small>: </td><td>");
        } else if (this.getContentType() == 7) {
            builder.append("<small>[xml tiers]</small>: </td><td>");
        }
        builder.append(this.description);
        if (this.showParamNames) {
            builder.append(" <i>[" + this.paramName + "]</i>");
        }
        builder.append("</td><tr></table></html>");
        this.descLabel.setText(builder.toString());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(1, 1, 0, 1);
        this.add((Component)this.descLabel, gbc);
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        this.add((Component)this.selectionPanel, gbc);
    }

    @Override
    public void updateMediaFiles(List<String> mediaFilePaths) {
        super.updateMediaFiles(mediaFilePaths);
        if (this.selectionPanel.getMode() == 1) {
            this.selectionPanel.updateMediaFiles(mediaFilePaths);
        }
    }

    @Override
    protected Object getParamValue() {
        return this.selectionPanel.getParamValue();
    }

    public HashMap getStorableMap(HashMap map) {
        return this.selectionPanel.getStorableParamPreferencesMap(map);
    }

    @Override
    public boolean isValueFilled() {
        Object value = this.getParamValue();
        if (value instanceof HashMap) {
            HashMap map = (HashMap)value;
            if (map.containsKey("Selections")) {
                value = map.get("Selections");
            } else if (map.containsKey("Tier")) {
                value = map.get("Tier");
            } else if (map.containsKey("FileName")) {
                value = map.get("FileName");
            }
            if (value instanceof String) {
                return super.isValueFilled();
            }
            if (value instanceof List && ((List)value).size() > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void setParamValue(Object value) {
        if (value instanceof String) {
            this.selectionPanel.setParamValue((String)value);
        } else if (value instanceof HashMap) {
            this.selectionPanel.setParamValue((HashMap)value);
        }
    }
}

