/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import mpi.eudico.client.annotator.recognizer.data.TextParam;
import mpi.eudico.client.annotator.recognizer.gui.AbstractParamPanel;

public class TextParamPanel
extends AbstractParamPanel {
    private JTextField tf;
    private JComboBox cb;
    private String initial;
    private List<String> convoc;

    public TextParamPanel(String paramName, String description, String initial, List<String> convoc) {
        super(paramName, description);
        this.initial = initial;
        this.convoc = convoc;
        this.initComponents();
    }

    public TextParamPanel(TextParam param) {
        super(param);
        if (param != null) {
            this.initial = param.curValue != null ? param.curValue : param.defValue;
            if (param.conVoc != null) {
                this.convoc = param.conVoc;
            }
            this.initComponents();
        }
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        StringBuilder builder = new StringBuilder("<html><p>");
        builder.append(this.description);
        if (this.showParamNames) {
            builder.append(" <i>[" + this.paramName + "]</i>");
        }
        builder.append("</p></html>");
        this.descLabel.setText(builder.toString());
        if (this.convoc != null && this.convoc.size() > 0) {
            this.cb = new JComboBox<Object>(this.convoc.toArray());
            if (this.initial != null) {
                this.cb.setSelectedItem(this.initial);
            }
        } else {
            this.tf = new JTextField();
            if (this.initial != null) {
                this.tf.setText(this.initial);
            }
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 3;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(1, 1, 0, 1);
        if (this.tf != null) {
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.add((Component)this.tf, gbc);
        } else if (this.cb != null) {
            gbc.fill = 0;
            gbc.weightx = 0.0;
            this.add((Component)this.cb, gbc);
        }
    }

    @Override
    protected Object getParamValue() {
        if (this.tf != null) {
            return this.tf.getText();
        }
        if (this.cb != null) {
            return this.cb.getSelectedItem();
        }
        return null;
    }

    @Override
    protected void setParamValue(Object value) {
        if (value instanceof String) {
            this.initial = (String)value;
        } else if (value != null) {
            this.initial = value.toString();
        }
        if (this.tf != null) {
            this.tf.setText(this.initial);
        } else if (this.cb != null) {
            this.cb.setSelectedItem(this.initial);
        }
    }
}

