/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.recognizer.api.ParamPreferences;
import mpi.eudico.client.annotator.recognizer.data.FileParam;
import mpi.eudico.client.annotator.recognizer.data.NumParam;
import mpi.eudico.client.annotator.recognizer.data.Param;
import mpi.eudico.client.annotator.recognizer.data.TextParam;
import mpi.eudico.client.annotator.recognizer.gui.AbstractParamPanel;
import mpi.eudico.client.annotator.recognizer.gui.FileParamPanel;
import mpi.eudico.client.annotator.recognizer.gui.NumParamPanel;
import mpi.eudico.client.annotator.recognizer.gui.TextParamPanel;
import mpi.eudico.client.annotator.recognizer.gui.TierParamPanel;
import mpi.eudico.client.annotator.recognizer.gui.TierSelectionPanel;
import mpi.eudico.server.corpora.clom.Tier;

public class ParamPanelContainer
extends JPanel
implements ParamPreferences {
    private String recogizerName;
    private List<AbstractParamPanel> panels;
    private List<FileParamPanel> mediaUpdatePanels;
    private List<TierSelectionPanel> tierUpdatePanels;
    private JPanel inputParamPanel;
    private JPanel outputParamPanel;
    private JPanel settingsParamPanel;
    private JPanel advancedInputPanel;
    private JPanel advancedOutputPanel;
    private JPanel advancedSettingsPanel;
    private ViewerManager2 vm;
    private List<String> tiers;
    private List<String> supportedMediaFiles;
    private boolean startReg = true;
    private JDialog advancedDialog;
    private JButton advancedParamButton;
    private final Color BACKGROUND_COLOR = new Color(250, 250, 250);

    public ParamPanelContainer(String recogizerName) {
        this.recogizerName = recogizerName;
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.panels = new ArrayList<AbstractParamPanel>(10);
    }

    public ParamPanelContainer(String recogizerName, List<Param> params, List<String> supportedMediaFiles, ViewerManager2 vm, int mode) {
        this.recogizerName = recogizerName;
        this.mediaUpdatePanels = new ArrayList<FileParamPanel>();
        this.tierUpdatePanels = new ArrayList<TierSelectionPanel>();
        if (params != null) {
            this.vm = vm;
            this.tiers = new ArrayList<String>();
            Vector list = vm.getTranscription().getTiers();
            if (list != null) {
                for (Object tier : list) {
                    this.tiers.add(((Tier)tier).getName());
                }
            }
            this.supportedMediaFiles = supportedMediaFiles;
            this.loadParameterPanels(params, mode);
            this.setLayout(new GridBagLayout());
            this.setBorder(new EmptyBorder(2, 2, 2, 2));
            this.doLayout(false);
        } else {
            this.panels = new ArrayList<AbstractParamPanel>(10);
        }
    }

    public void doLayout(boolean addScrollPanes) {
        this.removeAll();
        GridBagConstraints gbc = new GridBagConstraints();
        if (addScrollPanes) {
            JScrollPane jsp;
            gbc.gridy = 0;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            if (this.settingsParamPanel != null) {
                this.settingsParamPanel.setBorder(null);
                jsp = new JScrollPane(this.settingsParamPanel);
                jsp.setBorder(new TitledBorder(ElanLocale.getString("Recognizer.ParamPanel.SettingsPanel")));
                jsp.setBackground(this.getBackground());
                jsp.getViewport().setBackground(this.getBackground());
                this.add((Component)jsp, gbc);
            }
            if (this.inputParamPanel != null) {
                ++gbc.gridy;
                this.inputParamPanel.setBorder(null);
                jsp = new JScrollPane(this.inputParamPanel);
                jsp.setBorder(new TitledBorder(ElanLocale.getString("Recognizer.ParamPanel.InputPanel")));
                jsp.setBackground(this.getBackground());
                jsp.getViewport().setBackground(this.getBackground());
                this.add((Component)jsp, gbc);
            }
            if (this.outputParamPanel != null) {
                ++gbc.gridy;
                this.outputParamPanel.setBorder(null);
                jsp = new JScrollPane(this.outputParamPanel);
                jsp.setBorder(new TitledBorder(ElanLocale.getString("Recognizer.ParamPanel.OutputPanel")));
                jsp.setBackground(this.getBackground());
                jsp.getViewport().setBackground(this.getBackground());
                this.add((Component)jsp, gbc);
            }
            if (this.advancedParamButton != null) {
                ++gbc.gridy;
                gbc.fill = 0;
                gbc.weightx = 0.0;
                gbc.weighty = 0.0;
                this.add((Component)this.advancedParamButton, gbc);
            }
        } else {
            gbc.gridy = -1;
            gbc.anchor = 18;
            if (this.advancedParamButton != null) {
                ++gbc.gridy;
                gbc.fill = 0;
                gbc.weightx = 0.0;
                gbc.weighty = 0.0;
                this.add((Component)this.advancedParamButton, gbc);
            }
            gbc.fill = 2;
            gbc.weightx = 1.0;
            if (this.settingsParamPanel != null) {
                ++gbc.gridy;
                this.settingsParamPanel.setBorder(new TitledBorder(ElanLocale.getString("Recognizer.ParamPanel.SettingsPanel")));
                this.add((Component)this.settingsParamPanel, gbc);
            }
            if (this.inputParamPanel != null) {
                ++gbc.gridy;
                this.inputParamPanel.setBorder(new TitledBorder(ElanLocale.getString("Recognizer.ParamPanel.InputPanel")));
                this.add((Component)this.inputParamPanel, gbc);
            }
            if (this.outputParamPanel != null) {
                ++gbc.gridy;
                this.outputParamPanel.setBorder(new TitledBorder(ElanLocale.getString("Recognizer.ParamPanel.OutputPanel")));
                this.add((Component)this.outputParamPanel, gbc);
            }
        }
    }

    public void updateLocale() {
        if (this.settingsParamPanel != null) {
            if (this.settingsParamPanel.getBorder() == null) {
                ((TitledBorder)((JScrollPane)this.settingsParamPanel.getParent()).getBorder()).setTitle(ElanLocale.getString("Recognizer.ParamPanel.SettingsPanel"));
            } else {
                ((TitledBorder)this.settingsParamPanel.getBorder()).setTitle(ElanLocale.getString("Recognizer.ParamPanel.SettingsPanel"));
            }
        }
        if (this.inputParamPanel != null) {
            if (this.inputParamPanel.getBorder() == null) {
                ((TitledBorder)((JScrollPane)this.inputParamPanel.getParent()).getBorder()).setTitle(ElanLocale.getString("Recognizer.ParamPanel.InputPanel"));
            } else {
                ((TitledBorder)this.inputParamPanel.getBorder()).setTitle(ElanLocale.getString("Recognizer.ParamPanel.InputPanel"));
            }
        }
        if (this.outputParamPanel != null) {
            if (this.outputParamPanel.getBorder() == null) {
                ((TitledBorder)((JScrollPane)this.outputParamPanel.getParent()).getBorder()).setTitle(ElanLocale.getString("Recognizer.ParamPanel.OutputPanel"));
            } else {
                ((TitledBorder)this.outputParamPanel.getBorder()).setTitle(ElanLocale.getString("Recognizer.ParamPanel.OutputPanel"));
            }
        }
        if (this.advancedSettingsPanel != null) {
            ((TitledBorder)this.advancedSettingsPanel.getBorder()).setTitle(ElanLocale.getString("Recognizer.ParamPanel.SettingsPanel"));
        }
        if (this.advancedInputPanel != null) {
            ((TitledBorder)this.advancedInputPanel.getBorder()).setTitle(ElanLocale.getString("Recognizer.ParamPanel.InputPanel"));
        }
        if (this.advancedOutputPanel != null) {
            ((TitledBorder)this.advancedOutputPanel.getBorder()).setTitle(ElanLocale.getString("Recognizer.ParamPanel.OutputPanel"));
        }
        if (this.advancedParamButton != null) {
            this.advancedParamButton.setText(ElanLocale.getString("Recognizer.ParamPanel.AdvancedParamPanel"));
        }
    }

    private void loadParameterPanels(List<Param> params, int mode) {
        this.panels = new ArrayList<AbstractParamPanel>(params.size());
        int settingsPanelRowIndex = -1;
        int inputPanelRowIndex = -1;
        int outputPanelRowIndex = -1;
        int advancedSPRowIndex = -1;
        int advancedIPRowIndex = -1;
        int advancedOPRowIndex = -1;
        Comparator<Param> compare = new Comparator<Param>(){

            @Override
            public int compare(Param o1, Param o2) {
                if (!(o1 instanceof FileParam) && !(o2 instanceof FileParam)) {
                    return 0;
                }
                if (o1 instanceof FileParam && o2 instanceof FileParam) {
                    if (!((FileParam)o1).optional && !((FileParam)o2).optional || ((FileParam)o1).optional && ((FileParam)o2).optional) {
                        if (!(((FileParam)o1).contentType != 0 && ((FileParam)o1).contentType != 1 || ((FileParam)o2).contentType != 0 && ((FileParam)o2).contentType != 1)) {
                            return 0;
                        }
                        if (((FileParam)o1).contentType == 0 || ((FileParam)o1).contentType == 1) {
                            return -1;
                        }
                        if (((FileParam)o2).contentType == 0 || ((FileParam)o2).contentType == 1) {
                            return 1;
                        }
                        return 0;
                    }
                    if (!((FileParam)o1).optional) {
                        return -1;
                    }
                    if (!((FileParam)o2).optional) {
                        return 1;
                    }
                }
                if (o1 instanceof FileParam && !((FileParam)o1).optional) {
                    return -1;
                }
                if (o2 instanceof FileParam && !((FileParam)o2).optional) {
                    return 1;
                }
                if (o1 instanceof FileParam && !(o2 instanceof FileParam)) {
                    return -1;
                }
                return 1;
            }
        };
        Collections.sort(params, compare);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(1, 1, 4, 1);
        gbc.weightx = 1.0;
        for (Param p : params) {
            AbstractParamPanel panel;
            if (p instanceof NumParam) {
                if (p.level.equals(Param.BASIC)) {
                    if (this.settingsParamPanel == null) {
                        this.settingsParamPanel = new JPanel(new GridBagLayout());
                    }
                    panel = new NumParamPanel((NumParam)p);
                    gbc.gridy = ++settingsPanelRowIndex;
                    this.settingsParamPanel.add((Component)panel, gbc);
                    this.panels.add(panel);
                    panel.setBackground(this.getBackgroundColorForPanel(settingsPanelRowIndex));
                    continue;
                }
                if (this.advancedSettingsPanel == null) {
                    this.advancedSettingsPanel = new JPanel(new GridBagLayout());
                    this.advancedSettingsPanel.setBorder(new TitledBorder(ElanLocale.getString("Recognizer.ParamPanel.SettingsPanel")));
                }
                panel = new NumParamPanel((NumParam)p);
                gbc.gridy = ++advancedSPRowIndex;
                this.advancedSettingsPanel.add((Component)panel, gbc);
                this.panels.add(panel);
                panel.setBackground(this.getBackgroundColorForPanel(advancedSPRowIndex));
                continue;
            }
            if (p instanceof TextParam) {
                if (p.level.equals(Param.BASIC)) {
                    if (this.settingsParamPanel == null) {
                        this.settingsParamPanel = new JPanel(new GridBagLayout());
                    }
                    panel = new TextParamPanel((TextParam)p);
                    gbc.gridy = ++settingsPanelRowIndex;
                    this.settingsParamPanel.add((Component)panel, gbc);
                    this.panels.add(panel);
                    panel.setBackground(this.getBackgroundColorForPanel(settingsPanelRowIndex));
                    continue;
                }
                if (this.advancedSettingsPanel == null) {
                    this.advancedSettingsPanel = new JPanel(new GridBagLayout());
                    this.advancedSettingsPanel.setBorder(new TitledBorder(ElanLocale.getString("Recognizer.ParamPanel.SettingsPanel")));
                }
                panel = new TextParamPanel((TextParam)p);
                gbc.gridy = ++advancedSPRowIndex;
                this.advancedSettingsPanel.add((Component)panel, gbc);
                this.panels.add(panel);
                panel.setBackground(this.getBackgroundColorForPanel(advancedSPRowIndex));
                continue;
            }
            if (!(p instanceof FileParam)) continue;
            TierSelectionPanel tierPanel = null;
            if (((FileParam)p).contentType == 0 || ((FileParam)p).contentType == 1) {
                panel = new FileParamPanel((FileParam)p, this.supportedMediaFiles);
                this.mediaUpdatePanels.add((FileParamPanel)panel);
                if (!((FileParam)p).optional && this.supportedMediaFiles.size() <= 0) {
                    this.startReg = false;
                }
            } else if (((FileParam)p).ioType == 'i' && (((FileParam)p).contentType == 3 || ((FileParam)p).contentType == 2 || ((FileParam)p).contentType == 7)) {
                ArrayList<String> tierList = new ArrayList<String>();
                for (String name : this.tiers) {
                    tierList.add(name);
                }
                tierPanel = new TierSelectionPanel(mode, this.supportedMediaFiles, this.vm, true);
                panel = new TierParamPanel((FileParam)p, tierPanel);
                this.tierUpdatePanels.add(tierPanel);
                this.mediaUpdatePanels.add((FileParamPanel)panel);
            } else {
                panel = new FileParamPanel((FileParam)p);
            }
            if (!((FileParam)p).optional || p.level.equals(Param.BASIC)) {
                if (((FileParam)p).ioType == 'i') {
                    if (this.inputParamPanel == null) {
                        this.inputParamPanel = new JPanel(new GridBagLayout());
                    }
                    gbc.gridy = ++inputPanelRowIndex;
                    this.inputParamPanel.add((Component)panel, gbc);
                    this.panels.add(panel);
                    panel.setBackground(this.getBackgroundColorForPanel(inputPanelRowIndex));
                    if (tierPanel == null) continue;
                    tierPanel.updateBackgroundColor(this.getBackgroundColorForPanel(inputPanelRowIndex));
                    continue;
                }
                if (this.outputParamPanel == null) {
                    this.outputParamPanel = new JPanel(new GridBagLayout());
                }
                gbc.gridy = ++outputPanelRowIndex;
                this.outputParamPanel.add((Component)panel, gbc);
                this.panels.add(panel);
                panel.setBackground(this.getBackgroundColorForPanel(outputPanelRowIndex));
                continue;
            }
            if (((FileParam)p).ioType == 'i') {
                if (this.advancedInputPanel == null) {
                    this.advancedInputPanel = new JPanel(new GridBagLayout());
                    this.advancedInputPanel.setBorder(new TitledBorder(ElanLocale.getString("Recognizer.ParamPanel.InputPanel")));
                }
                gbc.gridy = ++advancedIPRowIndex;
                this.advancedInputPanel.add((Component)panel, gbc);
                this.panels.add(panel);
                panel.setBackground(this.getBackgroundColorForPanel(advancedIPRowIndex));
                continue;
            }
            if (this.advancedOutputPanel == null) {
                this.advancedOutputPanel = new JPanel(new GridBagLayout());
                this.advancedOutputPanel.setBorder(new TitledBorder(ElanLocale.getString("Recognizer.ParamPanel.OutputPanel")));
            }
            gbc.gridy = ++advancedOPRowIndex;
            this.advancedOutputPanel.add((Component)panel, gbc);
            this.panels.add(panel);
            panel.setBackground(this.getBackgroundColorForPanel(advancedOPRowIndex));
        }
        if (this.settingsParamPanel != null && this.advancedSettingsPanel != null || this.inputParamPanel != null && this.advancedInputPanel != null || this.outputParamPanel != null && this.advancedOutputPanel != null) {
            this.advancedParamButton = new JButton(ElanLocale.getString("Recognizer.ParamPanel.AdvancedParamPanel"));
            this.advancedParamButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParamPanelContainer.this.showAdvanceParametersDialog();
                }
            });
        } else {
            this.advancedParamButton = null;
        }
    }

    private Color getBackgroundColorForPanel(int index) {
        if (index % 2 != 0) {
            return this.BACKGROUND_COLOR;
        }
        return this.getBackground();
    }

    public void updateMediaFiles(List<String> mediaFilePaths) {
        this.supportedMediaFiles = mediaFilePaths;
        this.startReg = true;
        for (FileParamPanel panel : this.mediaUpdatePanels) {
            panel.updateMediaFiles(mediaFilePaths);
            if (panel.isOptional() || this.supportedMediaFiles.size() > 0 || panel.getContentType() != 0 && panel.getContentType() != 1) continue;
            this.startReg = false;
        }
    }

    public void updateTiers(int event) {
        for (TierSelectionPanel panel : this.tierUpdatePanels) {
            panel.updateTierNames(event);
        }
    }

    public boolean checkStartReg() {
        return this.startReg;
    }

    public String getRecognizerName() {
        return this.recogizerName;
    }

    @Override
    public Map<String, Object> getParamPreferences() {
        HashMap<String, Object> storedPrefs = new HashMap<String, Object>(this.panels.size());
        for (AbstractParamPanel p : this.panels) {
            Object value = p.getParamValue();
            if (value instanceof Map) {
                if (!(p instanceof TierParamPanel)) continue;
                storedPrefs.put(p.getParamName(), ((TierParamPanel)p).getStorableMap((HashMap)value));
                continue;
            }
            storedPrefs.put(p.getParamName(), value);
        }
        return storedPrefs;
    }

    private JPanel getAdvacnedParameterPanel() {
        JPanel advancedPanel = new JPanel();
        advancedPanel.setLayout(new GridBagLayout());
        advancedPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        if (this.advancedSettingsPanel != null) {
            advancedPanel.add((Component)this.advancedSettingsPanel, gbc);
        }
        if (this.advancedInputPanel != null) {
            ++gbc.gridy;
            advancedPanel.add((Component)this.advancedInputPanel, gbc);
        }
        if (this.advancedOutputPanel != null) {
            ++gbc.gridy;
            advancedPanel.add((Component)this.advancedOutputPanel, gbc);
        }
        return advancedPanel;
    }

    private void showAdvanceParametersDialog() {
        if (this.advancedDialog == null) {
            this.advancedDialog = new JDialog((Frame)ELANCommandFactory.getRootFrame(this.vm.getTranscription()), false);
            this.advancedDialog.setTitle(ElanLocale.getString("Recognizer.RecognizerPanel.Parameters"));
            this.advancedDialog.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.advancedDialog.getContentPane().add((Component)new JScrollPane(this.getAdvacnedParameterPanel()), gbc);
            gbc.gridy = 1;
            gbc.fill = 2;
            gbc.weighty = 0.0;
            JButton closeButton = new JButton(ElanLocale.getString("Button.Close"));
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParamPanelContainer.this.advancedDialog.setVisible(false);
                    ParamPanelContainer.this.advancedDialog.dispose();
                }
            });
            this.advancedDialog.getContentPane().add((Component)closeButton, gbc);
            this.advancedDialog.setDefaultCloseOperation(0);
        }
        this.advancedDialog.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle curRect = this.advancedDialog.getBounds();
        this.advancedDialog.setBounds(screen.width / 2, 10, Math.min(screen.width / 2 - 20, curRect.width + 30), Math.min(screen.height - 30, curRect.height));
        this.advancedDialog.setVisible(true);
    }

    @Override
    public void setParamPreferences(Map<String, Object> storedPrefs) {
        block0: for (String key : storedPrefs.keySet()) {
            for (AbstractParamPanel p : this.panels) {
                if (p.getParamName() == null || !p.getParamName().equals(key)) continue;
                p.setParamValue(storedPrefs.get(key));
                continue block0;
            }
        }
    }

    public int getNumPanels() {
        return this.panels.size();
    }

    public AbstractParamPanel getParamPanel(int index) {
        if (index >= 0 && index < this.panels.size()) {
            return this.panels.get(index);
        }
        return null;
    }
}

