/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.linkedmedia.MediaDescriptorUtil;
import mpi.eudico.client.annotator.recognizer.data.FileParam;
import mpi.eudico.client.annotator.recognizer.gui.AbstractParamPanel;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.annotator.util.FileUtility;

public class FileParamPanel
extends AbstractParamPanel
implements ActionListener {
    private boolean inputType;
    private int contentType;
    private boolean optional;
    private String initialPath;
    private List<String> mediaFiles;
    private List<String> mimeTypes;
    protected Insets insets = new Insets(1, 1, 0, 1);
    private boolean acceptAllFiles = false;
    protected JTextField fileField;
    protected JButton browseButton;
    private JComboBox mediaCB;

    public FileParamPanel(String paramName, String description, boolean inputType, int contentType, boolean optional) {
        this(paramName, description, inputType, contentType, optional, null);
    }

    public FileParamPanel(String paramName, String description, boolean inputType, int contentType, boolean optional, List<String> mediaFiles) {
        super(paramName, description);
        this.inputType = inputType;
        this.contentType = contentType;
        this.optional = optional;
        this.mediaFiles = mediaFiles;
        if (!inputType || contentType != 2 && contentType != 7 && contentType != 3) {
            this.initComponents();
        }
    }

    public FileParamPanel(FileParam param) {
        this(param, null);
    }

    public FileParamPanel(FileParam param, List<String> mediaFiles) {
        super(param);
        if (param != null) {
            this.mediaFiles = mediaFiles;
            this.mimeTypes = param.mimeTypes;
            this.inputType = param.ioType == 'i';
            this.optional = param.optional;
            this.contentType = param.contentType;
            if (!this.inputType || this.contentType != 2 && this.contentType != 7 && this.contentType != 3) {
                this.initComponents();
            }
        }
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        ImageIcon icon = null;
        try {
            icon = this.inputType ? new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Open16.gif")) : new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Save16.gif"));
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.inputType && (this.contentType == 0 || this.contentType == 1)) {
            this.mediaCB = new JComboBox();
            this.updateMediaFiles(this.mediaFiles);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridwidth = 3;
            gbc.gridy = 1;
            gbc.anchor = 17;
            gbc.fill = 0;
            gbc.insets = this.insets;
            this.add((Component)this.mediaCB, gbc);
        } else {
            this.fileField = new JTextField();
            this.fileField.setEditable(true);
            this.browseButton = new JButton();
            if (icon != null) {
                this.browseButton.setIcon(icon);
            } else {
                this.browseButton.setText("...");
            }
            this.browseButton.addActionListener(this);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridwidth = 2;
            gbc.gridy = 1;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.insets = this.insets;
            this.add((Component)this.fileField, gbc);
            gbc.gridx = 2;
            gbc.gridwidth = 1;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            this.add((Component)this.browseButton, gbc);
        }
        StringBuilder builder = new StringBuilder("<html><table><tr>");
        if (!this.optional) {
            builder.append("<td style=\"color:red\"> ");
        } else {
            builder.append("<td style=\"color:green\"> ");
        }
        if (this.contentType == 5) {
            builder.append("<small>[csv ts]</small>: </td><td>");
        } else if (this.contentType == 3) {
            builder.append("<small>[csv tier]</small>: </td><td>");
        } else if (this.contentType == 4) {
            builder.append("<small>[xml ts]</small>: </td><td>");
        } else if (this.contentType == 2) {
            builder.append("<small>[xml tier]</small>: </td><td>");
        } else if (this.contentType == 7) {
            builder.append("<small>[xml tiers]</small>: </td><td>");
        } else if (this.contentType == 0) {
            builder.append("<small>[audio]</small>: </td><td>");
        } else if (this.contentType == 1) {
            builder.append("<small>[video]</small>: </td><td>");
        } else {
            builder.append("<small>[aux]</small>: </td><td>");
        }
        builder.append(this.description);
        if (this.showParamNames) {
            builder.append(" <i>[" + this.paramName + "]</i>");
        }
        builder.append("</td><tr></table></html>");
        this.descLabel.setText(builder.toString());
    }

    @Override
    protected Object getParamValue() {
        if (this.mediaCB != null) {
            if (this.mediaFiles != null && this.mediaFiles.size() > 0) {
                return this.mediaFiles.get(this.mediaCB.getSelectedIndex());
            }
        } else if (this.fileField.getText() != null && this.fileField.getText().trim().length() > 0) {
            return this.fileField.getText();
        }
        return null;
    }

    @Override
    protected void setParamValue(Object value) {
        if (value instanceof String) {
            if (this.mediaCB != null && this.mediaFiles != null && this.mediaFiles.contains(value)) {
                String name = FileUtility.fileNameFromPath((String)value);
                if (name != null) {
                    this.mediaCB.setSelectedItem(name);
                }
            } else if (this.fileField != null) {
                this.initialPath = (String)value;
                this.fileField.setText(this.initialPath);
            }
        }
    }

    public void updateMediaFiles(List<String> mediaFilePaths) {
        this.mediaFiles = new ArrayList<String>();
        if (this.mediaCB != null) {
            String selectedMedia = (String)this.mediaCB.getSelectedItem();
            boolean selectedMediaFound = false;
            this.mediaCB.removeAllItems();
            if (mediaFilePaths != null) {
                for (String s : mediaFilePaths) {
                    String name = FileUtility.fileNameFromPath(s);
                    if (name == null || !this.isMediaSupported(s)) continue;
                    this.mediaCB.addItem(name);
                    this.mediaFiles.add(s);
                    if (!name.equals(selectedMedia)) continue;
                    selectedMediaFound = true;
                }
            }
            if (selectedMediaFound) {
                this.mediaCB.setSelectedItem(selectedMedia);
            } else if (this.mediaCB.getItemCount() > 0) {
                this.mediaCB.setSelectedIndex(0);
            } else {
                this.mediaCB.addItem("No supported media files available");
            }
        }
    }

    public boolean isMediaSupported(String mediaFilePath) {
        if (mediaFilePath == null || mediaFilePath.length() == 0) {
            return false;
        }
        int index = mediaFilePath.lastIndexOf(46);
        String ext = null;
        if (index > -1 && index < mediaFilePath.length() - 1) {
            ext = mediaFilePath.substring(index + 1);
        }
        if (ext == null || ext.length() == 0) {
            return false;
        }
        String mime = MediaDescriptorUtil.mimeTypeForExtension(ext);
        if (this.mimeTypes != null) {
            if (this.mimeTypes.contains(mime)) {
                return true;
            }
            for (String type : this.mimeTypes) {
                if (!(this.contentType == 0 ? type.startsWith("audio") && mime.startsWith("audio") || type.startsWith("video") && mime.startsWith("video") : type.startsWith("video") && mime.startsWith("video"))) continue;
                return true;
            }
            if (mime.startsWith("audio") && this.contentType == 0) {
                return true;
            }
            if (mime.startsWith("video") && this.contentType == 1) {
                return true;
            }
        } else {
            if (this.contentType == 0) {
                return true;
            }
            if (this.contentType == 1 && (mime != "audio/*" || mime != "audio/x-wav")) {
                return true;
            }
        }
        return false;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public int getContentType() {
        return this.contentType;
    }

    public boolean isFileInput() {
        return this.fileField != null;
    }

    public boolean isValueFilled() {
        Object value = this.getParamValue();
        return value instanceof String && ((String)value).trim().length() > 0;
    }

    public boolean isInputType() {
        return this.inputType;
    }

    public List<String[]> getFileTypeExtension() {
        ArrayList<Object> extensions = null;
        if (this.contentType == 5 || this.contentType == 3) {
            this.acceptAllFiles = false;
            extensions = new ArrayList<String[]>();
            extensions.add(FileExtension.CSV_EXT);
        } else if (this.contentType == 4 || this.contentType == 2 || this.contentType == 7) {
            this.acceptAllFiles = false;
            extensions = new ArrayList();
            extensions.add(FileExtension.XML_EXT);
        } else if ((this.contentType == 0 || this.contentType == 1) && this.mimeTypes != null) {
            extensions = new ArrayList();
            for (int i = 0; i < this.mimeTypes.size(); ++i) {
                String mimeType = this.mimeTypes.get(i);
                String[] extArray = MediaDescriptorUtil.extensionForMimeType(mimeType);
                if (extArray != null && !extensions.contains(extArray)) {
                    extensions.add(extArray);
                }
                if (extArray != null) continue;
                if (mimeType.equals("audio/*") || mimeType.startsWith("audio")) {
                    this.acceptAllFiles = true;
                    continue;
                }
                if (!mimeType.equals("video/*") && !mimeType.startsWith("video")) continue;
                this.acceptAllFiles = true;
            }
            if (extensions.size() == 0) {
                extensions = null;
            }
        }
        return extensions;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.browseButton) {
            FileChooser chooser = new FileChooser(this);
            if (this.initialPath != null) {
                chooser.setCurrentDirectory(this.initialPath);
            }
            int dialogType = -1;
            dialogType = this.inputType ? 0 : 1;
            List<String[]> extensions = this.getFileTypeExtension();
            String[] mainFilterExt = null;
            if (extensions != null && extensions.size() > 0) {
                mainFilterExt = extensions.get(0);
            }
            String title = null;
            if (this.contentType == 0) {
                title = "Select a audio file";
            } else if (this.contentType == 1) {
                title = "Select a video file";
            } else if (this.contentType == 2 || this.contentType == 3) {
                title = "Select a tier file";
            } else if (this.contentType == 7) {
                title = "Select a multitier file";
            } else if (this.contentType == 4 || this.contentType == 5) {
                title = "Select a timeseries file";
            }
            chooser.createAndShowFileDialog(title, dialogType, "select", extensions, mainFilterExt, this.acceptAllFiles, "Recognizer.Dir", 0, null);
            File f = chooser.getSelectedFile();
            if (f != null) {
                this.initialPath = f.getAbsolutePath();
                this.fileField.setText(this.initialPath);
            }
        }
    }
}

