/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.md.imdi.ImdiFileServiceProvider;
import mpi.eudico.client.annotator.md.imdi.ImdiKeyRenderer;
import mpi.eudico.client.annotator.prefs.PreferenceEditor;
import mpi.eudico.client.annotator.tier.TierExportTableModel;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;

public class MetadataPanel
extends JPanel
implements PreferenceEditor,
ListSelectionListener {
    private ImdiFileServiceProvider provider;
    private List origKeys = null;
    private List<String> afterKeys = null;
    private DefaultTableModel model;
    private JTable keyTable;
    private final String SEL_COLUMN = "Select";
    private final String KEY_COLUMN = "Key";

    public MetadataPanel() {
        this.readPrefs();
        this.initComponents();
    }

    private void readPrefs() {
        Object val = Preferences.get("Metadata.IMDI.Defaults", null);
        if (val instanceof List) {
            this.origKeys = (List)val;
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 0, 2, 0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        this.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Metadata.IMDI")), gbc);
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.gridy = 1;
        this.provider = new ImdiFileServiceProvider();
        URL imdiUrl = this.getClass().getResource("/mpi/eudico/client/annotator/resources/Session.imdi");
        this.provider.setMetadataFile(imdiUrl.toString());
        this.provider.initialize();
        this.model = new TierExportTableModel();
        this.keyTable = new JTable(this.model);
        this.model.setColumnIdentifiers(new String[]{"Select", "Key"});
        this.keyTable.getColumn("Select").setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.keyTable.getColumn("Select").setCellRenderer(new CheckBoxTableCellRenderer());
        this.keyTable.getColumn("Select").setMaxWidth(30);
        this.keyTable.getColumn("Key").setCellRenderer(new ImdiKeyRenderer());
        this.keyTable.setShowVerticalLines(false);
        this.keyTable.setTableHeader(null);
        this.keyTable.getSelectionModel().addListSelectionListener(this);
        this.keyTable.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        if (this.provider != null && this.provider.getKeys() != null) {
            for (int i = 0; i < this.provider.getKeys().size(); ++i) {
                String key = (String)this.provider.getKeys().get(i);
                if (this.origKeys != null && this.origKeys.contains(key)) {
                    this.model.addRow(new Object[]{Boolean.TRUE, key});
                    continue;
                }
                this.model.addRow(new Object[]{Boolean.FALSE, key});
            }
        }
        this.add((Component)new JScrollPane(this.keyTable), gbc);
    }

    @Override
    public Map getChangedPreferences() {
        if (this.afterKeys != null) {
            HashMap<String, List<String>> prefs = new HashMap<String, List<String>>(1);
            prefs.put("Metadata.IMDI.Defaults", this.afterKeys);
            return prefs;
        }
        return null;
    }

    @Override
    public boolean isChanged() {
        this.afterKeys = new ArrayList<String>();
        int includeCol = this.model.findColumn("Select");
        int nameCol = this.model.findColumn("Key");
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Boolean bl = (Boolean)this.model.getValueAt(i, includeCol);
            if (!bl.booleanValue()) continue;
            this.afterKeys.add((String)this.model.getValueAt(i, nameCol));
        }
        if (this.origKeys == null && this.afterKeys.size() > 0) {
            return true;
        }
        if (this.origKeys != null && this.afterKeys.size() != this.origKeys.size()) {
            return true;
        }
        if (this.origKeys != null) {
            for (Object e : this.origKeys) {
                if (this.afterKeys.contains(e)) continue;
                return true;
            }
            for (Object object : this.afterKeys) {
                if (this.origKeys.contains(object)) continue;
                return true;
            }
        }
        this.afterKeys = null;
        return false;
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (this.model != null && lse.getValueIsAdjusting()) {
            int b = lse.getFirstIndex();
            int e = lse.getLastIndex();
            int col = this.model.findColumn("Select");
            for (int i = b; i <= e; ++i) {
                if (!this.keyTable.isRowSelected(i)) continue;
                this.model.setValueAt(Boolean.TRUE, i, col);
            }
        }
    }
}

