/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.prefs.PreferenceEditor;
import mpi.eudico.client.annotator.util.FileUtility;

public class GeneralPrefsPanel
extends JPanel
implements PreferenceEditor,
ActionListener {
    private String curGenPrefsLocation = "-";
    private JLabel setDirLabel;
    private JLabel curDirLabel;
    private JButton defaultDirButton;
    private JButton resetDirButton;
    private JComboBox nrOfBuFilesCB;
    private Integer origNumBuFiles = 1;
    private JCheckBox checkForUpdatesCB;
    private boolean origCheckUpdates = true;

    public GeneralPrefsPanel() {
        this.readPrefs();
        this.initComponents();
    }

    private void readPrefs() {
        Object val = Preferences.get("DefaultPreferencesLocation", null);
        if (val instanceof String) {
            this.curGenPrefsLocation = (String)val;
        }
        if ((val = Preferences.get("NumberOfBackUpFiles", null)) instanceof Integer) {
            this.origNumBuFiles = (Integer)val;
        }
        if ((val = Preferences.get("AutomaticUpdate", null)) instanceof Boolean) {
            this.origCheckUpdates = (Boolean)val;
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 0, 2, 0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        gbc.gridwidth = 3;
        this.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Prefs.Location")), gbc);
        this.setDirLabel = new JLabel(ElanLocale.getString("PreferencesDialog.Prefs.DefaultLoc"));
        this.setDirLabel.setFont(this.setDirLabel.getFont().deriveFont(0));
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.5;
        this.add((Component)this.setDirLabel, gbc);
        this.curDirLabel = new JLabel(this.curGenPrefsLocation);
        this.curDirLabel.setFont(this.curDirLabel.getFont().deriveFont(0));
        gbc.gridy = 2;
        this.add((Component)this.curDirLabel, gbc);
        this.defaultDirButton = new JButton(ElanLocale.getString("Button.Browse"));
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridheight = 2;
        gbc.anchor = 18;
        this.add((Component)this.defaultDirButton, gbc);
        this.defaultDirButton.addActionListener(this);
        this.resetDirButton = new JButton();
        ImageIcon resetIcon = null;
        try {
            resetIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Remove.gif"));
            this.resetDirButton.setIcon(resetIcon);
        }
        catch (Exception ex) {
            this.resetDirButton.setText("X");
        }
        this.resetDirButton.setToolTipText(ElanLocale.getString("PreferencesDialog.Reset"));
        this.resetDirButton.setPreferredSize(new Dimension(this.resetDirButton.getPreferredSize().width, this.defaultDirButton.getPreferredSize().height));
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridheight = 2;
        gbc.anchor = 18;
        gbc.insets = new Insets(2, 10, 2, 0);
        this.add((Component)this.resetDirButton, gbc);
        this.resetDirButton.addActionListener(this);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(12, 0, 2, 0);
        this.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Prefs.NumBackUp")), gbc);
        Integer[] nrOfBuItemsList = new Integer[]{1, 2, 3, 4, 5};
        this.nrOfBuFilesCB = new JComboBox<Integer>(nrOfBuItemsList);
        this.nrOfBuFilesCB.setSelectedItem(this.origNumBuFiles);
        gbc.gridy = 4;
        gbc.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.nrOfBuFilesCB, gbc);
        this.checkForUpdatesCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Prefs.AutoUpdate"), this.origCheckUpdates);
        gbc.gridy = 5;
        gbc.insets = new Insets(12, 0, 2, 0);
        this.add((Component)this.checkForUpdatesCB, gbc);
        gbc.gridy = 6;
        gbc.gridwidth = 3;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.add((Component)new JPanel(), gbc);
    }

    @Override
    public Map getChangedPreferences() {
        if (this.isChanged()) {
            HashMap<String, Object> chMap = new HashMap<String, Object>(2);
            if (this.curDirLabel.getText() != null && !this.curDirLabel.getText().equals("-")) {
                chMap.put("DefaultPreferencesLocation", this.curDirLabel.getText());
            } else {
                chMap.put("DefaultPreferencesLocation", null);
            }
            if (this.origNumBuFiles != this.nrOfBuFilesCB.getSelectedItem()) {
                chMap.put("NumberOfBackUpFiles", this.nrOfBuFilesCB.getSelectedItem());
            }
            if (this.origCheckUpdates != this.checkForUpdatesCB.isSelected()) {
                chMap.put("AutomaticUpdate", this.checkForUpdatesCB.isSelected());
            }
            return chMap;
        }
        return null;
    }

    @Override
    public boolean isChanged() {
        return !this.curGenPrefsLocation.equals(this.curDirLabel.getText()) || this.origNumBuFiles != this.nrOfBuFilesCB.getSelectedItem() || this.origCheckUpdates != this.checkForUpdatesCB.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.defaultDirButton) {
            File dir;
            FileChooser chooser = new FileChooser(this);
            File startDir = new File(System.getProperty("user.home"));
            if (this.curGenPrefsLocation.length() > 1 && (dir = new File(FileUtility.urlToAbsPath(this.curGenPrefsLocation))).exists() && dir.isDirectory()) {
                startDir = dir;
            }
            chooser.setCurrentDirectory(startDir.getAbsolutePath());
            chooser.createAndShowFileDialog(ElanLocale.getString("PreferencesDialog.Media.DefaultLoc"), 0, ElanLocale.getString("Button.Select"), null, null, true, null, 1, null);
            File selFile = chooser.getSelectedFile();
            if (selFile != null) {
                this.curDirLabel.setText(selFile.getAbsolutePath());
                this.curDirLabel.setText(FileUtility.pathToURLString(selFile.getAbsolutePath()));
            }
        } else if (e.getSource() == this.resetDirButton) {
            this.curDirLabel.setText("-");
        }
    }
}

