/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.prefs.PreferenceEditor;

public class EditingPanel
extends JPanel
implements PreferenceEditor,
ChangeListener {
    private JCheckBox deselectCB;
    private JCheckBox enterCommitsCB;
    private JCheckBox clearSelectionCB;
    private JCheckBox clearSelectionOnSingleClickCB;
    private JCheckBox createDependAnnCB;
    private JCheckBox snapAnnCB;
    private JLabel snapAnnLabel;
    private JCheckBox stickToFramesCB;
    private JTextField snapAnnTextField;
    private JCheckBox editInCenterCB;
    private JLabel copyOptionLabel;
    private JComboBox copyOptionComboBox;
    private JCheckBox suggestEntryContainsCB;
    private JCheckBox suggestSearchDescCB;
    private JCheckBox suggestIgnoreCaseCB;
    private boolean origDeselectFlag = false;
    private boolean origEnterFlag = false;
    private boolean origClearSelFlag = false;
    private boolean origClearSelOnSingleClickFlag = true;
    private boolean oriCreateDependAnnFlag = false;
    private boolean oriSnapAnnotationsFlag = false;
    private boolean oriStickToFramesFlag = false;
    private long oriSnapValue = 100L;
    private long newSnapValue;
    private boolean oriAnnInCenterFlag = true;
    private static String TEXTANDTIME = ElanLocale.getString("PreferencesDialog.Edit.CopyAll");
    private static String TEXT = ElanLocale.getString("PreferencesDialog.Edit.CopyTextOnly");
    private Map<String, String> tcMap = new HashMap<String, String>(2);
    private int origCopyOptionIndex;
    private String oriCopyOption = "annotation + begintime + endtime";
    private boolean oriSuggestSearchMethodFlag = false;
    private boolean oriSuggestSearchInDescFlag = false;
    private boolean oriSuggestIgnoreCaseFlag = false;

    public EditingPanel() {
        this.tcMap.put(TEXTANDTIME, "annotation + begintime + endtime");
        this.tcMap.put(TEXT, "annotation only");
        this.readPrefs();
        this.initComponents();
    }

    private void readPrefs() {
        Object val = Preferences.get("InlineEdit.DeselectCommits", null);
        if (val instanceof Boolean) {
            this.origDeselectFlag = (Boolean)val;
        }
        if ((val = Preferences.get("InlineEdit.EnterCommits", null)) instanceof Boolean) {
            this.origEnterFlag = (Boolean)val;
        }
        if ((val = Preferences.get("ClearSelectionAfterCreation", null)) instanceof Boolean) {
            this.origClearSelFlag = (Boolean)val;
        }
        if ((val = Preferences.get("ClearSelectionOnSingleClick", null)) instanceof Boolean) {
            this.origClearSelOnSingleClickFlag = (Boolean)val;
        }
        if ((val = Preferences.get("CreateDependingAnnotations", null)) instanceof Boolean) {
            this.oriCreateDependAnnFlag = (Boolean)val;
        }
        if ((val = Preferences.get("SnapAnnotations", null)) instanceof Boolean) {
            this.oriSnapAnnotationsFlag = (Boolean)val;
        }
        if ((val = Preferences.get("SnapAnnotationsValue", null)) instanceof Long) {
            this.oriSnapValue = (Long)val;
        }
        this.newSnapValue = this.oriSnapValue;
        val = Preferences.get("StickAnnotationsWithVideoFrames", null);
        if (val instanceof Boolean) {
            this.oriStickToFramesFlag = (Boolean)val;
        }
        if ((val = Preferences.get("SuggestPanel.EntryContains", null)) instanceof Boolean) {
            this.oriSuggestSearchMethodFlag = (Boolean)val;
        }
        if ((val = Preferences.get("SuggestPanel.SearchDescription", null)) instanceof Boolean) {
            this.oriSuggestSearchInDescFlag = (Boolean)val;
        }
        if ((val = Preferences.get("SuggestPanel.IgnoreCase", null)) instanceof Boolean) {
            this.oriSuggestIgnoreCaseFlag = (Boolean)val;
        }
        if ((val = Preferences.get("EditingPanel.ActiveAnnotationInCenter", null)) instanceof Boolean) {
            this.oriAnnInCenterFlag = (Boolean)val;
        }
        if ((val = Preferences.get("EditingPanel.CopyOption", null)) instanceof String) {
            String storedPref = (String)val;
            if (this.tcMap.containsKey(storedPref)) {
                this.oriCopyOption = this.tcMap.get(storedPref);
            } else if (this.tcMap.values().contains(storedPref)) {
                this.oriCopyOption = storedPref;
            }
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 0, 2, 0);
        this.deselectCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.Deselect"), this.origDeselectFlag);
        this.enterCommitsCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.EnterCommits"), this.origEnterFlag);
        this.clearSelectionCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.ClearSelection"), this.origClearSelFlag);
        this.clearSelectionOnSingleClickCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.ClearSelectionOnSingleClick"), this.origClearSelOnSingleClickFlag);
        this.createDependAnnCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.CreateDependAnn"), this.oriCreateDependAnnFlag);
        this.snapAnnCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.SnapAnnotations"), this.oriSnapAnnotationsFlag);
        this.snapAnnCB.addChangeListener(this);
        this.snapAnnLabel = new JLabel(ElanLocale.getString("PreferencesDialog.Edit.SnapAnnotations.Label"));
        this.snapAnnTextField = new JTextField(Long.toString(this.oriSnapValue));
        this.snapAnnTextField.setEnabled(this.oriSnapAnnotationsFlag);
        this.stickToFramesCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.StickToVideoFrames"), this.oriStickToFramesFlag);
        this.editInCenterCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.ActiveAnnotationInCenter"), this.oriAnnInCenterFlag);
        this.deselectCB.setFont(this.deselectCB.getFont().deriveFont(0));
        this.enterCommitsCB.setFont(this.deselectCB.getFont());
        this.clearSelectionCB.setFont(this.deselectCB.getFont());
        this.clearSelectionOnSingleClickCB.setFont(this.deselectCB.getFont());
        this.createDependAnnCB.setFont(this.deselectCB.getFont());
        this.snapAnnCB.setFont(this.deselectCB.getFont());
        this.snapAnnLabel.setFont(this.deselectCB.getFont());
        this.snapAnnTextField.setFont(this.deselectCB.getFont());
        this.stickToFramesCB.setFont(this.deselectCB.getFont());
        this.editInCenterCB.setFont(this.deselectCB.getFont());
        this.suggestEntryContainsCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.SuggestEntryContains"), this.oriSuggestSearchMethodFlag);
        this.suggestSearchDescCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.SuggestSearchDesc"), this.oriSuggestSearchInDescFlag);
        this.suggestIgnoreCaseCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.SuggestIgnoreCase"), this.oriSuggestIgnoreCaseFlag);
        this.suggestEntryContainsCB.setFont(this.deselectCB.getFont());
        this.suggestSearchDescCB.setFont(this.deselectCB.getFont());
        this.suggestIgnoreCaseCB.setFont(this.deselectCB.getFont());
        this.copyOptionLabel = new JLabel(ElanLocale.getString("PreferencesDialog.Edit.CopyOptionLabel"));
        this.copyOptionLabel.setFont(this.deselectCB.getFont());
        this.copyOptionComboBox = new JComboBox();
        this.copyOptionComboBox.addItem(TEXTANDTIME);
        this.copyOptionComboBox.addItem(TEXT);
        boolean prefRestored = false;
        Iterator<String> tcIt = this.tcMap.keySet().iterator();
        String tcConst = null;
        while (tcIt.hasNext()) {
            String key = tcIt.next();
            tcConst = this.tcMap.get(key);
            if (!tcConst.equals(this.oriCopyOption)) continue;
            this.copyOptionComboBox.setSelectedItem(key);
            prefRestored = true;
            break;
        }
        if (!prefRestored) {
            this.copyOptionComboBox.setSelectedItem(TEXTANDTIME);
        }
        this.origCopyOptionIndex = this.copyOptionComboBox.getSelectedIndex();
        this.copyOptionComboBox.setSelectedItem(this.oriCopyOption);
        this.copyOptionComboBox.setFont(this.deselectCB.getFont());
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel snapPanel = new JPanel(new GridBagLayout());
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 35, 2, 0);
        snapPanel.add((Component)this.snapAnnLabel, gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 6, 2, 0);
        gbc.weightx = 1.0;
        snapPanel.add((Component)this.snapAnnTextField, gbc);
        JPanel copyOptionPanel = new JPanel(new GridBagLayout());
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.insets = new Insets(5, 0, 2, 0);
        copyOptionPanel.add((Component)this.copyOptionLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(2, 2, 2, 0);
        copyOptionPanel.add((Component)this.copyOptionComboBox, gbc);
        JPanel editingPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets;
        editingPanel.add((Component)this.deselectCB, gbc);
        gbc.gridy = 2;
        editingPanel.add((Component)this.enterCommitsCB, gbc);
        gbc.gridy = 3;
        editingPanel.add((Component)this.clearSelectionCB, gbc);
        gbc.gridy = 4;
        editingPanel.add((Component)this.clearSelectionOnSingleClickCB, gbc);
        gbc.gridy = 5;
        editingPanel.add((Component)this.createDependAnnCB, gbc);
        gbc.gridy = 6;
        editingPanel.add((Component)this.stickToFramesCB, gbc);
        gbc.gridy = 7;
        editingPanel.add((Component)this.snapAnnCB, gbc);
        gbc.gridy = 8;
        editingPanel.add((Component)snapPanel, gbc);
        gbc.gridy = 9;
        gbc.insets = insets;
        gbc.fill = 0;
        editingPanel.add((Component)this.editInCenterCB, gbc);
        gbc.gridy = 10;
        gbc.insets = new Insets(15, 2, 5, 0);
        editingPanel.add((Component)copyOptionPanel, gbc);
        gbc.gridy = 11;
        editingPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Edit.SuggestPanel")), gbc);
        gbc.insets = insets;
        gbc.gridy = 12;
        editingPanel.add((Component)this.suggestEntryContainsCB, gbc);
        gbc.gridy = 13;
        editingPanel.add((Component)this.suggestSearchDescCB, gbc);
        gbc.gridy = 14;
        editingPanel.add((Component)this.suggestIgnoreCaseCB, gbc);
        gbc.gridy = 15;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        editingPanel.add((Component)new JPanel(), gbc);
        JScrollPane scrollPane = new JScrollPane(editingPanel);
        scrollPane.setBorder(new TitledBorder(ElanLocale.getString("PreferencesDialog.Category.Edit")));
        scrollPane.setBackground(editingPanel.getBackground());
        gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        this.add((Component)scrollPane, gbc);
    }

    @Override
    public Map getChangedPreferences() {
        if (this.isChanged()) {
            HashMap<String, Object> chMap = new HashMap<String, Object>(3);
            if (this.deselectCB.isSelected() != this.origDeselectFlag) {
                chMap.put("InlineEdit.DeselectCommits", new Boolean(this.deselectCB.isSelected()));
            }
            if (this.enterCommitsCB.isSelected() != this.origEnterFlag) {
                chMap.put("InlineEdit.EnterCommits", new Boolean(this.enterCommitsCB.isSelected()));
            }
            if (this.clearSelectionCB.isSelected() != this.origClearSelFlag) {
                chMap.put("ClearSelectionAfterCreation", new Boolean(this.clearSelectionCB.isSelected()));
            }
            if (this.clearSelectionOnSingleClickCB.isSelected() != this.origClearSelOnSingleClickFlag) {
                chMap.put("ClearSelectionOnSingleClick", new Boolean(this.clearSelectionOnSingleClickCB.isSelected()));
            }
            if (this.createDependAnnCB.isSelected() != this.oriCreateDependAnnFlag) {
                chMap.put("CreateDependingAnnotations", new Boolean(this.createDependAnnCB.isSelected()));
            }
            if (this.snapAnnCB.isSelected() != this.oriSnapAnnotationsFlag) {
                chMap.put("SnapAnnotations", new Boolean(this.snapAnnCB.isSelected()));
            }
            if (this.snapAnnCB.isSelected()) {
                chMap.put("SnapAnnotationsValue", new Long(this.newSnapValue));
            }
            if (this.stickToFramesCB.isSelected() != this.oriStickToFramesFlag) {
                chMap.put("StickAnnotationsWithVideoFrames", new Boolean(this.stickToFramesCB.isSelected()));
            }
            if (this.suggestEntryContainsCB.isSelected() != this.oriSuggestSearchMethodFlag) {
                chMap.put("SuggestPanel.EntryContains", new Boolean(this.suggestEntryContainsCB.isSelected()));
            }
            if (this.suggestSearchDescCB.isSelected() != this.oriSuggestSearchInDescFlag) {
                chMap.put("SuggestPanel.SearchDescription", new Boolean(this.suggestSearchDescCB.isSelected()));
            }
            if (this.suggestIgnoreCaseCB.isSelected() != this.oriSuggestIgnoreCaseFlag) {
                chMap.put("SuggestPanel.IgnoreCase", new Boolean(this.suggestIgnoreCaseCB.isSelected()));
            }
            if (this.editInCenterCB.isSelected() != this.oriAnnInCenterFlag) {
                chMap.put("EditingPanel.ActiveAnnotationInCenter", new Boolean(this.editInCenterCB.isSelected()));
            }
            String string = this.copyOptionComboBox.getSelectedItem().toString();
            String nonLocaleString = "annotation + begintime + endtime";
            nonLocaleString = this.tcMap.get(string);
            if (!nonLocaleString.equals(this.oriCopyOption)) {
                chMap.put("EditingPanel.CopyOption", nonLocaleString);
            }
            return chMap;
        }
        return null;
    }

    @Override
    public boolean isChanged() {
        return this.deselectCB.isSelected() != this.origDeselectFlag || this.enterCommitsCB.isSelected() != this.origEnterFlag || this.clearSelectionCB.isSelected() != this.origClearSelFlag || this.clearSelectionOnSingleClickCB.isSelected() != this.origClearSelOnSingleClickFlag || this.createDependAnnCB.isSelected() != this.oriCreateDependAnnFlag || this.snapAnnCB.isSelected() != this.oriSnapAnnotationsFlag || this.newSnapValue != this.oriSnapValue || this.stickToFramesCB.isSelected() != this.oriStickToFramesFlag || this.suggestEntryContainsCB.isSelected() != this.oriSuggestSearchMethodFlag || this.suggestSearchDescCB.isSelected() != this.oriSuggestSearchInDescFlag || this.suggestIgnoreCaseCB.isSelected() != this.oriSuggestIgnoreCaseFlag || this.editInCenterCB.isSelected() != this.oriAnnInCenterFlag || this.origCopyOptionIndex != this.copyOptionComboBox.getSelectedIndex();
    }

    public boolean checkSnapValue() {
        if (this.snapAnnCB.isSelected() && this.snapAnnTextField.getText() != null) {
            try {
                this.newSnapValue = Long.parseLong(this.snapAnnTextField.getText().trim());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public void focusSnapValue() {
        this.snapAnnTextField.requestFocus();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.snapAnnCB) {
            this.snapAnnTextField.setEnabled(this.snapAnnCB.isSelected());
            if (this.snapAnnCB.isSelected()) {
                this.snapAnnTextField.requestFocus();
            }
        }
    }
}

