/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import java.awt.Component;
import javax.swing.JComponent;
import mpi.eudico.client.annotator.player.NoPlayerException;
import mpi.eudico.client.annotator.player.QTMediaPlayer;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import quicktime.QTException;
import quicktime.QTSession;
import quicktime.app.view.MoviePlayer;
import quicktime.app.view.QTFactory;
import quicktime.app.view.QTJComponent;
import quicktime.std.clocks.ExtremesCallBack;
import quicktime.std.clocks.TimeBase;
import quicktime.std.clocks.TimeRecord;
import quicktime.std.image.Matrix;
import quicktime.std.movies.Movie;
import quicktime.std.movies.media.DataRef;

public class QTStreamingPlayer
extends QTMediaPlayer {
    private QTJComponent canvas;
    private JComponent visualComponent;
    private MoviePlayer player;

    public QTStreamingPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        super(mediaDescriptor);
        String URLString = mediaDescriptor.mediaURL;
        System.out.println("mediaURL = " + URLString);
        try {
            if (URLString.startsWith("rtsp")) {
                DataRef dataRef = new DataRef(URLString);
                this.movie = Movie.fromDataRef((DataRef)dataRef, (int)1);
            }
            this.player = new MoviePlayer(this.movie);
            Matrix matrix = new Matrix();
            matrix.scale(4.0f, 4.0f, 0.0f, 0.0f);
            this.player.setMatrix(matrix);
            this.canvas = QTFactory.makeQTJComponent((MoviePlayer)this.player);
            this.visualComponent = this.canvas.asJComponent();
            this.visualComponent.addMouseListener(new QTMediaPlayer.MouseHandler(this));
            this.timeBase = this.movie.getTimeBase();
            this.endOfMediaCallback = new PlayerExtremesCallBack(this.timeBase, 2);
            this.endOfMediaCallback.callMeWhen();
        }
        catch (QTException e) {
            System.out.println("QTException while creating QT Streaming player ");
            e.printStackTrace();
            QTSession.close();
            throw new NoPlayerException("QTException while creating QT Streaming player.");
        }
    }

    @Override
    public String getFrameworkDescription() {
        return "Streaming Quicktime For Java Media Player";
    }

    @Override
    public Component createNewVisualComponent() {
        try {
            this.canvas = QTFactory.makeQTJComponent((MoviePlayer)this.player);
            this.visualComponent = this.canvas.asJComponent();
            this.visualComponent.addMouseListener(new QTMediaPlayer.MouseHandler(this));
        }
        catch (QTException qte) {
            System.out.println("Could not create a new visual component. ");
            qte.printStackTrace();
        }
        return this.visualComponent;
    }

    @Override
    public Component getVisualComponent() {
        return this.visualComponent;
    }

    @Override
    public void playInterval(long startTime, long stopTime) {
        if (this.movie == null || this.playingInterval || stopTime <= startTime) {
            return;
        }
        long startOff = startTime + this.offset;
        long stopOff = stopTime + this.offset;
        try {
            if (stopTime - startTime < 5000L) {
                int loadBeginTime = startOff - 5000L > 0L ? (int)(startOff - 5000L) : 0;
                int loadDuration = (int)(stopOff - (long)loadBeginTime + 1000L);
                this.movie.loadIntoRam(loadBeginTime, loadDuration, 2);
            }
            this.setMediaTime(startTime);
            Thread.sleep(100L);
            this.movie.prePreroll((int)startOff, this.movie.getPreferredRate());
            if (this.stopMode == 0) {
                this.setStopTime(stopOff);
            } else {
                this.movie.setPreviewTime((int)startOff, (int)(stopTime - startTime));
                this.movie.setPreviewMode(true);
            }
            this.exactStopTime = stopTime;
            this.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setStopTime(long stopTime) {
        try {
            this.timeBase.setStopTime(new TimeRecord(this.movie.getTimeScale(), stopTime));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void start() {
        if (this.movie == null) {
            return;
        }
        if (this.getMediaDuration() - this.getMediaTime() < 40L) {
            this.setMediaTime(0L);
        }
        try {
            this.startControllers();
            this.player.setRate(this.movie.getPreferredRate());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void stop() {
        if (this.movie == null) {
            return;
        }
        try {
            this.player.setRate(0.0f);
            this.stopControllers();
            this.setControllersMediaTime(this.getMediaTime());
        }
        catch (QTException qt) {
            qt.printStackTrace();
        }
    }

    @Override
    public synchronized void setMediaTime(long time) {
        if (this.movie == null) {
            return;
        }
        if (this.isPlaying()) {
            this.stop();
        }
        try {
            this.player.setTime(new Long(time + this.offset).intValue());
            this.setControllersMediaTime(time);
        }
        catch (Exception qt) {
            qt.printStackTrace();
        }
    }

    @Override
    public void cleanUpOnClose() {
        super.cleanUpOnClose();
        this.visualComponent = null;
        this.canvas = null;
        this.player = null;
    }

    private class PlayerExtremesCallBack
    extends ExtremesCallBack {
        public PlayerExtremesCallBack(TimeBase tb, int flag) throws QTException {
            super(tb, flag);
        }

        public void execute() {
            try {
                QTStreamingPlayer.this.player.setRate(0.0f);
                QTStreamingPlayer.this.stopControllers();
                QTStreamingPlayer.this.setMediaTime(QTStreamingPlayer.this.exactStopTime);
                if (QTStreamingPlayer.this.stopMode == 0) {
                    QTStreamingPlayer.this.setStopTime(QTStreamingPlayer.this.movie.getDuration());
                } else {
                    QTStreamingPlayer.this.movie.setPreviewMode(false);
                }
                QTStreamingPlayer.this.exactStopTime = QTStreamingPlayer.this.movie.getDuration();
                QTStreamingPlayer.this.endOfMediaCallback.callMeWhen();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

