/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.ControllerListener;
import javax.media.GainControl;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.Processor;
import javax.media.Renderer;
import javax.media.control.FormatControl;
import javax.media.control.FrameGrabbingControl;
import javax.media.control.FramePositioningControl;
import javax.media.control.TrackControl;
import javax.media.format.VideoFormat;
import javax.media.renderer.VideoRenderer;
import javax.media.util.BufferToImage;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.player.JMFMediaPlayer;
import mpi.eudico.client.annotator.player.NoPlayerException;
import mpi.eudico.client.annotator.svg.JMFGraphicVideoRenderer;
import mpi.eudico.client.annotator.svg.JMFSVGViewer;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.util.TimeFormatter;

public class JMFGraphicMediaPlayer
extends JMFMediaPlayer {
    final int transitionTime = 10000;
    final int sleepTime = 50;
    protected Processor processor;
    protected JMFGraphicVideoRenderer renderer;
    protected FrameGrabbingControl frameGrabber;
    protected FramePositioningControl framePositioner;

    public JMFGraphicMediaPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        super(mediaDescriptor);
        String URLString = mediaDescriptor.mediaURL;
        try {
            if (URLString.startsWith("rtsp")) {
                System.out.println("stream");
                MediaLocator ml = new MediaLocator(URLString);
                this.processor = Manager.createProcessor((MediaLocator)ml);
            } else {
                URL mediaURL = new URL(URLString);
                this.processor = Manager.createProcessor((URL)mediaURL);
            }
        }
        catch (javax.media.NoPlayerException e) {
            System.out.println("javax.media.NoPlayerException while creating JMF player");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("IO exception while creating JMF player");
            e.printStackTrace();
        }
        this.processor.configure();
        if (!this.checkState((Player)this.processor, 180)) {
            System.out.println("Could not configure the Processor");
        }
        this.processor.setContentDescriptor(null);
        TrackControl[] tc = this.processor.getTrackControls();
        if (tc == null || tc.length == 0) {
            System.err.println("Failed to obtain track controls from the processor.");
        } else {
            TrackControl videoTrack = null;
            for (int i = 0; i < tc.length; ++i) {
                if (!(tc[i].getFormat() instanceof VideoFormat)) continue;
                videoTrack = tc[i];
                break;
            }
            if (videoTrack != null) {
                try {
                    this.renderer = new JMFGraphicVideoRenderer();
                    videoTrack.setRenderer((Renderer)this.renderer);
                }
                catch (Exception e) {
                    System.out.println("Could not set renderer for videotrack");
                }
            }
        }
        this.processor.prefetch();
        if (!this.checkState((Player)this.processor, 500)) {
            System.out.println("Could not prefetch the processor");
        }
        if (this.processor != null && this.processor.getState() >= 500) {
            this.player = this.processor;
        }
        Control[] controls = this.player.getControls();
        for (int j = 0; j < controls.length; ++j) {
            if (controls[j] instanceof FrameGrabbingControl) {
                this.frameGrabber = (FrameGrabbingControl)controls[j];
            }
            if (!(controls[j] instanceof FramePositioningControl)) continue;
            this.framePositioner = (FramePositioningControl)controls[j];
        }
        GainControl gain = this.player.getGainControl();
        float level = 1.0f;
        if (gain != null) {
            level = gain.getLevel();
            gain.setLevel(0.0f);
        }
        this.systemVolumeLevel = level;
        this.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.stop();
        this.setMediaTime(0L);
        if (gain != null) {
            gain.setLevel(level);
        }
        this.player.addControllerListener((ControllerListener)this);
        if (this.player.getVisualComponent() != null) {
            this.player.getVisualComponent().addMouseListener(new JMFMediaPlayer.MouseHandler());
        }
        this.popup = new JPopupMenu();
        this.durationItem = new JMenuItem(ElanLocale.getString("Player.duration") + ":  " + TimeFormatter.toString(this.getMediaDuration()));
        this.durationItem.setEnabled(false);
        this.popup.addSeparator();
        this.popup.add(this.durationItem);
    }

    public VideoRenderer getRenderer() {
        return this.renderer;
    }

    public boolean connectViewer(JMFSVGViewer viewer) {
        if (this.renderer != null) {
            this.renderer.connectViewer(viewer);
            return true;
        }
        return false;
    }

    public Image getFrameImageForTime(long time) {
        if (this.getMediaTime() != time) {
            this.setMediaTime(time);
        }
        if (this.frameGrabber != null) {
            Buffer buffer = this.frameGrabber.grabFrame();
            BufferToImage b2i = new BufferToImage((VideoFormat)buffer.getFormat());
            BufferedImage bi = (BufferedImage)b2i.createImage(buffer);
            return bi;
        }
        return null;
    }

    private boolean checkState(Player p, int state) {
        int time = 0;
        if (p.getState() == state) {
            return true;
        }
        while (time < 10000) {
            try {
                Thread.sleep(50L);
                if (p.getState() == state) {
                    return true;
                }
                time += 50;
            }
            catch (InterruptedException ie) {}
        }
        return false;
    }

    @Override
    void printControls(Player player) {
        System.out.println("Player info: " + player);
        Control[] controls = player.getControls();
        for (int i = 0; i < controls.length; ++i) {
            System.out.print("\t" + i + ": ");
            System.out.println(controls[i].getClass());
            if (controls[i] instanceof FormatControl) {
                FormatControl fc = (FormatControl)controls[i];
                System.out.println("\tFormatcontrol format: " + fc.getFormat());
                System.out.println("\tControl Component: " + fc.getControlComponent());
            }
            if (controls[i] instanceof FrameGrabbingControl) {
                System.out.println("\t - is framgrabbing control");
            }
            if (!(controls[i] instanceof FramePositioningControl)) continue;
            System.out.println("\t - is framepositioning control");
        }
    }
}

