/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.multiplefilesedit;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.multiplefilesedit.MFEModel;
import mpi.eudico.client.annotator.multiplefilesedit.MFETierTable;
import mpi.eudico.client.annotator.multiplefilesedit.TableByTierModel;
import mpi.eudico.client.annotator.multiplefilesedit.TableListener;

public class TableByTierPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -9116156249200869862L;
    private MFEModel model;
    private MFETierTable table;
    private JButton addRowButton;
    private JButton removeRowButton;

    public TableByTierPanel(MFEModel model) {
        this.model = model;
        this.initComponents();
        this.initCombobox();
    }

    public void initCombobox() {
        this.table.initCombobox();
    }

    private void initComponents() {
        GridBagLayout lm = new GridBagLayout();
        this.setLayout(lm);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.9;
        c.fill = 1;
        this.table = new MFETierTable(this.model);
        JScrollPane scroll_pane = new JScrollPane(this.table);
        this.table.getModel().addTableModelListener(new TableListener());
        this.table.setRowHeight(24);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.add((Component)scroll_pane, c);
        c.gridwidth = 1;
        c.gridy = 0;
        c.weighty = 0.0;
        this.addRowButton = new JButton(ElanLocale.getString("MFE.TierTab.AddTier"));
        this.addRowButton.setActionCommand("addRow");
        this.addRowButton.addActionListener(this);
        this.add((Component)this.addRowButton, c);
        c.gridx = 1;
        this.removeRowButton = new JButton(ElanLocale.getString("MFE.TierTab.RemoveTier"));
        this.removeRowButton.setActionCommand("removeRow");
        this.removeRowButton.addActionListener(this);
        this.add((Component)this.removeRowButton, c);
        this.enableUI(false);
    }

    public void updateLocale() {
    }

    public void enableUI(boolean b) {
        this.addRowButton.setEnabled(b);
        this.removeRowButton.setEnabled(b && this.model.areTiersRemovable());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            if (e.getActionCommand().equals("addRow")) {
                int new_row = ((TableByTierModel)this.table.getModel()).newRow();
                this.table.newRow(new_row);
                this.table.showCell(this.table.getRowCount() - 1, 0);
            } else if (e.getActionCommand().equals("removeRow")) {
                int[] selectedRows = this.table.getSelectedRows();
                ((TableByTierModel)this.table.getModel()).removeRows(selectedRows);
            }
        }
    }

    public void rowAdded(int row_nr) {
        ((TableByTierModel)this.table.getModel()).fireTableRowsInserted(row_nr, row_nr);
    }
}

