/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.md.imdi;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class MultiLineValueRenderer
implements TableCellRenderer {
    private static final String EMPTY_STRING = "";
    private final Border BORDER_SELECTED = UIManager.getBorder("Table.focusCellHighlightBorder");
    private final Border BORDER_EMPTY = new EmptyBorder(1, 2, 0, 2);
    private JTextArea textArea = new JTextArea();

    public MultiLineValueRenderer(boolean wrap) {
        this.textArea.setOpaque(true);
        this.textArea.setWrapStyleWord(wrap);
        this.textArea.setLineWrap(wrap);
    }

    public void updateUI() {
        if (this.textArea != null) {
            this.textArea.updateUI();
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.textArea.setForeground(table.getForeground());
        this.textArea.setBackground(table.getBackground());
        if (this.textArea.getFont() != table.getFont()) {
            this.textArea.setFont(table.getFont());
        }
        if (hasFocus) {
            this.textArea.setBorder(this.BORDER_SELECTED);
        } else {
            this.textArea.setBorder(this.BORDER_EMPTY);
        }
        this.textArea.setText(value == null ? EMPTY_STRING : value.toString());
        return this.textArea;
    }
}

