/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.md.imdi;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.md.DefaultMDViewerComponent;
import mpi.eudico.client.annotator.md.imdi.ImdiFileServiceProvider;
import mpi.eudico.client.annotator.md.imdi.MDKVData;
import mpi.eudico.client.annotator.md.imdi.MDTable;
import mpi.eudico.client.annotator.md.imdi.MDTree;
import mpi.eudico.client.annotator.md.imdi.MDTreeCellRenderer;
import mpi.eudico.client.annotator.md.spi.MDServiceProvider;

public class ImdiMDViewerPanel
extends DefaultMDViewerComponent
implements ActionListener,
MouseListener,
ComponentListener {
    protected JTree tree;
    private final int TABLE = 0;
    private final int TREE = 1;
    private int mode;
    private JPopupMenu popup;
    private JRadioButtonMenuItem tableMI;
    private JRadioButtonMenuItem treeMI;
    private JCheckBoxMenuItem hideEmptyMI;
    private boolean hideEmptyRows;

    private ImdiMDViewerPanel() {
    }

    public ImdiMDViewerPanel(MDServiceProvider provider) {
        super(provider);
    }

    @Override
    protected void initComponents() {
        this.mode = 0;
        Object val = Preferences.get("Metadata.IMDI.ViewMode", null);
        if (val instanceof String && "Tree".equals(val)) {
            this.mode = 1;
        }
        this.hideEmptyRows = (val = Preferences.get("Metadata.HideEmptyValues", null)) instanceof Boolean ? (Boolean)val : false;
        this.addComponentListener(this);
        this.scrollPane = new JScrollPane();
        this.scrollPane.addComponentListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.add((Component)this.scrollPane, gbc);
        if (this.mode == 0) {
            this.model = new DefaultTableModel(1, 2);
            this.model.setColumnIdentifiers(new String[]{this.keyColumn, this.valColumn});
            this.mdTable = new MDTable(this.model);
            this.mdTable.getTableHeader().setReorderingAllowed(false);
            this.mdTable.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            this.scrollPane.setViewportView(this.mdTable);
            this.scrollPane.getVerticalScrollBar().setUnitIncrement(this.mdTable.getRowHeight());
            this.mdTable.addMouseListener(this);
        } else {
            this.tree = new MDTree(new DefaultMutableTreeNode("Session"));
            this.tree.setCellRenderer(new MDTreeCellRenderer());
            this.tree.setRowHeight(-1);
            this.scrollPane.setViewportView(this.tree);
            this.scrollPane.getVerticalScrollBar().setUnitIncrement(this.tree.getFont().getSize());
            ((MDTree)this.tree).setDisplayWidth(this.scrollPane.getViewport().getWidth());
            ((MDTree)this.tree).forceUIUpdate();
            this.tree.addMouseListener(this);
        }
    }

    @Override
    public void setSelectedKeysAndValues(Map keysAndValuesMap) {
        if (this.mode == 1) {
            DefaultMutableTreeNode rootNode = ((ImdiFileServiceProvider)this.provider).getSelectedAsTree();
            if (this.hideEmptyRows) {
                this.removeEmptyLeaves(rootNode);
            }
            ((DefaultTreeModel)this.tree.getModel()).setRoot(rootNode);
            this.expandAllRows(this.tree);
        } else {
            super.setSelectedKeysAndValues(keysAndValuesMap);
            if (this.hideEmptyRows) {
                this.removeEmptyRows();
            }
        }
    }

    private void removeEmptyLeaves(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        int numCH = node.getChildCount();
        if (numCH == 0) {
            return;
        }
        for (int i = numCH - 1; i >= 0; --i) {
            MDKVData mdkv;
            Object data;
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)node.getChildAt(i);
            if (n.isLeaf()) {
                data = n.getUserObject();
                if (!(data instanceof MDKVData)) continue;
                mdkv = (MDKVData)data;
                if (mdkv.value != null && mdkv.value.length() != 0) continue;
                node.remove(n);
                continue;
            }
            this.removeEmptyLeaves(n);
            if (n.getChildCount() != 0 || !((data = n.getUserObject()) instanceof MDKVData)) continue;
            mdkv = (MDKVData)data;
            if (mdkv.value != null && mdkv.value.length() != 0) continue;
            node.remove(n);
        }
    }

    private void expandAllRows(JTree tree) {
        for (int i = 0; i < tree.getRowCount(); ++i) {
            tree.expandRow(i);
        }
    }

    private void removeEmptyRows() {
        if (this.mdTable != null) {
            DefaultTableModel dtm = (DefaultTableModel)this.mdTable.getModel();
            int numRows = dtm.getRowCount();
            for (int i = numRows - 1; i >= 0; --i) {
                String val = (String)dtm.getValueAt(i, 1);
                if (val != null && val.length() != 0) continue;
                dtm.removeRow(i);
            }
        }
    }

    private void createPopupMenu() {
        this.popup = new JPopupMenu("Popup");
        ButtonGroup group = new ButtonGroup();
        this.tableMI = new JRadioButtonMenuItem();
        this.tableMI.setSelected(this.mode == 0);
        group.add(this.tableMI);
        this.tableMI.addActionListener(this);
        this.popup.add(this.tableMI);
        this.treeMI = new JRadioButtonMenuItem();
        this.treeMI.setSelected(this.mode == 1);
        group.add(this.treeMI);
        this.treeMI.addActionListener(this);
        this.popup.add(this.treeMI);
        this.popup.addSeparator();
        this.hideEmptyMI = new JCheckBoxMenuItem();
        this.hideEmptyMI.setSelected(this.hideEmptyRows);
        this.hideEmptyMI.addActionListener(this);
        this.popup.add(this.hideEmptyMI);
        if (this.bundle != null) {
            String text = this.bundle.getString("MetadataViewer.TableView");
            if (text != null) {
                this.tableMI.setText(text);
            } else {
                this.tableMI.setText("Table View");
            }
            text = this.bundle.getString("MetadataViewer.TreeView");
            if (text != null) {
                this.treeMI.setText(text);
            } else {
                this.treeMI.setText("Tree View");
            }
            text = this.bundle.getString("MetadataViewer.HideEmptyValues");
            if (text != null) {
                this.hideEmptyMI.setText(text);
            } else {
                this.hideEmptyMI.setText("Hide Empty Metadata Fields");
            }
        } else {
            this.tableMI.setText("Table View");
            this.treeMI.setText("Tree View");
            this.hideEmptyMI.setText("Hide Empty Metadata Fields");
        }
    }

    @Override
    public void setResourceBundle(ResourceBundle bundle) {
        super.setResourceBundle(bundle);
        if (this.popup != null) {
            String text = bundle.getString("MetadataViewer.TableView");
            if (text != null) {
                this.tableMI.setText(text);
            } else {
                this.tableMI.setText("Table View");
            }
            text = bundle.getString("MetadataViewer.TreeView");
            if (text != null) {
                this.treeMI.setText(text);
            } else {
                this.treeMI.setText("Tree View");
            }
            text = bundle.getString("MetadataViewer.HideEmptyValues");
            if (text != null) {
                this.hideEmptyMI.setText(text);
            } else {
                this.hideEmptyMI.setText("Hide Empty Metadata Fields");
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.tableMI) {
            if (this.mode == 0) {
                return;
            }
            this.mode = 0;
            if (this.tree != null) {
                this.tree.removeMouseListener(this);
            }
            this.model = new DefaultTableModel(0, 2);
            this.model.setColumnIdentifiers(new String[]{this.keyColumn, this.valColumn});
            this.mdTable = new MDTable(this.model);
            this.mdTable.getTableHeader().setReorderingAllowed(false);
            this.mdTable.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            this.scrollPane.setViewportView(this.mdTable);
            this.scrollPane.getVerticalScrollBar().setUnitIncrement(this.mdTable.getRowHeight());
            this.mdTable.addMouseListener(this);
            this.setSelectedKeysAndValues(this.provider.getSelectedKeysAndValues());
            this.tree = null;
            Preferences.set("Metadata.IMDI.ViewMode", "Table", null, false, false);
        } else if (e.getSource() == this.treeMI) {
            if (this.mode == 1) {
                return;
            }
            this.mode = 1;
            if (this.mdTable != null) {
                this.mdTable.removeMouseListener(this);
            }
            this.tree = new MDTree(new DefaultMutableTreeNode("Session"));
            this.tree.setCellRenderer(new MDTreeCellRenderer());
            this.tree.setRowHeight(-1);
            this.scrollPane.setViewportView(this.tree);
            this.scrollPane.getVerticalScrollBar().setUnitIncrement(this.tree.getFont().getSize());
            this.tree.addMouseListener(this);
            this.setSelectedKeysAndValues(null);
            ((MDTree)this.tree).setDisplayWidth(this.scrollPane.getViewport().getWidth());
            ((MDTree)this.tree).forceUIUpdate();
            this.mdTable = null;
            Preferences.set("Metadata.IMDI.ViewMode", "Tree", null, false, false);
        } else if (e.getSource() == this.hideEmptyMI) {
            boolean sel = this.hideEmptyMI.isSelected();
            if (this.hideEmptyRows != sel) {
                this.hideEmptyRows = sel;
                if (this.mode == 1) {
                    if (this.hideEmptyRows) {
                        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
                        this.removeEmptyLeaves(root);
                        ((DefaultTreeModel)this.tree.getModel()).setRoot(root);
                        this.expandAllRows(this.tree);
                    } else {
                        this.setSelectedKeysAndValues(null);
                    }
                    ((MDTree)this.tree).setDisplayWidth(this.scrollPane.getViewport().getWidth());
                    ((MDTree)this.tree).forceUIUpdate();
                } else if (this.hideEmptyRows) {
                    this.removeEmptyRows();
                } else {
                    this.setSelectedKeysAndValues(this.provider.getSelectedKeysAndValues());
                }
            }
            Preferences.set("Metadata.HideEmptyValues", new Boolean(this.hideEmptyRows), null, false, false);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) && e.getButton() == 1 ^ e.isMetaDown() || e.isPopupTrigger()) {
            if (this.popup == null) {
                this.createPopupMenu();
            }
            Point pp = e.getPoint();
            pp.move(pp.x, pp.y - this.scrollPane.getVerticalScrollBar().getValue());
            if (this.popup.getWidth() == 0 || this.popup.getHeight() == 0) {
                this.popup.show(this, pp.x, pp.y);
            } else {
                this.popup.show(this, pp.x, pp.y);
                SwingUtilities.convertPointToScreen(pp, this);
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                Window w = SwingUtilities.windowForComponent(this);
                if (pp.x + this.popup.getWidth() > d.width) {
                    pp.x -= this.popup.getWidth();
                }
                if (pp.y + this.popup.getHeight() > d.height) {
                    pp.y -= this.popup.getHeight();
                }
                if (pp.y + this.popup.getHeight() > w.getLocationOnScreen().y + w.getHeight()) {
                    pp.y -= this.popup.getHeight();
                }
                this.popup.setLocation(pp);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.tree != null) {
            ((MDTree)this.tree).setDisplayWidth(this.scrollPane.getViewport().getWidth());
            ((MDTree)this.tree).forceUIUpdate();
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
        if (this.tree != null) {
            ((MDTree)this.tree).forceUIUpdate();
        }
    }
}

