/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.md.imdi;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.md.imdi.ImdiConfigurationPanel;
import mpi.eudico.client.annotator.md.imdi.ImdiDoc;
import mpi.eudico.client.annotator.md.imdi.ImdiMDViewerPanel;
import mpi.eudico.client.annotator.md.imdi.ImdiSaxCheck;
import mpi.eudico.client.annotator.md.spi.MDConfigurationPanel;
import mpi.eudico.client.annotator.md.spi.MDServiceProvider;
import mpi.eudico.client.annotator.md.spi.MDViewerComponent;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.util.DocumentNotLoadedException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ImdiFileServiceProvider
implements MDServiceProvider {
    private String sourcePath;
    private Map<String, String> mdValuesMap = new LinkedHashMap<String, String>();
    private ImdiDoc imdiDoc;
    private List<String> selectedKeys = new ArrayList<String>();
    private ImdiMDViewerPanel viewerPanel = null;

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public List getKeys() {
        if (this.imdiDoc != null) {
            return this.imdiDoc.getKeys();
        }
        return null;
    }

    @Override
    public void setSelectedKeys(List selKeys) {
        this.selectedKeys.clear();
        if (selKeys != null) {
            this.selectedKeys.addAll(selKeys);
            if (this.imdiDoc != null) {
                this.mdValuesMap = this.imdiDoc.getValuesForKeys(this.selectedKeys, true);
            }
        }
    }

    @Override
    public List getSelectedKeys() {
        return this.selectedKeys;
    }

    @Override
    public List getValues(String key) {
        if (this.imdiDoc != null) {
            return this.imdiDoc.getValues(key);
        }
        return null;
    }

    @Override
    public String getMDFormatDescription() {
        return "IMDI";
    }

    @Override
    public String getValue(String key) {
        String val = this.mdValuesMap.get(key);
        if (val == null && this.imdiDoc != null) {
            return this.imdiDoc.getValue(key);
        }
        return val;
    }

    @Override
    public MDConfigurationPanel getConfigurationPanel() {
        return new ImdiConfigurationPanel(this);
    }

    @Override
    public Map getSelectedKeysAndValues() {
        return this.mdValuesMap;
    }

    public DefaultMutableTreeNode getSelectedAsTree() {
        if (this.mdValuesMap == null) {
            return null;
        }
        DefaultMutableTreeNode root = this.imdiDoc.getTreeForKeys(this.selectedKeys, true);
        return root;
    }

    @Override
    public MDViewerComponent getMDViewerComponent() {
        if (this.viewerPanel == null) {
            this.viewerPanel = new ImdiMDViewerPanel(this);
        }
        return this.viewerPanel;
    }

    @Override
    public boolean setMetadataFile(String filePath) {
        if (filePath == null) {
            return false;
        }
        File f = new File(filePath);
        if (!f.exists()) {
            if (filePath.indexOf("!/") > -1) {
                return this.setJarMetadataFile(filePath);
            }
            ClientLogger.LOG.warning("The metadata file does not exist: " + filePath);
            return false;
        }
        if (!f.canRead()) {
            ClientLogger.LOG.warning("The metadata file cannot be read: " + filePath);
            return false;
        }
        if (f.isDirectory()) {
            ClientLogger.LOG.warning("The path is a directory: " + filePath);
            return false;
        }
        if (f.length() == 0L) {
            ClientLogger.LOG.warning("The metadata file has zero length: " + filePath);
            return false;
        }
        if (filePath.toLowerCase().endsWith("imdi")) {
            this.sourcePath = filePath;
            ImdiSaxCheck checker = new ImdiSaxCheck();
            return checker.isSessionFile(f);
        }
        return false;
    }

    private boolean setJarMetadataFile(String filePath) {
        if (filePath == null) {
            return false;
        }
        try {
            URL url = new URL(filePath);
            InputSource is = new InputSource(url.openStream());
            if (filePath.startsWith("jar:file")) {
                this.sourcePath = filePath;
                return true;
            }
        }
        catch (MalformedURLException mue) {
            ClientLogger.LOG.warning("Not a valid jar url: " + filePath);
            return false;
        }
        catch (IOException ioe) {
            ClientLogger.LOG.warning("Cannot open stream from jar: " + filePath);
            return false;
        }
        return false;
    }

    @Override
    public String getMetadataFile() {
        return this.sourcePath;
    }

    @Override
    public void initialize() {
        try {
            if (this.sourcePath != null && this.sourcePath.startsWith("jar:file")) {
                try {
                    URL url = new URL(this.sourcePath);
                    InputSource is = new InputSource(url.openStream());
                    this.imdiDoc = new ImdiDoc(is);
                }
                catch (MalformedURLException mue) {
                    ClientLogger.LOG.warning("Not a valid jar url: " + this.sourcePath);
                }
                catch (IOException ioe) {
                    ClientLogger.LOG.warning("Cannot open stream from jar: " + this.sourcePath);
                }
            } else {
                this.imdiDoc = new ImdiDoc(this.sourcePath);
            }
        }
        catch (DocumentNotLoadedException dnle) {
            ClientLogger.LOG.warning("Could not load the Imdi document: " + dnle.getMessage());
        }
    }

    private void printChildren(Node node) {
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node nd = nodes.item(i);
            System.out.println("N: " + nd.getNodeName() + " V: " + nd.getNodeValue());
            if (nd instanceof Element) {
                Element el = (Element)nd;
                System.out.println("Id: " + el.getAttribute("id"));
            }
            if (!nd.hasChildNodes()) continue;
            this.printChildren(nd);
        }
    }
}

