/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.md.imdi;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.md.imdi.ImdiFileServiceProvider;
import mpi.eudico.client.annotator.md.imdi.ImdiKeyRenderer;
import mpi.eudico.client.annotator.md.spi.MDConfigurationPanel;
import mpi.eudico.client.annotator.tier.TierExportTableModel;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;

public class ImdiConfigurationPanel
extends MDConfigurationPanel
implements ListSelectionListener,
ActionListener {
    private ImdiFileServiceProvider provider;
    private DefaultTableModel model;
    private JTable keyTable;
    private final String SEL_COLUMN = "Select";
    private final String KEY_COLUMN = "Key";

    public ImdiConfigurationPanel(ImdiFileServiceProvider provider) {
        this.provider = provider;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(ElanLocale.getString("MetadataViewer.SelectKeys")));
        this.model = new TierExportTableModel();
        this.keyTable = new JTable(this.model);
        this.model.setColumnIdentifiers(new String[]{"Select", "Key"});
        this.keyTable.getColumn("Select").setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.keyTable.getColumn("Select").setCellRenderer(new CheckBoxTableCellRenderer());
        this.keyTable.getColumn("Select").setMaxWidth(30);
        this.keyTable.getColumn("Key").setCellRenderer(new ImdiKeyRenderer());
        this.keyTable.setShowVerticalLines(false);
        this.keyTable.setTableHeader(null);
        this.keyTable.getSelectionModel().addListSelectionListener(this);
        this.keyTable.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        if (this.provider != null && this.provider.getKeys() != null) {
            for (int i = 0; i < this.provider.getKeys().size(); ++i) {
                String key = (String)this.provider.getKeys().get(i);
                if (this.provider.getSelectedKeys().contains(key)) {
                    this.model.addRow(new Object[]{Boolean.TRUE, key});
                    continue;
                }
                this.model.addRow(new Object[]{Boolean.FALSE, key});
            }
        }
        JScrollPane keyScrollPane = new JScrollPane(this.keyTable);
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = insets;
        this.add((Component)keyScrollPane, gbc);
    }

    @Override
    public void applyChanges() {
        ArrayList<String> nextSelected = new ArrayList<String>();
        int includeCol = this.model.findColumn("Select");
        int nameCol = this.model.findColumn("Key");
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Boolean include = (Boolean)this.model.getValueAt(i, includeCol);
            if (!include.booleanValue()) continue;
            nextSelected.add((String)this.model.getValueAt(i, nameCol));
        }
        if (this.provider != null) {
            this.provider.setSelectedKeys(nextSelected);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (this.model != null && lse.getValueIsAdjusting()) {
            int b = lse.getFirstIndex();
            int e = lse.getLastIndex();
            int col = this.model.findColumn("Select");
            for (int i = b; i <= e; ++i) {
                if (!this.keyTable.isRowSelected(i)) continue;
                this.model.setValueAt(Boolean.TRUE, i, col);
            }
        }
    }
}

