/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.linkedmedia;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.linkedmedia.MediaFilesPanel;
import mpi.eudico.client.annotator.linkedmedia.SecLinkedFilesPanel;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class LinkedFilesDialog
extends ClosableDialog
implements ActionListener,
ChangeListener {
    private JLabel titleLabel;
    private JPanel titlePanel;
    private JPanel dialogButtonPanel;
    private JButton cancelButton;
    private JButton applyButton;
    private TranscriptionImpl transcription;
    private JTabbedPane tabPane;

    public LinkedFilesDialog(Transcription transcription) {
        super((Frame)ELANCommandFactory.getRootFrame(transcription), true);
        this.transcription = (TranscriptionImpl)transcription;
        this.initComponents();
        this.postInit();
    }

    public LinkedFilesDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.postInit();
    }

    private void initComponents() {
        this.tabPane = new JTabbedPane();
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.dialogButtonPanel = new JPanel();
        this.applyButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LinkedFilesDialog.this.closeDialog();
            }
        });
        Insets insets = new Insets(2, 6, 2, 6);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titlePanel.add(this.titleLabel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.titlePanel, gridBagConstraints);
        this.tabPane.addTab(ElanLocale.getString("LinkedFilesDialog.Label.LinkedMediaFiles"), new MediaFilesPanel(this.transcription));
        this.tabPane.addTab(ElanLocale.getString("LinkedFilesDialog.Label.LinkedSecFiles"), new SecLinkedFilesPanel(this.transcription));
        this.tabPane.addChangeListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.tabPane, gridBagConstraints);
        this.dialogButtonPanel.setLayout(new GridLayout(1, 2, 6, 0));
        this.applyButton.addActionListener(this);
        this.dialogButtonPanel.add(this.applyButton);
        this.cancelButton.addActionListener(this);
        this.dialogButtonPanel.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.dialogButtonPanel, gridBagConstraints);
        this.updateLocale();
    }

    private void updateLocale() {
        this.setTitle(ElanLocale.getString("LinkedFilesDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("LinkedFilesDialog.Title"));
        this.applyButton.setText(ElanLocale.getString("LinkedFilesDialog.Button.Apply"));
        this.cancelButton.setText(ElanLocale.getString("Button.Close"));
    }

    private void postInit() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void applyChanges() {
        if (this.tabPane.getSelectedIndex() == 0) {
            ((MediaFilesPanel)this.tabPane.getComponentAt(0)).applyChanges();
        } else {
            ((SecLinkedFilesPanel)this.tabPane.getComponentAt(1)).applyChanges();
        }
        this.closeDialog();
    }

    private void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    private boolean showOptionDialog(String question) {
        int option = JOptionPane.showOptionDialog(this, question, ElanLocale.getString("LinkedFilesDialog.Title"), 0, 3, null, new String[]{ElanLocale.getString("Button.Yes"), ElanLocale.getString("Button.No")}, ElanLocale.getString("Button.Yes"));
        return option == 0;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object source = actionEvent.getSource();
        if (source == this.cancelButton) {
            this.closeDialog();
        } else if (source == this.applyButton) {
            this.applyChanges();
        }
    }

    public static void main(String[] args) {
        new LinkedFilesDialog(new JFrame()).show();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.tabPane.getSelectedIndex() == 1) {
            if (((MediaFilesPanel)this.tabPane.getComponentAt(0)).hasChanged() && this.showOptionDialog(ElanLocale.getString("LinkedFilesDialog.Question.ApplyChangesMedia"))) {
                ((MediaFilesPanel)this.tabPane.getComponentAt(0)).applyChanges();
            }
        } else if (((SecLinkedFilesPanel)this.tabPane.getComponentAt(1)).hasChanged() && this.showOptionDialog(ElanLocale.getString("LinkedFilesDialog.Question.ApplyChangesNonAV"))) {
            ((SecLinkedFilesPanel)this.tabPane.getComponentAt(1)).applyChanges();
        }
    }
}

