/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.linkedmedia;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.timeseries.TSTrackManager;
import mpi.eudico.client.annotator.timeseries.config.TSSourceConfiguration;
import mpi.eudico.client.annotator.timeseries.io.TSConfigurationParser;
import mpi.eudico.client.annotator.timeseries.spi.TSServiceProvider;
import mpi.eudico.client.annotator.timeseries.spi.TSServiceRegistry;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.client.annotator.viewer.TimeSeriesViewer;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class LinkedFileDescriptorUtil
implements ClientLogger {
    public static LinkedFileDescriptor createLFDescriptor(String filePath) {
        if (filePath == null || filePath.length() == 0) {
            return null;
        }
        String linkURL = FileUtility.pathToURLString(filePath);
        if (linkURL == null) {
            return null;
        }
        String mimeType = null;
        String extension = "";
        if (linkURL.indexOf(46) > -1) {
            extension = linkURL.substring(linkURL.lastIndexOf(46) + 1);
        }
        mimeType = LinkedFileDescriptorUtil.mimeTypeForExtension(extension);
        LinkedFileDescriptor md = new LinkedFileDescriptor(linkURL, mimeType);
        return md;
    }

    public static String mimeTypeForExtension(String extension) {
        int i;
        if (extension == null || extension.length() < 3) {
            return "unknown";
        }
        String lowExt = extension.toLowerCase();
        for (i = 0; i < FileExtension.TEXT_EXT.length; ++i) {
            if (!lowExt.equals(FileExtension.TEXT_EXT[i])) continue;
            return "text/plain";
        }
        for (i = 0; i < FileExtension.LOG_EXT.length; ++i) {
            if (!lowExt.equals(FileExtension.LOG_EXT[i])) continue;
            return "text/plain";
        }
        for (i = 0; i < FileExtension.XML_EXT.length; ++i) {
            if (!lowExt.equals(FileExtension.XML_EXT[i])) continue;
            return "text/xml";
        }
        for (i = 0; i < FileExtension.SVG_EXT.length; ++i) {
            if (!lowExt.equals(FileExtension.SVG_EXT[i])) continue;
            return "image/svg+xml";
        }
        return "unknown";
    }

    public static void initLinkedFiles(TranscriptionImpl transcription) {
        LinkedFileDescriptor lfd;
        int i;
        if (transcription == null || transcription.getLinkedFileDescriptors() == null) {
            return;
        }
        boolean isChanged = transcription.isChanged();
        Vector lfDescs = transcription.getLinkedFileDescriptors();
        TSServiceRegistry registry = TSServiceRegistry.getInstance();
        TSTrackManager trackManager = null;
        ArrayList<String> handledSources = new ArrayList<String>();
        HashMap urlmap = LinkedFileDescriptorUtil.checkLinkedFiles(transcription);
        for (i = 0; i < lfDescs.size(); ++i) {
            TSConfigurationParser parser;
            ArrayList confs;
            lfd = (LinkedFileDescriptor)lfDescs.get(i);
            if (!lfd.linkURL.endsWith("_tsconf.xml")) continue;
            String path = lfd.linkURL;
            if (path.startsWith("file:")) {
                path = path.substring(5);
            }
            if ((confs = (parser = new TSConfigurationParser()).parseSourceConfigs(path)) == null || confs.size() <= 0 || trackManager != null) continue;
            trackManager = new TSTrackManager(transcription);
            ELANCommandFactory.addTrackManager(transcription, trackManager);
            TimeSeriesViewer tsViewer = ELANCommandFactory.getViewerManager(transcription).createTimeSeriesViewer();
            tsViewer.setTrackManager(trackManager);
            ELANCommandFactory.getLayoutManager(transcription).add(tsViewer);
            ArrayList<String> linkedFiles = new ArrayList<String>();
            for (int z = 0; z < lfDescs.size(); ++z) {
                String linkUrl = ((LinkedFileDescriptor)lfDescs.get((int)z)).linkURL;
                if (linkedFiles.contains(linkUrl)) continue;
                linkedFiles.add(linkUrl);
            }
            for (int j = 0; j < confs.size(); ++j) {
                TSSourceConfiguration sc = (TSSourceConfiguration)confs.get(j);
                if (urlmap.containsKey(sc.getSource())) {
                    sc.setSource((String)urlmap.get(sc.getSource()));
                }
                if (!linkedFiles.contains(sc.getSource())) continue;
                TSServiceProvider provider = null;
                if (sc.getProviderClassName() != null) {
                    provider = registry.getProviderByClassName(sc.getProviderClassName());
                }
                if (provider == null) {
                    provider = registry.getProviderForFile(sc.getSource());
                }
                if (provider != null) {
                    if (!provider.isConfigurable()) {
                        provider.autoCreateTracks(sc);
                    } else {
                        provider.createTracksFromConfiguration(sc);
                    }
                    trackManager.addTrackSource(sc, false);
                }
                handledSources.add(sc.getSource());
            }
        }
        for (i = 0; i < lfDescs.size(); ++i) {
            TSServiceProvider provider;
            lfd = (LinkedFileDescriptor)lfDescs.get(i);
            if (handledSources.contains(lfd.linkURL) || lfd.mimeType.equals("image/svg+xml") || (provider = registry.getProviderForFile(lfd.linkURL)) == null) continue;
            if (trackManager == null) {
                trackManager = new TSTrackManager(transcription);
                ELANCommandFactory.addTrackManager(transcription, trackManager);
                TimeSeriesViewer tsViewer = ELANCommandFactory.getViewerManager(transcription).createTimeSeriesViewer();
                tsViewer.setTrackManager(trackManager);
                ELANCommandFactory.getLayoutManager(transcription).add(tsViewer);
            }
            TSSourceConfiguration config = new TSSourceConfiguration(lfd.linkURL);
            config.setProviderClassName(provider.getClass().getName());
            if (!provider.isConfigurable()) {
                provider.autoCreateTracks(config);
            }
            trackManager.addTrackSource(config, false);
        }
        if (!isChanged) {
            transcription.setUnchanged();
        }
    }

    public static void updateLinkedFiles(TranscriptionImpl transcription, Vector descriptors) {
        LinkedFileDescriptor lfd;
        int j;
        LinkedFileDescriptor olfd;
        int i;
        if (transcription == null || descriptors == null) {
            return;
        }
        Vector oldDescriptors = transcription.getLinkedFileDescriptors();
        ArrayList<LinkedFileDescriptor> removedSources = new ArrayList<LinkedFileDescriptor>(4);
        ArrayList<LinkedFileDescriptor> addedSources = new ArrayList<LinkedFileDescriptor>(4);
        block0: for (i = 0; i < oldDescriptors.size(); ++i) {
            olfd = (LinkedFileDescriptor)oldDescriptors.get(i);
            if (descriptors.size() == 0) {
                removedSources.add(olfd);
                continue;
            }
            for (j = 0; j < descriptors.size(); ++j) {
                lfd = (LinkedFileDescriptor)descriptors.get(j);
                if (lfd.linkURL.equals(olfd.linkURL)) continue block0;
                if (j != descriptors.size() - 1) continue;
                removedSources.add(olfd);
            }
        }
        block2: for (i = 0; i < descriptors.size(); ++i) {
            lfd = (LinkedFileDescriptor)descriptors.get(i);
            if (oldDescriptors.size() == 0) {
                addedSources.add(lfd);
                continue;
            }
            for (j = 0; j < oldDescriptors.size(); ++j) {
                olfd = (LinkedFileDescriptor)oldDescriptors.get(j);
                if (olfd.linkURL.equals(lfd.linkURL)) continue block2;
                if (j != oldDescriptors.size() - 1) continue;
                addedSources.add(lfd);
            }
        }
        TSTrackManager trackManager = ELANCommandFactory.getTrackManager(transcription);
        TSServiceRegistry registry = TSServiceRegistry.getInstance();
        if (removedSources.size() > 0) {
            for (int i2 = 0; i2 < removedSources.size(); ++i2) {
                lfd = (LinkedFileDescriptor)removedSources.get(i2);
                if (trackManager == null) continue;
                trackManager.removeTrackSource(lfd.linkURL);
            }
            if (descriptors.size() == 1) {
                lfd = (LinkedFileDescriptor)descriptors.get(0);
                if (lfd.linkURL.endsWith("_tsconf.xml")) {
                    descriptors.remove(0);
                }
            }
        }
        if (addedSources.size() > 0) {
            boolean configFound = false;
            for (int i3 = 0; i3 < addedSources.size(); ++i3) {
                LinkedFileDescriptor configDesc;
                lfd = (LinkedFileDescriptor)addedSources.get(i3);
                TSServiceProvider provider = registry.getProviderForFile(lfd.linkURL);
                if (provider == null) continue;
                if (trackManager == null) {
                    trackManager = new TSTrackManager(transcription);
                    ELANCommandFactory.addTrackManager(transcription, trackManager);
                    TimeSeriesViewer tsViewer = ELANCommandFactory.getViewerManager(transcription).createTimeSeriesViewer();
                    tsViewer.setTrackManager(trackManager);
                    ELANCommandFactory.getLayoutManager(transcription).add(tsViewer);
                }
                TSSourceConfiguration config = new TSSourceConfiguration(lfd.linkURL);
                config.setProviderClassName(provider.getClass().getName());
                if (!provider.isConfigurable()) {
                    provider.autoCreateTracks(config);
                }
                trackManager.addTrackSource(config, true);
                if (configFound) continue;
                for (int j2 = 0; j2 < descriptors.size(); ++j2) {
                    LinkedFileDescriptor confLfd = (LinkedFileDescriptor)descriptors.get(j2);
                    if (confLfd == lfd || !confLfd.linkURL.endsWith("_tsconf.xml")) continue;
                    configFound = true;
                    break;
                }
                if (configFound) continue;
                String transPath = transcription.getFullPath();
                if (transPath.toLowerCase().endsWith(".eaf")) {
                    transPath = transPath.substring(0, transPath.length() - 4);
                }
                if ((configDesc = LinkedFileDescriptorUtil.createLFDescriptor(transPath = transPath + "_tsconf.xml")) == null) continue;
                descriptors.add(configDesc);
                configFound = true;
            }
        }
        transcription.setLinkedFileDescriptors(descriptors);
        transcription.setChanged();
    }

    private static HashMap checkLinkedFiles(TranscriptionImpl transcription) {
        HashMap<String, String> linkMap = new HashMap<String, String>(2);
        if (transcription == null) {
            return linkMap;
        }
        Vector lfDescs = transcription.getLinkedFileDescriptors();
        if (lfDescs == null || lfDescs.size() == 0) {
            return linkMap;
        }
        Object currentDir = null;
        for (int i = 0; i < lfDescs.size(); ++i) {
            String nextUrl;
            File eafFile;
            LinkedFileDescriptor lfd = (LinkedFileDescriptor)lfDescs.get(i);
            if (lfd.linkURL == null) {
                LOG.warning("Link url is null");
                continue;
            }
            String oldLinkURL = lfd.linkURL;
            int colonIndex = oldLinkURL.indexOf(58);
            String path = null;
            path = colonIndex > 0 && colonIndex < lfd.linkURL.length() - 1 ? lfd.linkURL.substring(colonIndex + 1) : lfd.linkURL;
            File file = new File(path = path.replace('\\', '/'));
            if (file.exists()) continue;
            int lastSlash = path.lastIndexOf(47);
            String linkName = path;
            if (lastSlash >= 0 && lastSlash < path.length() - 1) {
                linkName = path.substring(lastSlash + 1);
            }
            String linkDir = null;
            String eafFileName = transcription.getFullPath();
            colonIndex = eafFileName.indexOf(58);
            if (colonIndex > -1) {
                eafFileName = eafFileName.substring(colonIndex + 1);
            }
            if ((eafFile = new File(eafFileName)).exists() && eafFile.getParentFile() != null) {
                linkDir = eafFile.getParentFile().getAbsolutePath();
            }
            File searchFile = null;
            searchFile = linkDir != null ? new File(linkDir + "/" + linkName) : new File(linkName);
            if (searchFile.exists()) {
                lfd.linkURL = FileUtility.pathToURLString(searchFile.getAbsolutePath());
                LOG.info("Updating url from: " + oldLinkURL + " to: " + lfd.linkURL);
                transcription.setChanged();
                linkMap.put(oldLinkURL, lfd.linkURL);
                continue;
            }
            if (lfd.relativeLinkURL != null) {
                File relFile;
                String absPath;
                String fullEAFURL = FileUtility.pathToURLString(transcription.getFullPath());
                String relUrl = lfd.relativeLinkURL;
                if (relUrl.startsWith("file:/")) {
                    relUrl = relUrl.substring(6);
                }
                if ((absPath = FileUtility.getAbsolutePath(fullEAFURL, relUrl)) != null && (relFile = new File(absPath)).exists()) {
                    lfd.linkURL = FileUtility.pathToURLString(relFile.getAbsolutePath());
                    LOG.info("Updating url from: " + oldLinkURL + " to: " + lfd.linkURL);
                    transcription.setChanged();
                    linkMap.put(oldLinkURL, lfd.linkURL);
                    continue;
                }
            }
            FileChooser chooser = new FileChooser(ELANCommandFactory.getRootFrame(transcription));
            String[] extensions = null;
            if (lfd.mimeType.equals("text/xml")) {
                extensions = FileExtension.XML_EXT;
            } else if (oldLinkURL.toLowerCase().endsWith(FileExtension.LOG_EXT[0])) {
                extensions = FileExtension.LOG_EXT;
            } else if (lfd.mimeType.equals("text/plain")) {
                extensions = FileExtension.TEXT_EXT;
            } else if (lfd.mimeType.equals("image/svg+xml")) {
                extensions = FileExtension.SVG_EXT;
            }
            chooser.setCurrentDirectory(searchFile.getParentFile().getAbsolutePath());
            chooser.createAndShowFileDialog(ElanLocale.getString("LinkedFilesDialog.Message.Locate") + ": " + linkName, 0, ElanLocale.getString("Button.Select"), null, extensions, true, null, 0, linkName);
            File selectedFile = chooser.getSelectedFile();
            if (selectedFile == null) continue;
            lfd.linkURL = nextUrl = FileUtility.pathToURLString(chooser.getSelectedFile().getAbsolutePath());
            LOG.info("Updating url from: " + oldLinkURL + " to: " + nextUrl);
            transcription.setChanged();
            linkMap.put(oldLinkURL, nextUrl);
        }
        return linkMap;
    }

    private static String checkLinkedFile(String filePath, TranscriptionImpl transcription) {
        File eafFile;
        if (filePath == null || transcription == null) {
            return null;
        }
        String transPath = transcription.getFullPath();
        int colonIndex = filePath.indexOf(58);
        String path = null;
        path = colonIndex > 0 && colonIndex < filePath.length() - 1 ? filePath.substring(colonIndex + 1) : filePath;
        File file = new File(path = path.replace('\\', '/'));
        if (file.exists()) {
            return filePath;
        }
        int lastSlash = path.lastIndexOf(47);
        String linkName = path;
        if (lastSlash >= 0 && lastSlash < path.length() - 1) {
            linkName = path.substring(lastSlash + 1);
        }
        String linkDir = null;
        String eafFileName = transPath;
        colonIndex = eafFileName.indexOf(58);
        if (colonIndex > -1) {
            eafFileName = eafFileName.substring(colonIndex + 1);
        }
        if ((eafFile = new File(eafFileName)).exists() && eafFile.getParentFile() != null) {
            linkDir = eafFile.getParentFile().getAbsolutePath();
        }
        File searchFile = null;
        searchFile = linkDir != null ? new File(linkDir + "/" + linkName) : new File(linkName);
        if (searchFile.exists()) {
            String nextUrl = FileUtility.pathToURLString(searchFile.getAbsolutePath());
            LOG.info("Updating url from: " + filePath + " to: " + nextUrl);
            return nextUrl;
        }
        FileChooser chooser = new FileChooser(ELANCommandFactory.getRootFrame(transcription));
        chooser.setCurrentDirectory(searchFile.getParentFile().getAbsolutePath());
        chooser.createAndShowFileDialog(ElanLocale.getString("LinkedFilesDialog.Message.Locate") + ": " + linkName, 0, ElanLocale.getString("Button.Select"), null, null, true, null, 0, linkName);
        if (chooser.getSelectedFile() != null) {
            String nextUrl = FileUtility.pathToURLString(chooser.getSelectedFile().getAbsolutePath());
            LOG.info("Updating url from: " + filePath + " to: " + nextUrl);
            return nextUrl;
        }
        return filePath;
    }
}

