/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.lexicon.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import mpi.eudico.client.annotator.lexicon.api.Param;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class LexSrvcClntParser
implements ContentHandler {
    private InputStream inputStream;
    public ArrayList<Param> paramList;
    public String type;
    public boolean curOsSupported;
    public String name;
    public String implementor;
    public String description;
    String curContent = "";
    Param curParam;

    public LexSrvcClntParser(InputStream inputStream) {
        this.inputStream = inputStream;
        this.paramList = new ArrayList(10);
    }

    public void parse() throws SAXException {
        if (this.inputStream != null) {
            try {
                XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                reader.setContentHandler(this);
                reader.parse(new InputSource(this.inputStream));
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
        } else {
            throw new SAXException("No input stream specified");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.curContent = this.curContent + new String(ch, start, length);
    }

    @Override
    public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
        if (name.equals("lexiconserviceclient")) {
            this.description = attributes.getValue("info");
            this.implementor = attributes.getValue("spiClass");
            this.curOsSupported = true;
        } else if (name.equals("param")) {
            this.curParam = new Param();
            this.curParam.setType(attributes.getValue("type"));
        }
    }

    @Override
    public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
        if (this.curContent != null && this.curContent.length() > 0) {
            if (name.equals("lexiconserviceclient")) {
                this.name = this.curContent.trim();
            } else if (name.equals("param")) {
                this.curParam.setContent(this.curContent.trim());
                this.paramList.add(this.curParam);
            }
        }
        this.curContent = "";
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator arg0) {
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
    }
}

