/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.layout;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.SoftBevelBorder;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.gui.ResizeComponent;
import mpi.eudico.client.annotator.interlinear.edit.InterlinearEditor;
import mpi.eudico.client.annotator.layout.ModeLayoutManager;
import mpi.eudico.client.annotator.layout.PlayerLayoutModel;

public class InterlinearizationManager
implements ModeLayoutManager {
    private ViewerManager2 viewerManager;
    private ElanLayoutManager layoutManager;
    private Container container;
    int origMediaAreaWidth = 352;
    int origMediaAreaHeight = 250;
    private ResizeComponent leftRightResizer;
    private ResizeComponent topBottomResizer;
    private JPanel leftPanel;
    private JPanel topPanel;
    private JComponent interPanel;

    public InterlinearizationManager(ViewerManager2 viewerManager, ElanLayoutManager elanLayoutManager) {
        this.viewerManager = viewerManager;
        this.layoutManager = elanLayoutManager;
        this.container = this.layoutManager.getContainer();
        this.leftPanel = new JPanel();
        this.topPanel = new JPanel();
        this.interPanel = new InterlinearEditor(viewerManager.getTranscription());
    }

    @Override
    public void add(Object object) {
    }

    @Override
    public void remove(Object object) {
    }

    @Override
    public void doLayout() {
        int containerWidth = this.container.getWidth();
        int containerHeight = this.container.getHeight();
        int mediaAreaWidth = this.layoutManager.getMediaAreaWidth();
        int mediaAreaHeight = this.layoutManager.getMediaAreaHeight();
        int visibleMediaX = 3;
        int lrDivX = visibleMediaX + mediaAreaWidth + 3;
        int lrDivY = containerHeight - this.leftRightResizer.getPreferredSize().height;
        this.leftRightResizer.setBounds(lrDivX, lrDivY, this.leftRightResizer.getPreferredSize().width, this.leftRightResizer.getPreferredSize().height);
        int tbDivX = lrDivX + this.leftRightResizer.getWidth();
        int tbDivY = 6 + mediaAreaHeight;
        this.topBottomResizer.setBounds(tbDivX, tbDivY, containerWidth - tbDivX, this.topBottomResizer.getPreferredSize().height);
        this.leftPanel.setBounds(3, 3, lrDivX - 3, containerHeight - 6);
        int rightCompX = tbDivX + 3;
        int rightCompW = containerWidth - rightCompX - 3;
        this.topPanel.setBounds(rightCompX, 3, rightCompW, tbDivY - 3);
        int interCompY = tbDivY + this.topBottomResizer.getHeight() + 3;
        int interCompH = containerHeight - interCompY - 3;
        this.interPanel.setBounds(rightCompX, interCompY, rightCompW, interCompH);
    }

    @Override
    public void updateLocale() {
    }

    @Override
    public void clearLayout() {
        this.container.remove(this.leftRightResizer);
        this.container.remove(this.topBottomResizer);
        this.container.remove(this.leftPanel);
        this.container.remove(this.topPanel);
        this.container.remove(this.interPanel);
        this.layoutManager.setMediaAreaWidth(this.origMediaAreaWidth);
        this.layoutManager.setMediaAreaHeight(this.origMediaAreaHeight);
        PlayerLayoutModel model = null;
        List visuals = this.layoutManager.getPlayerList();
        for (int i = 0; i < visuals.size(); ++i) {
            model = (PlayerLayoutModel)visuals.get(i);
            if (!model.isVisual() || !model.isAttached()) continue;
            this.container.add(model.visualComponent);
        }
        this.container.repaint();
    }

    @Override
    public void initComponents() {
        this.origMediaAreaWidth = this.layoutManager.getMediaAreaWidth();
        this.origMediaAreaHeight = this.layoutManager.getMediaAreaHeight();
        PlayerLayoutModel model = null;
        List visuals = this.layoutManager.getPlayerList();
        for (int i = 0; i < visuals.size(); ++i) {
            model = (PlayerLayoutModel)visuals.get(i);
            if (!model.isVisual() || !model.isAttached()) continue;
            this.container.remove(model.visualComponent);
        }
        this.leftRightResizer = new ResizeComponent(this.layoutManager, 0);
        this.leftRightResizer.setBorder(new SoftBevelBorder(0));
        this.leftRightResizer.setPreferredSize(new Dimension(8, this.container.getHeight()));
        Component n = this.leftRightResizer.getComponent(0);
        this.leftRightResizer.remove(n);
        this.leftRightResizer.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 20;
        gbc.weighty = 1.0;
        this.leftRightResizer.add(n, gbc);
        this.container.add(this.leftRightResizer);
        this.topBottomResizer = new ResizeComponent(this.layoutManager, 1);
        this.topBottomResizer.setBorder(new SoftBevelBorder(0));
        this.topBottomResizer.setPreferredSize(new Dimension(this.container.getWidth(), 8));
        n = this.topBottomResizer.getComponent(0);
        this.topBottomResizer.remove(n);
        this.topBottomResizer.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 20;
        gbc.weightx = 1.0;
        this.topBottomResizer.add(n, gbc);
        this.container.add(this.topBottomResizer);
        this.leftPanel.setBackground(new Color(220, 220, 255));
        this.topPanel.setBackground(new Color(220, 255, 220));
        this.interPanel.setBackground(Color.WHITE);
        this.container.add(this.leftPanel);
        this.container.add(this.topPanel);
        this.container.add(this.interPanel);
        this.doLayout();
    }

    @Override
    public void enableOrDisableMenus(boolean enabled) {
    }

    @Override
    public void detach(Object object) {
    }

    @Override
    public void attach(Object object) {
    }

    @Override
    public void preferencesChanged() {
    }

    @Override
    public void cleanUpOnClose() {
    }

    @Override
    public void shortcutsChanged() {
    }

    @Override
    public void createAndAddViewer(String viewerName) {
    }

    @Override
    public boolean destroyAndRemoveViewer(String viewerName) {
        return false;
    }

    @Override
    public void isClosing() {
    }
}

