/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;

public class TierFontSizeDlg
extends ClosableDialog
implements ActionListener,
ItemListener {
    private Map tierMap;
    private ArrayList tierNames;
    private final int[] fontSizes = new int[]{8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 36, 48, 72};
    private JComboBox tierComboBox;
    private JComboBox fontSizeComboBox;
    private JButton applyToAllButton;

    public TierFontSizeDlg(Dialog parent, boolean modal, Map tierMap) {
        super(parent, modal);
        this.tierMap = tierMap;
        this.initComponents();
        this.pack();
        this.setResizable(false);
    }

    public TierFontSizeDlg(Dialog parent, boolean modal, Map tierMap, ArrayList tierNames) {
        super(parent, modal);
        this.tierMap = tierMap;
        this.tierNames = tierNames;
        this.initComponents();
        this.pack();
        this.setResizable(false);
    }

    public TierFontSizeDlg(Frame parent, boolean modal, Map tierMap) {
        super(parent, modal);
        this.tierMap = tierMap;
        this.initComponents();
        this.pack();
        this.setResizable(false);
    }

    public TierFontSizeDlg(Frame parent, boolean modal, Map tierMap, ArrayList tierNames) {
        super(parent, modal);
        this.tierMap = tierMap;
        this.tierNames = tierNames;
        this.initComponents();
        this.pack();
        this.setResizable(false);
    }

    private void initComponents() {
        this.tierComboBox = new JComboBox();
        this.fontSizeComboBox = new JComboBox();
        this.applyToAllButton = new JButton();
        this.fillTierComboBox();
        this.fillFontSizeComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Insets insets = new Insets(2, 2, 2, 2);
        this.tierComboBox.setMaximumRowCount(20);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = insets;
        this.getContentPane().add((Component)this.tierComboBox, c);
        this.fontSizeComboBox.setMaximumRowCount(20);
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = insets;
        this.getContentPane().add((Component)this.fontSizeComboBox, c);
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = insets;
        this.getContentPane().add((Component)this.applyToAllButton, c);
        this.setDefaultValues();
        this.updateForLocale();
        this.tierComboBox.addItemListener(this);
        this.fontSizeComboBox.addItemListener(this);
        this.applyToAllButton.addActionListener(this);
    }

    private void fillTierComboBox() {
        block3: {
            block2: {
                if (this.tierNames == null) break block2;
                for (int i = 0; i < this.tierNames.size(); ++i) {
                    this.tierComboBox.addItem(this.tierNames.get(i));
                }
                break block3;
            }
            if (this.tierMap == null) break block3;
            Set tiers = this.tierMap.keySet();
            Iterator tierIt = tiers.iterator();
            while (tierIt.hasNext()) {
                this.tierComboBox.addItem(tierIt.next());
            }
        }
    }

    private void fillFontSizeComboBox() {
        for (int i = 0; i < this.fontSizes.length; ++i) {
            this.fontSizeComboBox.addItem(new Integer(this.fontSizes[i]));
        }
    }

    private void setDefaultValues() {
        String tierName = (String)this.tierComboBox.getSelectedItem();
        this.updateFontSizeComboBox(tierName);
    }

    private void updateFontSizeComboBox(String tierName) {
        int size = 12;
        if (this.tierMap != null && tierName != null) {
            Object fs = this.tierMap.get(tierName);
            if (fs != null) {
                this.fontSizeComboBox.setSelectedItem(fs);
            } else {
                this.fontSizeComboBox.setSelectedItem(new Integer(size));
            }
        } else {
            this.fontSizeComboBox.setSelectedItem(new Integer(size));
        }
    }

    private void changeFontSize(Integer newSize) {
        String tierName = (String)this.tierComboBox.getSelectedItem();
        if (tierName != null) {
            this.tierMap.put(tierName, newSize);
        }
    }

    private void updateForLocale() {
        this.setTitle(ElanLocale.getString("InterlinearizerOptionsDlg.FontSizes"));
        this.applyToAllButton.setText(ElanLocale.getString("InterlinearizerOptionsDlg.ApplyToAll"));
    }

    private void doApplyToAll() {
        Object fontSize = this.fontSizeComboBox.getSelectedItem();
        if (fontSize instanceof Integer && this.tierMap != null) {
            Iterator tierIt = this.tierMap.keySet().iterator();
            while (tierIt.hasNext()) {
                this.tierMap.put(tierIt.next(), fontSize);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.applyToAllButton) {
            this.doApplyToAll();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Integer fontSize;
        if (e.getSource() == this.tierComboBox && e.getStateChange() == 1) {
            String tierName = (String)this.tierComboBox.getSelectedItem();
            if (tierName != null) {
                this.updateFontSizeComboBox(tierName);
            }
        } else if (e.getSource() == this.fontSizeComboBox && e.getStateChange() == 1 && (fontSize = (Integer)this.fontSizeComboBox.getSelectedItem()) != null) {
            this.changeFontSize(fontSize);
        }
    }
}

