/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interannotator;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.interannotator.AnnotatorCompareTable;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class AnnotatorCompareExportUtil {
    private TranscriptionImpl transcription;
    private Component parent = null;
    private char delimiter = (char)95;
    private int affixMode = 1;
    String TAB = "\t";
    String NL = "\n";

    public AnnotatorCompareExportUtil(TranscriptionImpl transcription, Frame parent) {
        this.transcription = transcription;
        this.parent = parent;
    }

    public AnnotatorCompareExportUtil(TranscriptionImpl transcription, Dialog parent) {
        this.transcription = transcription;
        this.parent = parent;
    }

    public void doExport() throws IOException {
        FileChooser chooser = new FileChooser(this.parent);
        chooser.createAndShowFileAndEncodingDialog(null, 1, FileExtension.TEXT_EXT, "LastUsedExportDir", "UTF-8");
        File exportFile = chooser.getSelectedFile();
        String encoding = chooser.getSelectedEncoding();
        if (exportFile != null) {
            BufferedWriter writer = null;
            try {
                FileOutputStream out = new FileOutputStream(exportFile);
                OutputStreamWriter osw = null;
                try {
                    osw = new OutputStreamWriter((OutputStream)out, encoding);
                }
                catch (UnsupportedCharsetException uce) {
                    osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
                }
                writer = new BufferedWriter(osw);
                writer.write(this.transcription.getFullPath());
                writer.write(this.NL);
                writer.write(this.NL);
            }
            catch (Exception ex) {
                throw new IOException("Cannot write to file: " + ex.getMessage());
            }
            ArrayList<String> exportedTiers = new ArrayList<String>();
            ArrayList<String> tierNames = new ArrayList<String>(this.transcription.getTiers().size());
            for (int i = 0; i < this.transcription.getTiers().size(); ++i) {
                tierNames.add(((Tier)this.transcription.getTiers().get(i)).getName());
            }
            String r1Suffix = null;
            for (int i = 0; i < tierNames.size(); ++i) {
                String tierName = (String)tierNames.get(i);
                if (exportedTiers.contains(tierName)) continue;
                String tierName2 = this.findCorrespondingTierName(tierName, tierNames);
                if (tierName2 != null) {
                    if (r1Suffix == null) {
                        r1Suffix = this.findFirstOrderSuffix(tierName, tierName2);
                    }
                    try {
                        if (r1Suffix == null || tierName.endsWith(r1Suffix)) {
                            this.write(writer, tierName, tierName2);
                        } else {
                            this.write(writer, tierName2, tierName);
                        }
                    }
                    catch (IOException ex) {
                        System.out.println("Error exporting the tiers: " + tierName + " + " + tierName2);
                    }
                    exportedTiers.add(tierName2);
                }
                exportedTiers.add(tierName);
            }
            try {
                writer.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    private void write(BufferedWriter writer, String tierName1, String tierName2) throws IOException {
        writer.write("R1 (columns): " + tierName1);
        writer.write(this.NL);
        writer.write("R2 (rows): " + tierName2);
        writer.write(this.NL);
        writer.write(this.NL);
        AnnotatorCompareTable rct = new AnnotatorCompareTable();
        TableModel model = rct.getComparisonTable(this.transcription, tierName1, tierName2, 0.6f);
        if (model != null) {
            int i;
            for (i = 0; i < model.getColumnCount(); ++i) {
                writer.write(model.getColumnName(i));
                if (i >= model.getColumnCount() - 1) continue;
                writer.write(this.TAB);
            }
            writer.write(this.NL);
            writer.write(this.NL);
            int[][] segmentationTable = new int[2][2];
            for (i = 0; i < model.getRowCount(); ++i) {
                for (int j = 0; j < model.getColumnCount(); ++j) {
                    writer.write((String)model.getValueAt(i, j));
                    if (j < model.getColumnCount() - 1) {
                        writer.write(this.TAB);
                    } else {
                        writer.write(this.NL);
                    }
                    if (j <= 0) continue;
                    if (i < model.getRowCount() - 1) {
                        if (j < model.getColumnCount() - 1) {
                            try {
                                int num = Integer.valueOf((String)model.getValueAt(i, j));
                                int[] nArray = segmentationTable[0];
                                nArray[0] = nArray[0] + num;
                            }
                            catch (NumberFormatException nfe) {
                                System.out.println("ERROR: non numeric value in row,col: " + i + "-" + j);
                            }
                            continue;
                        }
                        if (j != model.getColumnCount() - 1) continue;
                        try {
                            int num = Integer.valueOf((String)model.getValueAt(i, j));
                            int[] nArray = segmentationTable[0];
                            nArray[1] = nArray[1] + num;
                        }
                        catch (NumberFormatException nfe) {
                            System.out.println("ERROR: non numeric value in row,col: " + i + "-" + j);
                        }
                        continue;
                    }
                    if (i != model.getRowCount() - 1) continue;
                    try {
                        int num = Integer.valueOf((String)model.getValueAt(i, j));
                        int[] nArray = segmentationTable[1];
                        nArray[0] = nArray[0] + num;
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("ERROR: non numeric value in row,col: " + i + "-" + j);
                    }
                }
            }
            writer.write(this.NL);
            writer.write("Segmentation matrix");
            writer.write(this.NL);
            writer.write(String.valueOf(segmentationTable[0][0]));
            writer.write(this.TAB);
            writer.write(String.valueOf(segmentationTable[0][1]));
            writer.write(this.NL);
            writer.write(String.valueOf(segmentationTable[1][0]));
            writer.write(this.TAB);
            writer.write(String.valueOf(segmentationTable[1][1]));
            writer.write(this.NL);
            writer.write(this.NL);
        } else {
            writer.write("Could not create a combination table for the tiers");
            writer.write(this.NL);
            writer.write(this.NL);
        }
    }

    private String findCorrespondingTierName(String refTier, List<String> allTierNames) {
        if (this.affixMode == 1) {
            int delIndex = refTier.lastIndexOf(this.delimiter);
            if (delIndex == -1 || delIndex == refTier.length() - 1) {
                return null;
            }
            String firstPart1 = refTier.substring(0, delIndex);
            String lastPart1 = refTier.substring(delIndex + 1);
            for (int i = 0; i < allTierNames.size(); ++i) {
                int index;
                String otherName = allTierNames.get(i);
                if (otherName.equals(refTier) || (index = otherName.lastIndexOf(this.delimiter)) == -1 | index == otherName.length() - 1) continue;
                String firstPart2 = otherName.substring(0, index);
                String lastPart2 = otherName.substring(index + 1);
                if (!firstPart2.equals(firstPart1) || lastPart2.equals(lastPart1)) continue;
                return otherName;
            }
        }
        return null;
    }

    private String findFirstOrderSuffix(String tierName1, String tierName2) {
        if (this.affixMode == 1) {
            int i1 = tierName1.lastIndexOf(this.delimiter);
            int i2 = tierName2.lastIndexOf(this.delimiter);
            if (i1 > -1 && i2 > -1 && i1 < tierName1.length() - 1 && i2 < tierName2.length() - 1) {
                String suf2;
                String suf1 = tierName1.substring(i1 + 1);
                if (suf1.compareTo(suf2 = tierName2.substring(i2 + 1)) > 0) {
                    return suf2;
                }
                return suf1;
            }
        }
        return null;
    }
}

