/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.imports.praat;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.type.LinguisticTypeTableModel;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class ImportPraatTGStep2
extends StepPane
implements ListSelectionListener {
    private TranscriptionImpl curTranscription;
    private Vector rootTypes;
    private JTable typeTable;
    private String selTypeName;
    private LinguisticTypeTableModel model;
    private String[] columns;

    public ImportPraatTGStep2(MultiStepPane multiPane, TranscriptionImpl curTranscription) {
        super(multiPane);
        this.curTranscription = curTranscription;
        this.extractTypes();
        this.initComponents();
    }

    private void extractTypes() {
        LinguisticType lt;
        this.rootTypes = new Vector(6);
        Vector types = this.curTranscription.getLinguisticTypes();
        for (int i = 0; i < types.size(); ++i) {
            lt = (LinguisticType)types.get(i);
            if (lt.getConstraints() != null) continue;
            this.rootTypes.add(lt);
        }
        if (this.rootTypes.size() == 0) {
            Command com = ELANCommandFactory.createCommand(this.curTranscription, "Menu.Type.AddNewType");
            com.execute(this.curTranscription, new Object[]{"default-lt", null, null, Boolean.TRUE, Boolean.FALSE});
            lt = this.curTranscription.getLinguisticTypeByName("default-lt");
            if (lt != null) {
                this.rootTypes.add(lt);
            }
        }
    }

    @Override
    public void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.columns = new String[]{"Type", "Stereotype", "CV"};
        this.model = new LinguisticTypeTableModel(this.rootTypes, this.columns);
        this.typeTable = new JTable(this.model);
        this.typeTable.getSelectionModel().setSelectionMode(0);
        this.typeTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(this.typeTable);
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)scrollPane, gbc);
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("OverlapsDialog.Label.Type");
    }

    @Override
    public boolean doFinish() {
        this.multiPane.nextStep();
        return false;
    }

    @Override
    public void enterStepForward() {
        if (this.typeTable.getRowCount() > 0) {
            this.typeTable.setRowSelectionInterval(0, 0);
            int col = this.model.findColumn("Type");
            Object o = this.model.getValueAt(0, col);
            if (o instanceof String) {
                this.selTypeName = (String)o;
                this.multiPane.setButtonEnabled(3, true);
            }
        }
    }

    @Override
    public boolean leaveStepForward() {
        this.multiPane.putStepProperty("Type", this.selTypeName);
        return true;
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (this.model != null && lse.getValueIsAdjusting()) {
            int row = this.typeTable.getSelectedRow();
            if (row > -1) {
                int col = this.model.findColumn("Type");
                String typeName = (String)this.model.getValueAt(row, col);
                for (int i = 0; i < this.rootTypes.size(); ++i) {
                    LinguisticType t = (LinguisticType)this.rootTypes.get(i);
                    if (!t.getLinguisticTypeName().equals(typeName)) continue;
                    this.selTypeName = typeName;
                    break;
                }
                this.multiPane.setButtonEnabled(3, true);
            } else {
                this.multiPane.setButtonEnabled(3, false);
            }
        }
    }
}

