/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.imports.multiplefiles;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.imports.multiplefiles.AbstractMFImportStep4;
import mpi.eudico.client.annotator.imports.praat.PraatTextGrid;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class MFPraatImportStep4
extends AbstractMFImportStep4 {
    private boolean ipt = false;
    private int dur = 40;
    private boolean skipEmptyIntervals;

    public MFPraatImportStep4(MultiStepPane multiPane) {
        super(multiPane);
    }

    @Override
    public void enterStepForward() {
        Boolean includePT = (Boolean)this.multiPane.getStepProperty("PointTier");
        Integer duration = (Integer)this.multiPane.getStepProperty("PointDuration");
        Boolean skipEmpty = (Boolean)this.multiPane.getStepProperty("SkipEmpty");
        if (includePT != null) {
            this.ipt = includePT;
        }
        if (duration != null) {
            this.dur = duration;
        }
        if (skipEmpty != null) {
            this.skipEmptyIntervals = skipEmpty;
        }
        super.enterStepForward();
    }

    @Override
    protected boolean doImport(File sourceFile) {
        File impFile = sourceFile;
        boolean imported = false;
        if (impFile == null || !impFile.exists()) {
            this.report(ElanLocale.getString("MultiFileImport.Report.NoFile"));
            return false;
        }
        try {
            PraatTextGrid ptg = new PraatTextGrid(impFile, this.ipt, this.dur, this.encoding);
            imported = this.startImport(ptg);
        }
        catch (IOException ioe) {
            ClientLogger.LOG.warning("Could not handle file: " + impFile + "\n" + ioe.getMessage());
            this.report(ElanLocale.getString("MultiFileImport.Report.ParseError") + "\n" + ioe.getMessage());
        }
        return imported;
    }

    private boolean startImport(PraatTextGrid ptg) {
        this.transImpl = new TranscriptionImpl();
        ArrayList<String> tierNames = new ArrayList<String>();
        ArrayList<AnnotationDataRecord> annRecords = new ArrayList<AnnotationDataRecord>();
        LinguisticType type = new LinguisticType("Praat");
        type.setTimeAlignable(true);
        this.transImpl.addLinguisticType(type);
        try {
            TierImpl t;
            String name;
            int i;
            int tierCount = ptg.getTierNames().size();
            if (tierCount == 0) {
                return false;
            }
            float perTier = 10.0f / (float)tierCount;
            for (i = 0; i < tierCount; ++i) {
                name = (String)ptg.getTierNames().get(i);
                t = new TierImpl(name, "", this.transImpl, type);
                if (this.transImpl.getTierWithId(name) != null) continue;
                this.transImpl.addTier(t);
                tierNames.add(name);
            }
            tierCount = tierNames.size();
            perTier = 90.0f / (float)tierCount;
            for (i = 0; i < tierCount; ++i) {
                name = (String)tierNames.get(i);
                t = (TierImpl)this.transImpl.getTierWithId(name);
                ArrayList anns = (ArrayList)ptg.getAnnotationRecords(name);
                if (anns.size() == 0 || t == null) continue;
                float perAnn = perTier / (float)anns.size();
                AnnotationDataRecord record = null;
                for (int j = 0; j < anns.size(); ++j) {
                    Annotation ann;
                    record = (AnnotationDataRecord)anns.get(j);
                    if (this.skipEmptyIntervals && (record.getValue() == null || record.getValue().length() == 0) || (ann = t.createAnnotation(record.getBeginTime(), record.getEndTime())) == null) continue;
                    ann.setValue(record.getValue());
                    annRecords.add(new AnnotationDataRecord(ann));
                }
            }
            return true;
        }
        catch (Exception exc) {
            ClientLogger.LOG.warning("Unknown Error:\n" + exc.getMessage());
            this.report(ElanLocale.getString("MultiFileImport.Report.ExceptionOccured") + "\n" + exc.getMessage());
            return false;
        }
    }
}

