/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.help;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.net.URL;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.MainWindow;
import javax.help.Presentation;
import javax.help.WindowPresentation;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import mpi.eudico.client.annotator.help.HelpException;

public class HelpWindow {
    private static Window helpWindow = null;

    private HelpWindow() {
    }

    public static Window getHelpWindow() throws HelpException {
        if (helpWindow == null) {
            try {
                URL url = null;
                url = HelpWindow.class.getResource("/help/jhelpset.hs");
                HelpSet hs = null;
                ClassLoader cl = HelpWindow.class.getClassLoader();
                hs = new HelpSet(cl, url);
                Presentation pres = MainWindow.getPresentation((HelpSet)hs, (String)"ELAN Help");
                if (pres instanceof WindowPresentation) {
                    ((WindowPresentation)pres).createHelpWindow();
                    helpWindow = ((WindowPresentation)pres).getHelpWindow();
                }
                if (helpWindow == null) {
                    throw new HelpException("Help window is null");
                }
                try {
                    ImageIcon icon = new ImageIcon(HelpWindow.class.getResource("/mpi/eudico/client/annotator/resources/ELAN16.png"));
                    if (helpWindow instanceof Frame && icon != null) {
                        ((Frame)helpWindow).setIconImage(icon.getImage());
                    }
                }
                catch (Exception ee) {
                    // empty catch block
                }
                HelpWindow.checkComponentsForButton(((JFrame)helpWindow).getContentPane());
            }
            catch (HelpSetException hse) {
                throw new HelpException("Could not create help window: " + hse.getMessage(), hse.getCause());
            }
            catch (Exception ex) {
                throw new HelpException("Could not create help window: " + ex.getMessage(), ex.getCause());
            }
            catch (Error err) {
                throw new HelpException("Could not create help window: " + err.getMessage(), err.getCause());
            }
        }
        return helpWindow;
    }

    private static void checkComponentsForButton(Component c) {
        if (c instanceof JButton) {
            String name;
            JButton butt = (JButton)c;
            if (butt.getAccessibleContext() != null && ("Print Button".equals(name = butt.getAccessibleContext().getAccessibleName()) || "Page Setup Button".equals(name))) {
                butt.setEnabled(false);
            }
            return;
        }
        if (c instanceof Container) {
            Component[] comps;
            for (Component cc : comps = ((Container)c).getComponents()) {
                HelpWindow.checkComponentsForButton(cc);
            }
        }
    }
}

