/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui.multistep;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.util.ProgressListener;

public class ProgressStepPane
extends StepPane
implements ProgressListener {
    protected JProgressBar progressBar;
    protected JTextArea progressLabel;
    protected boolean completed = false;

    public ProgressStepPane(MultiStepPane multiPane) {
        super(multiPane);
    }

    @Override
    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        this.progressLabel = new JTextArea("...");
        this.progressLabel.setEditable(false);
        this.progressLabel.setBackground(this.getBackground());
        JLabel lab = new JLabel();
        this.progressLabel.setFont(lab.getFont());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.progressLabel, gbc);
        this.progressBar = new JProgressBar(0, 0, 100);
        this.progressBar.setValue(0);
        gbc.gridy = 1;
        this.add((Component)this.progressBar, gbc);
    }

    @Override
    public void progressUpdated(Object source, int percent, String message) {
        if (this.progressLabel != null && message != null) {
            this.progressLabel.setText(message);
        }
        if (percent < 0) {
            percent = 0;
        } else if (percent > 100) {
            percent = 100;
        }
        this.progressBar.setValue(percent);
        if (percent >= 100 && !this.completed) {
            this.showMessageDialog("Operation completed");
            this.endOfProcess();
            this.completed = true;
        }
    }

    @Override
    public void progressCompleted(Object source, String message) {
        if (this.progressLabel != null) {
            this.progressLabel.setText(message);
        }
        this.progressBar.setValue(100);
        if (!this.completed) {
            this.showMessageDialog("Operation completed");
            this.endOfProcess();
            this.completed = true;
        }
    }

    @Override
    public void progressInterrupted(Object source, String message) {
        if (this.progressLabel != null) {
            this.progressLabel.setText(message);
        }
        this.showWarningDialog("Operation interrupted: " + message);
        this.endOfProcess();
    }

    protected void endOfProcess() {
        this.multiPane.close();
    }

    protected void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    protected void showMessageDialog(String message) {
        JOptionPane.showMessageDialog(this, message, null, 1);
    }
}

